/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.MysqlUtil;
import org.apache.doris.common.util.PrintableMap;
import org.apache.doris.load.LoadErrorHub;
import org.apache.doris.thrift.TMysqlErrorHubInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MysqlLoadErrorHub
extends LoadErrorHub {
    private static final Logger LOG = LogManager.getLogger(MysqlLoadErrorHub.class);
    private static final String QUERY_SQL_FIRST = "SELECT job_id, error_msg FROM ";
    private static final String QUERY_SQL_LAST = " WHERE job_id = ? LIMIT ? ";
    private static final long MAX_LINE = 10L;
    private static final int STMT_TIMEOUT_S = 5;
    private MysqlParam param;

    public MysqlLoadErrorHub(MysqlParam mysqlParam) {
        Preconditions.checkNotNull((Object)mysqlParam);
        this.param = mysqlParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LoadErrorHub.ErrorMsg> fetchLoadError(long jobId) {
        ArrayList result = Lists.newArrayList();
        Connection conn = null;
        Statement stmt = null;
        ResultSet resultSet = null;
        conn = MysqlUtil.getConnection(this.param.getHost(), this.param.getPort(), this.param.getDb(), this.param.getUser(), this.param.getPasswd());
        if (conn == null) {
            return result;
        }
        String sql = null;
        try {
            sql = QUERY_SQL_FIRST + this.param.getTable() + QUERY_SQL_LAST;
            stmt = conn.prepareStatement(sql);
            stmt.setLong(1, jobId);
            stmt.setLong(2, 10L);
            stmt.setQueryTimeout(5);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String msg = resultSet.getString("error_msg");
                result.add(new LoadErrorHub.ErrorMsg(jobId, msg));
            }
        }
        catch (SQLException e) {
            LOG.warn("fail to query load error mysql. sql={}, table={}, jobId={}, max_line={}, exception={}", (Object)sql, (Object)this.param.getTable(), (Object)jobId, (Object)10L, (Object)e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sqlEx) {
                    LOG.warn("fail to close resultSet of load error.");
                }
                resultSet = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sqlEx) {
                    LOG.warn("fail to close stmt.");
                }
                stmt = null;
            }
            MysqlUtil.closeConnection(conn);
            conn = null;
        }
        return result;
    }

    @Override
    public boolean prepare() {
        return true;
    }

    @Override
    public boolean close() {
        return true;
    }

    public static class MysqlParam
    implements Writable {
        private String host;
        private int port;
        private String user;
        private String passwd;
        private String db;
        private String table;

        public MysqlParam() {
            this.host = "";
            this.port = 0;
            this.user = "";
            this.passwd = "";
            this.db = "";
            this.table = "";
        }

        public MysqlParam(String host, int port, String user, String passwd, String db, String table) {
            this.host = host;
            this.port = port;
            this.user = user;
            this.passwd = passwd;
            this.db = db;
            this.table = table;
        }

        public String getBrief() {
            HashMap briefMap = Maps.newHashMap();
            briefMap.put("host", this.host);
            briefMap.put("port", String.valueOf(this.port));
            briefMap.put("user", this.user);
            briefMap.put("password", this.passwd);
            briefMap.put("database", this.db);
            briefMap.put("table", this.table);
            PrintableMap printableMap = new PrintableMap(briefMap, "=", true, false, true);
            return printableMap.toString();
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getUser() {
            return this.user;
        }

        public String getPasswd() {
            return this.passwd;
        }

        public String getDb() {
            return this.db;
        }

        public String getTable() {
            return this.table;
        }

        public void write(DataOutput out) throws IOException {
            Text.writeString((DataOutput)out, (String)this.host);
            out.writeInt(this.port);
            Text.writeString((DataOutput)out, (String)this.user);
            Text.writeString((DataOutput)out, (String)this.passwd);
            Text.writeString((DataOutput)out, (String)this.db);
            Text.writeString((DataOutput)out, (String)this.table);
        }

        public void readFields(DataInput in) throws IOException {
            this.host = Text.readString((DataInput)in);
            this.port = in.readInt();
            this.user = Text.readString((DataInput)in);
            this.passwd = Text.readString((DataInput)in);
            this.db = Text.readString((DataInput)in);
            this.table = Text.readString((DataInput)in);
        }

        public TMysqlErrorHubInfo toThrift() {
            TMysqlErrorHubInfo info = new TMysqlErrorHubInfo(this.host, this.port, this.user, this.passwd, this.db, this.table);
            return info;
        }
    }
}

