/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.common.io.Writable;
import org.apache.doris.load.EtlStatus;

public class MiniEtlTaskInfo
implements Writable {
    private long id;
    private long backendId;
    private long tableId;
    private final EtlStatus taskStatus;

    public MiniEtlTaskInfo() {
        this(-1L, -1L, -1L);
    }

    public MiniEtlTaskInfo(long id, long backendId, long tableId) {
        this.id = id;
        this.backendId = backendId;
        this.tableId = tableId;
        this.taskStatus = new EtlStatus();
    }

    public long getId() {
        return this.id;
    }

    public long getBackendId() {
        return this.backendId;
    }

    public long getTableId() {
        return this.tableId;
    }

    public EtlStatus getTaskStatus() {
        return this.taskStatus;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.id);
        out.writeLong(this.backendId);
        out.writeLong(this.tableId);
    }

    public void readFields(DataInput in) throws IOException {
        this.id = in.readLong();
        this.backendId = in.readLong();
        this.tableId = in.readLong();
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MiniEtlTaskInfo)) {
            return false;
        }
        MiniEtlTaskInfo taskInfo = (MiniEtlTaskInfo)obj;
        return this.id == taskInfo.id && this.backendId == taskInfo.backendId && this.tableId == taskInfo.tableId;
    }
}

