/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load;

import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.doris.load.EtlJobInfo;
import org.apache.doris.load.MiniEtlTaskInfo;

public class MiniEtlJobInfo
extends EtlJobInfo {
    private static final int GET_STATUS_INTERVAL_TIMES = 5;
    private int checkTimes = 0;
    private Map<Long, MiniEtlTaskInfo> idToEtlTask = Maps.newHashMap();

    public boolean needGetTaskStatus() {
        return ++this.checkTimes % 5 == 0;
    }

    public Map<Long, MiniEtlTaskInfo> getEtlTasks() {
        return this.idToEtlTask;
    }

    public MiniEtlTaskInfo getEtlTask(long taskId) {
        return this.idToEtlTask.get(taskId);
    }

    public void setEtlTasks(Map<Long, MiniEtlTaskInfo> idToEtlTask) {
        this.idToEtlTask = idToEtlTask;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.idToEtlTask.size());
        for (MiniEtlTaskInfo taskInfo : this.idToEtlTask.values()) {
            taskInfo.write(out);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        int taskNum = in.readInt();
        for (int i = 0; i < taskNum; ++i) {
            MiniEtlTaskInfo taskInfo = new MiniEtlTaskInfo();
            taskInfo.readFields(in);
            this.idToEtlTask.put(taskInfo.getId(), taskInfo);
        }
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

