/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.BrokerDesc;
import org.apache.doris.analysis.IsNullPredicate;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.Predicate;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Replica;
import org.apache.doris.common.Config;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.load.BrokerFileGroupAggInfo;
import org.apache.doris.load.DeleteInfo;
import org.apache.doris.load.DppConfig;
import org.apache.doris.load.EtlJobInfo;
import org.apache.doris.load.EtlJobType;
import org.apache.doris.load.EtlStatus;
import org.apache.doris.load.FailMsg;
import org.apache.doris.load.HadoopEtlJobInfo;
import org.apache.doris.load.MiniEtlJobInfo;
import org.apache.doris.load.MiniEtlTaskInfo;
import org.apache.doris.load.PartitionLoadInfo;
import org.apache.doris.load.TableLoadInfo;
import org.apache.doris.load.TabletLoadInfo;
import org.apache.doris.persist.ReplicaPersistInfo;
import org.apache.doris.task.PushTask;
import org.apache.doris.thrift.TEtlState;
import org.apache.doris.thrift.TPriority;
import org.apache.doris.thrift.TResourceInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoadJob
implements Writable {
    private static final Logger LOG = LogManager.getLogger(LoadJob.class);
    private static final int DEFAULT_TIMEOUT_S = 0;
    private static final long DEFAULT_EXEC_MEM_LIMIT = 0x80000000L;
    private long id;
    private long dbId;
    private long tableId;
    private String label;
    private long transactionId = -1L;
    long timestamp;
    private int timeoutSecond;
    private double maxFilterRatio = Config.default_max_filter_ratio;
    private JobState state;
    private BrokerDesc brokerDesc;
    private BrokerFileGroupAggInfo pullLoadSourceInfo;
    private int progress;
    private long createTimeMs;
    private long etlStartTimeMs;
    private long etlFinishTimeMs;
    private long loadStartTimeMs;
    private long loadFinishTimeMs;
    private long quorumFinishTimeMs;
    private FailMsg failMsg;
    private EtlJobType etlJobType;
    private EtlJobInfo etlJobInfo;
    private Map<Long, TableLoadInfo> idToTableLoadInfo;
    private Map<Long, TabletLoadInfo> idToTabletLoadInfo;
    private Set<Long> quorumTablets;
    private Set<Long> fullTablets;
    private List<Long> unfinishedTablets;
    private Set<PushTask> pushTasks;
    private Map<Long, ReplicaPersistInfo> replicaPersistInfos;
    private Map<Long, Replica> finishedReplicas;
    private List<Predicate> conditions = null;
    private DeleteInfo deleteInfo;
    private TResourceInfo resourceInfo;
    private TPriority priority;
    private long execMemLimit;
    private Set<String> tableNames = Sets.newHashSet();

    public LoadJob() {
        this("");
    }

    public LoadJob(String label) {
        this(label, 0, Config.default_max_filter_ratio);
    }

    public LoadJob(long id, long dbId, long tableId, long partitionId, String label, Map<Long, Integer> indexIdToSchemaHash, List<Predicate> deleteConditions, DeleteInfo deleteInfo) {
        this.id = id;
        this.dbId = dbId;
        this.tableId = tableId;
        this.label = label;
        this.transactionId = -1L;
        this.timestamp = -1L;
        this.timeoutSecond = 0;
        this.state = JobState.LOADING;
        this.progress = 0;
        this.createTimeMs = System.currentTimeMillis();
        this.etlStartTimeMs = -1L;
        this.etlFinishTimeMs = -1L;
        this.loadStartTimeMs = -1L;
        this.loadFinishTimeMs = -1L;
        this.quorumFinishTimeMs = -1L;
        this.failMsg = new FailMsg(FailMsg.CancelType.UNKNOWN, "");
        this.etlJobType = EtlJobType.DELETE;
        EtlStatus etlStatus = new EtlStatus();
        etlStatus.setState(TEtlState.FINISHED);
        HadoopEtlJobInfo hadoopEtlJobInfo = new HadoopEtlJobInfo();
        hadoopEtlJobInfo.setCluster("");
        hadoopEtlJobInfo.setEtlOutputDir("");
        this.etlJobInfo = hadoopEtlJobInfo;
        this.etlJobInfo.setJobStatus(etlStatus);
        this.idToTableLoadInfo = Maps.newHashMap();
        this.idToTabletLoadInfo = Maps.newHashMap();
        this.quorumTablets = new HashSet<Long>();
        this.fullTablets = new HashSet<Long>();
        this.unfinishedTablets = new ArrayList<Long>();
        this.pushTasks = new HashSet<PushTask>();
        this.replicaPersistInfos = Maps.newHashMap();
        this.resourceInfo = null;
        this.priority = TPriority.NORMAL;
        this.execMemLimit = 0x80000000L;
        this.finishedReplicas = Maps.newHashMap();
        PartitionLoadInfo partitionLoadInfo = new PartitionLoadInfo(null);
        HashMap<Long, PartitionLoadInfo> idToPartitionLoadInfo = new HashMap<Long, PartitionLoadInfo>();
        idToPartitionLoadInfo.put(partitionId, partitionLoadInfo);
        TableLoadInfo tableLoadInfo = new TableLoadInfo(idToPartitionLoadInfo);
        tableLoadInfo.addAllSchemaHash(indexIdToSchemaHash);
        this.idToTableLoadInfo.put(tableId, tableLoadInfo);
        this.conditions = deleteConditions;
        this.deleteInfo = deleteInfo;
    }

    public LoadJob(String label, int timeoutSecond, double maxFilterRatio) {
        this.id = -1L;
        this.dbId = -1L;
        this.label = label;
        this.transactionId = -1L;
        this.timestamp = -1L;
        this.timeoutSecond = timeoutSecond;
        this.maxFilterRatio = maxFilterRatio;
        this.state = JobState.PENDING;
        this.progress = 0;
        this.createTimeMs = System.currentTimeMillis();
        this.etlStartTimeMs = -1L;
        this.etlFinishTimeMs = -1L;
        this.loadStartTimeMs = -1L;
        this.loadFinishTimeMs = -1L;
        this.quorumFinishTimeMs = -1L;
        this.failMsg = new FailMsg(FailMsg.CancelType.UNKNOWN, "");
        this.etlJobType = EtlJobType.HADOOP;
        this.etlJobInfo = new HadoopEtlJobInfo();
        this.idToTableLoadInfo = null;
        this.idToTabletLoadInfo = null;
        this.quorumTablets = new HashSet<Long>();
        this.fullTablets = new HashSet<Long>();
        this.unfinishedTablets = new ArrayList<Long>();
        this.pushTasks = new HashSet<PushTask>();
        this.replicaPersistInfos = Maps.newHashMap();
        this.resourceInfo = null;
        this.priority = TPriority.NORMAL;
        this.execMemLimit = 0x80000000L;
        this.finishedReplicas = Maps.newHashMap();
    }

    public void addTableName(String tableName) {
        this.tableNames.add(tableName);
    }

    public Set<String> getTableNames() {
        return this.tableNames;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long jobId) {
        this.id = jobId;
    }

    public long getDbId() {
        return this.dbId;
    }

    public long getTableId() {
        return this.tableId;
    }

    public void setDbId(long dbId) {
        this.dbId = dbId;
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(long transactionId) {
        this.transactionId = transactionId;
    }

    public String getLabel() {
        return this.label;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimeoutSecond(int timeoutSecond) {
        this.timeoutSecond = timeoutSecond;
    }

    public int getTimeoutSecond() {
        return this.timeoutSecond;
    }

    public void setMaxFilterRatio(double maxFilterRatio) {
        this.maxFilterRatio = maxFilterRatio;
    }

    public double getMaxFilterRatio() {
        return this.maxFilterRatio;
    }

    public JobState getState() {
        return this.state;
    }

    public void setState(JobState state) {
        this.state = state;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public long getCreateTimeMs() {
        return this.createTimeMs;
    }

    public void setCreateTimeMs(long createTimeMs) {
        this.createTimeMs = createTimeMs;
    }

    public long getEtlStartTimeMs() {
        return this.etlStartTimeMs;
    }

    public void setEtlStartTimeMs(long etlStartTimeMs) {
        this.etlStartTimeMs = etlStartTimeMs;
    }

    public long getEtlFinishTimeMs() {
        return this.etlFinishTimeMs;
    }

    public void setEtlFinishTimeMs(long etlFinishTimeMs) {
        this.etlFinishTimeMs = etlFinishTimeMs;
        if (this.etlStartTimeMs > -1L) {
            long etlCostMs = etlFinishTimeMs - this.etlStartTimeMs;
            switch (this.etlJobType) {
                case HADOOP: {
                    break;
                }
                case MINI: {
                    break;
                }
                case BROKER: {
                    break;
                }
            }
        }
    }

    public long getLoadStartTimeMs() {
        return this.loadStartTimeMs;
    }

    public void setLoadStartTimeMs(long loadStartTimeMs) {
        this.loadStartTimeMs = loadStartTimeMs;
    }

    public long getLoadFinishTimeMs() {
        return this.loadFinishTimeMs;
    }

    public void setLoadFinishTimeMs(long loadFinishTimeMs) {
        this.loadFinishTimeMs = loadFinishTimeMs;
        long loadCostMs = loadFinishTimeMs - this.loadStartTimeMs;
        long totalCostMs = loadFinishTimeMs - this.createTimeMs;
        switch (this.etlJobType) {
            case HADOOP: {
                break;
            }
            case MINI: {
                break;
            }
            case BROKER: {
                break;
            }
        }
    }

    public long getQuorumFinishTimeMs() {
        return this.quorumFinishTimeMs;
    }

    public void setQuorumFinishTimeMs(long quorumFinishTimeMs) {
        this.quorumFinishTimeMs = quorumFinishTimeMs;
    }

    public FailMsg getFailMsg() {
        return this.failMsg;
    }

    public void setFailMsg(FailMsg failMsg) {
        this.failMsg = failMsg;
    }

    public EtlJobType getEtlJobType() {
        return this.etlJobType;
    }

    public void setBrokerDesc(BrokerDesc brokerDesc) {
        this.brokerDesc = brokerDesc;
    }

    public BrokerDesc getBrokerDesc() {
        return this.brokerDesc;
    }

    public void setPullLoadSourceInfo(BrokerFileGroupAggInfo sourceInfo) {
        this.pullLoadSourceInfo = sourceInfo;
    }

    public BrokerFileGroupAggInfo getPullLoadSourceInfo() {
        return this.pullLoadSourceInfo;
    }

    public void setExecMemLimit(long execMemLimit) {
        this.execMemLimit = execMemLimit;
    }

    public long getExecMemLimit() {
        return this.execMemLimit;
    }

    public void setEtlJobType(EtlJobType etlJobType) {
        this.etlJobType = etlJobType;
        switch (etlJobType) {
            case HADOOP: {
                this.etlJobInfo = new HadoopEtlJobInfo();
                break;
            }
            case MINI: {
                this.etlJobInfo = new MiniEtlJobInfo();
                break;
            }
            case INSERT: {
                this.etlJobInfo = new EtlJobInfo();
                break;
            }
        }
    }

    public EtlJobInfo getEtlJobInfo() {
        return this.etlJobInfo;
    }

    public String getHadoopCluster() {
        if (this.etlJobType == EtlJobType.HADOOP) {
            return ((HadoopEtlJobInfo)this.etlJobInfo).getCluster();
        }
        return FeConstants.null_string;
    }

    public DppConfig getHadoopDppConfig() {
        if (this.etlJobType == EtlJobType.HADOOP) {
            return ((HadoopEtlJobInfo)this.etlJobInfo).getDppConfig();
        }
        return null;
    }

    public void setClusterInfo(String cluster, DppConfig dppConfig) {
        if (this.etlJobType == EtlJobType.HADOOP) {
            HadoopEtlJobInfo hadoopEtlJobInfo = (HadoopEtlJobInfo)this.etlJobInfo;
            hadoopEtlJobInfo.setCluster(cluster);
            hadoopEtlJobInfo.setDppConfig(dppConfig);
        }
    }

    public void setPriority(TPriority priority) {
        this.priority = priority;
    }

    public TPriority getPriority() {
        return this.priority;
    }

    public String getHadoopEtlOutputDir() {
        if (this.etlJobType == EtlJobType.HADOOP) {
            return ((HadoopEtlJobInfo)this.etlJobInfo).getEtlOutputDir();
        }
        return null;
    }

    public void setHadoopEtlOutputDir(String etlOutputDir) {
        if (this.etlJobType == EtlJobType.HADOOP) {
            ((HadoopEtlJobInfo)this.etlJobInfo).setEtlOutputDir(etlOutputDir);
        }
    }

    public String getHadoopEtlJobId() {
        if (this.etlJobType == EtlJobType.HADOOP) {
            return ((HadoopEtlJobInfo)this.etlJobInfo).getEtlJobId();
        }
        return null;
    }

    public void setHadoopEtlJobId(String etlJobId) {
        if (this.etlJobType == EtlJobType.HADOOP) {
            ((HadoopEtlJobInfo)this.etlJobInfo).setEtlJobId(etlJobId);
        }
    }

    public Map<Long, MiniEtlTaskInfo> getMiniEtlTasks() {
        if (this.etlJobType == EtlJobType.MINI) {
            return ((MiniEtlJobInfo)this.etlJobInfo).getEtlTasks();
        }
        return null;
    }

    public MiniEtlTaskInfo getMiniEtlTask(long taskId) {
        if (this.etlJobType == EtlJobType.MINI) {
            return ((MiniEtlJobInfo)this.etlJobInfo).getEtlTask(taskId);
        }
        return null;
    }

    public void setMiniEtlTasks(Map<Long, MiniEtlTaskInfo> idToEtlTask) {
        if (this.etlJobType == EtlJobType.MINI) {
            ((MiniEtlJobInfo)this.etlJobInfo).setEtlTasks(idToEtlTask);
        }
    }

    public boolean miniNeedGetTaskStatus() {
        if (this.etlJobType == EtlJobType.MINI) {
            return ((MiniEtlJobInfo)this.etlJobInfo).needGetTaskStatus();
        }
        return true;
    }

    public EtlStatus getEtlJobStatus() {
        return this.etlJobInfo.getJobStatus();
    }

    public void setEtlJobStatus(EtlStatus etlStatus) {
        this.etlJobInfo.setJobStatus(etlStatus);
    }

    public Map<Long, TableLoadInfo> getIdToTableLoadInfo() {
        return this.idToTableLoadInfo;
    }

    public TableLoadInfo getTableLoadInfo(long tableId) {
        return this.idToTableLoadInfo.get(tableId);
    }

    public PartitionLoadInfo getPartitionLoadInfo(long tableId, long partitionId) {
        if (!this.idToTableLoadInfo.containsKey(tableId)) {
            return null;
        }
        TableLoadInfo tableLoadInfo = this.getTableLoadInfo(tableId);
        return tableLoadInfo.getPartitionLoadInfo(partitionId);
    }

    public void setIdToTableLoadInfo(Map<Long, TableLoadInfo> idToTableLoadInfo) {
        this.idToTableLoadInfo = idToTableLoadInfo;
    }

    public List<Long> getAllTableIds() {
        ArrayList tblIds = Lists.newArrayList();
        if (this.idToTableLoadInfo != null) {
            tblIds.addAll(this.idToTableLoadInfo.keySet());
        }
        return tblIds;
    }

    public Map<Long, TabletLoadInfo> getIdToTabletLoadInfo() {
        return this.idToTabletLoadInfo;
    }

    public TabletLoadInfo getTabletLoadInfo(long tabletId) {
        return this.idToTabletLoadInfo.get(tabletId);
    }

    public void setIdToTabletLoadInfo(Map<Long, TabletLoadInfo> idTotabletLoadInfo) {
        this.idToTabletLoadInfo = idTotabletLoadInfo;
    }

    public void addQuorumTablet(long tabletId) {
        this.quorumTablets.add(tabletId);
    }

    public Set<Long> getQuorumTablets() {
        return this.quorumTablets;
    }

    public void clearQuorumTablets() {
        this.quorumTablets.clear();
    }

    public void addFullTablet(long tabletId) {
        this.fullTablets.add(tabletId);
    }

    public Set<Long> getFullTablets() {
        return this.fullTablets;
    }

    public void setUnfinishedTablets(Set<Long> unfinishedTablets) {
        this.unfinishedTablets.clear();
        this.unfinishedTablets.addAll(unfinishedTablets);
    }

    public void addPushTask(PushTask pushTask) {
        this.pushTasks.add(pushTask);
    }

    public Set<PushTask> getPushTasks() {
        return this.pushTasks;
    }

    public Map<Long, ReplicaPersistInfo> getReplicaPersistInfos() {
        return this.replicaPersistInfos;
    }

    public void addReplicaPersistInfos(ReplicaPersistInfo info) {
        if (!this.replicaPersistInfos.containsKey(info.getReplicaId())) {
            this.replicaPersistInfos.put(info.getReplicaId(), info);
        }
    }

    public void setResourceInfo(TResourceInfo resourceInfo) {
        this.resourceInfo = resourceInfo;
    }

    public TResourceInfo getResourceInfo() {
        return this.resourceInfo;
    }

    public boolean addFinishedReplica(Replica replica) {
        this.finishedReplicas.put(replica.getId(), replica);
        return true;
    }

    public boolean isReplicaFinished(long replicaId) {
        return this.finishedReplicas.containsKey(replicaId);
    }

    public Collection<Replica> getFinishedReplicas() {
        return this.finishedReplicas.values();
    }

    public List<Predicate> getConditions() {
        return this.conditions;
    }

    public boolean isSyncDeleteJob() {
        return this.conditions != null;
    }

    public DeleteInfo getDeleteInfo() {
        return this.deleteInfo;
    }

    public long getDeleteJobTimeout() {
        long timeout = Math.max((long)(this.idToTabletLoadInfo.size() * Config.tablet_delete_timeout_second) * 1000L, 30000L);
        return Math.min(timeout, (long)Config.load_straggler_wait_second * 1000L);
    }

    public String toString() {
        return "LoadJob [id=" + this.id + ", dbId=" + this.dbId + ", label=" + this.label + ", timeoutSecond=" + this.timeoutSecond + ", maxFilterRatio=" + this.maxFilterRatio + ", state=" + (Object)((Object)this.state) + ", progress=" + this.progress + ", createTimeMs=" + this.createTimeMs + ", etlStartTimeMs=" + this.etlStartTimeMs + ", etlFinishTimeMs=" + this.etlFinishTimeMs + ", loadStartTimeMs=" + this.loadStartTimeMs + ", loadFinishTimeMs=" + this.loadFinishTimeMs + ", failMsg=" + this.failMsg + ", etlJobType=" + (Object)((Object)this.etlJobType) + ", etlJobInfo=" + this.etlJobInfo + ", priority=" + this.priority + ", transactionId=" + this.transactionId + ", quorumFinishTimeMs=" + this.quorumFinishTimeMs + ", unfinished tablets=[" + this.unfinishedTablets.subList(0, Math.min(3, this.unfinishedTablets.size())) + "]]";
    }

    public void clearRedundantInfoForHistoryJob() {
        DppConfig dppConfig;
        if (this.idToTableLoadInfo != null) {
            this.idToTableLoadInfo.clear();
            this.idToTableLoadInfo = null;
        }
        if (this.idToTabletLoadInfo != null) {
            this.idToTabletLoadInfo.clear();
            this.idToTabletLoadInfo = null;
        }
        if (this.quorumTablets != null) {
            this.quorumTablets.clear();
            this.quorumTablets = null;
        }
        if (this.fullTablets != null) {
            this.fullTablets.clear();
            this.fullTablets = null;
        }
        if (this.replicaPersistInfos != null) {
            this.replicaPersistInfos.clear();
            this.replicaPersistInfos = null;
        }
        if (this.etlJobInfo != null && this.etlJobType == EtlJobType.HADOOP && (dppConfig = ((HadoopEtlJobInfo)this.etlJobInfo).getDppConfig()) != null) {
            dppConfig.clear();
        }
        if (this.pushTasks != null) {
            this.pushTasks.clear();
            this.pushTasks = null;
        }
        this.resourceInfo = null;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.id);
        out.writeLong(this.dbId);
        Text.writeString((DataOutput)out, (String)this.label);
        out.writeLong(this.timestamp);
        out.writeInt(this.timeoutSecond);
        out.writeDouble(this.maxFilterRatio);
        out.writeBoolean(true);
        Text.writeString((DataOutput)out, (String)this.state.name());
        out.writeInt(this.progress);
        out.writeLong(this.createTimeMs);
        out.writeLong(this.etlStartTimeMs);
        out.writeLong(this.etlFinishTimeMs);
        out.writeLong(this.loadStartTimeMs);
        out.writeLong(this.loadFinishTimeMs);
        this.failMsg.write(out);
        Text.writeString((DataOutput)out, (String)this.etlJobType.name());
        this.etlJobInfo.write(out);
        int count = 0;
        if (this.idToTableLoadInfo == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            count = this.idToTableLoadInfo.size();
            out.writeInt(count);
            for (Map.Entry<Long, TableLoadInfo> entry : this.idToTableLoadInfo.entrySet()) {
                out.writeLong(entry.getKey());
                entry.getValue().write(out);
            }
        }
        if (this.idToTabletLoadInfo == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            count = this.idToTabletLoadInfo.size();
            out.writeInt(count);
            for (Map.Entry<Long, Object> entry : this.idToTabletLoadInfo.entrySet()) {
                out.writeLong(entry.getKey());
                ((TabletLoadInfo)entry.getValue()).write(out);
            }
        }
        if (this.fullTablets == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            count = this.fullTablets.size();
            out.writeInt(count);
            Iterator<Object> iterator = this.fullTablets.iterator();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                out.writeLong(l);
            }
        }
        if (this.replicaPersistInfos == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            count = this.replicaPersistInfos.size();
            out.writeInt(count);
            for (ReplicaPersistInfo replicaPersistInfo : this.replicaPersistInfos.values()) {
                replicaPersistInfo.write(out);
            }
        }
        if (this.resourceInfo == null || Strings.isNullOrEmpty((String)this.resourceInfo.getGroup()) || Strings.isNullOrEmpty((String)this.resourceInfo.getUser())) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Text.writeString((DataOutput)out, (String)this.resourceInfo.getUser());
            Text.writeString((DataOutput)out, (String)this.resourceInfo.getGroup());
        }
        Text.writeString((DataOutput)out, (String)this.priority.name());
        if (this.brokerDesc == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.brokerDesc.write(out);
        }
        if (this.pullLoadSourceInfo == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.pullLoadSourceInfo.write(out);
        }
        out.writeLong(this.execMemLimit);
        out.writeLong(this.transactionId);
        if (this.conditions != null) {
            out.writeBoolean(true);
            count = this.conditions.size();
            out.writeInt(count);
            for (Predicate predicate : this.conditions) {
                String value;
                String columnName;
                SlotRef slotRef;
                if (predicate instanceof BinaryPredicate) {
                    BinaryPredicate binaryPredicate = (BinaryPredicate)predicate;
                    slotRef = (SlotRef)binaryPredicate.getChild(0);
                    columnName = slotRef.getColumnName();
                    Text.writeString((DataOutput)out, (String)columnName);
                    Text.writeString((DataOutput)out, (String)binaryPredicate.getOp().name());
                    value = ((LiteralExpr)binaryPredicate.getChild(1)).getStringValue();
                    Text.writeString((DataOutput)out, (String)value);
                    continue;
                }
                if (!(predicate instanceof IsNullPredicate)) continue;
                IsNullPredicate isNullPredicate = (IsNullPredicate)predicate;
                slotRef = (SlotRef)isNullPredicate.getChild(0);
                columnName = slotRef.getColumnName();
                Text.writeString((DataOutput)out, (String)columnName);
                Text.writeString((DataOutput)out, (String)"IS");
                value = null;
                value = isNullPredicate.isNotNull() ? "NOT NULL" : "NULL";
                Text.writeString((DataOutput)out, (String)value);
            }
        } else {
            out.writeBoolean(false);
        }
        if (this.deleteInfo != null) {
            out.writeBoolean(true);
            this.deleteInfo.write(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.tableNames.size());
        for (String string : this.tableNames) {
            Text.writeString((DataOutput)out, (String)string);
        }
    }

    public void readFields(DataInput in) throws IOException {
        Object value;
        long key;
        int i;
        long version = Catalog.getCurrentCatalogJournalVersion();
        this.id = in.readLong();
        this.dbId = in.readLong();
        this.label = Text.readString((DataInput)in);
        this.timestamp = in.readLong();
        this.timeoutSecond = in.readInt();
        this.maxFilterRatio = in.readDouble();
        boolean deleteFlag = false;
        deleteFlag = in.readBoolean();
        this.state = JobState.valueOf(Text.readString((DataInput)in));
        this.progress = in.readInt();
        this.createTimeMs = in.readLong();
        this.etlStartTimeMs = in.readLong();
        this.etlFinishTimeMs = in.readLong();
        this.loadStartTimeMs = in.readLong();
        this.loadFinishTimeMs = in.readLong();
        this.failMsg = new FailMsg();
        this.failMsg.readFields(in);
        String etlJobType = Text.readString((DataInput)in);
        if (etlJobType.equals("BULK")) {
            this.setEtlJobType(EtlJobType.MINI);
        } else {
            this.setEtlJobType(EtlJobType.valueOf(etlJobType));
        }
        this.etlJobInfo.readFields(in);
        int count = 0;
        if (in.readBoolean()) {
            count = in.readInt();
            this.idToTableLoadInfo = new HashMap<Long, TableLoadInfo>();
            for (i = 0; i < count; ++i) {
                key = in.readLong();
                value = new TableLoadInfo();
                ((TableLoadInfo)value).readFields(in);
                this.idToTableLoadInfo.put(key, (TableLoadInfo)value);
            }
        }
        if (in.readBoolean()) {
            count = in.readInt();
            this.idToTabletLoadInfo = new HashMap<Long, TabletLoadInfo>();
            for (i = 0; i < count; ++i) {
                key = in.readLong();
                TabletLoadInfo tLoadInfo = new TabletLoadInfo();
                tLoadInfo.readFields(in);
                this.idToTabletLoadInfo.put(key, tLoadInfo);
            }
        }
        if (in.readBoolean()) {
            count = in.readInt();
            this.fullTablets = new HashSet<Long>();
            for (i = 0; i < count; ++i) {
                long id = in.readLong();
                this.fullTablets.add(id);
            }
        }
        if (in.readBoolean()) {
            count = in.readInt();
            this.replicaPersistInfos = Maps.newHashMap();
            for (i = 0; i < count; ++i) {
                ReplicaPersistInfo info = ReplicaPersistInfo.read(in);
                this.replicaPersistInfos.put(info.getReplicaId(), info);
            }
        }
        if (in.readBoolean()) {
            String user = Text.readString((DataInput)in);
            String group = Text.readString((DataInput)in);
            this.resourceInfo = new TResourceInfo(user, group);
        }
        if (version >= 3L && version < 7L) {
            String bosEndpoint = Text.readString((DataInput)in);
            String bosAccessKey = Text.readString((DataInput)in);
            String string = Text.readString((DataInput)in);
        }
        this.priority = TPriority.valueOf((String)Text.readString((DataInput)in));
        if (in.readBoolean()) {
            this.brokerDesc = BrokerDesc.read(in);
        }
        if (in.readBoolean()) {
            this.pullLoadSourceInfo = BrokerFileGroupAggInfo.read(in);
        }
        this.execMemLimit = in.readLong();
        this.transactionId = in.readLong();
        if (in.readBoolean()) {
            count = in.readInt();
            this.conditions = Lists.newArrayList();
            for (int i2 = 0; i2 < count; ++i2) {
                String key2 = Text.readString((DataInput)in);
                String opStr = Text.readString((DataInput)in);
                if (opStr.equalsIgnoreCase("IS")) {
                    value = Text.readString((DataInput)in);
                    IsNullPredicate predicate = ((String)value).equalsIgnoreCase("NOT NULL") ? new IsNullPredicate(new SlotRef(null, key2), true) : new IsNullPredicate(new SlotRef(null, key2), true);
                    this.conditions.add(predicate);
                    continue;
                }
                BinaryPredicate.Operator op = BinaryPredicate.Operator.valueOf(opStr);
                String value2 = Text.readString((DataInput)in);
                BinaryPredicate predicate = new BinaryPredicate(op, new SlotRef(null, key2), new StringLiteral(value2));
                this.conditions.add(predicate);
            }
        }
        if (in.readBoolean()) {
            this.deleteInfo = DeleteInfo.read(in);
        }
        int size = in.readInt();
        for (int i3 = 0; i3 < size; ++i3) {
            this.tableNames.add(Text.readString((DataInput)in));
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LoadJob)) {
            return false;
        }
        LoadJob job = (LoadJob)obj;
        return this.id == job.id;
    }

    public boolean isExpired(long currentTimeMs) {
        return (this.getState() == JobState.FINISHED || this.getState() == JobState.CANCELLED) && (currentTimeMs - this.getLoadFinishTimeMs()) / 1000L > (long)Config.label_keep_max_second;
    }

    public static enum JobState {
        UNKNOWN,
        PENDING,
        ETL,
        LOADING,
        FINISHED,
        QUORUM_FINISHED,
        CANCELLED;

    }
}

