/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.load.BrokerLoadErrorHub;
import org.apache.doris.load.MysqlLoadErrorHub;
import org.apache.doris.thrift.TErrorHubType;
import org.apache.doris.thrift.TLoadErrorHubInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class LoadErrorHub {
    private static final Logger LOG = LogManager.getLogger(LoadErrorHub.class);
    public static final String MYSQL_PROTOCOL = "MYSQL";
    public static final String BROKER_PROTOCOL = "BROKER";

    public abstract List<ErrorMsg> fetchLoadError(long var1);

    public abstract boolean prepare();

    public abstract boolean close();

    public static LoadErrorHub createHub(Param param) {
        switch (param.getType()) {
            case MYSQL_TYPE: {
                MysqlLoadErrorHub hub = new MysqlLoadErrorHub(param.getMysqlParam());
                ((LoadErrorHub)hub).prepare();
                return hub;
            }
            case BROKER_TYPE: {
                BrokerLoadErrorHub hub = new BrokerLoadErrorHub(param.getBrokerParam());
                ((LoadErrorHub)hub).prepare();
                return hub;
            }
        }
        Preconditions.checkState((boolean)false, (Object)"unknown hub type");
        return null;
    }

    public static class Param
    implements Writable {
        private HubType type = HubType.NULL_TYPE;
        private MysqlLoadErrorHub.MysqlParam mysqlParam;
        private BrokerLoadErrorHub.BrokerParam brokerParam;

        public static Param createMysqlParam(MysqlLoadErrorHub.MysqlParam mysqlParam) {
            Param param = new Param();
            param.type = HubType.MYSQL_TYPE;
            param.mysqlParam = mysqlParam;
            return param;
        }

        public static Param createBrokerParam(BrokerLoadErrorHub.BrokerParam brokerParam) {
            Param param = new Param();
            param.type = HubType.BROKER_TYPE;
            param.brokerParam = brokerParam;
            return param;
        }

        public static Param createNullParam() {
            Param param = new Param();
            param.type = HubType.NULL_TYPE;
            return param;
        }

        public HubType getType() {
            return this.type;
        }

        public MysqlLoadErrorHub.MysqlParam getMysqlParam() {
            return this.mysqlParam;
        }

        public BrokerLoadErrorHub.BrokerParam getBrokerParam() {
            return this.brokerParam;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
            helper.add("type", (Object)this.type.toString());
            switch (this.type) {
                case MYSQL_TYPE: {
                    helper.add("mysql_info", (Object)this.mysqlParam.toString());
                    break;
                }
                case NULL_TYPE: {
                    helper.add("mysql_info", (Object)"null");
                    break;
                }
                default: {
                    Preconditions.checkState((boolean)false, (Object)"unknown hub type");
                }
            }
            return helper.toString();
        }

        public TLoadErrorHubInfo toThrift() {
            TLoadErrorHubInfo info = new TLoadErrorHubInfo();
            switch (this.type) {
                case MYSQL_TYPE: {
                    info.setType(TErrorHubType.MYSQL);
                    info.setMysqlInfo(this.mysqlParam.toThrift());
                    break;
                }
                case BROKER_TYPE: {
                    info.setType(TErrorHubType.BROKER);
                    info.setBrokerInfo(this.brokerParam.toThrift());
                    break;
                }
                case NULL_TYPE: {
                    info.setType(TErrorHubType.NULL_TYPE);
                    break;
                }
                default: {
                    Preconditions.checkState((boolean)false, (Object)"unknown hub type");
                }
            }
            return info;
        }

        public Map<String, Object> toDppConfigInfo() {
            HashMap dppHubInfo = Maps.newHashMap();
            dppHubInfo.put("type", this.type.toString());
            switch (this.type) {
                case MYSQL_TYPE: {
                    dppHubInfo.put("info", this.mysqlParam);
                    break;
                }
                case BROKER_TYPE: {
                    Preconditions.checkState((boolean)false, (Object)"hadoop load do not support broker error hub");
                }
                case NULL_TYPE: {
                    break;
                }
                default: {
                    Preconditions.checkState((boolean)false, (Object)"unknown hub type");
                }
            }
            return dppHubInfo;
        }

        public List<String> getInfo() {
            ArrayList info = Lists.newArrayList();
            info.add(this.type.name());
            switch (this.type) {
                case MYSQL_TYPE: {
                    info.add(this.mysqlParam.getBrief());
                    break;
                }
                case BROKER_TYPE: {
                    info.add(this.brokerParam.getBrief());
                    break;
                }
                default: {
                    info.add("");
                }
            }
            return info;
        }

        public void write(DataOutput out) throws IOException {
            Text.writeString((DataOutput)out, (String)this.type.name());
            switch (this.type) {
                case MYSQL_TYPE: {
                    this.mysqlParam.write(out);
                    break;
                }
                case BROKER_TYPE: {
                    this.brokerParam.write(out);
                    break;
                }
                case NULL_TYPE: {
                    break;
                }
                default: {
                    Preconditions.checkState((boolean)false, (Object)"unknown hub type");
                }
            }
        }

        public void readFields(DataInput in) throws IOException {
            this.type = HubType.valueOf(Text.readString((DataInput)in));
            switch (this.type) {
                case MYSQL_TYPE: {
                    this.mysqlParam = new MysqlLoadErrorHub.MysqlParam();
                    this.mysqlParam.readFields(in);
                    break;
                }
                case BROKER_TYPE: {
                    this.brokerParam = new BrokerLoadErrorHub.BrokerParam();
                    this.brokerParam.readFields(in);
                    break;
                }
                case NULL_TYPE: {
                    break;
                }
                default: {
                    Preconditions.checkState((boolean)false, (Object)"unknown hub type");
                }
            }
        }
    }

    public class ErrorMsg {
        private long jobId;
        private String msg;

        public ErrorMsg(long id, String message) {
            this.jobId = id;
            this.msg = message;
        }

        public long getJobId() {
            return this.jobId;
        }

        public String getMsg() {
            return this.msg;
        }
    }

    public static enum HubType {
        MYSQL_TYPE,
        BROKER_TYPE,
        NULL_TYPE;

    }
}

