/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.CancelLoadStmt;
import org.apache.doris.analysis.CastExpr;
import org.apache.doris.analysis.DataDescription;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ExprSubstitutionMap;
import org.apache.doris.analysis.FunctionCallExpr;
import org.apache.doris.analysis.FunctionName;
import org.apache.doris.analysis.FunctionParams;
import org.apache.doris.analysis.ImportColumnDesc;
import org.apache.doris.analysis.IsNullPredicate;
import org.apache.doris.analysis.LabelName;
import org.apache.doris.analysis.LoadStmt;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.analysis.PartitionNames;
import org.apache.doris.analysis.Separator;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.StorageBackend;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.backup.BlobStorage;
import org.apache.doris.backup.Status;
import org.apache.doris.catalog.AggregateType;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.KeysType;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.PartitionType;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.catalog.TabletInvertedIndex;
import org.apache.doris.catalog.TabletMeta;
import org.apache.doris.catalog.Type;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.CaseSensibility;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.FeNameFormat;
import org.apache.doris.common.LabelAlreadyUsedException;
import org.apache.doris.common.LoadException;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.PatternMatcher;
import org.apache.doris.common.TreeNode;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.ListComparator;
import org.apache.doris.common.util.MetaLockUtils;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.load.BrokerFileGroup;
import org.apache.doris.load.BrokerFileGroupAggInfo;
import org.apache.doris.load.BrokerLoadErrorHub;
import org.apache.doris.load.DppConfig;
import org.apache.doris.load.DppScheduler;
import org.apache.doris.load.EtlJobType;
import org.apache.doris.load.EtlStatus;
import org.apache.doris.load.FailMsg;
import org.apache.doris.load.LoadErrorHub;
import org.apache.doris.load.LoadJob;
import org.apache.doris.load.MiniEtlTaskInfo;
import org.apache.doris.load.MysqlLoadErrorHub;
import org.apache.doris.load.PartitionLoadInfo;
import org.apache.doris.load.Source;
import org.apache.doris.load.TableLoadInfo;
import org.apache.doris.load.TabletLoadInfo;
import org.apache.doris.load.loadv2.LoadTask;
import org.apache.doris.metric.MetricRepo;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.persist.ReplicaPersistInfo;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.system.Backend;
import org.apache.doris.task.AgentClient;
import org.apache.doris.task.AgentTaskQueue;
import org.apache.doris.task.LoadTaskInfo;
import org.apache.doris.task.PushTask;
import org.apache.doris.thrift.TBrokerScanRangeParams;
import org.apache.doris.thrift.TEtlState;
import org.apache.doris.thrift.TMiniLoadRequest;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TPriority;
import org.apache.doris.transaction.TransactionNotFoundException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Load {
    private static final Logger LOG = LogManager.getLogger(Load.class);
    public static final String VERSION = "v1";
    private static final Map<LoadJob.JobState, Set<LoadJob.JobState>> STATE_CHANGE_MAP = Maps.newHashMap();
    public static DppConfig dppDefaultConfig = null;
    public static Map<String, DppConfig> clusterToDppConfig = Maps.newHashMap();
    private Map<Long, LoadJob> idToLoadJob;
    private Map<Long, List<LoadJob>> dbToLoadJobs;
    private Map<Long, Map<String, List<LoadJob>>> dbLabelToLoadJobs;
    private Map<Long, LoadJob> idToPendingLoadJob;
    private Map<Long, LoadJob> idToEtlLoadJob;
    private Map<Long, LoadJob> idToLoadingLoadJob;
    private Map<Long, LoadJob> idToQuorumFinishedLoadJob;
    private Set<Long> loadingPartitionIds;
    private Map<Long, Map<String, Long>> dbToMiniLabels;
    private volatile LoadErrorHub.Param loadErrorHubParam = new LoadErrorHub.Param();
    private ReentrantReadWriteLock lock;

    public Load() {
        this.idToLoadJob = Maps.newHashMap();
        this.dbToLoadJobs = Maps.newHashMap();
        this.dbLabelToLoadJobs = Maps.newHashMap();
        this.idToPendingLoadJob = Maps.newLinkedHashMap();
        this.idToEtlLoadJob = Maps.newLinkedHashMap();
        this.idToLoadingLoadJob = Maps.newLinkedHashMap();
        this.idToQuorumFinishedLoadJob = Maps.newLinkedHashMap();
        this.loadingPartitionIds = Sets.newHashSet();
        this.dbToMiniLabels = Maps.newHashMap();
        this.lock = new ReentrantReadWriteLock(true);
    }

    public void readLock() {
        this.lock.readLock().lock();
    }

    public void readUnlock() {
        this.lock.readLock().unlock();
    }

    private void writeLock() {
        this.lock.writeLock().lock();
    }

    private void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean addMiniLoadJob(TMiniLoadRequest request) throws DdlException {
        String fullDbName = request.getDb();
        String tableName = request.getTbl();
        String label = request.getLabel();
        long timestamp = 0L;
        if (request.isSetTimestamp()) {
            timestamp = request.getTimestamp();
        }
        TNetworkAddress beAddr = request.getBackend();
        String filePathsValue = (String)request.getFiles().get(0);
        Map params = request.getProperties();
        LabelName labelName = new LabelName(fullDbName, label);
        if (Strings.isNullOrEmpty((String)filePathsValue)) {
            throw new DdlException("File paths are not specified");
        }
        List<String> filePaths = Arrays.asList(filePathsValue.split(","));
        List<String> partitionNames = null;
        List<String> columnNames = null;
        Separator columnSeparator = null;
        List<String> hllColumnPairList = null;
        Separator lineDelimiter = null;
        String formatType = null;
        if (params != null) {
            String lineDelimiterStr;
            String columnSeparatorStr;
            String hll;
            String specifiedColumns;
            String specifiedPartitions = (String)params.get("partitions");
            if (!Strings.isNullOrEmpty((String)specifiedPartitions)) {
                partitionNames = Arrays.asList(specifiedPartitions.split(","));
            }
            if (!Strings.isNullOrEmpty((String)(specifiedColumns = (String)params.get("columns")))) {
                columnNames = Arrays.asList(specifiedColumns.split(","));
            }
            if (!Strings.isNullOrEmpty((String)(hll = (String)params.get("hll")))) {
                hllColumnPairList = Arrays.asList(hll.split(":"));
            }
            if ((columnSeparatorStr = (String)params.get("column_separator")) != null) {
                if (columnSeparatorStr.isEmpty()) {
                    columnSeparatorStr = "\t";
                }
                columnSeparator = new Separator(columnSeparatorStr);
                try {
                    columnSeparator.analyze();
                }
                catch (AnalysisException e) {
                    throw new DdlException(e.getMessage());
                }
            }
            if ((lineDelimiterStr = (String)params.get("line_delimiter")) != null) {
                if (lineDelimiterStr.isEmpty()) {
                    lineDelimiterStr = "\n";
                }
                lineDelimiter = new Separator(lineDelimiterStr);
                try {
                    lineDelimiter.analyze();
                }
                catch (AnalysisException e) {
                    throw new DdlException(e.getMessage());
                }
            }
            formatType = (String)params.get("format");
        }
        DataDescription dataDescription = new DataDescription(tableName, partitionNames != null ? new PartitionNames(false, partitionNames) : null, filePaths, columnNames, columnSeparator, formatType, false, null);
        dataDescription.setLineDelimiter(lineDelimiter);
        dataDescription.setBeAddr(beAddr);
        if (hllColumnPairList != null) {
            for (int i = 0; i < hllColumnPairList.size(); ++i) {
                String pairStr = hllColumnPairList.get(i);
                List<String> pairList = Arrays.asList(pairStr.split(","));
                if (pairList.size() != 2) {
                    throw new DdlException("hll param format error");
                }
                String resultColumn = pairList.get(0);
                String hashColumn = pairList.get(1);
                Pair<String, List<String>> pair = new Pair<String, List<String>>("hll_hash", Arrays.asList(hashColumn));
                dataDescription.addColumnMapping(resultColumn, pair);
            }
        }
        ArrayList dataDescriptions = Lists.newArrayList((Object[])new DataDescription[]{dataDescription});
        HashMap properties = Maps.newHashMap();
        if (params != null) {
            String timeout;
            String maxFilterRatio = (String)params.get("max_filter_ratio");
            if (!Strings.isNullOrEmpty((String)maxFilterRatio)) {
                properties.put("max_filter_ratio", maxFilterRatio);
            }
            if (!Strings.isNullOrEmpty((String)(timeout = (String)params.get("timeout")))) {
                properties.put("timeout", timeout);
            }
        }
        LoadStmt stmt = new LoadStmt(labelName, dataDescriptions, null, null, properties);
        if (!this.registerMiniLabel(fullDbName, label, timestamp)) {
            return false;
        }
        try {
            this.addLoadJob(stmt, EtlJobType.MINI, timestamp);
            boolean bl = true;
            return bl;
        }
        finally {
            this.deregisterMiniLabel(fullDbName, label);
        }
    }

    public void addLoadJob(LoadStmt stmt, EtlJobType etlJobType, long timestamp) throws DdlException {
        String dbName = stmt.getLabel().getDbName();
        Database db = Catalog.getCurrentCatalog().getDbOrDdlException(dbName);
        LoadJob job = this.createLoadJob(stmt, etlJobType, db, timestamp);
        this.addLoadJob(job, db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLoadJob(LoadJob job, Database db) throws DdlException {
        Catalog.getCurrentSystemInfo().checkClusterCapacity(db.getClusterName());
        if (!job.isSyncDeleteJob()) {
            db.checkDataSizeQuota();
        }
        this.readLock();
        try {
            for (Long tblId : job.getIdToTableLoadInfo().keySet()) {
                Table tbl = db.getTableNullable(tblId);
                if (tbl == null || tbl.getType() != Table.TableType.OLAP || ((OlapTable)tbl).getState() != OlapTable.OlapTableState.RESTORE) continue;
                throw new DdlException("Table " + tbl.getName() + " is in restore process. Can not load into it");
            }
        }
        finally {
            this.readUnlock();
        }
        this.writeLock();
        try {
            this.unprotectAddLoadJob(job, false);
            MetricRepo.COUNTER_LOAD_ADD.increase(1L);
            Catalog.getCurrentCatalog().getEditLog().logLoadStart(job);
        }
        finally {
            this.writeUnlock();
        }
        LOG.info("add load job. job: {}", (Object)job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private LoadJob createLoadJob(LoadStmt stmt, EtlJobType etlJobType, Database db, long timestamp) throws DdlException {
        String label = stmt.getLabel().getLabelName();
        List<DataDescription> dataDescriptions = stmt.getDataDescriptions();
        Map<String, String> properties = stmt.getProperties();
        try {
            FeNameFormat.checkLabel(label);
        }
        catch (AnalysisException e) {
            throw new DdlException(e.getMessage());
        }
        if (dataDescriptions == null || dataDescriptions.isEmpty()) {
            throw new DdlException("No data file in load statement.");
        }
        LoadJob job = new LoadJob(label);
        job.setEtlJobType(etlJobType);
        job.setDbId(db.getId());
        job.setTimestamp(timestamp);
        job.setBrokerDesc(stmt.getBrokerDesc());
        if (ConnectContext.get() != null) {
            job.setResourceInfo(ConnectContext.get().toResourceCtx());
            job.setExecMemLimit(ConnectContext.get().getSessionVariable().getMaxExecMemByte());
        }
        if (properties != null) {
            if (properties.containsKey("timeout")) {
                try {
                    job.setTimeoutSecond(Integer.parseInt(properties.get("timeout")));
                }
                catch (NumberFormatException e) {
                    throw new DdlException("Timeout is not INT", e);
                }
            }
            if (properties.containsKey("max_filter_ratio")) {
                try {
                    job.setMaxFilterRatio(Double.parseDouble(properties.get("max_filter_ratio")));
                }
                catch (NumberFormatException e) {
                    throw new DdlException("Max filter ratio is not DOUBLE", e);
                }
            }
            if (properties.containsKey("exec_mem_limit")) {
                try {
                    job.setExecMemLimit(Long.parseLong(properties.get("exec_mem_limit")));
                }
                catch (NumberFormatException e) {
                    throw new DdlException("Execute memory limit is not Long", e);
                }
            }
        }
        HashMap idToTableLoadInfo = Maps.newHashMap();
        HashMap tableToPartitionSources = Maps.newHashMap();
        for (DataDescription dataDescription : dataDescriptions) {
            Load.checkAndCreateSource(db, dataDescription, tableToPartitionSources, etlJobType);
            job.addTableName(dataDescription.getTableName());
        }
        for (Map.Entry entry : tableToPartitionSources.entrySet()) {
            long tableId = (Long)entry.getKey();
            Map partitionToSources = (Map)entry.getValue();
            HashMap idToPartitionLoadInfo = Maps.newHashMap();
            for (Map.Entry partitionEntry : partitionToSources.entrySet()) {
                PartitionLoadInfo info = new PartitionLoadInfo((List)partitionEntry.getValue());
                idToPartitionLoadInfo.put((Long)partitionEntry.getKey(), info);
            }
            idToTableLoadInfo.put(tableId, new TableLoadInfo(idToPartitionLoadInfo));
        }
        job.setIdToTableLoadInfo(idToTableLoadInfo);
        if (etlJobType == EtlJobType.BROKER) {
            BrokerFileGroupAggInfo sourceInfo = new BrokerFileGroupAggInfo();
            for (DataDescription dataDescription : dataDescriptions) {
                BrokerFileGroup fileGroup = new BrokerFileGroup(dataDescription);
                fileGroup.parse(db, dataDescription);
                sourceInfo.addFileGroup(fileGroup);
            }
            job.setPullLoadSourceInfo(sourceInfo);
            LOG.info("source info is {}", (Object)sourceInfo);
        }
        if (etlJobType == EtlJobType.MINI) {
            HashMap idToEtlTask = Maps.newHashMap();
            long l = 0L;
            for (DataDescription dataDescription : dataDescriptions) {
                String tableName = dataDescription.getTableName();
                OlapTable table = db.getOlapTableOrDdlException(tableName);
                table.readLock();
                try {
                    TNetworkAddress beAddress = dataDescription.getBeAddr();
                    Backend backend = Catalog.getCurrentSystemInfo().getBackendWithBePort(beAddress.getHostname(), beAddress.getPort());
                    if (!Catalog.getCurrentSystemInfo().checkBackendLoadAvailable(backend.getId())) {
                        throw new DdlException("Etl backend is null or not available");
                    }
                    MiniEtlTaskInfo taskInfo = new MiniEtlTaskInfo(l++, backend.getId(), table.getId());
                    idToEtlTask.put(taskInfo.getId(), taskInfo);
                }
                finally {
                    table.readUnlock();
                }
            }
            job.setMiniEtlTasks(idToEtlTask);
            job.setPriority(TPriority.HIGH);
            if (job.getTimeoutSecond() == 0) {
                job.setTimeoutSecond(Config.mini_load_default_timeout_second);
            }
        } else if (etlJobType == EtlJobType.HADOOP) {
            void var13_27;
            void var13_24;
            DppConfig dppConfig = dppDefaultConfig.getCopiedDppConfig();
            String string = stmt.getCluster();
            if (string == null && properties != null) {
                String string2 = properties.get("cluster");
            }
            Pair<String, DppConfig> clusterInfo = Catalog.getCurrentCatalog().getAuth().getLoadClusterInfo(stmt.getUser(), (String)var13_24);
            String string3 = (String)clusterInfo.first;
            DppConfig clusterConfig = (DppConfig)clusterInfo.second;
            if (string3 == null || clusterConfig == null) {
                if (string3 == null) {
                    String string4 = Config.dpp_default_cluster;
                }
                if ((clusterConfig = clusterToDppConfig.get(var13_27)) == null) {
                    throw new DdlException("Load cluster[" + (String)var13_27 + "] does not exist");
                }
            }
            dppConfig.update(clusterConfig);
            try {
                dppConfig.updateHadoopConfigs(properties);
                dppConfig.check();
                job.setClusterInfo((String)var13_27, dppConfig);
                job.setPriority(dppConfig.getPriority());
            }
            catch (LoadException e) {
                throw new DdlException(e.getMessage());
            }
            if (job.getTimeoutSecond() == 0) {
                job.setTimeoutSecond(Config.hadoop_load_default_timeout_second);
            }
            for (DataDescription dataDescription : dataDescriptions) {
                if (dataDescription.getMergeType() == LoadTask.MergeType.APPEND) continue;
                throw new DdlException("MERGE OR DELETE is not supported in hadoop load.");
            }
        } else if (etlJobType == EtlJobType.BROKER) {
            if (job.getTimeoutSecond() == 0) {
                job.setTimeoutSecond(Config.broker_load_default_timeout_second);
            }
        } else if (etlJobType == EtlJobType.INSERT) {
            job.setPriority(TPriority.HIGH);
            if (job.getTimeoutSecond() == 0) {
                job.setTimeoutSecond(Config.insert_load_default_timeout_second);
            }
        }
        job.setId(Catalog.getCurrentCatalog().getNextId());
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkAndCreateSource(Database db, DataDescription dataDescription, Map<Long, Map<Long, List<Source>>> tableToPartitionSources, EtlJobType jobType) throws DdlException {
        String lineDelimiter;
        String columnSeparator;
        Source source = new Source(dataDescription.getFilePaths());
        long tableId = -1L;
        HashSet sourcePartitionIds = Sets.newHashSet();
        String tableName = dataDescription.getTableName();
        HashMap columnToFunction = null;
        OlapTable table = db.getOlapTableOrDdlException(tableName);
        tableId = table.getId();
        table.readLock();
        try {
            if (table.getPartitionInfo().isMultiColumnPartition() && jobType == EtlJobType.HADOOP) {
                throw new DdlException("Load by hadoop cluster does not support table with multi partition columns. Table: " + table.getName() + ". Try using broker load. See 'help broker load;'");
            }
            if (dataDescription.getPartitionNames() != null && table.getPartitionInfo().getType() == PartitionType.UNPARTITIONED) {
                ErrorReport.reportDdlException(ErrorCode.ERR_PARTITION_CLAUSE_NO_ALLOWED, new Object[0]);
            }
            if (table.getState() == OlapTable.OlapTableState.RESTORE) {
                throw new DdlException("Table [" + tableName + "] is under restore");
            }
            if (table.getKeysType() != KeysType.AGG_KEYS && dataDescription.isNegative()) {
                throw new DdlException("Load for AGG_KEYS table should not specify NEGATIVE");
            }
            List<Column> baseSchema = table.getBaseSchema(false);
            dataDescription.fillColumnInfoIfNotSpecified(baseSchema);
            ArrayList columnNames = Lists.newArrayList();
            ArrayList assignColumnNames = Lists.newArrayList();
            if (dataDescription.getFileFieldNames() != null) {
                assignColumnNames.addAll(dataDescription.getFileFieldNames());
                if (dataDescription.getColumnsFromPath() != null) {
                    assignColumnNames.addAll(dataDescription.getColumnsFromPath());
                }
            }
            if (assignColumnNames.isEmpty()) {
                for (Column column : baseSchema) {
                    columnNames.add(column.getName());
                }
            } else {
                for (String assignCol : assignColumnNames) {
                    if (table.getColumn(assignCol) != null) {
                        columnNames.add(table.getColumn(assignCol).getName());
                        continue;
                    }
                    columnNames.add(assignCol);
                }
            }
            source.setColumnNames(columnNames);
            Map<String, Pair<String, List<String>>> columnToHadoopFunction = dataDescription.getColumnToHadoopFunction();
            List<ImportColumnDesc> parsedColumnExprList = dataDescription.getParsedColumnExprList();
            TreeMap parsedColumnExprMap = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
            for (ImportColumnDesc importColumnDesc : parsedColumnExprList) {
                parsedColumnExprMap.put(importColumnDesc.getColumnName(), importColumnDesc.getExpr());
            }
            for (Column column : baseSchema) {
                String columnName = column.getName();
                if (columnNames.contains(columnName) || parsedColumnExprMap.containsKey(columnName) || column.getDefaultValue() != null || column.isAllowNull()) continue;
                throw new DdlException("Column has no default value. column: " + columnName);
            }
            if (dataDescription.isNegative()) {
                for (Column column : baseSchema) {
                    if (column.isKey() || column.getAggregationType() == AggregateType.SUM) continue;
                    throw new DdlException("Column is not SUM AggregateType. column:" + column.getName());
                }
            }
            for (Column column : baseSchema) {
                if (column.getDataType() != PrimitiveType.HLL || columnToHadoopFunction == null || columnToHadoopFunction.containsKey(column.getName())) continue;
                throw new DdlException("Hll column is not assigned. column:" + column.getName());
            }
            for (Column column : table.getFullSchema()) {
                if (column.isNameWithPrefix("__doris_shadow_")) {
                    ImportColumnDesc importColumnDesc;
                    String originCol = column.getNameWithoutPrefix("__doris_shadow_");
                    if (!parsedColumnExprMap.containsKey(originCol)) continue;
                    Expr mappingExpr = (Expr)parsedColumnExprMap.get(originCol);
                    if (mappingExpr != null) {
                        if (columnToHadoopFunction.containsKey(originCol)) {
                            columnToHadoopFunction.put(column.getName(), columnToHadoopFunction.get(originCol));
                        }
                        importColumnDesc = new ImportColumnDesc(column.getName(), mappingExpr);
                        parsedColumnExprList.add(importColumnDesc);
                        continue;
                    }
                    columnToHadoopFunction.put(column.getName(), Pair.create("substitute", Lists.newArrayList((Object[])new String[]{originCol})));
                    importColumnDesc = new ImportColumnDesc(column.getName(), new SlotRef(null, originCol));
                    parsedColumnExprList.add(importColumnDesc);
                    continue;
                }
                if (column.isVisible()) continue;
                columnToHadoopFunction.put(column.getName(), Pair.create("default_value", Lists.newArrayList((Object[])new String[]{column.getDefaultValue()})));
                ImportColumnDesc importColumnDesc = null;
                try {
                    importColumnDesc = new ImportColumnDesc(column.getName(), new FunctionCallExpr("default_value", Arrays.asList(column.getDefaultValueExpr())));
                }
                catch (AnalysisException e) {
                    throw new DdlException(e.getMessage());
                }
                parsedColumnExprList.add(importColumnDesc);
            }
            LOG.debug("after add shadow column. parsedColumnExprList: {}, columnToHadoopFunction: {}", parsedColumnExprList, columnToHadoopFunction);
            TreeMap columnNameMap = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
            for (String columnName : columnNames) {
                columnNameMap.put(columnName, columnName);
            }
            if (columnToHadoopFunction != null) {
                columnToFunction = Maps.newHashMap();
                for (Map.Entry<String, Pair<String, List<String>>> entry : columnToHadoopFunction.entrySet()) {
                    String mappingColumnName = entry.getKey();
                    Column mappingColumn = table.getColumn(mappingColumnName);
                    if (mappingColumn == null) {
                        throw new DdlException("Mapping column is not in table. column: " + mappingColumnName);
                    }
                    Pair<String, List<String>> function = entry.getValue();
                    try {
                        DataDescription.validateMappingFunction((String)function.first, (List)function.second, columnNameMap, mappingColumn, dataDescription.isHadoopLoad());
                    }
                    catch (AnalysisException e) {
                        throw new DdlException(e.getMessage());
                    }
                    columnToFunction.put(mappingColumn.getName(), function);
                }
            }
            OlapTable olapTable = table;
            PartitionNames partitionNames = dataDescription.getPartitionNames();
            if (partitionNames == null) {
                for (Partition partition : olapTable.getPartitions()) {
                    sourcePartitionIds.add(partition.getId());
                }
            } else {
                for (String partitionName : partitionNames.getPartitionNames()) {
                    Partition partition = olapTable.getPartition(partitionName, partitionNames.isTemp());
                    if (partition == null) {
                        throw new DdlException("Partition [" + partitionName + "] does not exist");
                    }
                    sourcePartitionIds.add(partition.getId());
                }
            }
        }
        finally {
            table.readUnlock();
        }
        if (!Strings.isNullOrEmpty((String)(columnSeparator = dataDescription.getColumnSeparator()))) {
            source.setColumnSeparator(columnSeparator);
        }
        if (!Strings.isNullOrEmpty((String)(lineDelimiter = dataDescription.getLineDelimiter()))) {
            source.setLineDelimiter(lineDelimiter);
        }
        source.setNegative(dataDescription.isNegative());
        if (columnToFunction != null) {
            source.setColumnToFunction(columnToFunction);
        }
        Map<Object, Object> partitionToSources = null;
        if (tableToPartitionSources.containsKey(tableId)) {
            partitionToSources = tableToPartitionSources.get(tableId);
        } else {
            partitionToSources = Maps.newHashMap();
            tableToPartitionSources.put(tableId, (Map<Long, List<Source>>)partitionToSources);
        }
        Iterator<Column> iterator = sourcePartitionIds.iterator();
        while (iterator.hasNext()) {
            long partitionId = (Long)((Object)iterator.next());
            List<Source> sources = null;
            if (partitionToSources.containsKey(partitionId)) {
                sources = (List)partitionToSources.get(partitionId);
            } else {
                sources = new ArrayList();
                partitionToSources.put(partitionId, sources);
            }
            sources.add(source);
        }
    }

    public static List<ImportColumnDesc> getSchemaChangeShadowColumnDesc(Table tbl, Map<String, Expr> columnExprMap) {
        ArrayList shadowColumnDescs = Lists.newArrayList();
        for (Column column : tbl.getFullSchema()) {
            ImportColumnDesc importColumnDesc;
            String originCol;
            if (!column.isNameWithPrefix("__doris_shadow_") || !columnExprMap.containsKey(originCol = column.getNameWithoutPrefix("__doris_shadow_"))) continue;
            Expr mappingExpr = columnExprMap.get(originCol);
            if (mappingExpr != null) {
                importColumnDesc = new ImportColumnDesc(column.getName(), mappingExpr);
                shadowColumnDescs.add(importColumnDesc);
                continue;
            }
            importColumnDesc = new ImportColumnDesc(column.getName(), new SlotRef(null, originCol));
            shadowColumnDescs.add(importColumnDesc);
        }
        return shadowColumnDescs;
    }

    public static void initColumns(Table tbl, List<ImportColumnDesc> columnExprs, Map<String, Pair<String, List<String>>> columnToHadoopFunction) throws UserException {
        Load.initColumns(tbl, columnExprs, columnToHadoopFunction, null, null, null, null, null, false);
    }

    public static void initColumns(Table tbl, LoadTaskInfo.ImportColumnDescs columnDescs, Map<String, Pair<String, List<String>>> columnToHadoopFunction, Map<String, Expr> exprsByName, Analyzer analyzer, TupleDescriptor srcTupleDesc, Map<String, SlotDescriptor> slotDescByName, TBrokerScanRangeParams params) throws UserException {
        Load.rewriteColumns(columnDescs);
        Load.initColumns(tbl, columnDescs.descs, columnToHadoopFunction, exprsByName, analyzer, srcTupleDesc, slotDescByName, params, true);
    }

    private static void initColumns(Table tbl, List<ImportColumnDesc> columnExprs, Map<String, Pair<String, List<String>>> columnToHadoopFunction, Map<String, Expr> exprsByName, Analyzer analyzer, TupleDescriptor srcTupleDesc, Map<String, SlotDescriptor> slotDescByName, TBrokerScanRangeParams params, boolean needInitSlotAndAnalyzeExprs) throws UserException {
        Object expr;
        ArrayList slots;
        ExprSubstitutionMap smap;
        boolean specifyFileFieldNames;
        ArrayList<ImportColumnDesc> copiedColumnExprs = new ArrayList<ImportColumnDesc>();
        for (ImportColumnDesc importColumnDesc : columnExprs) {
            String mappingColumnName = importColumnDesc.getColumnName();
            if (!importColumnDesc.isColumn() && tbl.getColumn(mappingColumnName) == null) continue;
            copiedColumnExprs.add(importColumnDesc);
        }
        boolean hasSequenceCol = false;
        if (tbl instanceof OlapTable && ((OlapTable)tbl).hasSequenceCol().booleanValue()) {
            hasSequenceCol = true;
        }
        if (!(specifyFileFieldNames = copiedColumnExprs.stream().anyMatch(p -> p.isColumn()))) {
            List<Column> columns = tbl.getBaseSchema(false);
            for (Column column : columns) {
                if (hasSequenceCol && column.isSequenceColumn()) continue;
                ImportColumnDesc importColumnDesc = new ImportColumnDesc(column.getName());
                LOG.debug("add base column {} to stream load task", (Object)column.getName());
                copiedColumnExprs.add(importColumnDesc);
            }
        }
        TreeMap columnExprMap = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        for (ImportColumnDesc importColumnDesc : copiedColumnExprs) {
            columnExprMap.put(importColumnDesc.getColumnName(), importColumnDesc.getExpr());
        }
        for (Column column : tbl.getBaseSchema()) {
            String string = column.getName();
            if (columnExprMap.containsKey(string) || column.getDefaultValue() != null || column.isAllowNull()) continue;
            throw new DdlException("Column has no default value. column: " + string);
        }
        copiedColumnExprs.addAll(Load.getSchemaChangeShadowColumnDesc(tbl, columnExprMap));
        if (columnToHadoopFunction != null) {
            TreeMap columnNameMap = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
            for (ImportColumnDesc importColumnDesc : copiedColumnExprs) {
                if (!importColumnDesc.isColumn()) continue;
                columnNameMap.put(importColumnDesc.getColumnName(), importColumnDesc.getColumnName());
            }
            for (Map.Entry<String, Pair<String, List<String>>> entry : columnToHadoopFunction.entrySet()) {
                String mappingColumnName = entry.getKey();
                Column mappingColumn = tbl.getColumn(mappingColumnName);
                if (mappingColumn == null) {
                    throw new DdlException("Mapping column is not in table. column: " + mappingColumnName);
                }
                Pair<String, List<String>> function = entry.getValue();
                try {
                    DataDescription.validateMappingFunction((String)function.first, (List)function.second, columnNameMap, mappingColumn, false);
                }
                catch (AnalysisException e) {
                    throw new DdlException(e.getMessage());
                }
            }
        }
        if (!needInitSlotAndAnalyzeExprs) {
            return;
        }
        for (ImportColumnDesc importColumnDesc : copiedColumnExprs) {
            String string = importColumnDesc.getColumnName();
            String realColName = tbl.getColumn(string) == null || importColumnDesc.getExpr() == null ? string : tbl.getColumn(string).getName();
            if (importColumnDesc.getExpr() != null) {
                Expr expr2 = Load.transformHadoopFunctionExpr(tbl, realColName, importColumnDesc.getExpr());
                exprsByName.put(realColName, expr2);
                continue;
            }
            SlotDescriptor slotDesc = analyzer.getDescTbl().addSlotDescriptor(srcTupleDesc);
            slotDesc.setType(ScalarType.createType(PrimitiveType.VARCHAR));
            slotDesc.setIsMaterialized(true);
            slotDesc.setIsNullable(true);
            slotDesc.setColumn(new Column(realColName, PrimitiveType.VARCHAR));
            params.addToSrcSlotIds(slotDesc.getId().asInt());
            slotDescByName.put(realColName, slotDesc);
        }
        HashMap mvDefineExpr = Maps.newHashMap();
        for (Column column : tbl.getFullSchema()) {
            if (column.getDefineExpr() == null) continue;
            mvDefineExpr.put(column.getName(), column.getDefineExpr());
        }
        LOG.debug("slotDescByName: {}, exprsByName: {}, mvDefineExpr: {}", slotDescByName, exprsByName, (Object)mvDefineExpr);
        for (Map.Entry<String, Expr> entry : exprsByName.entrySet()) {
            smap = new ExprSubstitutionMap();
            slots = Lists.newArrayList();
            entry.getValue().collect(SlotRef.class, slots);
            for (SlotRef slot : slots) {
                SlotDescriptor slotDesc = slotDescByName.get(slot.getColumnName());
                if (slotDesc == null) {
                    if (entry.getKey().equalsIgnoreCase("__DORIS_DELETE_SIGN__")) {
                        throw new UserException("unknown reference column in DELETE ON clause:" + slot.getColumnName());
                    }
                    if (entry.getKey().equalsIgnoreCase("__DORIS_SEQUENCE_COL__")) {
                        throw new UserException("unknown reference column in ORDER BY clause:" + slot.getColumnName());
                    }
                    throw new UserException("unknown reference column, column=" + entry.getKey() + ", reference=" + slot.getColumnName());
                }
                smap.getLhs().add(slot);
                smap.getRhs().add(new SlotRef(slotDesc));
            }
            expr = entry.getValue().clone(smap);
            ((Expr)expr).analyze(analyzer);
            ArrayList funcs = Lists.newArrayList();
            ((TreeNode)expr).collect(FunctionCallExpr.class, funcs);
            for (FunctionCallExpr fn : funcs) {
                if (!fn.isAggregateFunction()) continue;
                throw new AnalysisException("Don't support aggregation function in load expression");
            }
            exprsByName.put(entry.getKey(), (Expr)expr);
        }
        for (Map.Entry entry : mvDefineExpr.entrySet()) {
            smap = new ExprSubstitutionMap();
            slots = Lists.newArrayList();
            ((Expr)entry.getValue()).collect(SlotRef.class, slots);
            for (SlotRef slot : slots) {
                if (slotDescByName.get(slot.getColumnName()) != null) {
                    smap.getLhs().add(slot);
                    smap.getRhs().add(new CastExpr(tbl.getColumn(slot.getColumnName()).getType(), (Expr)new SlotRef(slotDescByName.get(slot.getColumnName()))));
                    continue;
                }
                if (exprsByName.get(slot.getColumnName()) != null) {
                    smap.getLhs().add(slot);
                    smap.getRhs().add(new CastExpr(tbl.getColumn(slot.getColumnName()).getType(), exprsByName.get(slot.getColumnName())));
                    continue;
                }
                if (((String)entry.getKey()).equalsIgnoreCase("__DORIS_DELETE_SIGN__")) {
                    throw new UserException("unknown reference column in DELETE ON clause:" + slot.getColumnName());
                }
                if (((String)entry.getKey()).equalsIgnoreCase("__DORIS_SEQUENCE_COL__")) {
                    throw new UserException("unknown reference column in ORDER BY clause:" + slot.getColumnName());
                }
                throw new UserException("unknown reference column, column=" + (String)entry.getKey() + ", reference=" + slot.getColumnName());
            }
            expr = ((Expr)entry.getValue()).clone(smap);
            ((Expr)expr).analyze(analyzer);
            exprsByName.put((String)entry.getKey(), (Expr)expr);
        }
        LOG.debug("after init column, exprMap: {}", exprsByName);
    }

    public static void rewriteColumns(LoadTaskInfo.ImportColumnDescs columnDescs) {
        if (columnDescs.isColumnDescsRewrited) {
            return;
        }
        HashMap<String, Expr> derivativeColumns = new HashMap<String, Expr>();
        for (ImportColumnDesc importColumnDesc : columnDescs.descs) {
            if (importColumnDesc.isColumn()) continue;
            if (importColumnDesc.getExpr() instanceof SlotRef) {
                String columnName = ((SlotRef)importColumnDesc.getExpr()).getColumnName();
                if (derivativeColumns.containsKey(columnName)) {
                    importColumnDesc.setExpr((Expr)derivativeColumns.get(columnName));
                }
            } else {
                Load.recursiveRewrite(importColumnDesc.getExpr(), derivativeColumns);
            }
            derivativeColumns.put(importColumnDesc.getColumnName(), importColumnDesc.getExpr());
        }
        columnDescs.isColumnDescsRewrited = true;
    }

    private static void recursiveRewrite(Expr expr, Map<String, Expr> derivativeColumns) {
        if (CollectionUtils.isEmpty(expr.getChildren())) {
            return;
        }
        for (int i = 0; i < expr.getChildren().size(); ++i) {
            Expr e = (Expr)expr.getChild(i);
            if (e instanceof SlotRef) {
                String columnName = ((SlotRef)e).getColumnName();
                if (!derivativeColumns.containsKey(columnName)) continue;
                expr.setChild(i, derivativeColumns.get(columnName));
                continue;
            }
            Load.recursiveRewrite(e, derivativeColumns);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Expr transformHadoopFunctionExpr(Table tbl, String columnName, Expr originExpr) throws UserException {
        Column column = tbl.getColumn(columnName);
        if (column == null) {
            return originExpr;
        }
        if (!(originExpr instanceof FunctionCallExpr)) return originExpr;
        FunctionCallExpr funcExpr = (FunctionCallExpr)originExpr;
        String funcName = funcExpr.getFnName().getFunction();
        if (funcName.equalsIgnoreCase("replace_value")) {
            ArrayList exprs = Lists.newArrayList();
            SlotRef slotRef = new SlotRef(null, columnName);
            if (funcExpr.getChild(0) instanceof NullLiteral) {
                exprs.add(new IsNullPredicate(slotRef, true));
                exprs.add(slotRef);
                if (funcExpr.hasChild(1)) {
                    exprs.add((Expr)funcExpr.getChild(1));
                } else if (column.getDefaultValue() != null) {
                    if (column.getDefaultValueExprDef() != null) {
                        exprs.add(column.getDefaultValueExpr());
                    } else {
                        exprs.add(new StringLiteral(column.getDefaultValue()));
                    }
                } else {
                    if (!column.isAllowNull()) throw new UserException("Column(" + columnName + ") has no default value.");
                    exprs.add(NullLiteral.create(Type.VARCHAR));
                }
            } else {
                exprs.add(new IsNullPredicate(slotRef, true));
                ArrayList innerIfExprs = Lists.newArrayList();
                innerIfExprs.add(new BinaryPredicate(BinaryPredicate.Operator.NE, slotRef, (Expr)funcExpr.getChild(0)));
                innerIfExprs.add(slotRef);
                if (funcExpr.hasChild(1)) {
                    innerIfExprs.add((Expr)funcExpr.getChild(1));
                } else if (column.getDefaultValue() != null) {
                    if (column.getDefaultValueExprDef() != null) {
                        innerIfExprs.add(column.getDefaultValueExpr());
                    } else {
                        innerIfExprs.add(new StringLiteral(column.getDefaultValue()));
                    }
                } else {
                    if (!column.isAllowNull()) throw new UserException("Column(" + columnName + ") has no default value.");
                    innerIfExprs.add(NullLiteral.create(Type.VARCHAR));
                }
                FunctionCallExpr innerIfFn = new FunctionCallExpr("if", (List<Expr>)innerIfExprs);
                exprs.add(innerIfFn);
                exprs.add(NullLiteral.create(Type.VARCHAR));
            }
            LOG.debug("replace_value expr: {}", (Object)exprs);
            return new FunctionCallExpr("if", (List<Expr>)exprs);
        }
        if (funcName.equalsIgnoreCase("strftime")) {
            FunctionName fromUnixName = new FunctionName("FROM_UNIXTIME");
            ArrayList fromUnixArgs = Lists.newArrayList((Object[])new Expr[]{(Expr)funcExpr.getChild(1)});
            return new FunctionCallExpr(fromUnixName, new FunctionParams(false, fromUnixArgs));
        }
        if (funcName.equalsIgnoreCase("time_format")) {
            FunctionName strToDateName = new FunctionName("STR_TO_DATE");
            ArrayList strToDateExprs = Lists.newArrayList((Object[])new Expr[]{(Expr)funcExpr.getChild(2), (Expr)funcExpr.getChild(1)});
            FunctionCallExpr strToDateFuncExpr = new FunctionCallExpr(strToDateName, new FunctionParams(false, strToDateExprs));
            FunctionName dateFormatName = new FunctionName("DATE_FORMAT");
            ArrayList dateFormatArgs = Lists.newArrayList((Object[])new Expr[]{strToDateFuncExpr, (Expr)funcExpr.getChild(0)});
            return new FunctionCallExpr(dateFormatName, new FunctionParams(false, dateFormatArgs));
        }
        if (funcName.equalsIgnoreCase("alignment_timestamp")) {
            StringLiteral format;
            FunctionName fromUnixName = new FunctionName("FROM_UNIXTIME");
            ArrayList fromUnixArgs = Lists.newArrayList((Object[])new Expr[]{(Expr)funcExpr.getChild(1)});
            FunctionCallExpr fromUnixFunc = new FunctionCallExpr(fromUnixName, new FunctionParams(false, fromUnixArgs));
            StringLiteral precision = (StringLiteral)funcExpr.getChild(0);
            if (precision.getStringValue().equalsIgnoreCase("year")) {
                format = new StringLiteral("%Y-01-01 00:00:00");
            } else if (precision.getStringValue().equalsIgnoreCase("month")) {
                format = new StringLiteral("%Y-%m-01 00:00:00");
            } else if (precision.getStringValue().equalsIgnoreCase("day")) {
                format = new StringLiteral("%Y-%m-%d 00:00:00");
            } else {
                if (!precision.getStringValue().equalsIgnoreCase("hour")) throw new UserException("Unknown precision(" + precision.getStringValue() + ")");
                format = new StringLiteral("%Y-%m-%d %H:00:00");
            }
            FunctionName dateFormatName = new FunctionName("DATE_FORMAT");
            ArrayList dateFormatArgs = Lists.newArrayList((Object[])new Expr[]{fromUnixFunc, format});
            FunctionCallExpr dateFormatFunc = new FunctionCallExpr(dateFormatName, new FunctionParams(false, dateFormatArgs));
            FunctionName unixTimeName = new FunctionName("UNIX_TIMESTAMP");
            ArrayList unixTimeArgs = Lists.newArrayList();
            unixTimeArgs.add(dateFormatFunc);
            return new FunctionCallExpr(unixTimeName, new FunctionParams(false, unixTimeArgs));
        }
        if (funcName.equalsIgnoreCase("default_value")) {
            return (Expr)funcExpr.getChild(0);
        }
        if (funcName.equalsIgnoreCase("now")) {
            FunctionName nowFunctionName = new FunctionName("NOW");
            return new FunctionCallExpr(nowFunctionName, new FunctionParams(null));
        }
        if (!funcName.equalsIgnoreCase("substitute")) return originExpr;
        return (Expr)funcExpr.getChild(0);
    }

    public void unprotectAddLoadJob(LoadJob job, boolean isReplay) throws DdlException {
        long jobId = job.getId();
        long dbId = job.getDbId();
        String label = job.getLabel();
        if (!isReplay && this.getAllUnfinishedLoadJob() > Config.max_unfinished_load_job) {
            throw new DdlException("Number of unfinished load jobs exceed the max number: " + Config.max_unfinished_load_job);
        }
        Preconditions.checkState((!job.isSyncDeleteJob() ? 1 : 0) != 0, (Object)"delete job is deprecated");
        boolean checkMini = true;
        if (job.getEtlJobType() == EtlJobType.MINI) {
            checkMini = false;
        }
        this.unprotectIsLabelUsed(dbId, label, -1L, checkMini);
        Map<Object, Object> labelToLoadJobs = null;
        if (this.dbLabelToLoadJobs.containsKey(dbId)) {
            labelToLoadJobs = this.dbLabelToLoadJobs.get(dbId);
        } else {
            labelToLoadJobs = Maps.newHashMap();
            this.dbLabelToLoadJobs.put(dbId, (Map<String, List<LoadJob>>)labelToLoadJobs);
        }
        List<LoadJob> labelLoadJobs = null;
        if (labelToLoadJobs.containsKey(label)) {
            labelLoadJobs = (List)labelToLoadJobs.get(label);
        } else {
            labelLoadJobs = Lists.newArrayList();
            labelToLoadJobs.put(label, labelLoadJobs);
        }
        List<Object> dbLoadJobs = null;
        if (this.dbToLoadJobs.containsKey(dbId)) {
            dbLoadJobs = this.dbToLoadJobs.get(dbId);
        } else {
            dbLoadJobs = Lists.newArrayList();
            this.dbToLoadJobs.put(dbId, (List<LoadJob>)dbLoadJobs);
        }
        this.idToLoadJob.put(jobId, job);
        dbLoadJobs.add(job);
        labelLoadJobs.add(job);
        switch (job.getState()) {
            case PENDING: {
                this.idToPendingLoadJob.put(jobId, job);
                break;
            }
            case ETL: {
                this.idToEtlLoadJob.put(jobId, job);
                break;
            }
            case LOADING: {
                this.idToLoadingLoadJob.put(jobId, job);
                this.recoverLoadingPartitions(job);
                break;
            }
            case QUORUM_FINISHED: {
                this.idToQuorumFinishedLoadJob.put(jobId, job);
                break;
            }
            case FINISHED: {
                break;
            }
            case CANCELLED: {
                break;
            }
            default: {
                Preconditions.checkNotNull(null, (Object)"Should not be here");
            }
        }
    }

    private long getAllUnfinishedLoadJob() {
        return this.idToPendingLoadJob.size() + this.idToEtlLoadJob.size() + this.idToLoadingLoadJob.size() + this.idToQuorumFinishedLoadJob.size();
    }

    public void replayAddLoadJob(LoadJob job) throws DdlException {
        this.writeLock();
        try {
            this.unprotectAddLoadJob(job, true);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void unprotectEtlLoadJob(LoadJob job) {
        long jobId = job.getId();
        this.idToPendingLoadJob.remove(jobId);
        this.idToEtlLoadJob.put(jobId, job);
        this.replaceLoadJob(job);
    }

    public void replayEtlLoadJob(LoadJob job) throws DdlException {
        this.writeLock();
        try {
            this.unprotectEtlLoadJob(job);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void unprotectLoadingLoadJob(LoadJob job) {
        long jobId = job.getId();
        this.idToEtlLoadJob.remove(jobId);
        this.idToLoadingLoadJob.put(jobId, job);
        this.recoverLoadingPartitions(job);
        this.replaceLoadJob(job);
    }

    public void replayLoadingLoadJob(LoadJob job) throws DdlException {
        this.writeLock();
        try {
            this.unprotectLoadingLoadJob(job);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerMiniLabel(String fullDbName, String label, long timestamp) throws DdlException {
        Database db = Catalog.getCurrentCatalog().getDbOrDdlException(fullDbName);
        long dbId = db.getId();
        this.writeLock();
        try {
            if (this.unprotectIsLabelUsed(dbId, label, timestamp, true)) {
                boolean bl = false;
                return bl;
            }
            Map<Object, Object> miniLabels = null;
            if (this.dbToMiniLabels.containsKey(dbId)) {
                miniLabels = this.dbToMiniLabels.get(dbId);
            } else {
                miniLabels = Maps.newHashMap();
                this.dbToMiniLabels.put(dbId, (Map<String, Long>)miniLabels);
            }
            miniLabels.put(label, timestamp);
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterMiniLabel(String fullDbName, String label) throws DdlException {
        Database db = Catalog.getCurrentCatalog().getDbOrDdlException(fullDbName);
        long dbId = db.getId();
        this.writeLock();
        try {
            if (!this.dbToMiniLabels.containsKey(dbId)) {
                return;
            }
            Map<String, Long> miniLabels = this.dbToMiniLabels.get(dbId);
            miniLabels.remove(label);
            if (miniLabels.isEmpty()) {
                this.dbToMiniLabels.remove(dbId);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUncommittedLabel(long dbId, String label) throws DdlException {
        this.readLock();
        try {
            if (this.dbToMiniLabels.containsKey(dbId)) {
                Map<String, Long> uncommittedLabels = this.dbToMiniLabels.get(dbId);
                boolean bl = uncommittedLabels.containsKey(label);
                return bl;
            }
        }
        finally {
            this.readUnlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLabelUsed(long dbId, String label) throws DdlException {
        this.readLock();
        try {
            boolean bl = this.unprotectIsLabelUsed(dbId, label, -1L, true);
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    private boolean unprotectIsLabelUsed(long dbId, String label, long timestamp, boolean checkMini) throws DdlException {
        Map<String, List<LoadJob>> labelToLoadJobs;
        if (this.dbLabelToLoadJobs.containsKey(dbId) && (labelToLoadJobs = this.dbLabelToLoadJobs.get(dbId)).containsKey(label)) {
            List<LoadJob> labelLoadJobs = labelToLoadJobs.get(label);
            for (LoadJob oldJob : labelLoadJobs) {
                LoadJob.JobState oldJobState = oldJob.getState();
                if (oldJobState == LoadJob.JobState.CANCELLED) continue;
                if (timestamp == -1L) {
                    throw new LabelAlreadyUsedException(label);
                }
                if (timestamp == oldJob.getTimestamp()) {
                    LOG.info("get a retry request with label: {}, timestamp: {}. return ok", (Object)label, (Object)timestamp);
                    return true;
                }
                throw new LabelAlreadyUsedException(label);
            }
        }
        if (checkMini) {
            return this.checkMultiLabelUsed(dbId, label, timestamp);
        }
        return false;
    }

    private boolean checkMultiLabelUsed(long dbId, String label, long timestamp) throws DdlException {
        Map<String, Long> uncommittedLabels;
        if (this.dbToMiniLabels.containsKey(dbId) && (uncommittedLabels = this.dbToMiniLabels.get(dbId)).containsKey(label)) {
            if (timestamp == -1L) {
                throw new LabelAlreadyUsedException(label);
            }
            if (timestamp == uncommittedLabels.get(label)) {
                LOG.info("get a retry mini load request with label: {}, timestamp: {}. return ok", (Object)label, (Object)timestamp);
                return true;
            }
            throw new LabelAlreadyUsedException(label);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLabelExist(String dbName, String labelValue, boolean isAccurateMatch) throws DdlException, AnalysisException {
        Database db = Catalog.getCurrentCatalog().getDbOrDdlException(dbName);
        this.readLock();
        try {
            Map<String, List<LoadJob>> labelToLoadJobs = this.dbLabelToLoadJobs.get(db.getId());
            if (labelToLoadJobs == null) {
                boolean bl = false;
                return bl;
            }
            ArrayList loadJobs = Lists.newArrayList();
            if (isAccurateMatch) {
                if (labelToLoadJobs.containsKey(labelValue)) {
                    loadJobs.addAll((Collection)labelToLoadJobs.get(labelValue));
                }
            } else {
                PatternMatcher matcher = PatternMatcher.createMysqlPattern(labelValue, CaseSensibility.LABEL.getCaseSensibility());
                for (Map.Entry<String, List<LoadJob>> entry : labelToLoadJobs.entrySet()) {
                    if (!matcher.match(entry.getKey())) continue;
                    loadJobs.addAll((Collection)entry.getValue());
                }
            }
            if (loadJobs.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            if (loadJobs.stream().filter(entity -> entity.getState() != LoadJob.JobState.CANCELLED).count() == 0L) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelLoadJob(CancelLoadStmt stmt, boolean isAccurateMatch) throws DdlException, AnalysisException {
        String dbName = stmt.getDbName();
        String label = stmt.getLabel();
        Database db = Catalog.getCurrentCatalog().getDbOrDdlException(dbName);
        ArrayList loadJobs = Lists.newArrayList();
        this.readLock();
        try {
            Map<String, List<LoadJob>> labelToLoadJobs = this.dbLabelToLoadJobs.get(db.getId());
            if (labelToLoadJobs == null) {
                throw new DdlException("Load job does not exist");
            }
            ArrayList matchLoadJobs = Lists.newArrayList();
            if (isAccurateMatch) {
                if (labelToLoadJobs.containsKey(label)) {
                    matchLoadJobs.addAll((Collection)labelToLoadJobs.get(label));
                }
            } else {
                PatternMatcher matcher = PatternMatcher.createMysqlPattern(label, CaseSensibility.LABEL.getCaseSensibility());
                for (Map.Entry<String, List<LoadJob>> entry : labelToLoadJobs.entrySet()) {
                    if (!matcher.match(entry.getKey())) continue;
                    loadJobs.addAll((Collection)entry.getValue());
                }
            }
            if (matchLoadJobs.isEmpty()) {
                throw new DdlException("Load job does not exist");
            }
            List uncompletedLoadJob = matchLoadJobs.stream().filter(job -> {
                LoadJob.JobState state = job.getState();
                return state != LoadJob.JobState.CANCELLED && state != LoadJob.JobState.QUORUM_FINISHED && state != LoadJob.JobState.FINISHED;
            }).collect(Collectors.toList());
            if (uncompletedLoadJob.isEmpty()) {
                throw new DdlException("There is no uncompleted job which label " + (isAccurateMatch ? "is " : "like ") + stmt.getLabel());
            }
            loadJobs.addAll(uncompletedLoadJob);
        }
        finally {
            this.readUnlock();
        }
        HashSet tableNames = Sets.newHashSet();
        for (LoadJob loadJob : loadJobs) {
            tableNames.addAll(loadJob.getTableNames());
        }
        if (tableNames.isEmpty()) {
            if (Catalog.getCurrentCatalog().getAuth().checkDbPriv(ConnectContext.get(), dbName, PrivPredicate.LOAD)) {
                ErrorReport.reportDdlException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "CANCEL LOAD");
            }
        } else {
            for (String tblName : tableNames) {
                if (Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), dbName, tblName, PrivPredicate.LOAD)) continue;
                ErrorReport.reportDdlException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, "CANCEL LOAD", ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), dbName + ": " + tblName);
            }
        }
        for (LoadJob loadJob : loadJobs) {
            ArrayList failedMsg;
            boolean ok = this.cancelLoadJob(loadJob, FailMsg.CancelType.USER_CANCEL, "user cancel", failedMsg = Lists.newArrayList());
            if (ok) continue;
            throw new DdlException("Cancel load job [" + loadJob.getId() + "] fail, label=[" + loadJob.getLabel() + "] failed msg=" + (failedMsg.isEmpty() ? "Unknown reason" : (String)failedMsg.get(0)));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelLoadJob(CancelLoadStmt stmt) throws DdlException {
        ArrayList failedMsg;
        LoadJob job;
        String dbName = stmt.getDbName();
        String label = stmt.getLabel();
        Database db = Catalog.getCurrentCatalog().getDbOrDdlException(dbName);
        this.readLock();
        try {
            Map<String, List<LoadJob>> labelToLoadJobs = this.dbLabelToLoadJobs.get(db.getId());
            if (labelToLoadJobs == null) {
                throw new DdlException("Load job does not exist");
            }
            List<LoadJob> loadJobs = labelToLoadJobs.get(label);
            if (loadJobs == null) {
                throw new DdlException("Load job does not exist");
            }
            job = loadJobs.get(loadJobs.size() - 1);
            LoadJob.JobState state = job.getState();
            if (state == LoadJob.JobState.CANCELLED) {
                throw new DdlException("Load job has been cancelled");
            }
            if (state == LoadJob.JobState.QUORUM_FINISHED || state == LoadJob.JobState.FINISHED) {
                throw new DdlException("Load job has been finished");
            }
        }
        finally {
            this.readUnlock();
        }
        Set<String> tableNames = job.getTableNames();
        if (tableNames.isEmpty()) {
            if (!Catalog.getCurrentCatalog().getAuth().checkDbPriv(ConnectContext.get(), dbName, PrivPredicate.LOAD)) {
                ErrorReport.reportDdlException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "CANCEL LOAD");
            }
        } else {
            for (String tblName : tableNames) {
                if (Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), dbName, tblName, PrivPredicate.LOAD)) continue;
                ErrorReport.reportDdlException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, "CANCEL LOAD", ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), dbName + ": " + tblName);
            }
        }
        if (!this.cancelLoadJob(job, FailMsg.CancelType.USER_CANCEL, "user cancel", failedMsg = Lists.newArrayList())) {
            throw new DdlException("Cancel load job fail: " + (failedMsg.isEmpty() ? "Unknown reason" : (String)failedMsg.get(0)));
        }
        return true;
    }

    public boolean cancelLoadJob(LoadJob job, FailMsg.CancelType cancelType, String msg) {
        return this.cancelLoadJob(job, cancelType, msg, null);
    }

    public boolean cancelLoadJob(LoadJob job, FailMsg.CancelType cancelType, String msg, List<String> failedMsg) {
        LOG.info("try to cancel load job: {}", (Object)job);
        LoadJob.JobState srcState = job.getState();
        if (!this.updateLoadJobState(job, LoadJob.JobState.CANCELLED, cancelType, msg, failedMsg)) {
            LOG.warn("cancel load job failed. job: {}", (Object)job);
            return false;
        }
        if (job.getHadoopDppConfig() != null) {
            this.clearJob(job, srcState);
        }
        Preconditions.checkState((job.getBrokerDesc() == null ? 1 : 0) != 0);
        LOG.info("cancel load job success. job: {}", (Object)job);
        return true;
    }

    public void unprotectCancelLoadJob(LoadJob job) {
        long jobId = job.getId();
        LoadJob oldJob = this.idToLoadJob.get(jobId);
        if (oldJob == null) {
            LOG.warn("cancel job does not exist. id: {}", (Object)jobId);
            return;
        }
        switch (oldJob.getState()) {
            case PENDING: {
                this.idToPendingLoadJob.remove(jobId);
                break;
            }
            case ETL: {
                this.idToEtlLoadJob.remove(jobId);
                break;
            }
            case LOADING: {
                this.idToLoadingLoadJob.remove(jobId);
                this.removeLoadingPartitions(oldJob);
                break;
            }
            default: {
                LOG.warn("cancel job has wrong src state: {}", (Object)oldJob.getState().name());
                return;
            }
        }
        this.replaceLoadJob(job);
    }

    public void replayCancelLoadJob(LoadJob job) {
        this.writeLock();
        try {
            this.unprotectCancelLoadJob(job);
        }
        finally {
            this.writeUnlock();
        }
    }

    public Map<Long, LoadJob> getIdToLoadJob() {
        return this.idToLoadJob;
    }

    public Map<Long, List<LoadJob>> getDbToLoadJobs() {
        return this.dbToLoadJobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LoadJob> getLoadJobs(LoadJob.JobState jobState) {
        ArrayList<LoadJob> jobs = new ArrayList<LoadJob>();
        Collection<LoadJob> stateJobs = null;
        this.readLock();
        try {
            switch (jobState) {
                case PENDING: {
                    stateJobs = this.idToPendingLoadJob.values();
                    break;
                }
                case ETL: {
                    stateJobs = this.idToEtlLoadJob.values();
                    break;
                }
                case LOADING: {
                    stateJobs = this.idToLoadingLoadJob.values();
                    break;
                }
                case QUORUM_FINISHED: {
                    stateJobs = this.idToQuorumFinishedLoadJob.values();
                    break;
                }
            }
            if (stateJobs != null) {
                jobs.addAll(stateJobs);
            }
        }
        finally {
            this.readUnlock();
        }
        return jobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLoadJobNum(LoadJob.JobState jobState, long dbId) {
        this.readLock();
        try {
            List<LoadJob> loadJobs = this.dbToLoadJobs.get(dbId);
            if (loadJobs == null) {
                long l = 0L;
                return l;
            }
            int jobNum = 0;
            for (LoadJob job : loadJobs) {
                if (job.getState() != jobState) continue;
                ++jobNum;
            }
            long l = jobNum;
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadJob getLoadJob(long jobId) {
        this.readLock();
        try {
            LoadJob loadJob = this.idToLoadJob.get(jobId);
            return loadJob;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList<List<Comparable>> getLoadJobInfosByDb(long dbId, String dbName, String labelValue, boolean accurateMatch, Set<LoadJob.JobState> states) throws AnalysisException {
        LinkedList<List<Comparable>> loadJobInfos = new LinkedList<List<Comparable>>();
        this.readLock();
        try {
            List<LoadJob> loadJobs = this.dbToLoadJobs.get(dbId);
            if (loadJobs == null) {
                LinkedList<List<Comparable>> linkedList = loadJobInfos;
                return linkedList;
            }
            long start = System.currentTimeMillis();
            LOG.debug("begin to get load job info, size: {}", (Object)loadJobs.size());
            PatternMatcher matcher = null;
            if (labelValue != null && !accurateMatch) {
                matcher = PatternMatcher.createMysqlPattern(labelValue, CaseSensibility.LABEL.getCaseSensibility());
            }
            for (LoadJob loadJob : loadJobs) {
                String label = loadJob.getLabel();
                LoadJob.JobState state = loadJob.getState();
                if (labelValue != null && (!accurateMatch ? !matcher.match(label) : !label.equals(labelValue))) continue;
                if (states != null && !states.contains((Object)state)) continue;
                Set<String> tableNames = loadJob.getTableNames();
                if (tableNames.isEmpty()) {
                    if (!Catalog.getCurrentCatalog().getAuth().checkDbPriv(ConnectContext.get(), dbName, PrivPredicate.LOAD)) {
                        continue;
                    }
                } else {
                    boolean auth = true;
                    for (String tblName : tableNames) {
                        if (Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), dbName, tblName, PrivPredicate.LOAD)) continue;
                        auth = false;
                        break;
                    }
                    if (!auth) continue;
                }
                ArrayList<Object> jobInfo = new ArrayList<Object>();
                jobInfo.add(loadJob.getId());
                jobInfo.add(label);
                jobInfo.add(state.name());
                switch (loadJob.getState()) {
                    case PENDING: {
                        jobInfo.add("ETL:0%; LOAD:0%");
                        break;
                    }
                    case ETL: {
                        jobInfo.add("ETL:" + loadJob.getProgress() + "%; LOAD:0%");
                        break;
                    }
                    case LOADING: {
                        jobInfo.add("ETL:100%; LOAD:" + loadJob.getProgress() + "%");
                        break;
                    }
                    case QUORUM_FINISHED: {
                        jobInfo.add("ETL:100%; LOAD:100%");
                        break;
                    }
                    case FINISHED: {
                        jobInfo.add("ETL:100%; LOAD:100%");
                        break;
                    }
                    case CANCELLED: {
                        jobInfo.add("ETL:N/A; LOAD:N/A");
                        break;
                    }
                    default: {
                        jobInfo.add("ETL:N/A; LOAD:N/A");
                    }
                }
                jobInfo.add(loadJob.getEtlJobType().name());
                EtlStatus status = loadJob.getEtlJobStatus();
                if (status == null || status.getState() == TEtlState.CANCELLED) {
                    jobInfo.add(FeConstants.null_string);
                } else {
                    Map<String, String> counters = status.getCounters();
                    ArrayList info = Lists.newArrayList();
                    for (String key : counters.keySet()) {
                        if (!key.equalsIgnoreCase("HDFS bytes read") && !key.equalsIgnoreCase("Map input records") && !key.startsWith("dpp.") && loadJob.getEtlJobType() != EtlJobType.MINI) continue;
                        info.add(key + "=" + counters.get(key));
                    }
                    if (info.isEmpty()) {
                        jobInfo.add(FeConstants.null_string);
                    } else {
                        jobInfo.add(StringUtils.join((Collection)info, (String)"; "));
                    }
                }
                jobInfo.add("cluster:" + loadJob.getHadoopCluster() + "; timeout(s):" + loadJob.getTimeoutSecond() + "; max_filter_ratio:" + loadJob.getMaxFilterRatio());
                if (loadJob.getState() == LoadJob.JobState.CANCELLED) {
                    FailMsg failMsg = loadJob.getFailMsg();
                    jobInfo.add("type:" + (Object)((Object)failMsg.getCancelType()) + "; msg:" + failMsg.getMsg());
                } else {
                    jobInfo.add(FeConstants.null_string);
                }
                jobInfo.add(TimeUtils.longToTimeString(loadJob.getCreateTimeMs()));
                jobInfo.add(TimeUtils.longToTimeString(loadJob.getEtlStartTimeMs()));
                jobInfo.add(TimeUtils.longToTimeString(loadJob.getEtlFinishTimeMs()));
                jobInfo.add(TimeUtils.longToTimeString(loadJob.getLoadStartTimeMs()));
                jobInfo.add(TimeUtils.longToTimeString(loadJob.getLoadFinishTimeMs()));
                jobInfo.add(status.getTrackingUrl());
                jobInfo.add("");
                jobInfo.add(loadJob.getTransactionId());
                jobInfo.add("");
                loadJobInfos.add(jobInfo);
            }
            LOG.debug("finished to get load job info, cost: {}", (Object)(System.currentTimeMillis() - start));
        }
        finally {
            this.readUnlock();
        }
        return loadJobInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLatestJobIdByLabel(long dbId, String labelValue) {
        LoadJob job = null;
        long jobId = 0L;
        this.readLock();
        try {
            List<LoadJob> loadJobs = this.dbToLoadJobs.get(dbId);
            if (loadJobs == null) {
                long l = 0L;
                return l;
            }
            for (LoadJob loadJob : loadJobs) {
                long currJobId;
                String label = loadJob.getLabel();
                if (labelValue != null && !label.equals(labelValue) || (currJobId = loadJob.getId()) <= jobId) continue;
                jobId = currJobId;
                job = loadJob;
            }
        }
        finally {
            this.readUnlock();
        }
        return jobId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<Comparable>> getLoadJobUnfinishedInfo(long jobId) {
        LinkedList<List<Comparable>> infos = new LinkedList<List<Comparable>>();
        TabletInvertedIndex invertedIndex = Catalog.getCurrentInvertedIndex();
        LoadJob loadJob = this.getLoadJob(jobId);
        if (loadJob == null || loadJob.getState() != LoadJob.JobState.LOADING && loadJob.getState() != LoadJob.JobState.QUORUM_FINISHED) {
            return infos;
        }
        long dbId = loadJob.getDbId();
        Database db = Catalog.getCurrentCatalog().getDbNullable(dbId);
        if (db == null) {
            return infos;
        }
        this.readLock();
        try {
            Map<Long, TabletLoadInfo> tabletMap = loadJob.getIdToTabletLoadInfo();
            for (long tabletId : tabletMap.keySet()) {
                long tableId;
                OlapTable table;
                TabletMeta tabletMeta = invertedIndex.getTabletMeta(tabletId);
                if (tabletMeta == null || (table = (OlapTable)db.getTableNullable(tableId = tabletMeta.getTableId())) == null) continue;
                table.readLock();
                try {
                    Tablet tablet;
                    long indexId;
                    MaterializedIndex index;
                    long partitionId = tabletMeta.getPartitionId();
                    Partition partition = table.getPartition(partitionId);
                    if (partition == null || (index = partition.getIndex(indexId = tabletMeta.getIndexId())) == null || (tablet = index.getTablet(tabletId)) == null) continue;
                    PartitionLoadInfo partitionLoadInfo = loadJob.getPartitionLoadInfo(tableId, partitionId);
                    long version = partitionLoadInfo.getVersion();
                    for (Replica replica : tablet.getReplicas()) {
                        if (replica.checkVersionCatchUp(version, false)) continue;
                        ArrayList info = Lists.newArrayList();
                        info.add(replica.getBackendId());
                        info.add(tabletId);
                        info.add(replica.getId());
                        info.add(replica.getVersion());
                        info.add(partitionId);
                        info.add(version);
                        infos.add(info);
                    }
                }
                finally {
                    table.readUnlock();
                }
            }
        }
        finally {
            this.readUnlock();
        }
        ListComparator comparator = new ListComparator(3, 0);
        Collections.sort(infos, comparator);
        return infos;
    }

    public LoadErrorHub.Param getLoadErrorHubInfo() {
        return this.loadErrorHubParam;
    }

    public void setLoadErrorHubInfo(LoadErrorHub.Param info) {
        this.loadErrorHubParam = info;
    }

    public void setLoadErrorHubInfo(Map<String, String> properties) throws DdlException {
        String type = properties.get("type");
        if (type.equalsIgnoreCase("MYSQL")) {
            String host = properties.get("host");
            if (Strings.isNullOrEmpty((String)host)) {
                throw new DdlException("mysql host is missing");
            }
            int port = -1;
            try {
                port = Integer.valueOf(properties.get("port"));
            }
            catch (NumberFormatException e) {
                throw new DdlException("invalid mysql port: " + properties.get("port"));
            }
            String user = properties.get("user");
            if (Strings.isNullOrEmpty((String)user)) {
                throw new DdlException("mysql user name is missing");
            }
            String db = properties.get("database");
            if (Strings.isNullOrEmpty((String)db)) {
                throw new DdlException("mysql database is missing");
            }
            String tbl = properties.get("table");
            if (Strings.isNullOrEmpty((String)tbl)) {
                throw new DdlException("mysql table is missing");
            }
            String pwd = Strings.nullToEmpty((String)properties.get("password"));
            MysqlLoadErrorHub.MysqlParam param = new MysqlLoadErrorHub.MysqlParam(host, port, user, pwd, db, tbl);
            this.loadErrorHubParam = LoadErrorHub.Param.createMysqlParam(param);
        } else if (type.equalsIgnoreCase("BROKER")) {
            String brokerName = properties.get("name");
            if (Strings.isNullOrEmpty((String)brokerName)) {
                throw new DdlException("broker name is missing");
            }
            properties.remove("name");
            if (!Catalog.getCurrentCatalog().getBrokerMgr().containsBroker(brokerName)) {
                throw new DdlException("broker does not exist: " + brokerName);
            }
            String path = properties.get("path");
            if (Strings.isNullOrEmpty((String)path)) {
                throw new DdlException("broker path is missing");
            }
            properties.remove("path");
            BlobStorage blobStorage = BlobStorage.create(brokerName, StorageBackend.StorageType.BROKER, properties);
            Status st = blobStorage.checkPathExist(path);
            if (!st.ok()) {
                throw new DdlException("failed to visit path: " + path + ", err: " + st.getErrMsg());
            }
            BrokerLoadErrorHub.BrokerParam param = new BrokerLoadErrorHub.BrokerParam(brokerName, path, properties);
            this.loadErrorHubParam = LoadErrorHub.Param.createBrokerParam(param);
        } else if (type.equalsIgnoreCase("null")) {
            this.loadErrorHubParam = LoadErrorHub.Param.createNullParam();
        }
        Catalog.getCurrentCatalog().getEditLog().logSetLoadErrorHub(this.loadErrorHubParam);
        LOG.info("set load error hub info: {}", (Object)this.loadErrorHubParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getJobInfo(JobInfo info) throws DdlException, MetaNotFoundException {
        String fullDbName;
        info.dbName = fullDbName = ClusterNamespace.getFullName(info.clusterName, info.dbName);
        Database db = Catalog.getCurrentCatalog().getDbOrMetaException(fullDbName);
        this.readLock();
        try {
            Map<String, List<LoadJob>> labelToLoadJobs = this.dbLabelToLoadJobs.get(db.getId());
            if (labelToLoadJobs == null) {
                throw new DdlException("No jobs belong to database(" + info.dbName + ")");
            }
            List<LoadJob> loadJobs = labelToLoadJobs.get(info.label);
            if (loadJobs == null) {
                throw new DdlException("Unknown job(" + info.label + ")");
            }
            LoadJob job = loadJobs.get(loadJobs.size() - 1);
            if (!job.getTableNames().isEmpty()) {
                info.tblNames.addAll(job.getTableNames());
            }
            info.state = job.getState();
            if (info.state == LoadJob.JobState.QUORUM_FINISHED) {
                info.state = LoadJob.JobState.FINISHED;
            }
            info.failMsg = job.getFailMsg().getMsg();
            info.trackingUrl = job.getEtlJobStatus().getTrackingUrl();
        }
        finally {
            this.readUnlock();
        }
    }

    public void unprotectQuorumLoadJob(LoadJob job, Database db) {
        if (job.getTransactionId() < 0L) {
            this.removeLoadingPartitions(job);
            Map<Long, ReplicaPersistInfo> replicaInfos = job.getReplicaPersistInfos();
            if (replicaInfos != null) {
                for (ReplicaPersistInfo info : replicaInfos.values()) {
                    OlapTable table = (OlapTable)db.getTableNullable(info.getTableId());
                    if (table == null) {
                        LOG.warn("the table[{}] is missing", (Object)info.getIndexId());
                        continue;
                    }
                    Partition partition = table.getPartition(info.getPartitionId());
                    if (partition == null) {
                        LOG.warn("the partition[{}] is missing", (Object)info.getIndexId());
                        continue;
                    }
                    MaterializedIndex index = partition.getIndex(info.getIndexId());
                    if (index == null) {
                        LOG.warn("the index[{}] is missing", (Object)info.getIndexId());
                        continue;
                    }
                    Tablet tablet = index.getTablet(info.getTabletId());
                    if (tablet == null) {
                        LOG.warn("the tablet[{}] is missing", (Object)info.getTabletId());
                        continue;
                    }
                    Replica replica = tablet.getReplicaById(info.getReplicaId());
                    if (replica == null) {
                        LOG.warn("the replica[{}] is missing", (Object)info.getReplicaId());
                        continue;
                    }
                    replica.updateVersionInfo(info.getVersion(), info.getDataSize(), info.getRowCount());
                }
            }
            long jobId = job.getId();
            Map<Long, TableLoadInfo> idToTableLoadInfo = job.getIdToTableLoadInfo();
            if (idToTableLoadInfo != null) {
                for (Map.Entry<Long, TableLoadInfo> tableEntry : idToTableLoadInfo.entrySet()) {
                    long tableId = tableEntry.getKey();
                    OlapTable table = (OlapTable)db.getTableNullable(tableId);
                    if (table == null) continue;
                    TableLoadInfo tableLoadInfo = tableEntry.getValue();
                    for (Map.Entry<Long, PartitionLoadInfo> entry : tableLoadInfo.getIdToPartitionLoadInfo().entrySet()) {
                        long partitionId = entry.getKey();
                        Partition partition = table.getPartition(partitionId);
                        PartitionLoadInfo partitionLoadInfo = entry.getValue();
                        if (!partitionLoadInfo.isNeedLoad()) continue;
                        this.updatePartitionVersion(partition, partitionLoadInfo.getVersion(), jobId);
                        for (MaterializedIndex materializedIndex : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.ALL)) {
                            long indexRowCount = 0L;
                            for (Tablet tablet : materializedIndex.getTablets()) {
                                long tabletRowCount = 0L;
                                for (Replica replica : tablet.getReplicas()) {
                                    long replicaRowCount = replica.getRowCount();
                                    if (replicaRowCount <= tabletRowCount) continue;
                                    tabletRowCount = replicaRowCount;
                                }
                                indexRowCount += tabletRowCount;
                            }
                            materializedIndex.setRowCount(indexRowCount);
                        }
                    }
                }
            }
            this.idToLoadingLoadJob.remove(jobId);
            this.idToQuorumFinishedLoadJob.put(jobId, job);
        }
        this.replaceLoadJob(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayQuorumLoadJob(LoadJob job, Catalog catalog) throws MetaNotFoundException {
        Database db = catalog.getDbOrMetaException(job.getDbId());
        ArrayList tableIds = Lists.newArrayList();
        long tblId = job.getTableId();
        if (tblId > 0L) {
            tableIds.add(tblId);
        } else {
            tableIds.addAll(job.getIdToTableLoadInfo().keySet());
        }
        List<Table> tables = db.getTablesOnIdOrderOrThrowException(tableIds);
        MetaLockUtils.writeLockTables(tables);
        try {
            this.writeLock();
            try {
                this.unprotectQuorumLoadJob(job, db);
            }
            finally {
                this.writeUnlock();
            }
        }
        finally {
            MetaLockUtils.writeUnlockTables(tables);
        }
    }

    public void unprotectFinishLoadJob(LoadJob job, Database db) {
        long jobId = job.getId();
        if (job.getTransactionId() < 0L) {
            this.idToQuorumFinishedLoadJob.remove(jobId);
            Map<Long, ReplicaPersistInfo> replicaInfos = job.getReplicaPersistInfos();
            if (replicaInfos != null) {
                for (ReplicaPersistInfo info : replicaInfos.values()) {
                    OlapTable table = (OlapTable)db.getTableNullable(info.getTableId());
                    if (table == null) {
                        LOG.warn("the table[{}] is missing", (Object)info.getIndexId());
                        continue;
                    }
                    Partition partition = table.getPartition(info.getPartitionId());
                    if (partition == null) {
                        LOG.warn("the partition[{}] is missing", (Object)info.getIndexId());
                        continue;
                    }
                    MaterializedIndex index = partition.getIndex(info.getIndexId());
                    if (index == null) {
                        LOG.warn("the index[{}] is missing", (Object)info.getIndexId());
                        continue;
                    }
                    Tablet tablet = index.getTablet(info.getTabletId());
                    if (tablet == null) {
                        LOG.warn("the tablet[{}] is missing", (Object)info.getTabletId());
                        continue;
                    }
                    Replica replica = tablet.getReplicaById(info.getReplicaId());
                    if (replica == null) {
                        LOG.warn("the replica[{}] is missing", (Object)info.getReplicaId());
                        continue;
                    }
                    replica.updateVersionInfo(info.getVersion(), info.getDataSize(), info.getRowCount());
                }
            }
        } else {
            this.idToPendingLoadJob.remove(jobId);
            this.idToLoadingLoadJob.remove(jobId);
            job.setProgress(100);
            job.setLoadFinishTimeMs(System.currentTimeMillis());
        }
        this.replaceLoadJob(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayFinishLoadJob(LoadJob job, Catalog catalog) throws MetaNotFoundException {
        Database db = catalog.getDbOrMetaException(job.getDbId());
        db.writeLock();
        try {
            this.writeLock();
            try {
                this.unprotectFinishLoadJob(job, db);
            }
            finally {
                this.writeUnlock();
            }
        }
        finally {
            db.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayClearRollupInfo(ReplicaPersistInfo info, Catalog catalog) throws MetaNotFoundException {
        Database db = catalog.getDbOrMetaException(info.getDbId());
        OlapTable olapTable = (OlapTable)db.getTableOrMetaException(info.getTableId(), Table.TableType.OLAP);
        olapTable.writeLock();
        try {
            Partition partition = olapTable.getPartition(info.getPartitionId());
            MaterializedIndex index = partition.getIndex(info.getIndexId());
            index.clearRollupIndexInfo();
        }
        finally {
            olapTable.writeUnlock();
        }
    }

    private void replaceLoadJob(LoadJob job) {
        long jobId = job.getId();
        if (!this.idToLoadJob.containsKey(jobId)) {
            LOG.warn("Does not find load job in idToLoadJob. JobId : {}", (Object)jobId);
            return;
        }
        this.idToLoadJob.put(jobId, job);
        Preconditions.checkState((!job.isSyncDeleteJob() ? 1 : 0) != 0, (Object)"delete job is deprecated");
        List<LoadJob> jobs = this.dbToLoadJobs.get(job.getDbId());
        if (jobs == null) {
            LOG.warn("Does not find db in dbToLoadJobs. DbId : {}", (Object)job.getDbId());
            return;
        }
        int pos = 0;
        for (LoadJob oneJob : jobs) {
            if (oneJob.getId() == jobId) break;
            ++pos;
        }
        if (pos == jobs.size()) {
            LOG.warn("Does not find load job for db. DbId : {}, jobId : {}", (Object)job.getDbId(), (Object)jobId);
            return;
        }
        jobs.remove(pos);
        jobs.add(pos, job);
        if (this.dbLabelToLoadJobs.get(job.getDbId()) == null) {
            LOG.warn("Does not find db in dbLabelToLoadJobs. DbId : {}", (Object)job.getDbId());
            return;
        }
        jobs = this.dbLabelToLoadJobs.get(job.getDbId()).get(job.getLabel());
        if (jobs == null) {
            LOG.warn("Does not find label for db. label : {}, DbId : {}", (Object)job.getLabel(), (Object)job.getDbId());
            return;
        }
        pos = 0;
        for (LoadJob oneJob : jobs) {
            if (oneJob.getId() == jobId) break;
            ++pos;
        }
        if (pos == jobs.size()) {
            LOG.warn("Does not find load job for label. label : {}, DbId : {}", (Object)job.getLabel(), (Object)job.getDbId());
            return;
        }
        jobs.remove(pos);
        jobs.add(pos, job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDbLoadJob(long dbId) {
        this.writeLock();
        try {
            if (this.dbToLoadJobs.containsKey(dbId)) {
                List<LoadJob> dbLoadJobs = this.dbToLoadJobs.remove(dbId);
                for (LoadJob job : dbLoadJobs) {
                    LoadJob.JobState state = job.getState();
                    if (state != LoadJob.JobState.CANCELLED && state != LoadJob.JobState.FINISHED) continue;
                    this.idToLoadJob.remove(job.getId());
                }
            }
            if (this.dbLabelToLoadJobs.containsKey(dbId)) {
                this.dbLabelToLoadJobs.remove(dbId);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOldLoadJobs() {
        long currentTimeMs = System.currentTimeMillis();
        this.writeLock();
        try {
            Iterator<Map.Entry<Long, LoadJob>> iter = this.idToLoadJob.entrySet().iterator();
            while (iter.hasNext()) {
                Map<String, List<LoadJob>> mapLabelToJobs;
                Map.Entry<Long, LoadJob> entry = iter.next();
                LoadJob job = entry.getValue();
                if (!job.isExpired(currentTimeMs)) continue;
                long dbId = job.getDbId();
                String label = job.getLabel();
                iter.remove();
                List<LoadJob> loadJobs = this.dbToLoadJobs.get(dbId);
                if (loadJobs != null) {
                    loadJobs.remove(job);
                    if (loadJobs.size() == 0) {
                        this.dbToLoadJobs.remove(dbId);
                    }
                }
                if ((mapLabelToJobs = this.dbLabelToLoadJobs.get(dbId)) == null || (loadJobs = mapLabelToJobs.get(label)) == null) continue;
                loadJobs.remove(job);
                if (!loadJobs.isEmpty()) continue;
                mapLabelToJobs.remove(label);
                if (!mapLabelToJobs.isEmpty()) continue;
                this.dbLabelToLoadJobs.remove(dbId);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public void clearJob(LoadJob job, LoadJob.JobState srcState) {
        LoadJob.JobState state = job.getState();
        if (state != LoadJob.JobState.CANCELLED && state != LoadJob.JobState.FINISHED) {
            LOG.warn("job state error. state: {}", (Object)state);
            return;
        }
        EtlJobType etlJobType = job.getEtlJobType();
        block2 : switch (etlJobType) {
            case HADOOP: {
                DppScheduler dppScheduler = new DppScheduler(job.getHadoopDppConfig());
                if (state == LoadJob.JobState.CANCELLED && srcState == LoadJob.JobState.ETL) {
                    try {
                        dppScheduler.killEtlJob(job.getHadoopEtlJobId());
                    }
                    catch (Exception e) {
                        LOG.warn("kill etl job error", (Throwable)e);
                    }
                }
                DppConfig dppConfig = job.getHadoopDppConfig();
                String outputPath = DppScheduler.getEtlOutputPath(dppConfig.getFsDefaultName(), dppConfig.getOutputPath(), job.getDbId(), job.getLabel(), "");
                try {
                    dppScheduler.deleteEtlOutputPath(outputPath);
                }
                catch (Exception e) {
                    LOG.warn("delete etl output path error", (Throwable)e);
                }
                break;
            }
            case MINI: {
                for (MiniEtlTaskInfo taskInfo : job.getMiniEtlTasks().values()) {
                    long backendId = taskInfo.getBackendId();
                    Backend backend = Catalog.getCurrentSystemInfo().getBackend(backendId);
                    if (backend == null) {
                        LOG.warn("backend does not exist. id: {}", (Object)backendId);
                        break block2;
                    }
                    long dbId = job.getDbId();
                    Database db = Catalog.getCurrentCatalog().getDbNullable(dbId);
                    if (db == null) {
                        LOG.warn("db does not exist. id: {}", (Object)dbId);
                        break block2;
                    }
                    AgentClient client = new AgentClient(backend.getHost(), backend.getBePort());
                    client.deleteEtlFiles(dbId, job.getId(), db.getFullName(), job.getLabel());
                }
                break;
            }
            case INSERT: {
                break;
            }
            case BROKER: {
                break;
            }
            case DELETE: {
                break;
            }
            default: {
                LOG.warn("unknown etl job type. type: {}, job id: {}", (Object)etlJobType.name(), (Object)job.getId());
            }
        }
    }

    public boolean updateLoadJobState(LoadJob job, LoadJob.JobState destState) {
        return this.updateLoadJobState(job, destState, FailMsg.CancelType.UNKNOWN, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateLoadJobState(LoadJob job, LoadJob.JobState destState, FailMsg.CancelType cancelType, String msg, List<String> failedMsg) {
        result = true;
        jobId = job.getId();
        dbId = job.getDbId();
        db = Catalog.getCurrentCatalog().getDbNullable(dbId);
        errMsg = msg;
        if (db == null) {
            errMsg = "db does not exist. id: " + dbId;
            Load.LOG.warn(errMsg);
            this.writeLock();
            try {
                this.processCancelled(job, cancelType, errMsg, failedMsg);
            }
            finally {
                this.writeUnlock();
            }
        }
        db.writeLock();
        try {
            this.writeLock();
            try {
                srcState = job.getState();
                if (!Load.STATE_CHANGE_MAP.containsKey((Object)srcState)) {
                    Load.LOG.warn("src state error. src state: {}", (Object)srcState.name());
                    var14_12 = false;
                    return var14_12;
                }
                destStates = Load.STATE_CHANGE_MAP.get((Object)srcState);
                if (!destStates.contains((Object)destState)) {
                    Load.LOG.warn("state change error. src state: {}, dest state: {}", (Object)srcState.name(), (Object)destState.name());
                    var15_15 = false;
                    return var15_15;
                }
                switch (1.$SwitchMap$org$apache$doris$load$LoadJob$JobState[destState.ordinal()]) {
                    case 2: {
                        this.idToPendingLoadJob.remove(jobId);
                        this.idToEtlLoadJob.put(jobId, job);
                        job.setProgress(0);
                        job.setEtlStartTimeMs(System.currentTimeMillis());
                        job.setState(destState);
                        Catalog.getCurrentCatalog().getEditLog().logLoadEtl(job);
                        ** break;
lbl42:
                        // 1 sources

                        break;
                    }
                    case 3: {
                        this.idToEtlLoadJob.remove(jobId);
                        this.idToLoadingLoadJob.put(jobId, job);
                        job.setProgress(0);
                        job.setLoadStartTimeMs(System.currentTimeMillis());
                        job.setState(destState);
                        Catalog.getCurrentCatalog().getEditLog().logLoadLoading(job);
                        ** break;
lbl53:
                        // 1 sources

                        break;
                    }
                    case 4: {
                        if (this.processQuorumFinished(job, db)) {
                            Catalog.getCurrentCatalog().getEditLog().logLoadQuorum(job);
                            ** break;
lbl58:
                            // 1 sources

                            break;
                        }
                        errMsg = "process loading finished fail";
                        this.processCancelled(job, cancelType, errMsg, failedMsg);
                        ** break;
lbl63:
                        // 1 sources

                        break;
                    }
                    case 5: {
                        if (job.getTransactionId() > 0L) {
                            this.idToPendingLoadJob.remove(jobId);
                            this.idToLoadingLoadJob.remove(jobId);
                            job.setProgress(100);
                            job.setLoadFinishTimeMs(System.currentTimeMillis());
                        }
                        MetricRepo.COUNTER_LOAD_FINISHED.increase(1L);
                        this.idToLoadingLoadJob.remove(jobId);
                        this.idToQuorumFinishedLoadJob.remove(jobId);
                        job.setState(destState);
                        for (PushTask pushTask : job.getPushTasks()) {
                            AgentTaskQueue.removePushTask(pushTask.getBackendId(), pushTask.getSignature(), pushTask.getVersion(), pushTask.getPushType(), pushTask.getTaskType());
                        }
                        if (!job.isSyncDeleteJob()) {
                            job.clearRedundantInfoForHistoryJob();
                        }
                        Catalog.getCurrentCatalog().getEditLog().logLoadDone(job);
                        ** break;
lbl85:
                        // 1 sources

                        break;
                    }
                    case 6: {
                        this.processCancelled(job, cancelType, errMsg, failedMsg);
                        ** break;
lbl90:
                        // 1 sources

                        break;
                    }
                    default: {
                        Preconditions.checkState((boolean)false, (Object)("wrong job state: " + destState.name()));
                        break;
                    }
                }
            }
            finally {
                this.writeUnlock();
            }
        }
        finally {
            db.writeUnlock();
        }
        if (destState == job.getState()) return result;
        return false;
    }

    private boolean processQuorumFinished(LoadJob job, Database db) {
        long partitionId;
        TableLoadInfo tableLoadInfo;
        OlapTable table;
        long tableId;
        long jobId = job.getId();
        this.removeLoadingPartitions(job);
        Map<Long, TableLoadInfo> idToTableLoadInfo = job.getIdToTableLoadInfo();
        for (Map.Entry<Long, TableLoadInfo> tableEntry : idToTableLoadInfo.entrySet()) {
            tableId = tableEntry.getKey();
            table = (OlapTable)db.getTableNullable(tableId);
            if (table == null) {
                LOG.warn("table does not exist, id: {}", (Object)tableId);
                return false;
            }
            tableLoadInfo = tableEntry.getValue();
            for (Map.Entry<Long, PartitionLoadInfo> partitionEntry : tableLoadInfo.getIdToPartitionLoadInfo().entrySet()) {
                Partition partition;
                partitionId = partitionEntry.getKey();
                PartitionLoadInfo partitionLoadInfo = partitionEntry.getValue();
                if (!partitionLoadInfo.isNeedLoad() || (partition = table.getPartition(partitionId)) != null) continue;
                LOG.warn("partition does not exist, id: {}", (Object)partitionId);
                return false;
            }
        }
        for (Map.Entry<Long, TableLoadInfo> tableEntry : idToTableLoadInfo.entrySet()) {
            tableId = tableEntry.getKey();
            table = (OlapTable)db.getTableNullable(tableId);
            if (table == null) continue;
            tableLoadInfo = tableEntry.getValue();
            for (Map.Entry<Long, PartitionLoadInfo> entry : tableLoadInfo.getIdToPartitionLoadInfo().entrySet()) {
                partitionId = entry.getKey();
                Partition partition = table.getPartition(partitionId);
                PartitionLoadInfo partitionLoadInfo = entry.getValue();
                if (!partitionLoadInfo.isNeedLoad()) continue;
                this.updatePartitionVersion(partition, partitionLoadInfo.getVersion(), jobId);
                for (MaterializedIndex materializedIndex : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.ALL)) {
                    long tableRowCount = 0L;
                    for (Tablet tablet : materializedIndex.getTablets()) {
                        long tabletRowCount = 0L;
                        for (Replica replica : tablet.getReplicas()) {
                            long replicaRowCount = replica.getRowCount();
                            if (replicaRowCount <= tabletRowCount) continue;
                            tabletRowCount = replicaRowCount;
                        }
                        tableRowCount += tabletRowCount;
                    }
                    materializedIndex.setRowCount(tableRowCount);
                }
            }
        }
        this.idToPendingLoadJob.remove(jobId);
        this.idToLoadingLoadJob.remove(jobId);
        this.idToQuorumFinishedLoadJob.put(jobId, job);
        job.setProgress(100);
        job.setLoadFinishTimeMs(System.currentTimeMillis());
        job.setState(LoadJob.JobState.QUORUM_FINISHED);
        return true;
    }

    private void updatePartitionVersion(Partition partition, long version, long jobId) {
        long partitionId = partition.getId();
        partition.updateVisibleVersion(version);
        LOG.info("update partition version success. version: {}, job id: {}, partition id: {}", (Object)version, (Object)jobId, (Object)partitionId);
    }

    private boolean processCancelled(LoadJob job, FailMsg.CancelType cancelType, String msg, List<String> failedMsg) {
        long jobId = job.getId();
        LoadJob.JobState srcState = job.getState();
        FailMsg.CancelType tmpCancelType = FailMsg.CancelType.UNKNOWN;
        try {
            Catalog.getCurrentGlobalTransactionMgr().abortTransaction(job.getDbId(), job.getTransactionId(), job.getFailMsg().toString());
        }
        catch (TransactionNotFoundException e) {
            LOG.info("transaction not found when try to abort it: {}", (Object)e.getTransactionId());
        }
        catch (AnalysisException e) {
            if (!e.getMessage().contains("does not exist")) {
                if (failedMsg != null) {
                    failedMsg.add("Abort transaction failed: " + e.getMessage());
                }
                return false;
            }
        }
        catch (Exception e) {
            LOG.info("errors while abort transaction", (Throwable)e);
            if (failedMsg != null) {
                failedMsg.add("Abort transaction failed: " + e.getMessage());
            }
            return false;
        }
        switch (srcState) {
            case PENDING: {
                this.idToPendingLoadJob.remove(jobId);
                tmpCancelType = FailMsg.CancelType.ETL_SUBMIT_FAIL;
                break;
            }
            case ETL: {
                this.idToEtlLoadJob.remove(jobId);
                tmpCancelType = FailMsg.CancelType.ETL_RUN_FAIL;
                break;
            }
            case LOADING: {
                this.removeLoadingPartitions(job);
                this.idToLoadingLoadJob.remove(jobId);
                tmpCancelType = FailMsg.CancelType.LOAD_RUN_FAIL;
                break;
            }
            case QUORUM_FINISHED: {
                this.idToQuorumFinishedLoadJob.remove(jobId);
                tmpCancelType = FailMsg.CancelType.LOAD_RUN_FAIL;
                break;
            }
            default: {
                Preconditions.checkState((boolean)false, (Object)("wrong job state: " + srcState.name()));
            }
        }
        FailMsg.CancelType newCancelType = cancelType;
        if (newCancelType == FailMsg.CancelType.UNKNOWN) {
            newCancelType = tmpCancelType;
        }
        FailMsg failMsg = new FailMsg(newCancelType, msg);
        job.setFailMsg(failMsg);
        job.setLoadFinishTimeMs(System.currentTimeMillis());
        job.setState(LoadJob.JobState.CANCELLED);
        if (srcState == LoadJob.JobState.LOADING || srcState == LoadJob.JobState.QUORUM_FINISHED) {
            for (PushTask pushTask : job.getPushTasks()) {
                AgentTaskQueue.removePushTask(pushTask.getBackendId(), pushTask.getSignature(), pushTask.getVersion(), pushTask.getPushType(), pushTask.getTaskType());
            }
        }
        job.clearRedundantInfoForHistoryJob();
        Catalog.getCurrentCatalog().getEditLog().logLoadCancel(job);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addLoadingPartitions(Set<Long> partitionIds) {
        this.writeLock();
        try {
            for (long partitionId : partitionIds) {
                if (!this.loadingPartitionIds.contains(partitionId)) continue;
                LOG.info("partition {} is loading", (Object)partitionId);
                boolean bl = false;
                return bl;
            }
            this.loadingPartitionIds.addAll(partitionIds);
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    private void recoverLoadingPartitions(LoadJob job) {
        if (job.getTransactionId() > 0L) {
            return;
        }
        for (TableLoadInfo tableLoadInfo : job.getIdToTableLoadInfo().values()) {
            Map<Long, PartitionLoadInfo> idToPartitionLoadInfo = tableLoadInfo.getIdToPartitionLoadInfo();
            for (Map.Entry<Long, PartitionLoadInfo> entry : idToPartitionLoadInfo.entrySet()) {
                PartitionLoadInfo partitionLoadInfo = entry.getValue();
                if (!partitionLoadInfo.isNeedLoad()) continue;
                this.loadingPartitionIds.add(entry.getKey());
            }
        }
    }

    public void removeLoadingPartitions(Set<Long> partitionIds) {
        this.writeLock();
        try {
            this.loadingPartitionIds.removeAll(partitionIds);
        }
        finally {
            this.writeUnlock();
        }
    }

    private void removeLoadingPartitions(LoadJob job) {
        for (TableLoadInfo tableLoadInfo : job.getIdToTableLoadInfo().values()) {
            Map<Long, PartitionLoadInfo> idToPartitionLoadInfo = tableLoadInfo.getIdToPartitionLoadInfo();
            for (Map.Entry<Long, PartitionLoadInfo> entry : idToPartitionLoadInfo.entrySet()) {
                PartitionLoadInfo partitionLoadInfo = entry.getValue();
                if (!partitionLoadInfo.isNeedLoad()) continue;
                this.loadingPartitionIds.remove(entry.getKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPartitionLoadFinished(long partitionId, List<LoadJob> quorumFinishedLoadJobs) {
        this.readLock();
        try {
            for (LoadJob.JobState state : LoadJob.JobState.values()) {
                if (state == LoadJob.JobState.FINISHED || state == LoadJob.JobState.CANCELLED) continue;
                List<LoadJob> loadJobs = this.getLoadJobs(state);
                for (LoadJob loadJob : loadJobs) {
                    Preconditions.checkNotNull(loadJob.getIdToTableLoadInfo());
                    for (TableLoadInfo tableLoadInfo : loadJob.getIdToTableLoadInfo().values()) {
                        if (!tableLoadInfo.getIdToPartitionLoadInfo().containsKey(partitionId)) continue;
                        if (state == LoadJob.JobState.QUORUM_FINISHED) {
                            if (quorumFinishedLoadJobs != null) {
                                quorumFinishedLoadJobs.add(loadJob);
                                continue;
                            }
                            boolean bl = false;
                            return bl;
                        }
                        boolean bl = false;
                        return bl;
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    static {
        HashSet pendingDestStates = Sets.newHashSet();
        pendingDestStates.add(LoadJob.JobState.ETL);
        pendingDestStates.add(LoadJob.JobState.CANCELLED);
        STATE_CHANGE_MAP.put(LoadJob.JobState.PENDING, pendingDestStates);
        HashSet etlDestStates = Sets.newHashSet();
        etlDestStates.add(LoadJob.JobState.LOADING);
        etlDestStates.add(LoadJob.JobState.CANCELLED);
        STATE_CHANGE_MAP.put(LoadJob.JobState.ETL, etlDestStates);
        HashSet loadingDestStates = Sets.newHashSet();
        loadingDestStates.add(LoadJob.JobState.FINISHED);
        loadingDestStates.add(LoadJob.JobState.QUORUM_FINISHED);
        loadingDestStates.add(LoadJob.JobState.CANCELLED);
        STATE_CHANGE_MAP.put(LoadJob.JobState.LOADING, loadingDestStates);
        HashSet quorumFinishedDestStates = Sets.newHashSet();
        quorumFinishedDestStates.add(LoadJob.JobState.FINISHED);
        STATE_CHANGE_MAP.put(LoadJob.JobState.QUORUM_FINISHED, quorumFinishedDestStates);
        Gson gson = new Gson();
        try {
            HashMap defaultConfig = (HashMap)gson.fromJson(Config.dpp_default_config_str, HashMap.class);
            dppDefaultConfig = DppConfig.create(defaultConfig);
            HashMap clusterToConfig = (HashMap)gson.fromJson(Config.dpp_config_str, HashMap.class);
            for (Map.Entry entry : clusterToConfig.entrySet()) {
                String cluster = (String)entry.getKey();
                DppConfig dppConfig = dppDefaultConfig.getCopiedDppConfig();
                dppConfig.update(DppConfig.create((Map)entry.getValue()));
                dppConfig.check();
                clusterToDppConfig.put(cluster, dppConfig);
            }
            if (!clusterToDppConfig.containsKey(Config.dpp_default_cluster)) {
                throw new LoadException("Default cluster not exist");
            }
        }
        catch (Throwable e) {
            LOG.error("dpp default config ill-formed", e);
            System.exit(-1);
        }
    }

    public static class JobInfo {
        public String dbName;
        public Set<String> tblNames = Sets.newHashSet();
        public String label;
        public String clusterName;
        public LoadJob.JobState state;
        public String failMsg;
        public String trackingUrl;

        public JobInfo(String dbName, String label, String clusterName) {
            this.dbName = dbName;
            this.label = label;
            this.clusterName = clusterName;
        }
    }
}

