/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.common.Config;
import org.apache.doris.common.io.Text;
import org.apache.doris.load.DppConfig;
import org.apache.doris.load.EtlJobInfo;

public class HadoopEtlJobInfo
extends EtlJobInfo {
    private String cluster = Config.dpp_default_cluster;
    private String etlJobId = "";
    private String etlOutputDir = String.valueOf(System.currentTimeMillis());
    private DppConfig dppConfig;

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getEtlJobId() {
        return this.etlJobId;
    }

    public void setEtlJobId(String etlJobId) {
        this.etlJobId = etlJobId;
    }

    public String getEtlOutputDir() {
        return this.etlOutputDir;
    }

    public void setEtlOutputDir(String etlOutputDir) {
        this.etlOutputDir = etlOutputDir;
    }

    public DppConfig getDppConfig() {
        return this.dppConfig;
    }

    public void setDppConfig(DppConfig dppConfig) {
        this.dppConfig = dppConfig;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        Text.writeString((DataOutput)out, (String)this.cluster);
        Text.writeString((DataOutput)out, (String)this.etlJobId);
        Text.writeString((DataOutput)out, (String)this.etlOutputDir);
        if (this.dppConfig == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.dppConfig.write(out);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.cluster = Text.readString((DataInput)in);
        this.etlJobId = Text.readString((DataInput)in);
        this.etlOutputDir = Text.readString((DataInput)in);
        if (in.readBoolean()) {
            this.dppConfig = new DppConfig();
            this.dppConfig.readFields(in);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HadoopEtlJobInfo)) {
            return false;
        }
        HadoopEtlJobInfo jobInfo = (HadoopEtlJobInfo)obj;
        if (this.dppConfig != jobInfo.dppConfig) {
            if (this.dppConfig == null || jobInfo.dppConfig == null) {
                return false;
            }
            if (!this.dppConfig.equals(jobInfo.dppConfig)) {
                return false;
            }
        }
        return this.cluster.equals(jobInfo.cluster) && this.etlJobId.equals(jobInfo.etlJobId) && this.etlOutputDir.equals(jobInfo.etlOutputDir);
    }
}

