/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.doris.analysis.ExportStmt;
import org.apache.doris.analysis.TableName;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.CaseSensibility;
import org.apache.doris.common.Config;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.LabelAlreadyUsedException;
import org.apache.doris.common.PatternMatcher;
import org.apache.doris.common.util.ListComparator;
import org.apache.doris.common.util.OrderByPair;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.load.ExportFailMsg;
import org.apache.doris.load.ExportJob;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExportMgr {
    private static final Logger LOG = LogManager.getLogger(ExportJob.class);
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private Map<Long, ExportJob> idToJob = Maps.newHashMap();
    private Map<String, Long> labelToJobId = Maps.newHashMap();

    public void readLock() {
        this.lock.readLock().lock();
    }

    public void readUnlock() {
        this.lock.readLock().unlock();
    }

    private void writeLock() {
        this.lock.writeLock().lock();
    }

    private void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    public List<ExportJob> getJobs() {
        return Lists.newArrayList(this.idToJob.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExportJob(ExportStmt stmt) throws Exception {
        long jobId = Catalog.getCurrentCatalog().getNextId();
        ExportJob job = this.createJob(jobId, stmt);
        this.writeLock();
        try {
            if (this.labelToJobId.containsKey(job.getLabel())) {
                throw new LabelAlreadyUsedException(job.getLabel());
            }
            this.unprotectAddJob(job);
            Catalog.getCurrentCatalog().getEditLog().logExportCreate(job);
        }
        finally {
            this.writeUnlock();
        }
        LOG.info("add export job. {}", (Object)job);
    }

    public void unprotectAddJob(ExportJob job) {
        this.idToJob.put(job.getId(), job);
        this.labelToJobId.putIfAbsent(job.getLabel(), job.getId());
    }

    private ExportJob createJob(long jobId, ExportStmt stmt) throws Exception {
        ExportJob job = new ExportJob(jobId);
        job.setJob(stmt);
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExportJob> getExportJobs(ExportJob.JobState state) {
        ArrayList result = Lists.newArrayList();
        this.readLock();
        try {
            for (ExportJob job : this.idToJob.values()) {
                if (job.getState() != state) continue;
                result.add(job);
            }
        }
        finally {
            this.readUnlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> getExportJobInfosByIdOrState(long dbId, long jobId, String label, boolean isLabelUseLike, Set<ExportJob.JobState> states, ArrayList<OrderByPair> orderByPairs, long limit) throws AnalysisException {
        long resultNum = limit == -1L ? Integer.MAX_VALUE : limit;
        LinkedList exportJobInfos = new LinkedList();
        PatternMatcher matcher = null;
        if (isLabelUseLike) {
            matcher = PatternMatcher.createMysqlPattern(label, CaseSensibility.LABEL.getCaseSensibility());
        }
        this.readLock();
        try {
            int counter = 0;
            for (ExportJob job : this.idToJob.values()) {
                Database db;
                TableName tableName;
                long l = job.getId();
                ExportJob.JobState state = job.getState();
                String jobLabel = job.getLabel();
                if (job.getDbId() != dbId || jobId != 0L && l != jobId || !Strings.isNullOrEmpty((String)label) && (!isLabelUseLike && !jobLabel.equals(label) || isLabelUseLike && !matcher.match(jobLabel)) || ((tableName = job.getTableName()) != null && !tableName.getTbl().equals("DUMMY") ? !Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), tableName.getDb(), tableName.getTbl(), PrivPredicate.SHOW) : (db = Catalog.getCurrentCatalog().getDbNullable(dbId)) == null || !Catalog.getCurrentCatalog().getAuth().checkDbPriv(ConnectContext.get(), db.getFullName(), PrivPredicate.SHOW))) continue;
                if (states != null && !states.contains((Object)state)) continue;
                ArrayList<Object> jobInfo = new ArrayList<Object>();
                jobInfo.add(l);
                jobInfo.add(jobLabel);
                jobInfo.add(state.name());
                jobInfo.add(job.getProgress() + "%");
                HashMap infoMap = Maps.newHashMap();
                ArrayList partitions = job.getPartitions();
                if (partitions == null) {
                    partitions = Lists.newArrayList();
                    partitions.add("*");
                }
                infoMap.put("db", job.getTableName().getDb());
                infoMap.put("tbl", job.getTableName().getTbl());
                if (job.getWhereExpr() != null) {
                    infoMap.put("where expr", job.getWhereExpr().toMySql());
                }
                infoMap.put("partitions", partitions);
                infoMap.put("broker", job.getBrokerDesc().getName());
                infoMap.put("column separator", job.getColumnSeparator());
                infoMap.put("line delimiter", job.getLineDelimiter());
                infoMap.put("exec mem limit", job.getExecMemLimit());
                infoMap.put("columns", job.getColumns());
                infoMap.put("coord num", job.getCoordList().size());
                infoMap.put("tablet num", job.getTabletLocations() == null ? -1 : job.getTabletLocations().size());
                jobInfo.add(new Gson().toJson((Object)infoMap));
                jobInfo.add(job.getShowExportPath());
                jobInfo.add(TimeUtils.longToTimeString(job.getCreateTimeMs()));
                jobInfo.add(TimeUtils.longToTimeString(job.getStartTimeMs()));
                jobInfo.add(TimeUtils.longToTimeString(job.getFinishTimeMs()));
                jobInfo.add(job.getTimeoutSecond());
                if (job.getState() == ExportJob.JobState.CANCELLED) {
                    ExportFailMsg failMsg = job.getFailMsg();
                    jobInfo.add("type:" + (Object)((Object)failMsg.getCancelType()) + "; msg:" + failMsg.getMsg());
                } else {
                    jobInfo.add(FeConstants.null_string);
                }
                exportJobInfos.add(jobInfo);
                if ((long)(++counter) < resultNum) continue;
                break;
            }
        }
        finally {
            this.readUnlock();
        }
        ListComparator comparator = null;
        if (orderByPairs != null) {
            OrderByPair[] orderByPairArr = new OrderByPair[orderByPairs.size()];
            comparator = new ListComparator(orderByPairs.toArray(orderByPairArr));
        } else {
            comparator = new ListComparator(0);
        }
        Collections.sort(exportJobInfos, comparator);
        ArrayList results = Lists.newArrayList();
        for (List list : exportJobInfos) {
            results.add(list.stream().map(e -> e.toString()).collect(Collectors.toList()));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOldExportJobs() {
        long currentTimeMs = System.currentTimeMillis();
        this.writeLock();
        try {
            Iterator<Map.Entry<Long, ExportJob>> iter = this.idToJob.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Long, ExportJob> entry = iter.next();
                ExportJob job = entry.getValue();
                if ((currentTimeMs - job.getCreateTimeMs()) / 1000L <= (long)Config.history_job_keep_max_second || job.getState() != ExportJob.JobState.CANCELLED && job.getState() != ExportJob.JobState.FINISHED) continue;
                iter.remove();
                this.labelToJobId.remove(job.getLabel(), job.getId());
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public void replayCreateExportJob(ExportJob job) {
        this.writeLock();
        try {
            this.unprotectAddJob(job);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayUpdateJobState(long jobId, ExportJob.JobState newState) {
        this.writeLock();
        try {
            ExportJob job = this.idToJob.get(jobId);
            job.updateState(newState, true);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getJobNum(ExportJob.JobState state, long dbId) {
        int size = 0;
        this.readLock();
        try {
            for (ExportJob job : this.idToJob.values()) {
                if (job.getState() != state || job.getDbId() != dbId) continue;
                ++size;
            }
        }
        finally {
            this.readUnlock();
        }
        return size;
    }
}

