/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BaseTableRef;
import org.apache.doris.analysis.BrokerDesc;
import org.apache.doris.analysis.DescriptorTable;
import org.apache.doris.analysis.ExportStmt;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ExprSubstitutionMap;
import org.apache.doris.analysis.PartitionNames;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.SqlParser;
import org.apache.doris.analysis.SqlScanner;
import org.apache.doris.analysis.StorageBackend;
import org.apache.doris.analysis.TableName;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.MysqlTable;
import org.apache.doris.catalog.OdbcTable;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.Status;
import org.apache.doris.common.UserException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.SqlParserUtils;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.load.ExportFailMsg;
import org.apache.doris.planner.DataPartition;
import org.apache.doris.planner.ExportSink;
import org.apache.doris.planner.MysqlScanNode;
import org.apache.doris.planner.OdbcScanNode;
import org.apache.doris.planner.OlapScanNode;
import org.apache.doris.planner.PlanFragment;
import org.apache.doris.planner.PlanFragmentId;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.planner.ScanNode;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.Coordinator;
import org.apache.doris.qe.OriginStatement;
import org.apache.doris.qe.SessionVariable;
import org.apache.doris.rewrite.ExprRewriter;
import org.apache.doris.system.Backend;
import org.apache.doris.task.AgentClient;
import org.apache.doris.thrift.TAgentResult;
import org.apache.doris.thrift.TFileType;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TScanRangeLocations;
import org.apache.doris.thrift.TStatusCode;
import org.apache.doris.thrift.TUniqueId;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExportJob
implements Writable {
    private static final Logger LOG = LogManager.getLogger(ExportJob.class);
    private long id = -1L;
    private String label;
    private long dbId = -1L;
    private long tableId = -1L;
    private BrokerDesc brokerDesc;
    private Expr whereExpr;
    private String exportPath = "";
    private String columnSeparator = "\t";
    private String lineDelimiter = "\n";
    private Map<String, String> properties = Maps.newHashMap();
    private List<String> partitions;
    private TableName tableName;
    private String sql = "";
    private JobState state;
    private long createTimeMs;
    private long startTimeMs = -1L;
    private long finishTimeMs = -1L;
    private int progress = 0;
    private ExportFailMsg failMsg;
    private Set<String> exportedFiles = Sets.newConcurrentHashSet();
    private final DescriptorTable desc;
    private TupleDescriptor exportTupleDesc;
    private ExportSink exportSink;
    private Analyzer analyzer;
    private Table exportTable;
    private List<Coordinator> coordList = Lists.newArrayList();
    private AtomicInteger nextId = new AtomicInteger(0);
    private boolean isReplayed = false;
    private Thread doExportingThread;
    private List<TScanRangeLocations> tabletLocations = Lists.newArrayList();
    private List<Pair<TNetworkAddress, String>> snapshotPaths = Lists.newArrayList();
    private OriginStatement origStmt;
    protected Map<String, String> sessionVariables = Maps.newHashMap();
    private List<String> exportColumns = Lists.newArrayList();
    private String columns = "";

    public ExportJob() {
        this.state = JobState.PENDING;
        this.createTimeMs = System.currentTimeMillis();
        this.failMsg = new ExportFailMsg(ExportFailMsg.CancelType.UNKNOWN, "");
        this.analyzer = new Analyzer(Catalog.getCurrentCatalog(), null);
        this.desc = this.analyzer.getDescTbl();
    }

    public ExportJob(long jobId) {
        this();
        this.id = jobId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJob(ExportStmt stmt) throws UserException {
        String dbName = stmt.getTblName().getDb();
        Database db = Catalog.getCurrentCatalog().getDbOrDdlException(dbName);
        Preconditions.checkNotNull((Object)stmt.getBrokerDesc());
        this.brokerDesc = stmt.getBrokerDesc();
        this.columnSeparator = stmt.getColumnSeparator();
        this.lineDelimiter = stmt.getLineDelimiter();
        this.properties = stmt.getProperties();
        this.label = this.properties.get("label");
        String path = stmt.getPath();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)path) ? 1 : 0) != 0);
        this.whereExpr = stmt.getWhereExpr();
        this.exportPath = path;
        this.partitions = stmt.getPartitions();
        this.exportTable = db.getTableOrDdlException(stmt.getTblName().getTbl());
        this.columns = stmt.getColumns();
        if (!Strings.isNullOrEmpty((String)this.columns)) {
            Splitter split = Splitter.on((char)',').trimResults().omitEmptyStrings();
            this.exportColumns = split.splitToList((CharSequence)stmt.getColumns().toLowerCase());
        }
        this.exportTable.readLock();
        try {
            this.dbId = db.getId();
            this.tableId = this.exportTable.getId();
            this.tableName = stmt.getTblName();
            this.genExecFragment();
        }
        finally {
            this.exportTable.readUnlock();
        }
        this.sql = stmt.toSql();
        this.origStmt = stmt.getOrigStmt();
        if (ConnectContext.get() != null) {
            SessionVariable var = ConnectContext.get().getSessionVariable();
            this.sessionVariables.put("sql_mode", Long.toString(var.getSqlMode()));
        } else {
            this.sessionVariables.put("sql_mode", String.valueOf(0L));
        }
    }

    private void genExecFragment() throws UserException {
        this.registerToDesc();
        String tmpExportPathStr = this.getExportPath();
        if (this.brokerDesc.getStorageType() == StorageBackend.StorageType.BROKER) {
            tmpExportPathStr = tmpExportPathStr + "/__doris_export_tmp_" + this.id + "/";
        }
        try {
            URI uri = new URI(tmpExportPathStr);
            tmpExportPathStr = uri.normalize().toString();
        }
        catch (URISyntaxException e) {
            throw new DdlException("Invalid export path: " + this.getExportPath());
        }
        this.exportSink = new ExportSink(tmpExportPathStr, this.getColumnSeparator(), this.getLineDelimiter(), this.brokerDesc);
        this.plan();
    }

    private void registerToDesc() throws UserException {
        TableRef ref = new TableRef(this.tableName, null, this.partitions == null ? null : new PartitionNames(false, this.partitions));
        BaseTableRef tableRef = new BaseTableRef(ref, this.exportTable, this.tableName);
        this.analyzer.registerTableRef(tableRef);
        this.exportTupleDesc = this.desc.createTupleDescriptor();
        this.exportTupleDesc.setTable(this.exportTable);
        this.exportTupleDesc.setRef(tableRef);
        this.exportTupleDesc.setAliases(tableRef.getAliases(), tableRef.hasExplicitAlias());
        if (this.exportColumns.isEmpty()) {
            for (Column column : this.exportTable.getBaseSchema()) {
                SlotDescriptor slot = this.desc.addSlotDescriptor(this.exportTupleDesc);
                slot.setIsMaterialized(true);
                slot.setColumn(column);
                slot.setIsNullable(column.isAllowNull());
            }
        } else {
            for (Column column : this.exportTable.getBaseSchema()) {
                String colName = column.getName().toLowerCase();
                if (!this.exportColumns.contains(colName)) continue;
                SlotDescriptor slot = this.desc.addSlotDescriptor(this.exportTupleDesc);
                slot.setIsMaterialized(true);
                slot.setColumn(column);
                slot.setIsNullable(column.isAllowNull());
            }
        }
        this.desc.computeStatAndMemLayout();
    }

    private void plan() throws UserException {
        ArrayList fragments = Lists.newArrayList();
        ArrayList scanNodes = Lists.newArrayList();
        this.analyzeWhereExpr();
        if (this.exportTable.getType() != Table.TableType.OLAP) {
            ScanNode scanNode = this.genScanNode();
            PlanFragment fragment = this.genPlanFragment(this.exportTable.getType(), scanNode);
            scanNodes.add(scanNode);
            fragments.add(fragment);
        } else {
            ScanNode tmpOlapScanNode = this.genScanNode();
            this.tabletLocations = tmpOlapScanNode.getScanRangeLocations(0L);
            for (TScanRangeLocations tablet : this.tabletLocations) {
                List locations = tablet.getLocations();
                Collections.shuffle(locations);
                tablet.setLocations(locations.subList(0, 1));
            }
            int size = this.tabletLocations.size();
            int tabletNum = this.getTabletNumberPerTask();
            for (int i = 0; i < size; i += tabletNum) {
                OlapScanNode olapScanNode = null;
                olapScanNode = i + tabletNum <= size ? this.genOlapScanNodeByLocation(this.tabletLocations.subList(i, i + tabletNum)) : this.genOlapScanNodeByLocation(this.tabletLocations.subList(i, size));
                PlanFragment fragment = this.genPlanFragment(this.exportTable.getType(), olapScanNode);
                fragments.add(fragment);
                scanNodes.add(olapScanNode);
            }
            LOG.info("total {} tablets of export job {}, and assign them to {} coordinators", (Object)size, (Object)this.id, (Object)fragments.size());
        }
        if (this.whereExpr != null) {
            for (ScanNode scanNode : scanNodes) {
                scanNode.addConjuncts(this.whereExpr.getConjuncts());
            }
        }
        this.genCoordinators(fragments, scanNodes);
    }

    private void analyzeWhereExpr() throws UserException {
        if (this.whereExpr == null) {
            return;
        }
        this.whereExpr = this.analyzer.getExprRewriter().rewrite(this.whereExpr, this.analyzer, ExprRewriter.ClauseType.WHERE_CLAUSE);
        TreeMap dstDescMap = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        for (SlotDescriptor slotDescriptor : this.exportTupleDesc.getSlots()) {
            dstDescMap.put(slotDescriptor.getColumn().getName(), slotDescriptor);
        }
        ArrayList slots = Lists.newArrayList();
        this.whereExpr.collect(SlotRef.class, slots);
        ExprSubstitutionMap smap = new ExprSubstitutionMap();
        for (SlotRef slot : slots) {
            SlotDescriptor slotDesc = (SlotDescriptor)dstDescMap.get(slot.getColumnName());
            if (slotDesc == null) {
                throw new UserException("unknown column reference in where statement, reference=" + slot.getColumnName());
            }
            smap.getLhs().add(slot);
            smap.getRhs().add(new SlotRef(slotDesc));
        }
        this.whereExpr = this.whereExpr.clone(smap);
        this.whereExpr.analyze(this.analyzer);
        if (!this.whereExpr.getType().equals(Type.BOOLEAN)) {
            throw new UserException("where statement is not a valid statement return bool");
        }
    }

    private ScanNode genScanNode() throws UserException {
        ScanNode scanNode = null;
        switch (this.exportTable.getType()) {
            case OLAP: {
                scanNode = new OlapScanNode(new PlanNodeId(0), this.exportTupleDesc, "OlapScanNodeForExport");
                ((OlapScanNode)scanNode).closePreAggregation("This an export operation");
                ((OlapScanNode)scanNode).selectBestRollupByRollupSelector(this.analyzer);
                break;
            }
            case ODBC: {
                scanNode = new OdbcScanNode(new PlanNodeId(0), this.exportTupleDesc, (OdbcTable)this.exportTable);
                break;
            }
            case MYSQL: {
                scanNode = new MysqlScanNode(new PlanNodeId(0), this.exportTupleDesc, (MysqlTable)this.exportTable);
                break;
            }
        }
        if (scanNode != null) {
            scanNode.init(this.analyzer);
            scanNode.finalize(this.analyzer);
        }
        return scanNode;
    }

    private OlapScanNode genOlapScanNodeByLocation(List<TScanRangeLocations> locations) {
        OlapScanNode olapScanNode = OlapScanNode.createOlapScanNodeByLocation(new PlanNodeId(this.nextId.getAndIncrement()), this.exportTupleDesc, "OlapScanNodeForExport", locations);
        return olapScanNode;
    }

    private PlanFragment genPlanFragment(Table.TableType type, ScanNode scanNode) throws UserException {
        PlanFragment fragment = null;
        switch (this.exportTable.getType()) {
            case OLAP: {
                fragment = new PlanFragment(new PlanFragmentId(this.nextId.getAndIncrement()), scanNode, DataPartition.RANDOM);
                break;
            }
            case ODBC: 
            case MYSQL: {
                fragment = new PlanFragment(new PlanFragmentId(this.nextId.getAndIncrement()), scanNode, DataPartition.UNPARTITIONED);
                break;
            }
        }
        fragment.setOutputExprs(this.createOutputExprs());
        scanNode.setFragmentId(fragment.getFragmentId());
        fragment.setSink(this.exportSink);
        try {
            fragment.finalize(null);
        }
        catch (Exception e) {
            LOG.info("Fragment finalize failed. e= {}", (Throwable)e);
            throw new UserException("Fragment finalize failed");
        }
        return fragment;
    }

    private List<Expr> createOutputExprs() {
        ArrayList outputExprs = Lists.newArrayList();
        for (int i = 0; i < this.exportTupleDesc.getSlots().size(); ++i) {
            SlotDescriptor slotDesc = this.exportTupleDesc.getSlots().get(i);
            SlotRef slotRef = new SlotRef(slotDesc);
            if (slotDesc.getType().getPrimitiveType() == PrimitiveType.CHAR) {
                slotRef.setType(Type.CHAR);
            }
            outputExprs.add(slotRef);
        }
        return outputExprs;
    }

    private void genCoordinators(List<PlanFragment> fragments, List<ScanNode> nodes) {
        UUID uuid = UUID.randomUUID();
        for (int i = 0; i < fragments.size(); ++i) {
            PlanFragment fragment = fragments.get(i);
            ScanNode scanNode = nodes.get(i);
            TUniqueId queryId = new TUniqueId(uuid.getMostSignificantBits() + (long)i, uuid.getLeastSignificantBits());
            Coordinator coord = new Coordinator(this.id, queryId, this.desc, Lists.newArrayList((Object[])new PlanFragment[]{fragment}), Lists.newArrayList((Object[])new ScanNode[]{scanNode}), "Asia/Shanghai", true);
            coord.setExecMemoryLimit(this.getExecMemLimit());
            this.coordList.add(coord);
        }
        LOG.info("create {} coordinators for export job: {}", (Object)this.coordList.size(), (Object)this.id);
    }

    public String getColumns() {
        return this.columns;
    }

    public long getId() {
        return this.id;
    }

    public long getDbId() {
        return this.dbId;
    }

    public long getTableId() {
        return this.tableId;
    }

    public Expr getWhereExpr() {
        return this.whereExpr;
    }

    public JobState getState() {
        return this.state;
    }

    public BrokerDesc getBrokerDesc() {
        return this.brokerDesc;
    }

    public void setBrokerDesc(BrokerDesc brokerDesc) {
        this.brokerDesc = brokerDesc;
    }

    public String getExportPath() {
        return this.exportPath;
    }

    public String getShowExportPath() {
        if (this.brokerDesc.getFileType() == TFileType.FILE_LOCAL) {
            StringBuilder sb = new StringBuilder();
            sb.append("file:///".substring(0, "file:///".length() - 1));
            sb.append(this.exportPath);
            return sb.toString();
        }
        return this.exportPath;
    }

    public String getColumnSeparator() {
        return this.columnSeparator;
    }

    public String getLineDelimiter() {
        return this.lineDelimiter;
    }

    public long getExecMemLimit() {
        return Long.parseLong(this.properties.get("exec_mem_limit"));
    }

    public int getTimeoutSecond() {
        if (this.properties.containsKey("timeout")) {
            return Integer.parseInt(this.properties.get("timeout"));
        }
        return Config.export_task_default_timeout_second;
    }

    public int getTabletNumberPerTask() {
        if (this.properties.containsKey("tablet_num_per_task")) {
            return Integer.parseInt(this.properties.get("tablet_num_per_task"));
        }
        return Config.export_tablet_num_per_task;
    }

    public List<String> getPartitions() {
        return this.partitions;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public void setFailMsg(ExportFailMsg failMsg) {
        this.failMsg = failMsg;
    }

    public long getCreateTimeMs() {
        return this.createTimeMs;
    }

    public long getStartTimeMs() {
        return this.startTimeMs;
    }

    public long getFinishTimeMs() {
        return this.finishTimeMs;
    }

    public ExportFailMsg getFailMsg() {
        return this.failMsg;
    }

    public Set<String> getExportedFiles() {
        return this.exportedFiles;
    }

    public synchronized void addExportedFiles(List<String> files) {
        this.exportedFiles.addAll(files);
        LOG.debug("exported files: {}", this.exportedFiles);
    }

    public synchronized Thread getDoExportingThread() {
        return this.doExportingThread;
    }

    public synchronized void setDoExportingThread(Thread isExportingThread) {
        this.doExportingThread = isExportingThread;
    }

    public List<Coordinator> getCoordList() {
        return this.coordList;
    }

    public List<TScanRangeLocations> getTabletLocations() {
        return this.tabletLocations;
    }

    public List<Pair<TNetworkAddress, String>> getSnapshotPaths() {
        return this.snapshotPaths;
    }

    public void addSnapshotPath(Pair<TNetworkAddress, String> snapshotPath) {
        this.snapshotPaths.add(snapshotPath);
    }

    public String getSql() {
        return this.sql;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public synchronized void cancel(ExportFailMsg.CancelType type, String msg) {
        this.releaseSnapshotPaths();
        if (msg != null) {
            this.failMsg = new ExportFailMsg(type, msg);
        }
        this.updateState(JobState.CANCELLED, false);
    }

    public synchronized boolean updateState(JobState newState) {
        return this.updateState(newState, false);
    }

    public synchronized boolean updateState(JobState newState, boolean isReplay) {
        this.state = newState;
        switch (newState) {
            case PENDING: {
                this.progress = 0;
                break;
            }
            case EXPORTING: {
                this.startTimeMs = System.currentTimeMillis();
                break;
            }
            case FINISHED: 
            case CANCELLED: {
                this.finishTimeMs = System.currentTimeMillis();
                this.progress = 100;
                break;
            }
            default: {
                Preconditions.checkState((boolean)false, (Object)("wrong job state: " + newState.name()));
            }
        }
        if (!isReplay) {
            Catalog.getCurrentCatalog().getEditLog().logExportUpdateState(this.id, newState);
        }
        return true;
    }

    public Status releaseSnapshotPaths() {
        List<Pair<TNetworkAddress, String>> snapshotPaths = this.getSnapshotPaths();
        LOG.debug("snapshotPaths:{}", snapshotPaths);
        for (Pair<TNetworkAddress, String> snapshotPath : snapshotPaths) {
            AgentClient client;
            TAgentResult result;
            TNetworkAddress address = (TNetworkAddress)snapshotPath.first;
            String host = address.getHostname();
            int port = address.getPort();
            Backend backend = Catalog.getCurrentSystemInfo().getBackendWithBePort(host, port);
            if (backend == null) continue;
            long backendId = backend.getId();
            if (Catalog.getCurrentSystemInfo().checkBackendQueryAvailable(backendId) && (result = (client = new AgentClient(host, port)).releaseSnapshot((String)snapshotPath.second)) != null && result.getStatus().getStatusCode() == TStatusCode.OK) continue;
        }
        snapshotPaths.clear();
        return Status.OK;
    }

    public boolean isExpired(long curTime) {
        return (curTime - this.createTimeMs) / 1000L > (long)Config.history_job_keep_max_second && (this.state == JobState.CANCELLED || this.state == JobState.FINISHED);
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return "ExportJob [jobId=" + this.id + ", label=" + this.label + ", dbId=" + this.dbId + ", tableId=" + this.tableId + ", state=" + (Object)((Object)this.state) + ", path=" + this.exportPath + ", partitions=(" + StringUtils.join(this.partitions, (String)",") + "), progress=" + this.progress + ", createTimeMs=" + TimeUtils.longToTimeString(this.createTimeMs) + ", exportStartTimeMs=" + TimeUtils.longToTimeString(this.startTimeMs) + ", exportFinishTimeMs=" + TimeUtils.longToTimeString(this.finishTimeMs) + ", failMsg=" + this.failMsg + ", files=(" + StringUtils.join(this.exportedFiles, (String)",") + ")]";
    }

    public static ExportJob read(DataInput in) throws IOException {
        ExportJob job = new ExportJob();
        job.readFields(in);
        return job;
    }

    public void write(DataOutput out) throws IOException {
        boolean hasPartition;
        out.writeLong(this.id);
        out.writeLong(this.dbId);
        out.writeLong(this.tableId);
        Text.writeString((DataOutput)out, (String)this.exportPath);
        Text.writeString((DataOutput)out, (String)this.columnSeparator);
        Text.writeString((DataOutput)out, (String)this.lineDelimiter);
        out.writeInt(this.properties.size());
        for (Map.Entry<String, String> property : this.properties.entrySet()) {
            Text.writeString((DataOutput)out, (String)property.getKey());
            Text.writeString((DataOutput)out, (String)property.getValue());
        }
        boolean bl = hasPartition = this.partitions != null;
        if (hasPartition) {
            out.writeBoolean(true);
            int partitionSize = this.partitions.size();
            out.writeInt(partitionSize);
            for (String partitionName : this.partitions) {
                Text.writeString((DataOutput)out, (String)partitionName);
            }
        } else {
            out.writeBoolean(false);
        }
        Text.writeString((DataOutput)out, (String)this.state.name());
        out.writeLong(this.createTimeMs);
        out.writeLong(this.startTimeMs);
        out.writeLong(this.finishTimeMs);
        out.writeInt(this.progress);
        this.failMsg.write(out);
        if (this.brokerDesc == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.brokerDesc.write(out);
        }
        this.tableName.write(out);
        this.origStmt.write(out);
        out.writeInt(this.sessionVariables.size());
        for (Map.Entry<String, String> entry : this.sessionVariables.entrySet()) {
            Text.writeString((DataOutput)out, (String)entry.getKey());
            Text.writeString((DataOutput)out, (String)entry.getValue());
        }
    }

    private void readFields(DataInput in) throws IOException {
        boolean hasPartition;
        this.isReplayed = true;
        this.id = in.readLong();
        this.dbId = in.readLong();
        this.tableId = in.readLong();
        this.exportPath = Text.readString((DataInput)in);
        this.columnSeparator = Text.readString((DataInput)in);
        this.lineDelimiter = Text.readString((DataInput)in);
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            String propertyKey = Text.readString((DataInput)in);
            String propertyValue = Text.readString((DataInput)in);
            this.properties.put(propertyKey, propertyValue);
        }
        this.properties.putIfAbsent("label", "export_" + this.id);
        this.label = this.properties.get("label");
        this.columns = this.properties.get("columns");
        if (!Strings.isNullOrEmpty((String)this.columns)) {
            Splitter split = Splitter.on((char)',').trimResults().omitEmptyStrings();
            this.exportColumns = split.splitToList((CharSequence)this.columns.toLowerCase());
        }
        if (hasPartition = in.readBoolean()) {
            this.partitions = Lists.newArrayList();
            int partitionSize = in.readInt();
            for (int i = 0; i < partitionSize; ++i) {
                String partitionName = Text.readString((DataInput)in);
                this.partitions.add(partitionName);
            }
        }
        this.state = JobState.valueOf(Text.readString((DataInput)in));
        this.createTimeMs = in.readLong();
        this.startTimeMs = in.readLong();
        this.finishTimeMs = in.readLong();
        this.progress = in.readInt();
        this.failMsg.readFields(in);
        if (in.readBoolean()) {
            this.brokerDesc = BrokerDesc.read(in);
        }
        this.tableName = new TableName();
        this.tableName.readFields(in);
        this.origStmt = OriginStatement.read(in);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String key = Text.readString((DataInput)in);
            String value = Text.readString((DataInput)in);
            this.sessionVariables.put(key, value);
        }
        if (this.origStmt.originStmt.isEmpty()) {
            return;
        }
        SqlParser parser = new SqlParser(new SqlScanner(new StringReader(this.origStmt.originStmt), Long.valueOf(this.sessionVariables.get("sql_mode"))));
        ExportStmt stmt = null;
        try {
            stmt = (ExportStmt)SqlParserUtils.getStmt(parser, this.origStmt.idx);
            this.whereExpr = stmt.getWhereExpr();
        }
        catch (Exception e) {
            throw new IOException("error happens when parsing create routine load stmt: " + this.origStmt, e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExportJob)) {
            return false;
        }
        ExportJob job = (ExportJob)obj;
        return this.id == job.id;
    }

    public boolean isReplayed() {
        return this.isReplayed;
    }

    public static class StateTransfer
    implements Writable {
        long jobId;
        JobState state;

        public StateTransfer() {
            this.jobId = -1L;
            this.state = JobState.CANCELLED;
        }

        public StateTransfer(long jobId, JobState state) {
            this.jobId = jobId;
            this.state = state;
        }

        public long getJobId() {
            return this.jobId;
        }

        public JobState getState() {
            return this.state;
        }

        public void write(DataOutput out) throws IOException {
            out.writeLong(this.jobId);
            Text.writeString((DataOutput)out, (String)this.state.name());
        }

        public void readFields(DataInput in) throws IOException {
            this.jobId = in.readLong();
            this.state = JobState.valueOf(Text.readString((DataInput)in));
        }
    }

    public static enum JobState {
        PENDING,
        EXPORTING,
        FINISHED,
        CANCELLED;

    }
}

