/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;

public class ExportFailMsg
implements Writable {
    private CancelType cancelType;
    private String msg;

    public ExportFailMsg() {
        this.cancelType = CancelType.UNKNOWN;
        this.msg = "";
    }

    public ExportFailMsg(CancelType cancelType, String msg) {
        this.cancelType = cancelType;
        this.msg = msg;
    }

    public CancelType getCancelType() {
        return this.cancelType;
    }

    public void setCancelType(CancelType cancelType) {
        this.cancelType = cancelType;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String toString() {
        return "ExportFailMsg [cancelType=" + (Object)((Object)this.cancelType) + ", msg=" + this.msg + "]";
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.cancelType.name());
        Text.writeString((DataOutput)out, (String)this.msg);
    }

    public void readFields(DataInput in) throws IOException {
        this.cancelType = CancelType.valueOf(Text.readString((DataInput)in));
        this.msg = Text.readString((DataInput)in);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExportFailMsg)) {
            return false;
        }
        ExportFailMsg failMsg = (ExportFailMsg)obj;
        return this.cancelType.equals((Object)failMsg.cancelType) && this.msg.equals(failMsg.msg);
    }

    public static enum CancelType {
        USER_CANCEL,
        SUBMIT_FAIL,
        RUN_FAIL,
        TIMEOUT,
        UNKNOWN;

    }
}

