/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.Config;
import org.apache.doris.common.util.MasterDaemon;
import org.apache.doris.load.ExportJob;
import org.apache.doris.load.ExportMgr;
import org.apache.doris.task.ExportExportingTask;
import org.apache.doris.task.ExportPendingTask;
import org.apache.doris.task.MasterTaskExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ExportChecker
extends MasterDaemon {
    private static final Logger LOG = LogManager.getLogger(ExportChecker.class);
    private static Map<ExportJob.JobState, ExportChecker> checkers = Maps.newHashMap();
    private static Map<ExportJob.JobState, MasterTaskExecutor> executors = Maps.newHashMap();
    private ExportJob.JobState jobState;

    private ExportChecker(ExportJob.JobState jobState, long intervalMs) {
        super("export checker " + jobState.name().toLowerCase(), intervalMs);
        this.jobState = jobState;
    }

    public static void init(long intervalMs) {
        checkers.put(ExportJob.JobState.PENDING, new ExportChecker(ExportJob.JobState.PENDING, intervalMs));
        checkers.put(ExportJob.JobState.EXPORTING, new ExportChecker(ExportJob.JobState.EXPORTING, intervalMs));
        int poolSize = Config.export_running_job_num_limit == 0 ? 5 : Config.export_running_job_num_limit;
        MasterTaskExecutor pendingTaskExecutor = new MasterTaskExecutor("export_pending_job", poolSize, true);
        executors.put(ExportJob.JobState.PENDING, pendingTaskExecutor);
        MasterTaskExecutor exportingTaskExecutor = new MasterTaskExecutor("export_exporting_job", poolSize, true);
        executors.put(ExportJob.JobState.EXPORTING, exportingTaskExecutor);
    }

    public static void startAll() {
        for (ExportChecker exportChecker : checkers.values()) {
            exportChecker.start();
        }
        for (MasterTaskExecutor masterTaskExecutor : executors.values()) {
            masterTaskExecutor.start();
        }
    }

    @Override
    protected void runAfterCatalogReady() {
        LOG.debug("start check export jobs. job state: {}", (Object)this.jobState.name());
        switch (this.jobState) {
            case PENDING: {
                this.runPendingJobs();
                break;
            }
            case EXPORTING: {
                this.runExportingJobs();
                break;
            }
            default: {
                LOG.warn("wrong export job state: {}", (Object)this.jobState.name());
            }
        }
    }

    private void runPendingJobs() {
        ExportMgr exportMgr = Catalog.getCurrentCatalog().getExportMgr();
        List<ExportJob> pendingJobs = exportMgr.getExportJobs(ExportJob.JobState.PENDING);
        int runningJobNumLimit = Config.export_running_job_num_limit;
        if (runningJobNumLimit > 0 && !pendingJobs.isEmpty()) {
            int runningJobNum = executors.get((Object)ExportJob.JobState.PENDING).getTaskNum() + executors.get((Object)ExportJob.JobState.EXPORTING).getTaskNum();
            if (runningJobNum >= runningJobNumLimit) {
                LOG.info("running export job num {} exceeds system limit {}", (Object)runningJobNum, (Object)runningJobNumLimit);
                return;
            }
            int remain = runningJobNumLimit - runningJobNum;
            if (pendingJobs.size() > remain) {
                pendingJobs = pendingJobs.subList(0, remain);
            }
        }
        LOG.debug("pending export job num: {}", (Object)pendingJobs.size());
        for (ExportJob job : pendingJobs) {
            try {
                ExportPendingTask task = new ExportPendingTask(job);
                if (!executors.get((Object)ExportJob.JobState.PENDING).submit(task)) continue;
                LOG.info("run pending export job. job: {}", (Object)job);
            }
            catch (Exception e) {
                LOG.warn("run pending export job error", (Throwable)e);
            }
        }
    }

    private void runExportingJobs() {
        List<ExportJob> jobs = Catalog.getCurrentCatalog().getExportMgr().getExportJobs(ExportJob.JobState.EXPORTING);
        LOG.debug("exporting export job num: {}", (Object)jobs.size());
        for (ExportJob job : jobs) {
            try {
                ExportExportingTask task = new ExportExportingTask(job);
                if (executors.get((Object)ExportJob.JobState.EXPORTING).submit(task)) {
                    LOG.info("run exporting export job. job: {}", (Object)job);
                    continue;
                }
                LOG.info("fail to submit exporting job to executor. job: {}", (Object)job);
            }
            catch (Exception e) {
                LOG.warn("run export exporting job error", (Throwable)e);
            }
        }
    }
}

