/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.load.loadv2.dpp.DppResult;
import org.apache.doris.thrift.TEtlState;

public class EtlStatus
implements Writable {
    public static final String DEFAULT_TRACKING_URL = FeConstants.null_string;
    private TEtlState state = TEtlState.RUNNING;
    private String trackingUrl = DEFAULT_TRACKING_URL;
    private Map<String, String> stats = Maps.newHashMap();
    private Map<String, String> counters = Maps.newHashMap();
    private Map<String, Long> fileMap = Maps.newHashMap();
    private int progress = 0;
    private String failMsg = "";
    private DppResult dppResult = null;

    public TEtlState getState() {
        return this.state;
    }

    public boolean setState(TEtlState state) {
        if (this.state != TEtlState.RUNNING) {
            return false;
        }
        this.state = state;
        return true;
    }

    public String getTrackingUrl() {
        return this.trackingUrl;
    }

    public void setTrackingUrl(String trackingUrl) {
        this.trackingUrl = Strings.nullToEmpty((String)trackingUrl);
    }

    public Map<String, String> getStats() {
        return this.stats;
    }

    public void setStats(Map<String, String> stats) {
        this.stats = stats;
    }

    public Map<String, String> getCounters() {
        return this.counters;
    }

    public void replaceCounter(String key, String value) {
        this.counters.put(key, value);
    }

    public void setCounters(Map<String, String> counters) {
        this.counters = counters;
    }

    public Map<String, Long> getFileMap() {
        return this.fileMap;
    }

    public void setFileMap(Map<String, Long> fileMap) {
        this.fileMap = fileMap;
    }

    public void addAllFileMap(Map<String, Long> fileMap) {
        this.fileMap.putAll(fileMap);
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public String getFailMsg() {
        return this.failMsg;
    }

    public void setFailMsg(String failMsg) {
        this.failMsg = failMsg;
    }

    public DppResult getDppResult() {
        return this.dppResult;
    }

    public void setDppResult(DppResult dppResult) {
        this.dppResult = dppResult;
    }

    public void reset() {
        this.stats.clear();
        this.counters.clear();
        this.fileMap.clear();
        this.progress = 0;
        this.failMsg = "";
        this.dppResult = null;
    }

    public String toString() {
        return "EtlStatus{state=" + this.state + ", trackingUrl='" + this.trackingUrl + '\'' + ", stats=" + this.stats + ", counters=" + this.counters + ", fileMap=" + this.fileMap + ", progress=" + this.progress + ", failMsg='" + this.failMsg + '\'' + ", dppResult='" + this.dppResult + '\'' + '}';
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.state.name());
        Text.writeString((DataOutput)out, (String)this.trackingUrl);
        int statsCount = this.stats == null ? 0 : this.stats.size();
        out.writeInt(statsCount);
        for (Map.Entry<String, String> entry : this.stats.entrySet()) {
            Text.writeString((DataOutput)out, (String)entry.getKey());
            Text.writeString((DataOutput)out, (String)entry.getValue());
        }
        int countersCount = this.counters == null ? 0 : this.counters.size();
        out.writeInt(countersCount);
        for (Map.Entry<String, String> entry : this.counters.entrySet()) {
            Text.writeString((DataOutput)out, (String)entry.getKey());
            Text.writeString((DataOutput)out, (String)entry.getValue());
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.state = TEtlState.valueOf((String)Text.readString((DataInput)in));
        this.trackingUrl = Text.readString((DataInput)in);
        int statsCount = in.readInt();
        for (int i = 0; i < statsCount; ++i) {
            String key = Text.readString((DataInput)in);
            String value = Text.readString((DataInput)in);
            this.stats.put(key, value);
        }
        int countersCount = in.readInt();
        for (int i = 0; i < countersCount; ++i) {
            String key = Text.readString((DataInput)in);
            String value = Text.readString((DataInput)in);
            this.counters.put(key, value);
        }
    }

    public boolean equals(Object obj) {
        String key;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EtlStatus)) {
            return false;
        }
        EtlStatus etlTaskStatus = (EtlStatus)obj;
        if (etlTaskStatus.stats == null) {
            return false;
        }
        if (this.stats.size() != etlTaskStatus.stats.size()) {
            return false;
        }
        for (Map.Entry<String, String> entry : this.stats.entrySet()) {
            key = entry.getKey();
            if (!etlTaskStatus.stats.containsKey(key)) {
                return false;
            }
            if (entry.getValue().equals(etlTaskStatus.stats.get(key))) continue;
            return false;
        }
        if (etlTaskStatus.counters == null) {
            return false;
        }
        if (this.counters.size() != etlTaskStatus.counters.size()) {
            return false;
        }
        for (Map.Entry<String, String> entry : this.counters.entrySet()) {
            key = entry.getKey();
            if (!etlTaskStatus.counters.containsKey(key)) {
                return false;
            }
            if (entry.getValue().equals(etlTaskStatus.counters.get(key))) continue;
            return false;
        }
        return this.state.equals((Object)etlTaskStatus.state) && this.trackingUrl.equals(etlTaskStatus.trackingUrl);
    }
}

