/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.LoadException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.thrift.TPriority;

public class DppConfig
implements Writable {
    private static final String FS_DEFAULT_NAME = "fs.default.name";
    private static final String MAPRED_JOB_TRACKER = "mapred.job.tracker";
    private static final String HADOOP_JOB_UGI = "hadoop.job.ugi";
    private static final String FS_BOS_ENDPOINT = "fs.bos.endpoint";
    private static final String FS_BOS_ACCESS_KEY = "fs.bos.access.key";
    private static final String FS_BOS_SECRET_ACCESS_KEY = "fs.bos.secret.access.key";
    private static final String SEMICOLON_SEPARATOR = ";";
    private static final String EQUAL_SEPARATOR = "=";
    private static final String COLON_SEPARATOR = ":";
    private static final String APPLICATIONS_PATH = "applications";
    private static final String OUTPUT_PATH = "output";
    public static final String PALO_PATH = "hadoop_palo_path";
    public static final String HTTP_PORT = "hadoop_http_port";
    public static final String HADOOP_CONFIGS = "hadoop_configs";
    public static final String PRIORITY = "priority";
    public static final String CLUSTER_NAME_REGEX = "[a-z][a-z0-9-_]{0,63}";
    private static final int DEFAULT_HTTP_PORT = 8070;
    private String paloPath;
    private int httpPort;
    private Map<String, String> hadoopConfigs;
    private TPriority priority;

    public DppConfig() {
        this(null, -1, null, null);
    }

    private DppConfig(String paloPath, int httpPort, Map<String, String> hadoopConfigs, TPriority priority) {
        this.paloPath = paloPath;
        this.httpPort = httpPort;
        this.hadoopConfigs = hadoopConfigs;
        this.priority = priority;
    }

    public static DppConfig create(Map<String, String> configMap) throws LoadException {
        String paloPath = null;
        int httpPort = -1;
        HashMap hadoopConfigs = Maps.newHashMap();
        TPriority priority = null;
        for (Map.Entry<String, String> entry : configMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.equalsIgnoreCase(PALO_PATH)) {
                if (Strings.isNullOrEmpty((String)value)) {
                    throw new LoadException("Load cluster hadoop_palo_path is null");
                }
                paloPath = value.trim();
                continue;
            }
            if (key.equalsIgnoreCase(HTTP_PORT)) {
                try {
                    httpPort = Integer.parseInt(value);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new LoadException("Load cluster hadoop_http_port is not INT");
                }
            }
            if (key.equalsIgnoreCase(HADOOP_CONFIGS)) {
                if (Strings.isNullOrEmpty((String)value)) {
                    throw new LoadException("Load cluster hadoop_configs is null");
                }
                value = value.trim();
                for (String config : value.split(SEMICOLON_SEPARATOR)) {
                    if ((config = config.trim()).equals("")) continue;
                    String[] keyValueArr = config.split(EQUAL_SEPARATOR);
                    if (keyValueArr.length != 2) {
                        throw new LoadException("Load cluster hadoop_configs format error");
                    }
                    hadoopConfigs.put(keyValueArr[0], keyValueArr[1]);
                }
                continue;
            }
            if (key.equalsIgnoreCase(PRIORITY)) {
                try {
                    priority = TPriority.valueOf((String)value);
                    continue;
                }
                catch (Exception e) {
                    throw new LoadException("Load cluster priority format error");
                }
            }
            throw new LoadException("Unknown load cluster config key: " + key);
        }
        if (hadoopConfigs.isEmpty()) {
            hadoopConfigs = null;
        }
        return new DppConfig(paloPath, httpPort, hadoopConfigs, priority);
    }

    public void update(DppConfig dppConfig) {
        this.update(dppConfig, false);
    }

    public void update(DppConfig dppConfig, boolean needReplace) {
        if (dppConfig == null) {
            return;
        }
        if (dppConfig.paloPath != null) {
            this.paloPath = dppConfig.paloPath;
        }
        if (dppConfig.httpPort != -1) {
            this.httpPort = dppConfig.httpPort;
        }
        if (dppConfig.hadoopConfigs != null) {
            if (needReplace) {
                if (!dppConfig.hadoopConfigs.isEmpty()) {
                    this.hadoopConfigs = dppConfig.hadoopConfigs;
                }
            } else {
                if (this.hadoopConfigs == null) {
                    this.hadoopConfigs = Maps.newHashMap();
                }
                this.hadoopConfigs.putAll(dppConfig.hadoopConfigs);
            }
        }
        if (dppConfig.priority != null) {
            this.priority = dppConfig.priority;
        }
    }

    public void updateHadoopConfigs(Map<String, String> configMap) throws LoadException {
        if (configMap == null) {
            return;
        }
        if (this.hadoopConfigs == null) {
            this.hadoopConfigs = Maps.newHashMap();
        }
        int bosParameters = 0;
        if (configMap.containsKey("bos_endpoint")) {
            String bosEndpoint = configMap.get("bos_endpoint");
            this.hadoopConfigs.put(FS_BOS_ENDPOINT, bosEndpoint);
        }
        if (configMap.containsKey("bos_accesskey")) {
            ++bosParameters;
            String bosAccessKey = configMap.get("bos_accesskey");
            this.hadoopConfigs.put(FS_BOS_ACCESS_KEY, bosAccessKey);
        }
        if (configMap.containsKey("bos_secret_accesskey")) {
            ++bosParameters;
            String bosSecretAccessKey = configMap.get("bos_secret_accesskey");
            this.hadoopConfigs.put(FS_BOS_SECRET_ACCESS_KEY, bosSecretAccessKey);
        }
        if (bosParameters > 0 && bosParameters < 2) {
            throw new LoadException("You should specify 3 parameters (bos_endpoint, bos_accesskey, bos_secret_accesskey) when loading data from BOS");
        }
        if (this.hadoopConfigs.isEmpty()) {
            this.hadoopConfigs = null;
        }
    }

    public void resetConfigByKey(String key) throws LoadException {
        if (key.equalsIgnoreCase(PALO_PATH)) {
            this.paloPath = null;
        } else if (key.equalsIgnoreCase(HTTP_PORT)) {
            this.httpPort = 8070;
        } else if (key.equalsIgnoreCase(HADOOP_CONFIGS)) {
            this.hadoopConfigs = null;
        } else if (key.equalsIgnoreCase(PRIORITY)) {
            this.priority = TPriority.NORMAL;
        } else {
            throw new LoadException("Unknown load cluster config key: " + key);
        }
    }

    public void clear() {
        Iterator<Map.Entry<String, String>> iter = this.hadoopConfigs.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            String key = entry.getKey();
            if (key.equals(FS_DEFAULT_NAME) || key.equals(MAPRED_JOB_TRACKER) || key.equals(HADOOP_JOB_UGI)) continue;
            iter.remove();
        }
    }

    public void check() throws LoadException {
        if (Strings.isNullOrEmpty((String)this.paloPath)) {
            throw new LoadException("Load cluster hadoop_palo_path is null");
        }
        if (this.httpPort == -1) {
            this.httpPort = 8070;
        }
        if (this.hadoopConfigs == null) {
            throw new LoadException("Load cluster hadoop_configs is null");
        }
        if (!this.hadoopConfigs.containsKey(FS_DEFAULT_NAME)) {
            throw new LoadException("Load cluster fs.default.name not set");
        }
        if (!this.hadoopConfigs.containsKey(MAPRED_JOB_TRACKER)) {
            throw new LoadException("Load cluster mapred.job.tracker not set");
        }
        if (!this.hadoopConfigs.containsKey(HADOOP_JOB_UGI)) {
            throw new LoadException("Load cluster hadoop.job.ugi not set");
        }
    }

    public DppConfig getCopiedDppConfig() {
        HashMap copiedHadoopConfigs = null;
        if (this.hadoopConfigs != null) {
            copiedHadoopConfigs = Maps.newHashMap(this.hadoopConfigs);
        }
        return new DppConfig(this.paloPath, this.httpPort, copiedHadoopConfigs, this.priority);
    }

    public static String getPaloPathKey() {
        return PALO_PATH;
    }

    public String getPaloPath() {
        return this.paloPath;
    }

    public String getApplicationsPath() {
        return String.format("%s/%d/%s/%s", this.paloPath, Catalog.getCurrentCatalog().getClusterId(), APPLICATIONS_PATH, FeConstants.dpp_version);
    }

    public String getOutputPath() {
        return String.format("%s/%d/%s", this.paloPath, Catalog.getCurrentCatalog().getClusterId(), OUTPUT_PATH);
    }

    public static String getHttpPortKey() {
        return HTTP_PORT;
    }

    public int getHttpPort() {
        if (this.httpPort == -1) {
            return 8070;
        }
        return this.httpPort;
    }

    public String getFsDefaultName() {
        return this.hadoopConfigs.get(FS_DEFAULT_NAME);
    }

    public String getNameNodeHost() {
        String fsDefaultName = this.hadoopConfigs.get(FS_DEFAULT_NAME);
        String[] arr = fsDefaultName.split(COLON_SEPARATOR);
        if (arr.length != 3) {
            return null;
        }
        return arr[1].substring(2);
    }

    public String getHadoopJobUgiStr() {
        return this.hadoopConfigs.get(HADOOP_JOB_UGI);
    }

    public static String getHadoopConfigsKey() {
        return HADOOP_CONFIGS;
    }

    public Map<String, String> getHadoopConfigs() {
        return this.hadoopConfigs;
    }

    public static String getPriorityKey() {
        return PRIORITY;
    }

    public TPriority getPriority() {
        if (this.priority == null) {
            return TPriority.NORMAL;
        }
        return this.priority;
    }

    public String toString() {
        return "DppConfig{paloPath=" + this.paloPath + ", httpPort=" + this.httpPort + ", hadoopConfigs=" + this.hadoopConfigs + "}";
    }

    public void write(DataOutput out) throws IOException {
        if (this.paloPath != null) {
            out.writeBoolean(true);
            Text.writeString((DataOutput)out, (String)this.paloPath);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.httpPort);
        if (this.hadoopConfigs != null) {
            out.writeBoolean(true);
            out.writeInt(this.hadoopConfigs.size());
            for (Map.Entry<String, String> entry : this.hadoopConfigs.entrySet()) {
                Text.writeString((DataOutput)out, (String)entry.getKey());
                Text.writeString((DataOutput)out, (String)entry.getValue());
            }
        } else {
            out.writeBoolean(false);
        }
        if (this.priority == null) {
            this.priority = TPriority.NORMAL;
        }
        Text.writeString((DataOutput)out, (String)this.priority.name());
    }

    public void readFields(DataInput in) throws IOException {
        boolean readPaloPath = false;
        if (in.readBoolean()) {
            readPaloPath = true;
        }
        if (readPaloPath) {
            this.paloPath = Text.readString((DataInput)in);
        }
        this.httpPort = in.readInt();
        boolean readHadoopConfigs = false;
        if (in.readBoolean()) {
            readHadoopConfigs = true;
        }
        if (readHadoopConfigs) {
            this.hadoopConfigs = Maps.newHashMap();
            int count = in.readInt();
            for (int i = 0; i < count; ++i) {
                this.hadoopConfigs.put(Text.readString((DataInput)in), Text.readString((DataInput)in));
            }
        }
        this.priority = TPriority.valueOf((String)Text.readString((DataInput)in));
    }

    public boolean equals(Object obj) {
        return true;
    }
}

