/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.TabletInvertedIndex;
import org.apache.doris.common.Config;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.UserException;
import org.apache.doris.load.DeleteInfo;
import org.apache.doris.load.TabletDeleteInfo;
import org.apache.doris.task.PushTask;
import org.apache.doris.transaction.AbstractTxnStateChangeCallback;
import org.apache.doris.transaction.TransactionState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeleteJob
extends AbstractTxnStateChangeCallback {
    private static final Logger LOG = LogManager.getLogger(DeleteJob.class);
    private DeleteState state;
    private long id;
    private long signature;
    private String label;
    private Set<Long> totalTablets;
    private Set<Long> quorumTablets;
    private Set<Long> finishedTablets;
    Map<Long, TabletDeleteInfo> tabletDeleteInfoMap;
    private Set<PushTask> pushTasks;
    private DeleteInfo deleteInfo;
    private Map<Long, Short> partitionReplicaNum;

    public DeleteJob(long id, long transactionId, String label, Map<Long, Short> partitionReplicaNum, DeleteInfo deleteInfo) {
        this.id = id;
        this.signature = transactionId;
        this.label = label;
        this.deleteInfo = deleteInfo;
        this.totalTablets = Sets.newHashSet();
        this.finishedTablets = Sets.newHashSet();
        this.quorumTablets = Sets.newHashSet();
        this.tabletDeleteInfoMap = Maps.newConcurrentMap();
        this.pushTasks = Sets.newHashSet();
        this.state = DeleteState.UN_QUORUM;
        this.partitionReplicaNum = partitionReplicaNum;
    }

    public void checkAndUpdateQuorum() throws MetaNotFoundException {
        long dbId = this.deleteInfo.getDbId();
        Catalog.getCurrentCatalog().getDbOrMetaException(dbId);
        for (TabletDeleteInfo tDeleteInfo : this.getTabletDeleteInfo()) {
            Short replicaNum = this.partitionReplicaNum.get(tDeleteInfo.getPartitionId());
            if (replicaNum == null) {
                throw new MetaNotFoundException("Unknown partition " + tDeleteInfo.getPartitionId() + " when commit delete job");
            }
            if (tDeleteInfo.getFinishedReplicas().size() == replicaNum.shortValue()) {
                this.finishedTablets.add(tDeleteInfo.getTabletId());
            }
            if (tDeleteInfo.getFinishedReplicas().size() < replicaNum / 2 + 1) continue;
            this.quorumTablets.add(tDeleteInfo.getTabletId());
        }
        int dropCounter = 0;
        TabletInvertedIndex invertedIndex = Catalog.getCurrentInvertedIndex();
        for (long tabletId : this.totalTablets) {
            if (invertedIndex.getTabletMeta(tabletId) != null) continue;
            this.finishedTablets.add(tabletId);
            ++dropCounter;
            LOG.warn("tablet {} has been dropped when checking delete job {}", (Object)tabletId, (Object)this.id);
        }
        LOG.info("check delete job quorum, transaction id: {}, total tablets: {}, quorum tablets: {}, dropped tablets: {}", (Object)this.signature, (Object)this.totalTablets.size(), (Object)this.quorumTablets.size(), (Object)dropCounter);
        if (this.finishedTablets.containsAll(this.totalTablets)) {
            this.setState(DeleteState.FINISHED);
        } else if (this.quorumTablets.containsAll(this.totalTablets)) {
            this.setState(DeleteState.QUORUM_FINISHED);
        }
    }

    public void setState(DeleteState state) {
        this.state = state;
    }

    public DeleteState getState() {
        return this.state;
    }

    public boolean addTablet(long tabletId) {
        return this.totalTablets.add(tabletId);
    }

    public boolean addPushTask(PushTask pushTask) {
        return this.pushTasks.add(pushTask);
    }

    public boolean addFinishedReplica(long partitionId, long tabletId, Replica replica) {
        this.tabletDeleteInfoMap.putIfAbsent(tabletId, new TabletDeleteInfo(partitionId, tabletId));
        TabletDeleteInfo tDeleteInfo = this.tabletDeleteInfoMap.get(tabletId);
        return tDeleteInfo.addFinishedReplica(replica);
    }

    public DeleteInfo getDeleteInfo() {
        return this.deleteInfo;
    }

    public String getLabel() {
        return this.label;
    }

    public Set<PushTask> getPushTasks() {
        return this.pushTasks;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void afterVisible(TransactionState txnState, boolean txnOperated) {
        if (!txnOperated) {
            return;
        }
        this.executeFinish();
        Catalog.getCurrentCatalog().getEditLog().logFinishDelete(this.deleteInfo);
    }

    @Override
    public void afterAborted(TransactionState txnState, boolean txnOperated, String txnStatusChangeReason) throws UserException {
        Catalog.getCurrentGlobalTransactionMgr().getCallbackFactory().removeCallback(this.getId());
    }

    public void executeFinish() {
        this.setState(DeleteState.FINISHED);
        Catalog.getCurrentCatalog().getDeleteHandler().recordFinishedJob(this);
        Catalog.getCurrentGlobalTransactionMgr().getCallbackFactory().removeCallback(this.getId());
    }

    public long getTransactionId() {
        return this.signature;
    }

    public Collection<TabletDeleteInfo> getTabletDeleteInfo() {
        return this.tabletDeleteInfoMap.values();
    }

    public long getTimeoutMs() {
        if (FeConstants.runningUnitTest) {
            return 1000L;
        }
        long timeout = Math.max((long)(this.totalTablets.size() * Config.tablet_delete_timeout_second) * 1000L, 30000L);
        return Math.min(timeout, (long)Config.load_straggler_wait_second * 1000L);
    }

    public static enum DeleteState {
        UN_QUORUM,
        QUORUM_FINISHED,
        FINISHED;

    }
}

