/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonPostProcessable;
import org.apache.doris.persist.gson.GsonUtils;

public class DeleteInfo
implements Writable,
GsonPostProcessable {
    @SerializedName(value="dbId")
    private long dbId;
    @SerializedName(value="tableId")
    private long tableId;
    @SerializedName(value="tableName")
    private String tableName;
    @SerializedName(value="deleteConditions")
    private List<String> deleteConditions;
    @SerializedName(value="createTimeMs")
    private long createTimeMs;
    @SerializedName(value="partitionIds")
    private List<Long> partitionIds;
    @SerializedName(value="partitionNames")
    private List<String> partitionNames;
    @SerializedName(value="noPartitionSpecified")
    private boolean noPartitionSpecified = false;
    @Deprecated
    @SerializedName(value="partitionId")
    private long partitionId;
    @Deprecated
    @SerializedName(value="partitionName")
    private String partitionName;

    public DeleteInfo() {
        this.deleteConditions = Lists.newArrayList();
    }

    public DeleteInfo(long dbId, long tableId, String tableName, List<String> deleteConditions) {
        this.dbId = dbId;
        this.tableId = tableId;
        this.tableName = tableName;
        this.deleteConditions = deleteConditions;
        this.createTimeMs = System.currentTimeMillis();
    }

    public long getDbId() {
        return this.dbId;
    }

    public long getTableId() {
        return this.tableId;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<String> getDeleteConditions() {
        return this.deleteConditions;
    }

    public long getCreateTimeMs() {
        return this.createTimeMs;
    }

    public boolean isNoPartitionSpecified() {
        return this.noPartitionSpecified;
    }

    public void setPartitions(boolean noPartitionSpecified, List<Long> partitionIds, List<String> partitionNames) {
        this.noPartitionSpecified = noPartitionSpecified;
        Preconditions.checkState((partitionIds.size() == partitionNames.size() ? 1 : 0) != 0);
        this.partitionIds = partitionIds;
        this.partitionNames = partitionNames;
    }

    public List<Long> getPartitionIds() {
        return this.partitionIds;
    }

    public List<String> getPartitionNames() {
        return this.partitionNames;
    }

    public static DeleteInfo read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (DeleteInfo)GsonUtils.GSON.fromJson(json, DeleteInfo.class);
    }

    public void write(DataOutput out) throws IOException {
        String json = GsonUtils.GSON.toJson((Object)this);
        Text.writeString((DataOutput)out, (String)json);
    }

    @Override
    public void gsonPostProcess() throws IOException {
        if (this.partitionId > 0L) {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this.partitionName) ? 1 : 0) != 0);
            this.partitionIds = Lists.newArrayList((Object[])new Long[]{this.partitionId});
            this.partitionNames = Lists.newArrayList((Object[])new String[]{this.partitionName});
        }
    }
}

