/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.DateLiteral;
import org.apache.doris.analysis.DeleteStmt;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.InPredicate;
import org.apache.doris.analysis.IsNullPredicate;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.Predicate;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.KeysType;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.MaterializedIndexMeta;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.PartitionType;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.catalog.TabletInvertedIndex;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.MarkedCountDownLatch;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.UserException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.ListComparator;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.load.DeleteInfo;
import org.apache.doris.load.DeleteJob;
import org.apache.doris.load.TabletDeleteInfo;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.QueryState;
import org.apache.doris.qe.QueryStateException;
import org.apache.doris.service.FrontendOptions;
import org.apache.doris.task.AgentBatchTask;
import org.apache.doris.task.AgentTaskExecutor;
import org.apache.doris.task.AgentTaskQueue;
import org.apache.doris.task.PushTask;
import org.apache.doris.thrift.TPriority;
import org.apache.doris.thrift.TPushType;
import org.apache.doris.thrift.TTaskType;
import org.apache.doris.transaction.GlobalTransactionMgr;
import org.apache.doris.transaction.TabletCommitInfo;
import org.apache.doris.transaction.TransactionState;
import org.apache.doris.transaction.TransactionStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeleteHandler
implements Writable {
    private static final Logger LOG = LogManager.getLogger(DeleteHandler.class);
    private Map<Long, DeleteJob> idToDeleteJob = Maps.newConcurrentMap();
    @SerializedName(value="dbToDeleteInfos")
    private Map<Long, List<DeleteInfo>> dbToDeleteInfos = Maps.newConcurrentMap();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public void readLock() {
        this.lock.readLock().lock();
    }

    public void readUnlock() {
        this.lock.readLock().unlock();
    }

    private void writeLock() {
        this.lock.writeLock().lock();
    }

    private void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(DeleteStmt stmt) throws DdlException, QueryStateException {
        String dbName = stmt.getDbName();
        String tableName = stmt.getTableName();
        List<String> partitionNames = stmt.getPartitionNames();
        boolean noPartitionSpecified = partitionNames.isEmpty();
        List<Predicate> conditions = stmt.getDeleteConditions();
        Database db = Catalog.getCurrentCatalog().getDbOrDdlException(dbName);
        DeleteJob deleteJob = null;
        try {
            MarkedCountDownLatch<Long, Long> countDownLatch;
            long transactionId = -1L;
            OlapTable olapTable = db.getOlapTableOrDdlException(tableName);
            olapTable.readLock();
            try {
                if (olapTable.getState() != OlapTable.OlapTableState.NORMAL) {
                    // empty if block
                }
                if (noPartitionSpecified) {
                    if (olapTable.getPartitionInfo().getType() == PartitionType.RANGE || olapTable.getPartitionInfo().getType() == PartitionType.LIST) {
                        if (!ConnectContext.get().getSessionVariable().isDeleteWithoutPartition()) {
                            throw new DdlException("This is a range or list partitioned table. You should specify partition in delete stmt, or set delete_without_partition to true");
                        }
                        partitionNames.addAll(olapTable.getPartitionNames());
                    } else if (olapTable.getPartitionInfo().getType() == PartitionType.UNPARTITIONED) {
                        partitionNames.add(olapTable.getName());
                    } else {
                        throw new DdlException("Unknown partition type: " + (Object)((Object)olapTable.getPartitionInfo().getType()));
                    }
                }
                HashMap partitionReplicaNum = Maps.newHashMap();
                ArrayList partitions = Lists.newArrayList();
                for (String partName : partitionNames) {
                    Partition partition = olapTable.getPartition(partName);
                    if (partition == null) {
                        throw new DdlException("Partition does not exist. name: " + partName);
                    }
                    partitions.add(partition);
                    partitionReplicaNum.put(partition.getId(), olapTable.getPartitionInfo().getReplicaAllocation(partition.getId()).getTotalReplicaNum());
                }
                ArrayList deleteConditions = Lists.newArrayList();
                this.checkDeleteV2(olapTable, partitions, conditions, deleteConditions);
                String label = "delete_" + UUID.randomUUID();
                long jobId = Catalog.getCurrentCatalog().getNextId();
                transactionId = Catalog.getCurrentGlobalTransactionMgr().beginTransaction(db.getId(), Lists.newArrayList((Object[])new Long[]{olapTable.getId()}), label, null, new TransactionState.TxnCoordinator(TransactionState.TxnSourceType.FE, FrontendOptions.getLocalHostAddress()), TransactionState.LoadJobSourceType.FRONTEND, jobId, Config.stream_load_default_timeout_second);
                DeleteInfo deleteInfo = new DeleteInfo(db.getId(), olapTable.getId(), tableName, deleteConditions);
                deleteInfo.setPartitions(noPartitionSpecified, partitions.stream().map(p -> p.getId()).collect(Collectors.toList()), partitionNames);
                deleteJob = new DeleteJob(jobId, transactionId, label, partitionReplicaNum, deleteInfo);
                this.idToDeleteJob.put(deleteJob.getTransactionId(), deleteJob);
                Catalog.getCurrentGlobalTransactionMgr().getCallbackFactory().addCallback(deleteJob);
                TransactionState txnState = Catalog.getCurrentGlobalTransactionMgr().getTransactionState(db.getId(), transactionId);
                txnState.addTableIndexes(olapTable);
                AgentBatchTask batchTask = new AgentBatchTask();
                int totalReplicaNum = 0;
                for (Partition partition : partitions) {
                    for (MaterializedIndex index : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.ALL)) {
                        for (Tablet tablet : index.getTablets()) {
                            totalReplicaNum += tablet.getReplicas().size();
                        }
                    }
                }
                countDownLatch = new MarkedCountDownLatch<Long, Long>(totalReplicaNum);
                for (Partition partition : partitions) {
                    for (MaterializedIndex index : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.ALL)) {
                        long indexId = index.getId();
                        int schemaHash = olapTable.getSchemaHashByIndexId(indexId);
                        for (Tablet tablet : index.getTablets()) {
                            long tabletId = tablet.getId();
                            TPushType type = TPushType.DELETE;
                            for (Replica replica : tablet.getReplicas()) {
                                long replicaId = replica.getId();
                                long backendId = replica.getBackendId();
                                countDownLatch.addMark(backendId, tabletId);
                                PushTask pushTask = new PushTask(null, replica.getBackendId(), db.getId(), olapTable.getId(), partition.getId(), indexId, tabletId, replicaId, schemaHash, -1L, "", -1L, 0, -1L, type, conditions, true, TPriority.NORMAL, TTaskType.REALTIME_PUSH, transactionId, Catalog.getCurrentGlobalTransactionMgr().getTransactionIDGenerator().getNextTransactionId());
                                pushTask.setIsSchemaChanging(false);
                                pushTask.setCountDownLatch(countDownLatch);
                                if (!AgentTaskQueue.addTask(pushTask)) continue;
                                batchTask.addTask(pushTask);
                                deleteJob.addPushTask(pushTask);
                                deleteJob.addTablet(tabletId);
                            }
                        }
                    }
                }
                if (batchTask.getTaskNum() > 0) {
                    AgentTaskExecutor.submit(batchTask);
                }
            }
            catch (Throwable t) {
                LOG.warn("error occurred during delete process", t);
                if (Catalog.getCurrentGlobalTransactionMgr().getTransactionState(db.getId(), transactionId) != null) {
                    this.cancelJob(deleteJob, CancelType.UNKNOWN, t.getMessage());
                }
                throw new DdlException(t.getMessage(), t);
            }
            finally {
                olapTable.readUnlock();
            }
            long timeoutMs = deleteJob.getTimeoutMs();
            LOG.info("waiting delete Job finish, signature: {}, timeout: {}", (Object)transactionId, (Object)timeoutMs);
            boolean ok = false;
            try {
                ok = countDownLatch.await(timeoutMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOG.warn("InterruptedException: ", (Throwable)e);
                ok = false;
            }
            if (!ok) {
                String errMsg = "";
                List unfinishedMarks = countDownLatch.getLeftMarks();
                List subList = unfinishedMarks.subList(0, Math.min(unfinishedMarks.size(), 5));
                if (!subList.isEmpty()) {
                    errMsg = "unfinished replicas [BackendId=TabletId]: " + Joiner.on((String)", ").join(subList);
                }
                LOG.warn(errMsg);
                try {
                    deleteJob.checkAndUpdateQuorum();
                }
                catch (MetaNotFoundException e) {
                    this.cancelJob(deleteJob, CancelType.METADATA_MISSING, e.getMessage());
                    throw new DdlException(e.getMessage(), e);
                }
                DeleteJob.DeleteState state = deleteJob.getState();
                switch (state) {
                    case UN_QUORUM: {
                        LOG.warn("delete job timeout: transactionId {}, timeout {}, {}", (Object)transactionId, (Object)timeoutMs, (Object)errMsg);
                        this.cancelJob(deleteJob, CancelType.TIMEOUT, "delete job timeout");
                        throw new DdlException("failed to execute delete. transaction id " + transactionId + ", timeout(ms) " + timeoutMs + ", " + errMsg);
                    }
                    case QUORUM_FINISHED: 
                    case FINISHED: {
                        try {
                            long nowQuorumTimeMs = System.currentTimeMillis();
                            long endQuorumTimeoutMs = nowQuorumTimeMs + timeoutMs / 2L;
                            while (deleteJob.getState() == DeleteJob.DeleteState.QUORUM_FINISHED && endQuorumTimeoutMs > nowQuorumTimeMs) {
                                deleteJob.checkAndUpdateQuorum();
                                Thread.sleep(1000L);
                                nowQuorumTimeMs = System.currentTimeMillis();
                                LOG.debug("wait for quorum finished delete job: {}, txn id: {}" + deleteJob.getId(), (Object)transactionId);
                            }
                        }
                        catch (MetaNotFoundException e) {
                            this.cancelJob(deleteJob, CancelType.METADATA_MISSING, e.getMessage());
                            throw new DdlException(e.getMessage(), e);
                        }
                        catch (InterruptedException e) {
                            this.cancelJob(deleteJob, CancelType.UNKNOWN, e.getMessage());
                            throw new DdlException(e.getMessage(), e);
                        }
                        this.commitJob(deleteJob, db, olapTable, timeoutMs);
                        break;
                    }
                    default: {
                        Preconditions.checkState((boolean)false, (Object)("wrong delete job state: " + state.name()));
                        break;
                    }
                }
            } else {
                this.commitJob(deleteJob, db, olapTable, timeoutMs);
            }
            if (!FeConstants.runningUnitTest) {
                this.clearJob(deleteJob);
            }
        }
        catch (Throwable throwable) {
            if (!FeConstants.runningUnitTest) {
                this.clearJob(deleteJob);
            }
            throw throwable;
        }
    }

    private void commitJob(DeleteJob job, Database db, Table table, long timeoutMs) throws DdlException, QueryStateException {
        TransactionStatus status;
        block6: {
            status = null;
            try {
                this.unprotectedCommitJob(job, db, table, timeoutMs);
                status = Catalog.getCurrentGlobalTransactionMgr().getTransactionState(db.getId(), job.getTransactionId()).getTransactionStatus();
            }
            catch (UserException e) {
                if (!this.cancelJob(job, CancelType.COMMIT_FAIL, e.getMessage())) break block6;
                throw new DdlException(e.getMessage(), e);
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{'label':'").append(job.getLabel()).append("', 'status':'").append(status.name());
        sb.append("', 'txnId':'").append(job.getTransactionId()).append("'");
        switch (status) {
            case COMMITTED: {
                String errMsg = "delete job is committed but may be taking effect later";
                sb.append(", 'err':'").append(errMsg).append("'");
                sb.append("}");
                throw new QueryStateException(QueryState.MysqlStateType.OK, sb.toString());
            }
            case VISIBLE: {
                sb.append("}");
                throw new QueryStateException(QueryState.MysqlStateType.OK, sb.toString());
            }
        }
        Preconditions.checkState((boolean)false, (Object)("wrong transaction status: " + status.name()));
    }

    private boolean unprotectedCommitJob(DeleteJob job, Database db, Table table, long timeoutMs) throws UserException {
        long transactionId = job.getTransactionId();
        GlobalTransactionMgr globalTransactionMgr = Catalog.getCurrentGlobalTransactionMgr();
        ArrayList<TabletCommitInfo> tabletCommitInfos = new ArrayList<TabletCommitInfo>();
        TabletInvertedIndex invertedIndex = Catalog.getCurrentInvertedIndex();
        for (TabletDeleteInfo tDeleteInfo : job.getTabletDeleteInfo()) {
            for (Replica replica : tDeleteInfo.getFinishedReplicas()) {
                Long tabletId = invertedIndex.getTabletIdByReplica(replica.getId());
                if (tabletId == null) {
                    LOG.warn("could not find tablet id for replica {}, the tablet maybe dropped", (Object)replica);
                    continue;
                }
                tabletCommitInfos.add(new TabletCommitInfo(tabletId, replica.getBackendId()));
            }
        }
        return globalTransactionMgr.commitAndPublishTransaction(db, Lists.newArrayList((Object[])new Table[]{table}), transactionId, tabletCommitInfos, timeoutMs);
    }

    private void clearJob(DeleteJob job) {
        if (job != null) {
            long signature = job.getTransactionId();
            if (this.idToDeleteJob.containsKey(signature)) {
                this.idToDeleteJob.remove(signature);
            }
            for (PushTask pushTask : job.getPushTasks()) {
                AgentTaskQueue.removePushTask(pushTask.getBackendId(), pushTask.getSignature(), pushTask.getVersion(), pushTask.getPushType(), pushTask.getTaskType());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordFinishedJob(DeleteJob job) {
        if (job != null) {
            long dbId = job.getDeleteInfo().getDbId();
            LOG.info("record finished deleteJob, transactionId {}, dbId {}", (Object)job.getTransactionId(), (Object)dbId);
            this.dbToDeleteInfos.putIfAbsent(dbId, Lists.newArrayList());
            List<DeleteInfo> deleteInfoList = this.dbToDeleteInfos.get(dbId);
            this.writeLock();
            try {
                deleteInfoList.add(job.getDeleteInfo());
            }
            finally {
                this.writeUnlock();
            }
        }
    }

    public boolean cancelJob(DeleteJob job, CancelType cancelType, String reason) {
        LOG.info("start to cancel delete job, transactionId: {}, cancelType: {}", (Object)job.getTransactionId(), (Object)cancelType.name());
        GlobalTransactionMgr globalTransactionMgr = Catalog.getCurrentGlobalTransactionMgr();
        try {
            if (job != null) {
                globalTransactionMgr.abortTransaction(job.getDeleteInfo().getDbId(), job.getTransactionId(), reason);
            }
        }
        catch (Exception e) {
            TransactionState state = globalTransactionMgr.getTransactionState(job.getDeleteInfo().getDbId(), job.getTransactionId());
            if (state == null) {
                LOG.warn("cancel delete job failed because txn not found, transactionId: {}", (Object)job.getTransactionId());
            }
            if (state.getTransactionStatus() == TransactionStatus.COMMITTED || state.getTransactionStatus() == TransactionStatus.VISIBLE) {
                LOG.warn("cancel delete job {} failed because it has been committed, transactionId: {}", (Object)job.getTransactionId());
                return false;
            }
            LOG.warn("errors while abort transaction", (Throwable)e);
        }
        return true;
    }

    public DeleteJob getDeleteJob(long transactionId) {
        return this.idToDeleteJob.get(transactionId);
    }

    private SlotRef getSlotRef(Predicate condition) {
        SlotRef slotRef = null;
        if (condition instanceof BinaryPredicate) {
            BinaryPredicate binaryPredicate = (BinaryPredicate)condition;
            slotRef = (SlotRef)binaryPredicate.getChild(0);
        } else if (condition instanceof IsNullPredicate) {
            IsNullPredicate isNullPredicate = (IsNullPredicate)condition;
            slotRef = (SlotRef)isNullPredicate.getChild(0);
        } else if (condition instanceof InPredicate) {
            InPredicate inPredicate = (InPredicate)condition;
            slotRef = (SlotRef)inPredicate.getChild(0);
        }
        return slotRef;
    }

    /*
     * WARNING - void declaration
     */
    private void checkDeleteV2(OlapTable table, List<Partition> partitions, List<Predicate> conditions, List<String> deleteConditions) throws DdlException {
        TreeMap nameToColumn = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        for (Column column : table.getFullSchema()) {
            nameToColumn.put(column.getName(), column);
        }
        for (Predicate condition : conditions) {
            Object column;
            String shadowColName;
            SlotRef slotRef = this.getSlotRef(condition);
            String columnName = slotRef.getColumnName();
            if (!nameToColumn.containsKey(columnName)) {
                ErrorReport.reportDdlException(ErrorCode.ERR_BAD_FIELD_ERROR, columnName, table.getName());
            }
            if (Column.isShadowColumn(columnName)) {
                ErrorReport.reportDdlException(ErrorCode.ERR_COMMON_ERROR, "Can not apply delete condition to shadow column");
            }
            if (nameToColumn.containsKey(shadowColName = Column.getShadowName(columnName))) {
                ErrorReport.reportDdlException(ErrorCode.ERR_COMMON_ERROR, "Column " + columnName + " is under schema change operation. Do not allow delete operation");
            }
            if (!((Column)(column = (Column)nameToColumn.get(columnName))).isKey() && table.getKeysType() != KeysType.DUP_KEYS || ((Column)column).getDataType().isFloatingPointType()) {
                throw new DdlException("Column[" + columnName + "] is not key column or storage model is not duplicate or column type is float or double.");
            }
            if (condition instanceof BinaryPredicate) {
                String string = null;
                try {
                    void var12_16;
                    BinaryPredicate binaryPredicate = (BinaryPredicate)condition;
                    String string2 = ((LiteralExpr)binaryPredicate.getChild(1)).getStringValue();
                    if (((Column)column).getDataType() == PrimitiveType.BOOLEAN) {
                        if (string2.toLowerCase().equals("true")) {
                            binaryPredicate.setChild(1, LiteralExpr.create("1", Type.TINYINT));
                        } else if (string2.toLowerCase().equals("false")) {
                            binaryPredicate.setChild(1, LiteralExpr.create("0", Type.TINYINT));
                        }
                    } else if (((Column)column).getDataType() == PrimitiveType.DATE || ((Column)column).getDataType() == PrimitiveType.DATETIME) {
                        DateLiteral dateLiteral = new DateLiteral(string2, Type.fromPrimitiveType(((Column)column).getDataType()));
                        String string3 = dateLiteral.getStringValue();
                        binaryPredicate.setChild(1, LiteralExpr.create(string3, Type.fromPrimitiveType(((Column)column).getDataType())));
                    }
                    LiteralExpr.create((String)var12_16, Type.fromPrimitiveType(((Column)column).getDataType()));
                }
                catch (AnalysisException e) {
                    throw new DdlException("Invalid column value[" + string + "] for column " + columnName);
                }
            }
            if (condition instanceof InPredicate) {
                String string = null;
                try {
                    InPredicate inPredicate = (InPredicate)condition;
                    for (int i = 1; i <= inPredicate.getInElementNum(); ++i) {
                        String string4 = ((LiteralExpr)inPredicate.getChild(i)).getStringValue();
                        if (((Column)column).getDataType() == PrimitiveType.DATE || ((Column)column).getDataType() == PrimitiveType.DATETIME) {
                            DateLiteral dateLiteral = new DateLiteral(string4, Type.fromPrimitiveType(((Column)column).getDataType()));
                            String string5 = dateLiteral.getStringValue();
                            inPredicate.setChild(i, LiteralExpr.create(string5, Type.fromPrimitiveType(((Column)column).getDataType())));
                            continue;
                        }
                        LiteralExpr.create(string4, Type.fromPrimitiveType(((Column)column).getDataType()));
                    }
                }
                catch (AnalysisException e) {
                    throw new DdlException("Invalid column value[" + string + "] for column " + columnName);
                }
            }
            slotRef.setCol(((Column)column).getName());
        }
        Map<Long, List<Column>> indexIdToSchema = table.getIndexIdToSchema();
        Partition partition = partitions.get(0);
        for (MaterializedIndex index : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.ALL)) {
            if (table.getBaseIndexId() == index.getId()) continue;
            TreeMap indexColNameToColumn = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
            for (Column column : indexIdToSchema.get(index.getId())) {
                indexColNameToColumn.put(column.getName(), column);
            }
            String indexName = table.getIndexNameById(index.getId());
            for (Predicate condition : conditions) {
                MaterializedIndexMeta indexMeta;
                SlotRef slotRef = this.getSlotRef(condition);
                String columnName = slotRef.getColumnName();
                Column column3 = (Column)indexColNameToColumn.get(columnName);
                if (column3 == null) {
                    ErrorReport.reportDdlException(ErrorCode.ERR_BAD_FIELD_ERROR, columnName, "index[" + indexName + "]");
                }
                if ((indexMeta = table.getIndexIdToMeta().get(index.getId())).getKeysType() == KeysType.DUP_KEYS || column3.isKey()) continue;
                throw new DdlException("Column[" + columnName + "] is not key column in index[" + indexName + "]");
            }
        }
        if (deleteConditions == null) {
            return;
        }
        for (Predicate condition : conditions) {
            StringBuilder sb;
            SlotRef slotRef;
            if (condition instanceof BinaryPredicate) {
                BinaryPredicate binaryPredicate = (BinaryPredicate)condition;
                slotRef = (SlotRef)binaryPredicate.getChild(0);
                String string = slotRef.getColumnName();
                sb = new StringBuilder();
                sb.append(string).append(" ").append(binaryPredicate.getOp().name()).append(" \"").append(((LiteralExpr)binaryPredicate.getChild(1)).getStringValue()).append("\"");
                deleteConditions.add(sb.toString());
                continue;
            }
            if (condition instanceof IsNullPredicate) {
                IsNullPredicate isNullPredicate = (IsNullPredicate)condition;
                slotRef = (SlotRef)isNullPredicate.getChild(0);
                String string = slotRef.getColumnName();
                sb = new StringBuilder();
                sb.append(string);
                if (isNullPredicate.isNotNull()) {
                    sb.append(" IS NOT NULL");
                } else {
                    sb.append(" IS NULL");
                }
                deleteConditions.add(sb.toString());
                continue;
            }
            if (!(condition instanceof InPredicate)) continue;
            InPredicate inPredicate = (InPredicate)condition;
            slotRef = (SlotRef)inPredicate.getChild(0);
            String string = slotRef.getColumnName();
            StringBuilder strBuilder = new StringBuilder();
            String notStr = inPredicate.isNotIn() ? "NOT " : "";
            strBuilder.append(string).append(" ").append(notStr).append("IN (");
            for (int i = 1; i <= inPredicate.getInElementNum(); ++i) {
                strBuilder.append(((Expr)inPredicate.getChild(i)).toSql());
                strBuilder.append(i != inPredicate.getInElementNum() ? ", " : "");
            }
            strBuilder.append(")");
            deleteConditions.add(strBuilder.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<Comparable>> getDeleteInfosByDb(long dbId) {
        LinkedList<List<Comparable>> infos = new LinkedList<List<Comparable>>();
        Database db = Catalog.getCurrentCatalog().getDbNullable(dbId);
        if (db == null) {
            return infos;
        }
        String dbName = db.getFullName();
        List<DeleteInfo> deleteInfoList = this.dbToDeleteInfos.get(dbId);
        this.readLock();
        try {
            if (deleteInfoList == null) {
                LinkedList<List<Comparable>> linkedList = infos;
                return linkedList;
            }
            for (DeleteInfo deleteInfo : deleteInfoList) {
                if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), dbName, deleteInfo.getTableName(), PrivPredicate.LOAD)) continue;
                ArrayList info = Lists.newArrayList();
                info.add(deleteInfo.getTableName());
                if (deleteInfo.isNoPartitionSpecified()) {
                    info.add("*");
                } else {
                    info.add(Joiner.on((String)", ").join(deleteInfo.getPartitionNames()));
                }
                info.add(TimeUtils.longToTimeString(deleteInfo.getCreateTimeMs()));
                String conds = Joiner.on((String)", ").join(deleteInfo.getDeleteConditions());
                info.add(conds);
                info.add("FINISHED");
                infos.add(info);
            }
        }
        finally {
            this.readUnlock();
        }
        ListComparator comparator = new ListComparator(2);
        Collections.sort(infos, comparator);
        return infos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayDelete(DeleteInfo deleteInfo, Catalog catalog) {
        long dbId = deleteInfo.getDbId();
        LOG.info("replay delete, dbId {}", (Object)dbId);
        this.dbToDeleteInfos.putIfAbsent(dbId, Lists.newArrayList());
        List<DeleteInfo> deleteInfoList = this.dbToDeleteInfos.get(dbId);
        this.writeLock();
        try {
            deleteInfoList.add(deleteInfo);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void write(DataOutput out) throws IOException {
        this.removeOldDeleteInfos();
        Text.writeString((DataOutput)out, (String)GsonUtils.GSON.toJson((Object)this));
    }

    public static DeleteHandler read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        DeleteHandler deleteHandler = (DeleteHandler)GsonUtils.GSON.fromJson(json, DeleteHandler.class);
        deleteHandler.removeOldDeleteInfos();
        return deleteHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOldDeleteInfos() {
        long curTime = System.currentTimeMillis();
        int counter = 0;
        Iterator<Map.Entry<Long, List<DeleteInfo>>> iter1 = this.dbToDeleteInfos.entrySet().iterator();
        while (iter1.hasNext()) {
            List<DeleteInfo> deleteInfoList = iter1.next().getValue();
            this.writeLock();
            try {
                Iterator<DeleteInfo> iter2 = deleteInfoList.iterator();
                while (iter2.hasNext()) {
                    DeleteInfo deleteInfo = iter2.next();
                    if ((curTime - deleteInfo.getCreateTimeMs()) / 1000L <= (long)Config.streaming_label_keep_max_second) continue;
                    iter2.remove();
                    ++counter;
                }
            }
            finally {
                this.writeUnlock();
            }
            if (!deleteInfoList.isEmpty()) continue;
            iter1.remove();
        }
        LOG.debug("remove expired delete job info num: {}", (Object)counter);
    }

    private static enum CancelType {
        METADATA_MISSING,
        TIMEOUT,
        COMMIT_FAIL,
        UNKNOWN;

    }
}

