/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.FsBroker;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.PrintableMap;
import org.apache.doris.load.LoadErrorHub;
import org.apache.doris.thrift.TBrokerErrorHubInfo;
import org.apache.doris.thrift.TNetworkAddress;

public class BrokerLoadErrorHub
extends LoadErrorHub {
    private BrokerParam brokerParam;

    public BrokerLoadErrorHub(BrokerParam brokerParam) {
        this.brokerParam = brokerParam;
    }

    public BrokerParam getBrokerParam() {
        return this.brokerParam;
    }

    @Override
    public List<LoadErrorHub.ErrorMsg> fetchLoadError(long jobId) {
        ArrayList result = Lists.newArrayList();
        String hint = "Find detail load error info on '" + this.brokerParam.path + "' with file name showed in 'SHOW LOAD' stmt";
        LoadErrorHub.ErrorMsg errorMsg = new LoadErrorHub.ErrorMsg(this, 0L, hint);
        result.add(errorMsg);
        return result;
    }

    @Override
    public boolean prepare() {
        return true;
    }

    @Override
    public boolean close() {
        return true;
    }

    public static class BrokerParam
    implements Writable {
        private String brokerName;
        private String path;
        private Map<String, String> prop = Maps.newHashMap();

        public BrokerParam() {
        }

        public BrokerParam(String brokerName, String path, Map<String, String> prop) {
            this.brokerName = brokerName;
            this.path = path;
            this.prop = prop;
        }

        public void write(DataOutput out) throws IOException {
            Text.writeString((DataOutput)out, (String)this.brokerName);
            Text.writeString((DataOutput)out, (String)this.path);
            out.writeInt(this.prop.size());
            for (Map.Entry<String, String> entry : this.prop.entrySet()) {
                Text.writeString((DataOutput)out, (String)entry.getKey());
                Text.writeString((DataOutput)out, (String)entry.getValue());
            }
        }

        public void readFields(DataInput in) throws IOException {
            this.brokerName = Text.readString((DataInput)in);
            this.path = Text.readString((DataInput)in);
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                String key = Text.readString((DataInput)in);
                String val = Text.readString((DataInput)in);
                this.prop.put(key, val);
            }
        }

        public TBrokerErrorHubInfo toThrift() {
            FsBroker fsBroker = Catalog.getCurrentCatalog().getBrokerMgr().getAnyBroker(this.brokerName);
            if (fsBroker == null) {
                return null;
            }
            TBrokerErrorHubInfo info = new TBrokerErrorHubInfo(new TNetworkAddress(fsBroker.ip, fsBroker.port), this.path, this.prop);
            return info;
        }

        public String getBrief() {
            HashMap briefMap = Maps.newHashMap(this.prop);
            briefMap.put("name", this.brokerName);
            briefMap.put("path", this.path);
            PrintableMap printableMap = new PrintableMap(briefMap, "=", true, false, true);
            return printableMap.toString();
        }
    }
}

