/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.io.Writable;
import org.apache.doris.load.BrokerFileGroup;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrokerFileGroupAggInfo
implements Writable {
    private static final Logger LOG = LogManager.getLogger(BrokerFileGroupAggInfo.class);
    private Map<FileGroupAggKey, List<BrokerFileGroup>> aggKeyToFileGroups = Maps.newHashMap();
    private Map<Long, Set<Long>> tableIdToPartitionIds = Maps.newHashMap();

    public void addFileGroup(BrokerFileGroup fileGroup) throws DdlException {
        FileGroupAggKey fileGroupAggKey = new FileGroupAggKey(fileGroup.getTableId(), fileGroup.getPartitionIds());
        ArrayList fileGroupList = this.aggKeyToFileGroups.get(fileGroupAggKey);
        if (fileGroupList == null) {
            if (this.tableIdToPartitionIds.containsKey(fileGroup.getTableId()) && this.tableIdToPartitionIds.get(fileGroup.getTableId()).stream().anyMatch(id -> fileGroup.getPartitionIds().contains(id))) {
                throw new DdlException("There are overlapping partitions of same table in data description of load job stmt");
            }
            fileGroupList = Lists.newArrayList();
            this.aggKeyToFileGroups.put(fileGroupAggKey, fileGroupList);
        }
        fileGroupList.add((BrokerFileGroup)fileGroup);
        HashSet partitionIds = this.tableIdToPartitionIds.get(fileGroup.getTableId());
        if (partitionIds == null) {
            partitionIds = Sets.newHashSet();
            this.tableIdToPartitionIds.put(fileGroup.getTableId(), partitionIds);
        }
        if (fileGroup.getPartitionIds() != null) {
            partitionIds.addAll(fileGroup.getPartitionIds());
        }
    }

    public Set<Long> getAllTableIds() {
        return this.aggKeyToFileGroups.keySet().stream().map(k -> ((FileGroupAggKey)k).tableId).collect(Collectors.toSet());
    }

    public Map<FileGroupAggKey, List<BrokerFileGroup>> getAggKeyToFileGroups() {
        return this.aggKeyToFileGroups;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.aggKeyToFileGroups);
        return sb.toString();
    }

    @Deprecated
    public void write(DataOutput out) throws IOException {
        out.writeInt(0);
    }

    @Deprecated
    public void readFields(DataInput in) throws IOException {
        int mapSize = in.readInt();
        for (int i = 0; i < mapSize; ++i) {
            long id = in.readLong();
            int listSize = in.readInt();
            for (int j = 0; j < listSize; ++j) {
                BrokerFileGroup brokerFileGroup = BrokerFileGroup.read(in);
            }
        }
    }

    @Deprecated
    public static BrokerFileGroupAggInfo read(DataInput in) throws IOException {
        BrokerFileGroupAggInfo sourceInfo = new BrokerFileGroupAggInfo();
        sourceInfo.readFields(in);
        return sourceInfo;
    }

    public static class FileGroupAggKey {
        private long tableId;
        private Set<Long> partitionIds;

        public FileGroupAggKey(long tableId, List<Long> partitionIds) {
            this.tableId = tableId;
            this.partitionIds = partitionIds != null ? Sets.newHashSet(partitionIds) : Sets.newHashSet();
        }

        public long getTableId() {
            return this.tableId;
        }

        public Set<Long> getPartitionIds() {
            return this.partitionIds;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof FileGroupAggKey)) {
                return false;
            }
            FileGroupAggKey other = (FileGroupAggKey)obj;
            return other.tableId == this.tableId && other.partitionIds.equals(this.partitionIds);
        }

        public int hashCode() {
            return Objects.hash(this.tableId, this.partitionIds);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[").append(this.tableId).append(": ").append(this.partitionIds).append("]");
            return sb.toString();
        }
    }
}

