/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.doris.analysis.DataDescription;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ImportColumnDesc;
import org.apache.doris.analysis.PartitionNames;
import org.apache.doris.analysis.Separator;
import org.apache.doris.catalog.AggregateType;
import org.apache.doris.catalog.BrokerTable;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.HiveTable;
import org.apache.doris.catalog.IcebergTable;
import org.apache.doris.catalog.KeysType;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.UserException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.load.loadv2.LoadTask;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrokerFileGroup
implements Writable {
    private static final Logger LOG = LogManager.getLogger(BrokerFileGroup.class);
    private long tableId;
    private String valueSeparator;
    private String lineDelimiter;
    private String fileFormat;
    private boolean isNegative;
    private List<Long> partitionIds;
    private List<String> filePaths;
    private List<Long> fileSize;
    private List<String> fileFieldNames;
    private List<String> columnsFromPath;
    private List<ImportColumnDesc> columnExprList;
    private Map<String, Pair<String, List<String>>> columnToHadoopFunction;
    private Expr precedingFilterExpr;
    private Expr whereExpr;
    private Expr deleteCondition;
    private LoadTask.MergeType mergeType;
    private String sequenceCol;
    private long srcTableId = -1L;
    private boolean isLoadFromTable = false;
    private TNetworkAddress beAddr;
    private long backendID;
    private boolean stripOuterArray = false;
    private String jsonPaths = "";
    private String jsonRoot = "";
    private boolean fuzzyParse = true;
    private boolean readJsonByLine = false;
    private boolean numAsString = false;

    private BrokerFileGroup() {
    }

    public BrokerFileGroup(BrokerTable table) throws AnalysisException {
        this.tableId = table.getId();
        this.valueSeparator = Separator.convertSeparator(table.getColumnSeparator());
        this.lineDelimiter = Separator.convertSeparator(table.getLineDelimiter());
        this.isNegative = false;
        this.filePaths = table.getPaths();
        this.fileFormat = table.getFileFormat();
    }

    public BrokerFileGroup(HiveTable table, String columnSeparator, String lineDelimiter, String filePath, String fileFormat, List<String> columnsFromPath, List<ImportColumnDesc> columnExprList) throws AnalysisException {
        this.tableId = table.getId();
        this.valueSeparator = Separator.convertSeparator(columnSeparator);
        this.lineDelimiter = Separator.convertSeparator(lineDelimiter);
        this.isNegative = false;
        this.filePaths = Lists.newArrayList((Object[])new String[]{filePath});
        this.fileFormat = fileFormat;
        this.columnsFromPath = columnsFromPath;
        this.columnExprList = columnExprList;
    }

    public BrokerFileGroup(IcebergTable table) throws UserException {
        this.tableId = table.getId();
        this.isNegative = false;
        this.valueSeparator = "|";
        this.lineDelimiter = "\n";
        this.fileFormat = table.getFileFormat();
    }

    public BrokerFileGroup(DataDescription dataDescription) {
        this.fileFieldNames = dataDescription.getFileFieldNames();
        this.columnsFromPath = dataDescription.getColumnsFromPath();
        this.columnExprList = dataDescription.getParsedColumnExprList();
        this.columnToHadoopFunction = dataDescription.getColumnToHadoopFunction();
        this.precedingFilterExpr = dataDescription.getPrecdingFilterExpr();
        this.whereExpr = dataDescription.getWhereExpr();
        this.deleteCondition = dataDescription.getDeleteCondition();
        this.mergeType = dataDescription.getMergeType();
        this.sequenceCol = dataDescription.getSequenceCol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Database db, DataDescription dataDescription) throws DdlException {
        OlapTable olapTable = db.getOlapTableOrDdlException(dataDescription.getTableName());
        this.tableId = olapTable.getId();
        olapTable.readLock();
        try {
            PartitionNames partitionNames = dataDescription.getPartitionNames();
            if (partitionNames != null) {
                this.partitionIds = Lists.newArrayList();
                for (String pName : partitionNames.getPartitionNames()) {
                    Partition partition = olapTable.getPartition(pName, partitionNames.isTemp());
                    if (partition == null) {
                        throw new DdlException("Unknown partition '" + pName + "' in table '" + olapTable.getName() + "'");
                    }
                    this.partitionIds.add(partition.getId());
                }
            }
            if (olapTable.getState() == OlapTable.OlapTableState.RESTORE) {
                throw new DdlException("Table [" + olapTable.getName() + "] is under restore");
            }
            if (olapTable.getKeysType() != KeysType.AGG_KEYS && dataDescription.isNegative()) {
                throw new DdlException("Load for AGG_KEYS table should not specify NEGATIVE");
            }
            if (dataDescription.isNegative()) {
                for (Column column : olapTable.getBaseSchema()) {
                    if (column.isKey() || column.getAggregationType() == AggregateType.SUM) continue;
                    throw new DdlException("Column is not SUM AggregateType. column:" + column.getName());
                }
            }
        }
        finally {
            olapTable.readUnlock();
        }
        this.valueSeparator = dataDescription.getColumnSeparator();
        if (this.valueSeparator == null) {
            this.valueSeparator = "\t";
        }
        this.lineDelimiter = dataDescription.getLineDelimiter();
        if (this.lineDelimiter == null) {
            this.lineDelimiter = "\n";
        }
        this.fileFormat = dataDescription.getFileFormat();
        if (!(this.fileFormat == null || this.fileFormat.equalsIgnoreCase("parquet") || this.fileFormat.equalsIgnoreCase("csv") || this.fileFormat.equalsIgnoreCase("orc") || this.fileFormat.equalsIgnoreCase("json"))) {
            throw new DdlException("File Format Type " + this.fileFormat + " is invalid.");
        }
        this.isNegative = dataDescription.isNegative();
        this.filePaths = dataDescription.getFilePaths();
        this.fileSize = dataDescription.getFileSize();
        if (dataDescription.isLoadFromTable()) {
            String srcTableName = dataDescription.getSrcTableName();
            Table srcTable = db.getTableOrDdlException(srcTableName);
            if (!(srcTable instanceof HiveTable)) {
                throw new DdlException("Source table " + srcTableName + " is not HiveTable");
            }
            for (Column column : olapTable.getBaseSchema()) {
                boolean isIncluded = false;
                for (Column srcColumn : srcTable.getBaseSchema()) {
                    if (!srcColumn.getName().equalsIgnoreCase(column.getName())) continue;
                    isIncluded = true;
                    break;
                }
                if (isIncluded) continue;
                throw new DdlException("Column " + column.getName() + " is not in Source table");
            }
            this.srcTableId = srcTable.getId();
            this.isLoadFromTable = true;
        }
        this.beAddr = dataDescription.getBeAddr();
        this.backendID = dataDescription.getBackendId();
        if (this.fileFormat != null && this.fileFormat.equalsIgnoreCase("json")) {
            this.stripOuterArray = dataDescription.isStripOuterArray();
            this.jsonPaths = dataDescription.getJsonPaths();
            this.jsonRoot = dataDescription.getJsonRoot();
            this.fuzzyParse = dataDescription.isFuzzyParse();
            this.readJsonByLine = true;
            this.numAsString = dataDescription.isNumAsString();
        }
    }

    public long getTableId() {
        return this.tableId;
    }

    public String getValueSeparator() {
        return this.valueSeparator;
    }

    public String getLineDelimiter() {
        return this.lineDelimiter;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public boolean isNegative() {
        return this.isNegative;
    }

    public List<Long> getPartitionIds() {
        return this.partitionIds;
    }

    public Expr getPrecedingFilterExpr() {
        return this.precedingFilterExpr;
    }

    public Expr getWhereExpr() {
        return this.whereExpr;
    }

    public List<String> getFilePaths() {
        return this.filePaths;
    }

    public List<String> getColumnsFromPath() {
        return this.columnsFromPath;
    }

    public List<ImportColumnDesc> getColumnExprList() {
        return this.columnExprList;
    }

    public List<String> getFileFieldNames() {
        return this.fileFieldNames;
    }

    public Map<String, Pair<String, List<String>>> getColumnToHadoopFunction() {
        return this.columnToHadoopFunction;
    }

    public long getSrcTableId() {
        return this.srcTableId;
    }

    public boolean isLoadFromTable() {
        return this.isLoadFromTable;
    }

    public Expr getDeleteCondition() {
        return this.deleteCondition;
    }

    public LoadTask.MergeType getMergeType() {
        return this.mergeType;
    }

    public String getSequenceCol() {
        return this.sequenceCol;
    }

    public boolean hasSequenceCol() {
        return !Strings.isNullOrEmpty((String)this.sequenceCol);
    }

    public List<Long> getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(List<Long> fileSize) {
        this.fileSize = fileSize;
    }

    public TNetworkAddress getBeAddr() {
        return this.beAddr;
    }

    public long getBackendID() {
        return this.backendID;
    }

    public boolean isStripOuterArray() {
        return this.stripOuterArray;
    }

    public void setStripOuterArray(boolean stripOuterArray) {
        this.stripOuterArray = stripOuterArray;
    }

    public boolean isFuzzyParse() {
        return this.fuzzyParse;
    }

    public void setFuzzyParse(boolean fuzzyParse) {
        this.fuzzyParse = fuzzyParse;
    }

    public boolean isReadJsonByLine() {
        return this.readJsonByLine;
    }

    public void setReadJsonByLine(boolean readJsonByLine) {
        this.readJsonByLine = readJsonByLine;
    }

    public boolean isNumAsString() {
        return this.numAsString;
    }

    public void setNumAsString(boolean numAsString) {
        this.numAsString = numAsString;
    }

    public String getJsonPaths() {
        return this.jsonPaths;
    }

    public void setJsonPaths(String jsonPaths) {
        this.jsonPaths = jsonPaths;
    }

    public String getJsonRoot() {
        return this.jsonRoot;
    }

    public void setJsonRoot(String jsonRoot) {
        this.jsonRoot = jsonRoot;
    }

    public boolean isBinaryFileFormat() {
        if (this.fileFormat == null) {
            return false;
        }
        return this.fileFormat.toLowerCase().equals("parquet") || this.fileFormat.toLowerCase().equals("orc");
    }

    public String toString() {
        int idx;
        StringBuilder sb = new StringBuilder();
        sb.append("BrokerFileGroup{tableId=").append(this.tableId);
        if (this.partitionIds != null) {
            sb.append(",partitionIds=[");
            idx = 0;
            Iterator<Object> iterator = this.partitionIds.iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                if (idx++ != 0) {
                    sb.append(",");
                }
                sb.append(id);
            }
            sb.append("]");
        }
        if (this.columnsFromPath != null) {
            sb.append(",columnsFromPath=[");
            idx = 0;
            for (String name : this.columnsFromPath) {
                if (idx++ != 0) {
                    sb.append(",");
                }
                sb.append(name);
            }
            sb.append("]");
        }
        if (this.fileFieldNames != null) {
            sb.append(",fileFieldNames=[");
            idx = 0;
            for (String name : this.fileFieldNames) {
                if (idx++ != 0) {
                    sb.append(",");
                }
                sb.append(name);
            }
            sb.append("]");
        }
        sb.append(",valueSeparator=").append(this.valueSeparator).append(",lineDelimiter=").append(this.lineDelimiter).append(",fileFormat=").append(this.fileFormat).append(",isNegative=").append(this.isNegative);
        sb.append(",fileInfos=[");
        idx = 0;
        for (String path : this.filePaths) {
            if (idx++ != 0) {
                sb.append(",");
            }
            sb.append(path);
        }
        sb.append("]");
        sb.append(",srcTableId=").append(this.srcTableId);
        sb.append(",isLoadFromTable=").append(this.isLoadFromTable);
        sb.append("}");
        return sb.toString();
    }

    @Deprecated
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.tableId);
        Text.writeString((DataOutput)out, (String)this.valueSeparator);
        Text.writeString((DataOutput)out, (String)this.lineDelimiter);
        out.writeBoolean(this.isNegative);
        if (this.partitionIds == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.partitionIds.size());
            Iterator<Object> iterator = this.partitionIds.iterator();
            while (iterator.hasNext()) {
                long id = iterator.next();
                out.writeLong(id);
            }
        }
        if (this.fileFieldNames == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.fileFieldNames.size());
            for (String name : this.fileFieldNames) {
                Text.writeString((DataOutput)out, (String)name);
            }
        }
        out.writeInt(this.filePaths.size());
        for (String path : this.filePaths) {
            Text.writeString((DataOutput)out, (String)path);
        }
        out.writeInt(0);
        if (this.fileFormat == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Text.writeString((DataOutput)out, (String)this.fileFormat);
        }
        out.writeLong(this.srcTableId);
        out.writeBoolean(this.isLoadFromTable);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void readFields(DataInput in) throws IOException {
        void var4_7;
        int fileFieldNameSize;
        int i;
        this.tableId = in.readLong();
        this.valueSeparator = Text.readString((DataInput)in);
        this.lineDelimiter = Text.readString((DataInput)in);
        this.isNegative = in.readBoolean();
        int partSize = in.readInt();
        if (partSize > 0) {
            this.partitionIds = Lists.newArrayList();
            for (i = 0; i < partSize; ++i) {
                this.partitionIds.add(in.readLong());
            }
        }
        if ((fileFieldNameSize = in.readInt()) > 0) {
            this.fileFieldNames = Lists.newArrayList();
            for (i = 0; i < fileFieldNameSize; ++i) {
                this.fileFieldNames.add(Text.readString((DataInput)in));
            }
        }
        int size = in.readInt();
        this.filePaths = Lists.newArrayList();
        for (i = 0; i < size; ++i) {
            this.filePaths.add(Text.readString((DataInput)in));
        }
        HashMap exprColumnMap = Maps.newHashMap();
        int size2 = in.readInt();
        boolean bl = false;
        while (var4_7 < size2) {
            String name = Text.readString((DataInput)in);
            exprColumnMap.put(name, Expr.readIn(in));
            ++var4_7;
        }
        if (in.readBoolean()) {
            this.fileFormat = Text.readString((DataInput)in);
        }
        this.srcTableId = in.readLong();
        this.isLoadFromTable = in.readBoolean();
        if (this.fileFieldNames == null || this.fileFieldNames.isEmpty()) {
            return;
        }
        this.columnExprList = Lists.newArrayList();
        for (String string : this.fileFieldNames) {
            this.columnExprList.add(new ImportColumnDesc(string, null));
        }
        if (exprColumnMap == null || exprColumnMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : exprColumnMap.entrySet()) {
            this.columnExprList.add(new ImportColumnDesc((String)entry.getKey(), (Expr)entry.getValue()));
        }
    }

    @Deprecated
    public static BrokerFileGroup read(DataInput in) throws IOException {
        BrokerFileGroup fileGroup = new BrokerFileGroup();
        fileGroup.readFields(in);
        return fileGroup;
    }
}

