/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.ldap;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.doris.analysis.ResourcePattern;
import org.apache.doris.analysis.TablePattern;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.LdapConfig;
import org.apache.doris.mysql.privilege.PaloAuth;
import org.apache.doris.mysql.privilege.PaloPrivilege;
import org.apache.doris.mysql.privilege.PaloRole;
import org.apache.doris.mysql.privilege.PrivBitSet;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LdapPrivsChecker {
    private static final Logger LOG = LogManager.getLogger(LdapPrivsChecker.class);

    public static boolean hasGlobalPrivFromLdap(UserIdentity currentUser, PrivPredicate wanted) {
        return LdapPrivsChecker.hasTblPatternPrivs(currentUser, wanted, null, null, PaloAuth.PrivLevel.GLOBAL) || LdapPrivsChecker.hasResourcePatternPrivs(currentUser, wanted, null, PaloAuth.PrivLevel.GLOBAL);
    }

    public static boolean hasDbPrivFromLdap(UserIdentity currentUser, String db, PrivPredicate wanted) {
        return LdapPrivsChecker.hasTblPatternPrivs(currentUser, wanted, db, null, PaloAuth.PrivLevel.DATABASE);
    }

    public static boolean hasDbPrivFromLdap(UserIdentity currentUser, PrivPredicate wanted) {
        return LdapPrivsChecker.hasPrivs(currentUser, wanted, PaloAuth.PrivLevel.DATABASE);
    }

    public static boolean hasTblPrivFromLdap(UserIdentity currentUser, String db, String tbl, PrivPredicate wanted) {
        return LdapPrivsChecker.hasTblPatternPrivs(currentUser, wanted, db, tbl, PaloAuth.PrivLevel.TABLE);
    }

    public static boolean hasTblPrivFromLdap(UserIdentity currentUser, PrivPredicate wanted) {
        return LdapPrivsChecker.hasPrivs(currentUser, wanted, PaloAuth.PrivLevel.TABLE);
    }

    public static boolean hasResourcePrivFromLdap(UserIdentity currentUser, String resourceName, PrivPredicate wanted) {
        return LdapPrivsChecker.hasResourcePatternPrivs(currentUser, wanted, resourceName, PaloAuth.PrivLevel.RESOURCE);
    }

    private static boolean hasTblPatternPrivs(UserIdentity currentUser, PrivPredicate wanted, String db, String tbl, PaloAuth.PrivLevel level) {
        PrivBitSet savedPrivs = PrivBitSet.of(new PaloPrivilege[0]);
        LdapPrivsChecker.getCurrentUserTblPrivs(currentUser, db, tbl, savedPrivs, level);
        return PaloPrivilege.satisfy(savedPrivs, wanted);
    }

    private static boolean hasResourcePatternPrivs(UserIdentity currentUser, PrivPredicate wanted, String resourceName, PaloAuth.PrivLevel level) {
        PrivBitSet savedPrivs = PrivBitSet.of(new PaloPrivilege[0]);
        LdapPrivsChecker.getCurrentUserResourcePrivs(currentUser, resourceName, savedPrivs, level);
        return PaloPrivilege.satisfy(savedPrivs, wanted);
    }

    public static PrivBitSet getGlobalPrivFromLdap(UserIdentity currentUser) {
        PrivBitSet savedPrivs = PrivBitSet.of(new PaloPrivilege[0]);
        LdapPrivsChecker.getCurrentUserTblPrivs(currentUser, null, null, savedPrivs, PaloAuth.PrivLevel.GLOBAL);
        LdapPrivsChecker.getCurrentUserResourcePrivs(currentUser, null, savedPrivs, PaloAuth.PrivLevel.GLOBAL);
        return savedPrivs;
    }

    public static PrivBitSet getDbPrivFromLdap(UserIdentity currentUser, String db) {
        PrivBitSet savedPrivs = PrivBitSet.of(new PaloPrivilege[0]);
        LdapPrivsChecker.getCurrentUserTblPrivs(currentUser, db, null, savedPrivs, PaloAuth.PrivLevel.DATABASE);
        return savedPrivs;
    }

    public static PrivBitSet getTblPrivFromLdap(UserIdentity currentUser, String db, String tbl) {
        PrivBitSet savedPrivs = PrivBitSet.of(new PaloPrivilege[0]);
        LdapPrivsChecker.getCurrentUserTblPrivs(currentUser, db, tbl, savedPrivs, PaloAuth.PrivLevel.TABLE);
        return savedPrivs;
    }

    public static PrivBitSet getResourcePrivFromLdap(UserIdentity currentUser, String resourceName) {
        PrivBitSet savedPrivs = PrivBitSet.of(new PaloPrivilege[0]);
        LdapPrivsChecker.getCurrentUserResourcePrivs(currentUser, resourceName, savedPrivs, PaloAuth.PrivLevel.RESOURCE);
        return savedPrivs;
    }

    private static void getCurrentUserTblPrivs(UserIdentity currentUser, String db, String tbl, PrivBitSet savedPrivs, PaloAuth.PrivLevel level) {
        if (!LdapPrivsChecker.hasLdapPrivs(currentUser)) {
            return;
        }
        PaloRole currentUserLdapPrivs = ConnectContext.get().getLdapGroupsPrivs();
        block5: for (Map.Entry<TablePattern, PrivBitSet> entry : currentUserLdapPrivs.getTblPatternToPrivs().entrySet()) {
            switch (entry.getKey().getPrivLevel()) {
                case GLOBAL: {
                    if (!level.equals((Object)PaloAuth.PrivLevel.GLOBAL)) continue block5;
                    savedPrivs.or(entry.getValue());
                    return;
                }
                case DATABASE: {
                    if (!level.equals((Object)PaloAuth.PrivLevel.DATABASE) || db == null || !entry.getKey().getQualifiedDb().equals(db)) continue block5;
                    savedPrivs.or(entry.getValue());
                    return;
                }
                case TABLE: {
                    if (!level.equals((Object)PaloAuth.PrivLevel.TABLE) || db == null || tbl == null || !entry.getKey().getQualifiedDb().equals(db) || !entry.getKey().getTbl().equals(tbl)) continue block5;
                    savedPrivs.or(entry.getValue());
                    return;
                }
            }
            Preconditions.checkNotNull(null, (Object)((Object)entry.getKey().getPrivLevel()));
        }
    }

    private static void getCurrentUserResourcePrivs(UserIdentity currentUser, String resourceName, PrivBitSet savedPrivs, PaloAuth.PrivLevel level) {
        if (!LdapPrivsChecker.hasLdapPrivs(currentUser)) {
            return;
        }
        PaloRole currentUserLdapPrivs = ConnectContext.get().getLdapGroupsPrivs();
        block4: for (Map.Entry<ResourcePattern, PrivBitSet> entry : currentUserLdapPrivs.getResourcePatternToPrivs().entrySet()) {
            switch (entry.getKey().getPrivLevel()) {
                case GLOBAL: {
                    if (!level.equals((Object)PaloAuth.PrivLevel.GLOBAL)) continue block4;
                    savedPrivs.or(entry.getValue());
                    return;
                }
                case RESOURCE: {
                    if (!level.equals((Object)PaloAuth.PrivLevel.RESOURCE) || resourceName == null || !entry.getKey().getResourceName().equals(resourceName)) continue block4;
                    savedPrivs.or(entry.getValue());
                    return;
                }
            }
            Preconditions.checkNotNull(null, (Object)((Object)entry.getKey().getPrivLevel()));
        }
    }

    private static boolean hasPrivs(UserIdentity currentUser, PrivPredicate wanted, PaloAuth.PrivLevel level) {
        if (!LdapPrivsChecker.hasLdapPrivs(currentUser)) {
            return false;
        }
        PaloRole currentUserLdapPrivs = ConnectContext.get().getLdapGroupsPrivs();
        for (Map.Entry<TablePattern, PrivBitSet> entry : currentUserLdapPrivs.getTblPatternToPrivs().entrySet()) {
            if (!entry.getKey().getPrivLevel().equals((Object)level) || !PaloPrivilege.satisfy(entry.getValue(), wanted)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPrivsOfDb(UserIdentity currentUser, String db) {
        if (!LdapPrivsChecker.hasLdapPrivs(currentUser)) {
            return false;
        }
        PaloRole currentUserLdapPrivs = ConnectContext.get().getLdapGroupsPrivs();
        for (Map.Entry<TablePattern, PrivBitSet> entry : currentUserLdapPrivs.getTblPatternToPrivs().entrySet()) {
            if (!entry.getKey().getPrivLevel().equals((Object)PaloAuth.PrivLevel.TABLE) || !entry.getKey().getQualifiedDb().equals(db)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCurrentUser(UserIdentity userIdent) {
        ConnectContext context = ConnectContext.get();
        if (context == null) {
            return false;
        }
        UserIdentity currentUser = context.getCurrentUserIdentity();
        return currentUser.getQualifiedUser().equals(userIdent.getQualifiedUser()) && currentUser.getHost().equals(userIdent.getHost());
    }

    public static boolean hasLdapPrivs(UserIdentity userIdent) {
        return LdapConfig.ldap_authentication_enabled && LdapPrivsChecker.isCurrentUser(userIdent) && ConnectContext.get().getLdapGroupsPrivs() != null;
    }

    public static Map<TablePattern, PrivBitSet> getLdapAllDbPrivs(UserIdentity userIdentity) {
        ConcurrentMap ldapDbPrivs = Maps.newConcurrentMap();
        if (!LdapPrivsChecker.hasLdapPrivs(userIdentity)) {
            return ldapDbPrivs;
        }
        for (Map.Entry<TablePattern, PrivBitSet> entry : ConnectContext.get().getLdapGroupsPrivs().getTblPatternToPrivs().entrySet()) {
            if (!entry.getKey().getPrivLevel().equals((Object)PaloAuth.PrivLevel.DATABASE)) continue;
            ldapDbPrivs.put(entry.getKey(), entry.getValue());
        }
        return ldapDbPrivs;
    }

    public static Map<TablePattern, PrivBitSet> getLdapAllTblPrivs(UserIdentity userIdentity) {
        ConcurrentMap ldapTblPrivs = Maps.newConcurrentMap();
        if (!LdapPrivsChecker.hasLdapPrivs(userIdentity)) {
            return ldapTblPrivs;
        }
        for (Map.Entry<TablePattern, PrivBitSet> entry : ConnectContext.get().getLdapGroupsPrivs().getTblPatternToPrivs().entrySet()) {
            if (!entry.getKey().getPrivLevel().equals((Object)PaloAuth.PrivLevel.TABLE)) continue;
            ldapTblPrivs.put(entry.getKey(), entry.getValue());
        }
        return ldapTblPrivs;
    }

    public static Map<ResourcePattern, PrivBitSet> getLdapAllResourcePrivs(UserIdentity userIdentity) {
        ConcurrentMap ldapResourcePrivs = Maps.newConcurrentMap();
        if (!LdapPrivsChecker.hasLdapPrivs(userIdentity)) {
            return ldapResourcePrivs;
        }
        for (Map.Entry<ResourcePattern, PrivBitSet> entry : ConnectContext.get().getLdapGroupsPrivs().getResourcePatternToPrivs().entrySet()) {
            if (!entry.getKey().getPrivLevel().equals((Object)PaloAuth.PrivLevel.RESOURCE)) continue;
            ldapResourcePrivs.put(entry.getKey(), entry.getValue());
        }
        return ldapResourcePrivs;
    }

    public static void grantDefaultPrivToTempUser(PaloRole role, String clusterName) {
        TablePattern tblPattern = new TablePattern("information_schema", "*");
        try {
            tblPattern.analyze(clusterName);
        }
        catch (AnalysisException e) {
            LOG.warn("should not happen.", (Throwable)e);
        }
        PaloRole newRole = new PaloRole(role.getRoleName(), tblPattern, PrivBitSet.of(PaloPrivilege.SELECT_PRIV));
        role.merge(newRole);
    }
}

