/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.ldap;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.LdapConfig;
import org.apache.doris.common.util.SymmetricEncryption;
import org.apache.doris.persist.LdapInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.AbstractContextMapper;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.pool.factory.PoolingContextSource;
import org.springframework.ldap.pool.validation.DefaultDirContextValidator;
import org.springframework.ldap.pool.validation.DirContextValidator;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.ldap.transaction.compensating.manager.TransactionAwareContextSourceProxy;

public class LdapClient {
    private static final Logger LOG = LogManager.getLogger(LdapClient.class);
    private static volatile ClientInfo clientInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void init() {
        LdapInfo ldapInfo = Catalog.getCurrentCatalog().getAuth().getLdapInfo();
        if (ldapInfo == null || !ldapInfo.isValid()) {
            LOG.error("info is null, maybe no ldap admin password is set.");
            ErrorReport.report(ErrorCode.ERROR_LDAP_CONFIGURATION_ERR, new Object[0]);
            throw new RuntimeException("ldapTemplate is not initialized");
        }
        String ldapPassword = SymmetricEncryption.decrypt(ldapInfo.getLdapPasswdEncrypted(), ldapInfo.getSecretKey(), ldapInfo.getIv());
        if (clientInfo != null && !clientInfo.checkUpdate(ldapPassword)) return;
        Class<LdapClient> clazz = LdapClient.class;
        synchronized (LdapClient.class) {
            if (clientInfo != null && !clientInfo.checkUpdate(ldapPassword)) return;
            clientInfo = new ClientInfo(ldapPassword);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static boolean doesUserExist(String userName) {
        String user = LdapClient.getUserDn(userName);
        if (user == null) {
            LOG.debug("User:{} does not exist in LDAP.", (Object)userName);
            return false;
        }
        return true;
    }

    public static boolean checkPassword(String userName, String password) {
        LdapClient.init();
        try {
            clientInfo.getLdapTemplateNoPool().authenticate(LdapQueryBuilder.query().base(LdapConfig.ldap_user_basedn).filter(LdapClient.getUserFilter(LdapConfig.ldap_user_filter, userName)), password);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static List<String> getGroups(String userName) {
        ArrayList groups = Lists.newArrayList();
        if (LdapConfig.ldap_group_basedn.isEmpty()) {
            return groups;
        }
        String userDn = LdapClient.getUserDn(userName);
        if (userDn == null) {
            return groups;
        }
        List<String> groupDns = LdapClient.getDn((LdapQuery)LdapQueryBuilder.query().base(LdapConfig.ldap_group_basedn).where("member").is(userDn));
        if (groupDns == null) {
            return groups;
        }
        for (String dn : groupDns) {
            String[] strings = dn.split("[,=]", 3);
            if (strings.length <= 2) continue;
            groups.add(strings[1]);
        }
        return groups;
    }

    private static String getUserDn(String userName) {
        List<String> userDns = LdapClient.getDn(LdapQueryBuilder.query().base(LdapConfig.ldap_user_basedn).filter(LdapClient.getUserFilter(LdapConfig.ldap_user_filter, userName)));
        if (userDns == null || userDns.isEmpty()) {
            return null;
        }
        if (userDns.size() > 1) {
            LOG.error("{} not unique in LDAP server:{}", (Object)LdapClient.getUserFilter(LdapConfig.ldap_user_filter, userName), userDns);
            ErrorReport.report(ErrorCode.ERROR_LDAP_USER_NOT_UNIQUE_ERR, userName);
            throw new RuntimeException("User is not unique");
        }
        return userDns.get(0);
    }

    private static List<String> getDn(LdapQuery query) {
        LdapClient.init();
        try {
            return clientInfo.getLdapTemplatePool().search(query, (ContextMapper)new AbstractContextMapper<String>(){

                protected String doMapFromContext(DirContextOperations ctx) {
                    return ctx.getNameInNamespace();
                }
            });
        }
        catch (Exception e) {
            LOG.error("Get user dn fail.", (Throwable)e);
            ErrorReport.report(ErrorCode.ERROR_LDAP_CONFIGURATION_ERR, new Object[0]);
            throw e;
        }
    }

    private static String getUserFilter(String userFilter, String userName) {
        return userFilter.replaceAll("\\{login}", userName);
    }

    private static class ClientInfo {
        private LdapTemplate ldapTemplateNoPool;
        private LdapTemplate ldapTemplatePool;
        private String ldapPassword;

        public ClientInfo(String ldapPassword) {
            this.ldapPassword = ldapPassword;
            this.setLdapTemplateNoPool(ldapPassword);
            this.setLdapTemplatePool(ldapPassword);
        }

        private void setLdapTemplateNoPool(String ldapPassword) {
            LdapContextSource contextSource = new LdapContextSource();
            String url = "ldap://" + LdapConfig.ldap_host + ":" + LdapConfig.ldap_port;
            contextSource.setUrl(url);
            contextSource.setUserDn(LdapConfig.ldap_admin_name);
            contextSource.setPassword(ldapPassword);
            contextSource.afterPropertiesSet();
            this.ldapTemplateNoPool = new LdapTemplate((ContextSource)contextSource);
        }

        private void setLdapTemplatePool(String ldapPassword) {
            LdapContextSource contextSource = new LdapContextSource();
            String url = "ldap://" + LdapConfig.ldap_host + ":" + LdapConfig.ldap_port;
            contextSource.setUrl(url);
            contextSource.setUserDn(LdapConfig.ldap_admin_name);
            contextSource.setPassword(ldapPassword);
            contextSource.setPooled(true);
            contextSource.afterPropertiesSet();
            PoolingContextSource poolingContextSource = new PoolingContextSource();
            poolingContextSource.setDirContextValidator((DirContextValidator)new DefaultDirContextValidator());
            poolingContextSource.setContextSource((ContextSource)contextSource);
            poolingContextSource.setMaxActive(LdapConfig.max_active);
            poolingContextSource.setMaxTotal(LdapConfig.max_total);
            poolingContextSource.setMaxIdle(LdapConfig.max_idle);
            poolingContextSource.setMaxWait((long)LdapConfig.max_wait);
            poolingContextSource.setMinIdle(LdapConfig.min_idle);
            poolingContextSource.setWhenExhaustedAction(LdapConfig.when_exhausted);
            poolingContextSource.setTestOnBorrow(LdapConfig.test_on_borrow);
            poolingContextSource.setTestOnReturn(LdapConfig.test_on_return);
            poolingContextSource.setTestWhileIdle(LdapConfig.test_while_idle);
            TransactionAwareContextSourceProxy proxy = new TransactionAwareContextSourceProxy((ContextSource)poolingContextSource);
            this.ldapTemplatePool = new LdapTemplate((ContextSource)proxy);
        }

        public boolean checkUpdate(String ldapPassword) {
            return this.ldapPassword == null || !this.ldapPassword.equals(ldapPassword);
        }

        public LdapTemplate getLdapTemplateNoPool() {
            return this.ldapTemplateNoPool;
        }

        public LdapTemplate getLdapTemplatePool() {
            return this.ldapTemplatePool;
        }

        public String getLdapPassword() {
            return this.ldapPassword;
        }

        public void setLdapPassword(String ldapPassword) {
            this.ldapPassword = ldapPassword;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClientInfo)) {
                return false;
            }
            ClientInfo other = (ClientInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LdapTemplate this$ldapTemplateNoPool = this.getLdapTemplateNoPool();
            LdapTemplate other$ldapTemplateNoPool = other.getLdapTemplateNoPool();
            if (this$ldapTemplateNoPool == null ? other$ldapTemplateNoPool != null : !this$ldapTemplateNoPool.equals(other$ldapTemplateNoPool)) {
                return false;
            }
            LdapTemplate this$ldapTemplatePool = this.getLdapTemplatePool();
            LdapTemplate other$ldapTemplatePool = other.getLdapTemplatePool();
            if (this$ldapTemplatePool == null ? other$ldapTemplatePool != null : !this$ldapTemplatePool.equals(other$ldapTemplatePool)) {
                return false;
            }
            String this$ldapPassword = this.getLdapPassword();
            String other$ldapPassword = other.getLdapPassword();
            return !(this$ldapPassword == null ? other$ldapPassword != null : !this$ldapPassword.equals(other$ldapPassword));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ClientInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LdapTemplate $ldapTemplateNoPool = this.getLdapTemplateNoPool();
            result = result * 59 + ($ldapTemplateNoPool == null ? 43 : $ldapTemplateNoPool.hashCode());
            LdapTemplate $ldapTemplatePool = this.getLdapTemplatePool();
            result = result * 59 + ($ldapTemplatePool == null ? 43 : $ldapTemplatePool.hashCode());
            String $ldapPassword = this.getLdapPassword();
            result = result * 59 + ($ldapPassword == null ? 43 : $ldapPassword.hashCode());
            return result;
        }

        public String toString() {
            return "LdapClient.ClientInfo(ldapTemplateNoPool=" + this.getLdapTemplateNoPool() + ", ldapTemplatePool=" + this.getLdapTemplatePool() + ", ldapPassword=" + this.getLdapPassword() + ")";
        }
    }
}

