/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.ldap;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.LdapConfig;
import org.apache.doris.ldap.LdapClient;
import org.apache.doris.ldap.LdapPrivsChecker;
import org.apache.doris.mysql.privilege.PaloRole;
import org.apache.doris.qe.ConnectContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LdapAuthenticate {
    private static final Logger LOG = LogManager.getLogger(LdapAuthenticate.class);
    private static final String LDAP_GROUPS_PRIVS_NAME = "ldapGroupsPrivs";
    private static long userMaxConn = 100L;

    public LdapAuthenticate() {
        if (LdapConfig.user_max_connections <= 0L || LdapConfig.user_max_connections > 10000L) {
            LOG.warn("Ldap config user_max_connections is invalid. It should be set between 1 and 10000. And now, it is set to the default value.");
        } else {
            userMaxConn = LdapConfig.user_max_connections;
        }
    }

    public static boolean authenticate(ConnectContext context, String password, String qualifiedUser) {
        PaloRole ldapGroupsPrivs;
        String usePasswd = Strings.isNullOrEmpty((String)password) ? "NO" : "YES";
        String userName = ClusterNamespace.getNameFromFullName(qualifiedUser);
        String clusterName = ClusterNamespace.getClusterNameFromFullName(qualifiedUser);
        LOG.debug("user:{}, cluster:{}", (Object)userName, (Object)clusterName);
        try {
            if (!LdapClient.checkPassword(userName, password)) {
                LOG.debug("user:{} use error LDAP password.", (Object)userName);
                ErrorReport.report(ErrorCode.ERR_ACCESS_DENIED_ERROR, qualifiedUser, context.getRemoteIP(), usePasswd);
                return false;
            }
        }
        catch (Exception e) {
            LOG.error("Check ldap password error.", (Throwable)e);
            return false;
        }
        try {
            ldapGroupsPrivs = LdapAuthenticate.getLdapGroupsPrivs(userName, clusterName);
        }
        catch (Exception e) {
            LOG.error("Get ldap groups error.", (Throwable)e);
            return false;
        }
        String remoteIp = context.getMysqlChannel().getRemoteIp();
        UserIdentity tempUserIdentity = UserIdentity.createAnalyzedUserIdentWithIp(qualifiedUser, remoteIp);
        UserIdentity userIdentity = Catalog.getCurrentCatalog().getAuth().getCurrentUserIdentity(tempUserIdentity);
        if (userIdentity == null) {
            userIdentity = tempUserIdentity;
            LOG.debug("User:{} does not exists in doris, login as temporary users.", (Object)userName);
            context.setIsTempUser(true);
            if (ldapGroupsPrivs == null) {
                ldapGroupsPrivs = new PaloRole(LDAP_GROUPS_PRIVS_NAME);
            }
            LdapPrivsChecker.grantDefaultPrivToTempUser(ldapGroupsPrivs, clusterName);
        }
        context.setCurrentUserIdentity(userIdentity);
        context.setRemoteIP(remoteIp);
        context.setLdapGroupsPrivs(ldapGroupsPrivs);
        LOG.debug("ldap authentication success: identity:{}, privs:{}", (Object)context.getCurrentUserIdentity(), (Object)context.getLdapGroupsPrivs());
        return true;
    }

    private static PaloRole getLdapGroupsPrivs(String userName, String clusterName) {
        List<String> ldapGroups = LdapClient.getGroups(userName);
        ArrayList rolesNames = Lists.newArrayList();
        for (String group : ldapGroups) {
            String qualifiedRole = ClusterNamespace.getFullName(clusterName, group);
            if (!Catalog.getCurrentCatalog().getAuth().doesRoleExist(qualifiedRole)) continue;
            rolesNames.add(qualifiedRole);
        }
        LOG.debug("get user:{} ldap groups:{} and doris roles:{}", (Object)userName, ldapGroups, (Object)rolesNames);
        if (rolesNames.isEmpty()) {
            return null;
        }
        PaloRole ldapGroupsPrivs = new PaloRole(LDAP_GROUPS_PRIVS_NAME);
        Catalog.getCurrentCatalog().getAuth().mergeRolesNoCheckName(rolesNames, ldapGroupsPrivs);
        return ldapGroupsPrivs;
    }

    public static long getMaxConn() {
        return userMaxConn;
    }
}

