/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.journal.local;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.doris.catalog.Database;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.ha.MasterInfo;
import org.apache.doris.journal.JournalCursor;
import org.apache.doris.journal.JournalEntity;
import org.apache.doris.journal.bdbje.Timestamp;
import org.apache.doris.load.DeleteInfo;
import org.apache.doris.load.LoadErrorHub;
import org.apache.doris.load.LoadJob;
import org.apache.doris.persist.BatchDropInfo;
import org.apache.doris.persist.BatchModifyPartitionsInfo;
import org.apache.doris.persist.ConsistencyCheckInfo;
import org.apache.doris.persist.CreateTableInfo;
import org.apache.doris.persist.DatabaseInfo;
import org.apache.doris.persist.DropInfo;
import org.apache.doris.persist.DropPartitionInfo;
import org.apache.doris.persist.EditLogFileInputStream;
import org.apache.doris.persist.ModifyPartitionInfo;
import org.apache.doris.persist.PartitionPersistInfo;
import org.apache.doris.persist.RecoverInfo;
import org.apache.doris.persist.RefreshExternalTableInfo;
import org.apache.doris.persist.ReplicaPersistInfo;
import org.apache.doris.persist.Storage;
import org.apache.doris.persist.TableInfo;
import org.apache.doris.system.Backend;
import org.apache.doris.system.Frontend;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public final class LocalJournalCursor
implements JournalCursor {
    private static final Logger LOG = LogManager.getLogger(LocalJournalCursor.class);
    private String imageDir;
    private long toKey;
    private long currentKey;
    private List<Long> editFileSequenceNumbers;
    private int nextFilePositionIndex;
    private Storage storage;
    private DataInputStream currentStream;

    public static LocalJournalCursor getJournalCursor(String imageDir, long fromKey, long toKey) {
        LocalJournalCursor cursor;
        if (toKey < fromKey && toKey != -1L || fromKey < 0L) {
            System.out.println("Invalid key range!");
            return null;
        }
        long newToKey = toKey;
        if (newToKey == -1L) {
            newToKey = Long.MAX_VALUE;
        }
        try {
            cursor = new LocalJournalCursor(imageDir, fromKey, newToKey);
        }
        catch (IOException e) {
            LOG.error((Object)e);
            return null;
        }
        return cursor;
    }

    private LocalJournalCursor(String imageDir, long fromKey, long toKey) throws IOException {
        long minJournalKey;
        this.imageDir = imageDir;
        this.currentKey = fromKey;
        this.toKey = toKey;
        this.storage = new Storage(imageDir);
        this.editFileSequenceNumbers = this.storage.getEditsFileSequenceNumbers();
        this.nextFilePositionIndex = 0;
        long scannedKey = 0L;
        String fileName = null;
        Iterator<Long> iterator = this.editFileSequenceNumbers.iterator();
        while (iterator.hasNext() && fromKey >= (minJournalKey = iterator.next().longValue())) {
            fileName = Long.toString(minJournalKey);
            ++this.nextFilePositionIndex;
            scannedKey = minJournalKey;
        }
        if (fileName == null) {
            System.out.println("Can not find the key:" + fromKey);
            throw new IOException();
        }
        this.currentStream = new DataInputStream(new BufferedInputStream(new EditLogFileInputStream(new File(imageDir, "edits." + fileName))));
        while (scannedKey < fromKey) {
            short opCode = this.currentStream.readShort();
            if (opCode == -1) {
                System.out.println("Can not find the key:" + fromKey);
                throw new IOException();
            }
            this.getJournalEntity(this.currentStream, opCode);
            ++scannedKey;
        }
    }

    @Override
    public JournalEntity next() {
        if (this.currentKey > this.toKey) {
            return null;
        }
        JournalEntity ret = null;
        try {
            short opCode = -1;
            while (true) {
                try {
                    while ((opCode = (short)this.currentStream.readShort()) == -1) {
                        if (this.nextFilePositionIndex < this.editFileSequenceNumbers.size()) {
                            this.currentStream.close();
                            this.currentStream = new DataInputStream(new BufferedInputStream(new EditLogFileInputStream(new File(this.imageDir, "edits." + this.editFileSequenceNumbers.get(this.nextFilePositionIndex)))));
                            ++this.nextFilePositionIndex;
                            continue;
                        }
                        return null;
                    }
                }
                catch (EOFException e) {
                    if (this.nextFilePositionIndex < this.editFileSequenceNumbers.size()) {
                        this.currentStream.close();
                        this.currentStream = new DataInputStream(new BufferedInputStream(new EditLogFileInputStream(new File(this.imageDir, "edits." + this.editFileSequenceNumbers.get(this.nextFilePositionIndex)))));
                        ++this.nextFilePositionIndex;
                        continue;
                    }
                    return null;
                }
                break;
            }
            ret = this.getJournalEntity(this.currentStream, opCode);
            ++this.currentKey;
            return ret;
        }
        catch (IOException e) {
            LOG.error("something wrong. {}", (Throwable)e);
            try {
                this.currentStream.close();
            }
            catch (IOException e1) {
                LOG.error((Object)e1);
            }
            LOG.error((Object)e);
            return ret;
        }
    }

    @Deprecated
    private JournalEntity getJournalEntity(DataInputStream in, short opCode) throws IOException {
        JournalEntity ret = new JournalEntity();
        ret.setOpCode(opCode);
        switch (opCode) {
            case 0: {
                Text text = new Text();
                text.readFields((DataInput)in);
                ret.setData((Writable)text);
                break;
            }
            case 104: {
                Text text = new Text();
                text.readFields((DataInput)in);
                ret.setData((Writable)text);
                break;
            }
            case 1: {
                Database db = new Database();
                db.readFields(in);
                ret.setData(db);
                break;
            }
            case 2: {
                Text text = new Text();
                text.readFields((DataInput)in);
                ret.setData((Writable)text);
                break;
            }
            case 3: 
            case 6: {
                DatabaseInfo info = new DatabaseInfo();
                info.readFields(in);
                ret.setData(info);
                break;
            }
            case 10: {
                CreateTableInfo info = new CreateTableInfo();
                info.readFields(in);
                ret.setData(info);
                break;
            }
            case 11: {
                DropInfo info = new DropInfo();
                info.readFields(in);
                ret.setData(info);
                break;
            }
            case 280: {
                RefreshExternalTableInfo info = RefreshExternalTableInfo.read(in);
                ret.setData(info);
                break;
            }
            case 12: {
                PartitionPersistInfo info = new PartitionPersistInfo();
                info.readFields(in);
                ret.setData(info);
                break;
            }
            case 13: {
                DropPartitionInfo info = DropPartitionInfo.read(in);
                ret.setData(info);
                break;
            }
            case 14: {
                ModifyPartitionInfo info = ModifyPartitionInfo.read(in);
                ret.setData(info);
                break;
            }
            case 211: {
                BatchModifyPartitionsInfo info = BatchModifyPartitionsInfo.read(in);
                ret.setData(info);
                break;
            }
            case 4: 
            case 15: 
            case 16: {
                Text text = new Text();
                text.readFields((DataInput)in);
                ret.setData((Writable)text);
                break;
            }
            case 5: 
            case 17: 
            case 18: {
                RecoverInfo recoverInfo = new RecoverInfo();
                recoverInfo.readFields(in);
                ret.setData(recoverInfo);
                break;
            }
            case 28: {
                ReplicaPersistInfo info = ReplicaPersistInfo.read(in);
                ret.setData(info);
                break;
            }
            case 24: {
                DropInfo info = DropInfo.read(in);
                ret.setData(info);
                break;
            }
            case 124: {
                BatchDropInfo batchDropInfo = BatchDropInfo.read(in);
                ret.setData(batchDropInfo);
                break;
            }
            case 19: 
            case 110: 
            case 120: {
                TableInfo info = TableInfo.read(in);
                ret.setData(info);
                break;
            }
            case 29: {
                ConsistencyCheckInfo info = ConsistencyCheckInfo.read(in);
                ret.setData(info);
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                LoadJob job = new LoadJob();
                job.readFields(in);
                ret.setData(job);
                break;
            }
            case 41: {
                DeleteInfo info = DeleteInfo.read(in);
                ret.setData(info);
                break;
            }
            case 42: 
            case 43: {
                ReplicaPersistInfo info = ReplicaPersistInfo.read(in);
                ret.setData(info);
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                Backend be = Backend.read(in);
                ret.setData(be);
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                Frontend fe = Frontend.read(in);
                ret.setData(fe);
                break;
            }
            case 58: {
                LoadErrorHub.Param param = new LoadErrorHub.Param();
                param.readFields(in);
                ret.setData(param);
                break;
            }
            case 71: {
                MasterInfo info = new MasterInfo();
                info.readFields(in);
                ret.setData(info);
                break;
            }
            case 70: {
                Timestamp stamp = new Timestamp();
                stamp.readFields(in);
                ret.setData(stamp);
                break;
            }
            case 72: {
                Text text = new Text();
                text.readFields((DataInput)in);
                ret.setData((Writable)text);
                break;
            }
            default: {
                throw new IOException("Never seen opcode " + opCode);
            }
        }
        return ret;
    }

    @Override
    public void close() {
    }
}

