/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.journal.local;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.doris.common.io.Writable;
import org.apache.doris.journal.Journal;
import org.apache.doris.journal.JournalCursor;
import org.apache.doris.journal.JournalEntity;
import org.apache.doris.journal.local.LocalJournalCursor;
import org.apache.doris.persist.EditLogFileOutputStream;
import org.apache.doris.persist.EditLogOutputStream;
import org.apache.doris.persist.Storage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocalJournal
implements Journal {
    private static final Logger LOG = LogManager.getLogger(LocalJournal.class);
    private EditLogOutputStream outputStream = null;
    private AtomicLong journalId = new AtomicLong(1L);
    private String imageDir;
    private File currentEditFile;

    public LocalJournal(String imageDir) {
        this.imageDir = imageDir;
    }

    @Override
    public void open() {
        if (this.outputStream == null) {
            try {
                Storage storage = new Storage(this.imageDir);
                this.journalId.set(this.getCurrentJournalId(storage.getEditsFileSequenceNumbers()));
                long id = this.journalId.get();
                if (id == storage.getEditsSeq()) {
                    this.currentEditFile = storage.getEditsFile(id);
                    this.outputStream = new EditLogFileOutputStream(this.currentEditFile);
                } else {
                    this.currentEditFile = new File(this.imageDir, "edits." + (id + 1L));
                    this.currentEditFile.createNewFile();
                    this.outputStream = new EditLogFileOutputStream(this.currentEditFile);
                }
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
        }
    }

    @Override
    public synchronized void rollJournal() {
        try {
            Storage storage = new Storage(this.imageDir);
            if (this.journalId.get() == storage.getEditsSeq()) {
                System.out.println("Does not need to roll!");
                return;
            }
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            this.currentEditFile = new File(this.imageDir, "edits." + this.journalId.get());
            this.currentEditFile.createNewFile();
            this.outputStream = new EditLogFileOutputStream(this.currentEditFile);
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
    }

    @Override
    public long getMaxJournalId() {
        return 0L;
    }

    @Override
    public long getMinJournalId() {
        return 0L;
    }

    @Override
    public void close() {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.setReadyToFlush();
            this.outputStream.flush();
            this.outputStream.close();
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
    }

    @Override
    public JournalEntity read(long journalId) {
        return null;
    }

    @Override
    public JournalCursor read(long fromKey, long toKey) {
        LocalJournalCursor cursor = LocalJournalCursor.getJournalCursor(this.imageDir, fromKey, toKey);
        return cursor;
    }

    @Override
    public synchronized void write(short op, Writable writable) throws IOException {
        this.outputStream.write(op, writable);
        this.outputStream.setReadyToFlush();
        this.outputStream.flush();
        this.journalId.incrementAndGet();
    }

    @Override
    public void deleteJournals(long deleteJournalToId) {
        try {
            Storage storage = new Storage(this.imageDir);
            List<Long> numbers = storage.getEditsFileSequenceNumbers();
            for (long number : numbers) {
                File file;
                if (number >= deleteJournalToId || !(file = new File(this.imageDir, "edits." + number)).exists()) continue;
                file.delete();
            }
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
    }

    @Override
    public long getFinalizedJournalId() {
        try {
            Storage storage = new Storage(this.imageDir);
            List<Long> numbers = storage.getEditsFileSequenceNumbers();
            int size = numbers.size();
            if (size > 1) {
                return numbers.get(size - 1) - 1L;
            }
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
        return 0L;
    }

    private long getCurrentJournalId(List<Long> editFileNames) {
        if (editFileNames.size() == 0) {
            return 1L;
        }
        long ret = editFileNames.get(editFileNames.size() - 1);
        JournalCursor cursor = this.read(ret, -1L);
        while (cursor.next() != null) {
            ++ret;
        }
        return ret;
    }

    @Override
    public List<Long> getDatabaseNames() {
        throw new RuntimeException("Not Support");
    }
}

