/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.journal.bdbje;

import com.google.common.base.Strings;
import org.apache.doris.common.FeConstants;

public class BDBToolOptions {
    private boolean isListDbs;
    private String dbName;
    private boolean isDbStat;
    private boolean hasFromKey;
    private String fromKey;
    private boolean hasEndKey;
    private String endKey;
    private int metaVersion;

    public BDBToolOptions(boolean isListDbs, String dbName, boolean isDbStat, String fromKey, String endKey, int metaVersion) {
        this.isListDbs = isListDbs;
        this.dbName = dbName;
        this.isDbStat = isDbStat;
        this.fromKey = fromKey;
        this.hasFromKey = !Strings.isNullOrEmpty((String)fromKey);
        this.endKey = endKey;
        this.hasEndKey = !Strings.isNullOrEmpty((String)endKey);
        this.metaVersion = metaVersion == 0 ? FeConstants.meta_version : metaVersion;
    }

    public boolean isListDbs() {
        return this.isListDbs;
    }

    public String getDbName() {
        return this.dbName;
    }

    public boolean isDbStat() {
        return this.isDbStat;
    }

    public boolean hasFromKey() {
        return this.hasFromKey;
    }

    public String getFromKey() {
        return this.fromKey;
    }

    public boolean hasEndKey() {
        return this.hasEndKey;
    }

    public String getEndKey() {
        return this.endKey;
    }

    public int getMetaVersion() {
        return this.metaVersion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("list bdb database: " + this.isListDbs).append("\n");
        sb.append("bdb database name: " + this.dbName).append("\n");
        sb.append("get bdb database stat: " + this.isDbStat).append("\n");
        sb.append("from key" + this.fromKey).append("\n");
        sb.append("end key: " + this.endKey).append("\n");
        sb.append("meta version: " + this.metaVersion).append("\n");
        return sb.toString();
    }
}

