/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.journal.bdbje;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.journal.JournalEntity;
import org.apache.doris.journal.bdbje.BDBToolOptions;
import org.apache.doris.meta.MetaContext;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class BDBTool {
    private String metaPath;
    private BDBToolOptions options;

    public BDBTool(String metaPath, BDBToolOptions options) {
        this.metaPath = metaPath;
        this.options = options;
    }

    public boolean run() {
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setAllowCreate(false);
        envConfig.setReadOnly(true);
        envConfig.setCachePercent(20);
        Environment env = null;
        try {
            env = new Environment(new File(this.metaPath), envConfig);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            System.err.println("Failed to open BDBJE env: " + Catalog.getCurrentCatalog().getBdbDir() + ". exit");
            return false;
        }
        Preconditions.checkNotNull((Object)env);
        try {
            if (this.options.isListDbs()) {
                List dbNames = env.getDatabaseNames();
                System.out.println(JSONArray.toJSONString((List)dbNames));
                return true;
            }
            String dbName = this.options.getDbName();
            Preconditions.checkState((!Strings.isNullOrEmpty((String)dbName) ? 1 : 0) != 0);
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setAllowCreate(false);
            dbConfig.setReadOnly(true);
            Database db = env.openDatabase(null, dbName, dbConfig);
            if (this.options.isDbStat()) {
                HashMap statMap = Maps.newHashMap();
                statMap.put("count", String.valueOf(db.count()));
                System.out.println(JSONObject.toJSONString((Map)statMap));
                return true;
            }
            Long fromKey = 0L;
            String fromKeyStr = this.options.hasFromKey() ? this.options.getFromKey() : dbName;
            try {
                fromKey = Long.valueOf(fromKeyStr);
            }
            catch (NumberFormatException e) {
                System.err.println("Not a valid from key: " + fromKeyStr);
                return false;
            }
            Long endKey = fromKey + db.count() - 1L;
            if (this.options.hasEndKey()) {
                try {
                    endKey = Long.valueOf(this.options.getEndKey());
                }
                catch (NumberFormatException e) {
                    System.err.println("Not a valid end key: " + this.options.getEndKey());
                    return false;
                }
            }
            if (fromKey > endKey) {
                System.err.println("from key should less than or equal to end key[" + fromKey + " vs. " + endKey + "]");
                return false;
            }
            MetaContext metaContext = new MetaContext();
            metaContext.setMetaVersion(this.options.getMetaVersion());
            metaContext.setThreadLocalInfo();
            Long key = fromKey;
            while (key <= endKey) {
                this.getValueByKey(db, key);
                Long l = key;
                Long l2 = key = Long.valueOf(key + 1L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Failed to run bdb tools");
            return false;
        }
        return true;
    }

    private void getValueByKey(Database db, Long key) throws UnsupportedEncodingException {
        DatabaseEntry queryKey = new DatabaseEntry();
        TupleBinding myBinding = TupleBinding.getPrimitiveBinding(Long.class);
        myBinding.objectToEntry((Object)key, queryKey);
        DatabaseEntry value = new DatabaseEntry();
        OperationStatus status = db.get(null, queryKey, value, LockMode.READ_COMMITTED);
        if (status == OperationStatus.SUCCESS) {
            byte[] retData = value.getData();
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(retData));
            JournalEntity entity = new JournalEntity();
            try {
                entity.readFields(in);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Fail to read journal entity for key: " + key + ". reason: " + e.getMessage());
                System.exit(-1);
            }
            System.out.println("key: " + key);
            System.out.println("op code: " + entity.getOpCode());
            System.out.println("value: " + entity.getData().toString());
        } else if (status == OperationStatus.NOTFOUND) {
            System.out.println("key: " + key);
            System.out.println("value: NOT FOUND");
        }
    }
}

