/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.journal.bdbje;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.doris.journal.JournalCursor;
import org.apache.doris.journal.JournalEntity;
import org.apache.doris.journal.bdbje.BDBEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BDBJournalCursor
implements JournalCursor {
    private static final Logger LOG = LogManager.getLogger(BDBJournalCursor.class);
    private long toKey;
    private long currentKey;
    private BDBEnvironment environment;
    private List<Long> dbNames;
    private Database database;
    private int nextDbPositionIndex;
    private final int maxTryTime = 3;

    public static BDBJournalCursor getJournalCursor(BDBEnvironment env, long fromKey, long toKey) {
        if (toKey < fromKey || fromKey < 0L) {
            System.out.println("Invalid key range!");
            return null;
        }
        BDBJournalCursor cursor = null;
        try {
            cursor = new BDBJournalCursor(env, fromKey, toKey);
        }
        catch (Exception e) {
            LOG.error("new BDBJournalCursor error.", (Throwable)e);
        }
        return cursor;
    }

    private BDBJournalCursor(BDBEnvironment env, long fromKey, long toKey) throws Exception {
        long db;
        this.environment = env;
        this.toKey = toKey;
        this.currentKey = fromKey;
        this.dbNames = env.getDatabaseNames();
        if (this.dbNames == null) {
            throw new NullPointerException("dbNames is null.");
        }
        this.nextDbPositionIndex = 0;
        String dbName = null;
        Iterator<Long> iterator = this.dbNames.iterator();
        while (iterator.hasNext() && fromKey >= (db = iterator.next().longValue())) {
            dbName = Long.toString(db);
            ++this.nextDbPositionIndex;
        }
        if (dbName == null) {
            LOG.error("Can not find the key:{}, fail to get journal cursor. will exit.", (Object)fromKey);
            System.exit(-1);
        }
        this.database = env.openDatabase(dbName);
    }

    @Override
    public JournalEntity next() {
        JournalEntity ret = null;
        if (this.currentKey > this.toKey) {
            return ret;
        }
        Long key = this.currentKey;
        DatabaseEntry theKey = new DatabaseEntry();
        TupleBinding myBinding = TupleBinding.getPrimitiveBinding(Long.class);
        myBinding.objectToEntry((Object)key, theKey);
        DatabaseEntry theData = new DatabaseEntry();
        try {
            int tryTimes = 0;
            while (true) {
                OperationStatus operationStatus;
                if ((operationStatus = this.database.get(null, theKey, theData, LockMode.READ_COMMITTED)) == OperationStatus.SUCCESS) {
                    byte[] retData = theData.getData();
                    DataInputStream in = new DataInputStream(new ByteArrayInputStream(retData));
                    ret = new JournalEntity();
                    try {
                        ret.readFields(in);
                    }
                    catch (Exception e) {
                        LOG.error("fail to read journal entity key={}, will exit", (Object)this.currentKey, (Object)e);
                        System.exit(-1);
                    }
                    ++this.currentKey;
                    return ret;
                }
                if (this.nextDbPositionIndex < this.dbNames.size() && this.currentKey == this.dbNames.get(this.nextDbPositionIndex)) {
                    this.database = this.environment.openDatabase(this.dbNames.get(this.nextDbPositionIndex).toString());
                    ++this.nextDbPositionIndex;
                    tryTimes = 0;
                    continue;
                }
                if (tryTimes < 3) {
                    ++tryTimes;
                    LOG.warn("fail to get journal {}, will try again. status: {}", (Object)this.currentKey, (Object)operationStatus);
                    Thread.sleep(3000L);
                    continue;
                }
                if (operationStatus == OperationStatus.NOTFOUND) {
                    throw new Exception("Failed to find key " + this.currentKey + " in database " + this.database.getDatabaseName());
                }
                LOG.error("fail to get journal {}, status: {}, will exit", (Object)this.currentKey, (Object)operationStatus);
                System.exit(-1);
            }
        }
        catch (Exception e) {
            LOG.warn("Catch an exception when get next JournalEntity. key:{}", (Object)this.currentKey, (Object)e);
            return null;
        }
    }

    @Override
    public void close() {
    }
}

