/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.journal.bdbje;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.rep.InsufficientLogException;
import com.sleepycat.je.rep.NetworkRestore;
import com.sleepycat.je.rep.NetworkRestoreConfig;
import com.sleepycat.je.rep.RollbackException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.Pair;
import org.apache.doris.common.io.DataOutputBuffer;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.Util;
import org.apache.doris.journal.Journal;
import org.apache.doris.journal.JournalCursor;
import org.apache.doris.journal.JournalEntity;
import org.apache.doris.journal.bdbje.BDBEnvironment;
import org.apache.doris.journal.bdbje.BDBJournalCursor;
import org.apache.doris.metric.MetricRepo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BDBJEJournal
implements Journal {
    public static final Logger LOG = LogManager.getLogger(BDBJEJournal.class);
    private static final int OUTPUT_BUFFER_INIT_SIZE = 128;
    private static final int RETRY_TIME = 3;
    private String environmentPath = null;
    private String selfNodeName;
    private String selfNodeHostPort;
    private BDBEnvironment bdbEnvironment = null;
    private Database currentJournalDB;
    private AtomicLong nextJournalId = new AtomicLong(1L);

    public BDBJEJournal(String nodeName) {
        this.initBDBEnv(nodeName);
    }

    private void initBDBEnv(String nodeName) {
        this.environmentPath = Catalog.getServingCatalog().getBdbDir();
        Pair<String, Integer> selfNode = Catalog.getServingCatalog().getSelfNode();
        this.selfNodeName = nodeName;
        this.selfNodeHostPort = (String)selfNode.first + ":" + selfNode.second;
    }

    @Override
    public synchronized void rollJournal() {
        String currentDbName;
        long currentName;
        long newNameVerify;
        if (this.currentJournalDB.count() == 0L) {
            return;
        }
        long newName = this.nextJournalId.get();
        if (newName == (newNameVerify = (currentName = Long.parseLong(currentDbName = this.currentJournalDB.getDatabaseName())) + this.currentJournalDB.count())) {
            LOG.info("roll edit log. new db name is {}", (Object)newName);
            this.currentJournalDB = this.bdbEnvironment.openDatabase(Long.toString(newName));
        } else {
            String msg = String.format("roll journal error! journalId and db journal numbers is not match. journal id: %d, current db: %s, expected db count: %d", newName, currentDbName, newNameVerify);
            LOG.error(msg);
            Util.stdoutWithTime(msg);
            System.exit(-1);
        }
    }

    @Override
    public synchronized void write(short op, Writable writable) throws IOException {
        JournalEntity entity = new JournalEntity();
        entity.setOpCode(op);
        entity.setData(writable);
        long id = this.nextJournalId.getAndIncrement();
        Long idLong = id;
        DatabaseEntry theKey = new DatabaseEntry();
        TupleBinding idBinding = TupleBinding.getPrimitiveBinding(Long.class);
        idBinding.objectToEntry((Object)idLong, theKey);
        DataOutputBuffer buffer = new DataOutputBuffer(128);
        entity.write((DataOutput)buffer);
        DatabaseEntry theData = new DatabaseEntry(buffer.getData());
        if (MetricRepo.isInit) {
            MetricRepo.COUNTER_EDIT_LOG_SIZE_BYTES.increase(Long.valueOf(theData.getSize()));
        }
        LOG.debug("opCode = {}, journal size = {}", (Object)op, (Object)theData.getSize());
        boolean writeSucceed = false;
        for (int i = 0; i < 3; ++i) {
            try {
                if (this.currentJournalDB.put(null, theKey, theData) != OperationStatus.SUCCESS) continue;
                writeSucceed = true;
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("master write journal {} finished. db name {}, current time {}", (Object)id, (Object)this.currentJournalDB.getDatabaseName(), (Object)System.currentTimeMillis());
                break;
            }
            catch (DatabaseException e) {
                LOG.error("catch an exception when writing to database. sleep and retry. journal id {}", (Object)id, (Object)e);
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        }
        if (!writeSucceed) {
            if (op == 70) {
                this.nextJournalId.set(id);
                LOG.warn("master can not achieve quorum. write timestamp fail. but will not exit.");
                return;
            }
            String msg = "write bdb failed. will exit. journalId: " + id + ", bdb database Name: " + this.currentJournalDB.getDatabaseName();
            LOG.error(msg);
            Util.stdoutWithTime(msg);
            System.exit(-1);
        }
    }

    @Override
    public JournalEntity read(long journalId) {
        long db;
        List<Long> dbNames = this.getDatabaseNames();
        if (dbNames == null) {
            return null;
        }
        String dbName = null;
        Iterator<Long> iterator = dbNames.iterator();
        while (iterator.hasNext() && journalId >= (db = iterator.next().longValue())) {
            dbName = Long.toString(db);
        }
        if (dbName == null) {
            return null;
        }
        JournalEntity ret = null;
        Long key = new Long(journalId);
        DatabaseEntry theKey = new DatabaseEntry();
        TupleBinding myBinding = TupleBinding.getPrimitiveBinding(Long.class);
        myBinding.objectToEntry((Object)key, theKey);
        DatabaseEntry theData = new DatabaseEntry();
        Database database = this.bdbEnvironment.openDatabase(dbName);
        try {
            if (database.get(null, theKey, theData, LockMode.READ_COMMITTED) == OperationStatus.SUCCESS) {
                byte[] retData = theData.getData();
                DataInputStream in = new DataInputStream(new ByteArrayInputStream(retData));
                ret = new JournalEntity();
                try {
                    ret.readFields(in);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println("No record found for key '" + journalId + "'.");
            }
        }
        catch (Exception e) {
            LOG.warn("catch an exception when get JournalEntity. key:{}", (Object)journalId, (Object)e);
            return null;
        }
        return ret;
    }

    @Override
    public JournalCursor read(long fromKey, long toKey) {
        return BDBJournalCursor.getJournalCursor(this.bdbEnvironment, fromKey, toKey);
    }

    @Override
    public long getMaxJournalId() {
        long ret = -1L;
        if (this.bdbEnvironment == null) {
            return ret;
        }
        List<Long> dbNames = this.getDatabaseNames();
        if (dbNames == null) {
            return ret;
        }
        if (dbNames.size() == 0) {
            return ret;
        }
        int index = dbNames.size() - 1;
        String dbName = dbNames.get(index).toString();
        long dbNumberName = dbNames.get(index);
        Database database = this.bdbEnvironment.openDatabase(dbName);
        ret = dbNumberName + database.count() - 1L;
        return ret;
    }

    @Override
    public long getMinJournalId() {
        long ret = -1L;
        if (this.bdbEnvironment == null) {
            return ret;
        }
        List<Long> dbNames = this.getDatabaseNames();
        if (dbNames == null) {
            return ret;
        }
        if (dbNames.size() == 0) {
            return ret;
        }
        String dbName = dbNames.get(0).toString();
        Database database = this.bdbEnvironment.openDatabase(dbName);
        if (database.count() == 0L) {
            return ret;
        }
        return dbNames.get(0);
    }

    @Override
    public void close() {
        this.bdbEnvironment.close();
        this.bdbEnvironment = null;
    }

    @Override
    public synchronized void open() {
        if (this.bdbEnvironment == null) {
            File dbEnv = new File(this.environmentPath);
            this.bdbEnvironment = new BDBEnvironment();
            Pair<String, Integer> helperNode = Catalog.getServingCatalog().getHelperNode();
            String helperHostPort = (String)helperNode.first + ":" + helperNode.second;
            try {
                this.bdbEnvironment.setup(dbEnv, this.selfNodeName, this.selfNodeHostPort, helperHostPort, Catalog.getServingCatalog().isElectable());
            }
            catch (Exception e) {
                LOG.error("catch an exception when setup bdb environment. will exit.", (Throwable)e);
                System.exit(-1);
            }
        }
        List<Long> dbNames = null;
        for (int i = 0; i < 3; ++i) {
            try {
                dbNames = this.getDatabaseNames();
                if (dbNames == null) {
                    LOG.error("fail to get dbNames while open bdbje journal. will exit");
                    System.exit(-1);
                }
                if (dbNames.size() == 0) {
                    String dbName = Long.toString(Catalog.getServingCatalog().getReplayedJournalId() + 1L);
                    LOG.info("the very first time to open bdb, dbname is {}", (Object)dbName);
                    this.currentJournalDB = this.bdbEnvironment.openDatabase(dbName);
                } else {
                    this.currentJournalDB = this.bdbEnvironment.openDatabase(dbNames.get(dbNames.size() - 1).toString());
                }
                this.nextJournalId.set(this.getMaxJournalId() + 1L);
                break;
            }
            catch (InsufficientLogException insufficientLogEx) {
                this.reSetupBdbEnvironment(insufficientLogEx);
                continue;
            }
        }
    }

    private void reSetupBdbEnvironment(InsufficientLogException insufficientLogEx) {
        LOG.warn("catch insufficient log exception. will recover and try again.", (Throwable)insufficientLogEx);
        Pair<String, Integer> helperNode = Catalog.getServingCatalog().getHelperNode();
        NetworkRestore restore = new NetworkRestore();
        NetworkRestoreConfig config = new NetworkRestoreConfig();
        config.setRetainLogFiles(false);
        restore.execute(insufficientLogEx, config);
        this.bdbEnvironment.close();
        this.bdbEnvironment.setup(new File(this.environmentPath), this.selfNodeName, this.selfNodeHostPort, (String)helperNode.first + ":" + helperNode.second, Catalog.getServingCatalog().isElectable());
    }

    @Override
    public void deleteJournals(long deleteToJournalId) {
        List<Long> dbNames = this.getDatabaseNames();
        if (dbNames == null) {
            LOG.info("delete database names is null.");
            return;
        }
        String msg = "existing database names: ";
        for (long name : dbNames) {
            msg = msg + name + " ";
        }
        msg = msg + ", deleteToJournalId is " + deleteToJournalId;
        LOG.info(msg);
        for (int i = 1; i < dbNames.size(); ++i) {
            long name;
            if (deleteToJournalId < dbNames.get(i)) {
                LOG.info("database name {} is larger than deleteToJournalId {}, not delete", (Object)dbNames.get(i), (Object)deleteToJournalId);
                break;
            }
            name = dbNames.get(i - 1);
            String stringName = Long.toString(name);
            LOG.info("delete database name {}", (Object)stringName);
            this.bdbEnvironment.removeDatabase(stringName);
        }
    }

    @Override
    public long getFinalizedJournalId() {
        List<Long> dbNames = this.getDatabaseNames();
        if (dbNames == null) {
            LOG.error("database name is null.");
            return 0L;
        }
        String msg = "database names: ";
        for (long name : dbNames) {
            msg = msg + name + " ";
        }
        LOG.info(msg);
        if (dbNames.size() < 2) {
            return 0L;
        }
        return dbNames.get(dbNames.size() - 1) - 1L;
    }

    @Override
    public List<Long> getDatabaseNames() {
        if (this.bdbEnvironment == null) {
            return null;
        }
        List<Long> dbNames = null;
        for (int i = 0; i < 3; ++i) {
            try {
                dbNames = this.bdbEnvironment.getDatabaseNames();
                break;
            }
            catch (InsufficientLogException insufficientLogEx) {
                if (!Catalog.isCheckpointThread()) {
                    this.reSetupBdbEnvironment(insufficientLogEx);
                    continue;
                }
                throw insufficientLogEx;
            }
            catch (RollbackException rollbackEx) {
                if (!Catalog.isCheckpointThread()) {
                    LOG.warn("catch rollback log exception. will reopen the ReplicatedEnvironment.", (Throwable)rollbackEx);
                    this.bdbEnvironment.closeReplicatedEnvironment();
                    this.bdbEnvironment.openReplicatedEnvironment(new File(this.environmentPath));
                    continue;
                }
                throw rollbackEx;
            }
        }
        return dbNames;
    }
}

