/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.journal.bdbje;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.rep.InsufficientLogException;
import com.sleepycat.je.rep.NetworkRestore;
import com.sleepycat.je.rep.NetworkRestoreConfig;
import com.sleepycat.je.rep.NoConsistencyRequiredPolicy;
import com.sleepycat.je.rep.NodeType;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.ReplicationConfig;
import com.sleepycat.je.rep.RollbackException;
import com.sleepycat.je.rep.StateChangeListener;
import com.sleepycat.je.rep.util.DbResetRepGroup;
import com.sleepycat.je.rep.util.ReplicationGroupAdmin;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.StringUtils;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.Config;
import org.apache.doris.ha.BDBHA;
import org.apache.doris.ha.BDBStateChangeListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BDBEnvironment {
    private static final Logger LOG = LogManager.getLogger(BDBEnvironment.class);
    private static final int RETRY_TIME = 3;
    private static final int MEMORY_CACHE_PERCENT = 20;
    public static final String PALO_JOURNAL_GROUP = "PALO_JOURNAL_GROUP";
    private ReplicatedEnvironment replicatedEnvironment;
    private EnvironmentConfig environmentConfig;
    private ReplicationConfig replicationConfig;
    private DatabaseConfig dbConfig;
    private Database epochDB = null;
    private ReplicationGroupAdmin replicationGroupAdmin = null;
    private ReentrantReadWriteLock lock;
    private List<Database> openedDatabases = new ArrayList<Database>();

    public BDBEnvironment() {
        this.lock = new ReentrantReadWriteLock(true);
    }

    public void setup(File envHome, String selfNodeName, String selfNodeHostPort, String helperHostPort, boolean isElectable) {
        if (Config.metadata_failure_recovery.equals("true")) {
            if (!isElectable) {
                LOG.error("Current node is not in the electable_nodes list. will exit");
                System.exit(-1);
            }
            DbResetRepGroup resetUtility = new DbResetRepGroup(envHome, PALO_JOURNAL_GROUP, selfNodeName, selfNodeHostPort);
            resetUtility.reset();
            LOG.info("group has been reset.");
        }
        this.replicationConfig = new ReplicationConfig();
        this.replicationConfig.setNodeName(selfNodeName);
        this.replicationConfig.setNodeHostPort(selfNodeHostPort);
        this.replicationConfig.setHelperHosts(helperHostPort);
        this.replicationConfig.setGroupName(PALO_JOURNAL_GROUP);
        this.replicationConfig.setConfigParam("je.rep.envUnknownStateTimeout", "10");
        this.replicationConfig.setMaxClockDelta(Config.max_bdbje_clock_delta_ms, TimeUnit.MILLISECONDS);
        this.replicationConfig.setConfigParam("je.rep.txnRollbackLimit", String.valueOf(Config.txn_rollback_limit));
        this.replicationConfig.setConfigParam("je.rep.replicaTimeout", Config.bdbje_heartbeat_timeout_second + " s");
        this.replicationConfig.setConfigParam("je.rep.feederTimeout", Config.bdbje_heartbeat_timeout_second + " s");
        if (isElectable) {
            this.replicationConfig.setReplicaAckTimeout((long)Config.bdbje_replica_ack_timeout_second, TimeUnit.SECONDS);
            this.replicationConfig.setConfigParam("je.rep.replicaMaxGroupCommit", "0");
            this.replicationConfig.setConsistencyPolicy((ReplicaConsistencyPolicy)new NoConsistencyRequiredPolicy());
        } else {
            this.replicationConfig.setNodeType(NodeType.SECONDARY);
            this.replicationConfig.setConsistencyPolicy((ReplicaConsistencyPolicy)new NoConsistencyRequiredPolicy());
        }
        this.environmentConfig = new EnvironmentConfig();
        this.environmentConfig.setTransactional(true);
        this.environmentConfig.setAllowCreate(true);
        this.environmentConfig.setCachePercent(20);
        this.environmentConfig.setLockTimeout((long)Config.bdbje_lock_timeout_second, TimeUnit.SECONDS);
        if (isElectable) {
            Durability durability = new Durability(this.getSyncPolicy(Config.master_sync_policy), this.getSyncPolicy(Config.replica_sync_policy), this.getAckPolicy(Config.replica_ack_policy));
            this.environmentConfig.setDurability(durability);
        }
        this.dbConfig = new DatabaseConfig();
        this.dbConfig.setTransactional(true);
        if (isElectable) {
            this.dbConfig.setAllowCreate(true);
            this.dbConfig.setReadOnly(false);
        } else {
            this.dbConfig.setAllowCreate(false);
            this.dbConfig.setReadOnly(true);
        }
        for (int i = 0; i < 3; ++i) {
            try {
                this.replicatedEnvironment = new ReplicatedEnvironment(envHome, this.replicationConfig, this.environmentConfig);
                HashSet<InetSocketAddress> adminNodes = new HashSet<InetSocketAddress>();
                InetSocketAddress helper = new InetSocketAddress(helperHostPort.split(":")[0], Integer.parseInt(helperHostPort.split(":")[1]));
                adminNodes.add(helper);
                LOG.info("add helper[{}] as ReplicationGroupAdmin", (Object)helperHostPort);
                if (!selfNodeHostPort.equals(helperHostPort) && Catalog.getCurrentCatalog().isElectable()) {
                    InetSocketAddress self = new InetSocketAddress(selfNodeHostPort.split(":")[0], Integer.parseInt(selfNodeHostPort.split(":")[1]));
                    adminNodes.add(self);
                    LOG.info("add self[{}] as ReplicationGroupAdmin", (Object)selfNodeHostPort);
                }
                this.replicationGroupAdmin = new ReplicationGroupAdmin(PALO_JOURNAL_GROUP, adminNodes);
                BDBHA protocol = new BDBHA(this, selfNodeName);
                Catalog.getCurrentCatalog().setHaProtocol(protocol);
                BDBStateChangeListener listener = new BDBStateChangeListener();
                this.replicatedEnvironment.setStateChangeListener((StateChangeListener)listener);
                this.epochDB = this.replicatedEnvironment.openDatabase(null, "epochDB", this.dbConfig);
                break;
            }
            catch (InsufficientLogException insufficientLogEx) {
                NetworkRestore restore = new NetworkRestore();
                NetworkRestoreConfig config = new NetworkRestoreConfig();
                config.setRetainLogFiles(false);
                restore.execute(insufficientLogEx, config);
                continue;
            }
            catch (DatabaseException e) {
                if (i < 2) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                LOG.error("error to open replicated environment. will exit.", (Throwable)e);
                System.exit(-1);
            }
        }
    }

    public ReplicationGroupAdmin getReplicationGroupAdmin() {
        return this.replicationGroupAdmin;
    }

    public void setNewReplicationGroupAdmin(Set<InetSocketAddress> newHelperNodes) {
        this.replicationGroupAdmin = new ReplicationGroupAdmin(PALO_JOURNAL_GROUP, newHelperNodes);
    }

    public Database getEpochDB() {
        return this.epochDB;
    }

    public ReplicatedEnvironment getReplicatedEnvironment() {
        return this.replicatedEnvironment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database openDatabase(String dbName) {
        Database db = null;
        this.lock.writeLock().lock();
        try {
            Iterator<Database> iter = this.openedDatabases.iterator();
            while (iter.hasNext()) {
                Database openedDb;
                block10: {
                    openedDb = iter.next();
                    try {
                        if (openedDb.getDatabaseName() == null) {
                            openedDb.close();
                            iter.remove();
                        }
                        break block10;
                    }
                    catch (Exception e) {
                        LOG.warn("get exception when try to close previously opened bdb database. ignore it", (Throwable)e);
                        iter.remove();
                    }
                    continue;
                }
                if (!openedDb.getDatabaseName().equals(dbName)) continue;
                Database database = openedDb;
                return database;
            }
            try {
                db = this.replicatedEnvironment.openDatabase(null, dbName, this.dbConfig);
                this.openedDatabases.add(db);
            }
            catch (Exception e) {
                LOG.warn("catch an exception when open database {}", (Object)dbName, (Object)e);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDatabase(String dbName) {
        this.lock.writeLock().lock();
        try {
            String targetDbName = null;
            int index = 0;
            for (Database db : this.openedDatabases) {
                String name = db.getDatabaseName();
                if (dbName.equals(name)) {
                    db.close();
                    LOG.info("database {} has been closed", (Object)name);
                    targetDbName = name;
                    break;
                }
                ++index;
            }
            if (targetDbName != null) {
                LOG.info("begin to remove database {} from openedDatabases", targetDbName);
                this.openedDatabases.remove(index);
            }
            try {
                LOG.info("begin to remove database {} from replicatedEnvironment", (Object)dbName);
                this.replicatedEnvironment.removeDatabase(null, dbName);
            }
            catch (DatabaseNotFoundException e) {
                LOG.warn("catch an exception when remove db:{}, this db does not exist", (Object)dbName, (Object)e);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public List<Long> getDatabaseNames() {
        ArrayList<Long> ret = new ArrayList<Long>();
        List names = null;
        int tried = 0;
        while (true) {
            try {
                names = this.replicatedEnvironment.getDatabaseNames();
            }
            catch (InsufficientLogException e) {
                throw e;
            }
            catch (RollbackException e) {
                throw e;
            }
            catch (EnvironmentFailureException e) {
                if (++tried == 3) {
                    LOG.error("bdb environment failure exception.", (Throwable)e);
                    System.exit(-1);
                }
                LOG.warn("bdb environment failure exception. will retry", (Throwable)e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                continue;
            }
            catch (DatabaseException e) {
                LOG.warn("catch an exception when calling getDatabaseNames", (Throwable)e);
                return null;
            }
            break;
        }
        if (names != null) {
            for (String name : names) {
                if (!StringUtils.isNumeric((String)name)) continue;
                ret.add(Long.parseLong(name));
            }
        }
        Collections.sort(ret);
        return ret;
    }

    public void close() {
        for (Database db : this.openedDatabases) {
            try {
                db.close();
            }
            catch (DatabaseException exception) {
                LOG.error("Error closing db {} will exit", (Object)db.getDatabaseName(), (Object)exception);
                System.exit(-1);
            }
        }
        this.openedDatabases.clear();
        if (this.epochDB != null) {
            try {
                this.epochDB.close();
            }
            catch (DatabaseException exception) {
                LOG.error("Error closing db {} will exit", (Object)this.epochDB.getDatabaseName(), (Object)exception);
                System.exit(-1);
            }
        }
        if (this.replicatedEnvironment != null) {
            try {
                this.replicatedEnvironment.close();
            }
            catch (DatabaseException exception) {
                LOG.error("Error closing replicatedEnvironment", (Throwable)exception);
                System.exit(-1);
            }
        }
    }

    public void closeReplicatedEnvironment() {
        if (this.replicatedEnvironment != null) {
            try {
                this.replicatedEnvironment.close();
            }
            catch (DatabaseException exception) {
                LOG.error("Error closing replicatedEnvironment", (Throwable)exception);
                System.exit(-1);
            }
        }
    }

    public void openReplicatedEnvironment(File envHome) {
        for (int i = 0; i < 3; ++i) {
            try {
                this.replicatedEnvironment = new ReplicatedEnvironment(envHome, this.replicationConfig, this.environmentConfig);
                break;
            }
            catch (DatabaseException e) {
                if (i < 2) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                LOG.error("error to open replicated environment. will exit.", (Throwable)e);
                System.exit(-1);
                continue;
            }
        }
    }

    private Durability.SyncPolicy getSyncPolicy(String policy) {
        if (policy.equalsIgnoreCase("SYNC")) {
            return Durability.SyncPolicy.SYNC;
        }
        if (policy.equalsIgnoreCase("NO_SYNC")) {
            return Durability.SyncPolicy.NO_SYNC;
        }
        return Durability.SyncPolicy.WRITE_NO_SYNC;
    }

    private Durability.ReplicaAckPolicy getAckPolicy(String policy) {
        if (policy.equalsIgnoreCase("ALL")) {
            return Durability.ReplicaAckPolicy.ALL;
        }
        if (policy.equalsIgnoreCase("NONE")) {
            return Durability.ReplicaAckPolicy.NONE;
        }
        return Durability.ReplicaAckPolicy.SIMPLE_MAJORITY;
    }
}

