/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.journal.bdbje;

import com.clearspring.analytics.util.Lists;
import com.google.common.base.Preconditions;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.doris.common.Config;
import org.apache.doris.common.ThreadPoolManager;
import org.apache.doris.httpv2.HttpServer;
import org.apache.doris.httpv2.IllegalArgException;
import org.apache.doris.journal.JournalEntity;
import org.apache.doris.meta.MetaContext;
import org.apache.doris.qe.QeService;
import org.apache.doris.service.ExecuteEnv;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BDBDebugger {
    private static final Logger LOG = LogManager.getLogger(BDBDebugger.class);
    private BDBDebugEnv debugEnv;

    public static BDBDebugger get() {
        return SingletonHolder.INSTANCE;
    }

    public void startDebugMode(String dorisHomeDir) {
        try {
            this.initDebugEnv();
            this.startService(dorisHomeDir);
            while (true) {
                Thread.sleep(2000L);
            }
        }
        catch (Throwable t) {
            LOG.warn("BDB debug mode exception", t);
            System.exit(-1);
            return;
        }
    }

    private void startService(String dorisHomeDir) throws IllegalArgException, IOException {
        HttpServer httpServer = new HttpServer();
        httpServer.setPort(Config.http_port);
        httpServer.start(dorisHomeDir);
        QeService qeService = new QeService(Config.query_port, Config.mysql_service_nio_enabled, ExecuteEnv.getInstance().getScheduler());
        qeService.start();
        ThreadPoolManager.registerAllThreadPoolMetric();
    }

    private void initDebugEnv() throws BDBDebugException {
        this.debugEnv = new BDBDebugEnv(Config.meta_dir + "/bdb/");
        this.debugEnv.init();
    }

    public BDBDebugEnv getEnv() {
        return this.debugEnv;
    }

    public static class BDBDebugException
    extends Exception {
        public BDBDebugException(String msg) {
            super(msg);
        }

        public BDBDebugException(String msg, Throwable t) {
            super(msg, t);
        }
    }

    public static class JournalEntityWrapper {
        public Long journalId;
        public JournalEntity entity;
        public String errMsg;

        public JournalEntityWrapper(long journalId) {
            this.journalId = journalId;
        }
    }

    public static class BDBDebugEnv {
        private String metaPath;
        private Environment env;

        public BDBDebugEnv(String metaPath) {
            this.metaPath = metaPath;
        }

        public void init() throws BDBDebugException {
            EnvironmentConfig envConfig = new EnvironmentConfig();
            envConfig.setAllowCreate(false);
            envConfig.setReadOnly(true);
            envConfig.setCachePercent(20);
            try {
                this.env = new Environment(new File(this.metaPath), envConfig);
            }
            catch (DatabaseException e) {
                throw new BDBDebugException("failed to init bdb env", e);
            }
            Preconditions.checkNotNull((Object)this.env);
        }

        public List<String> listDbNames() {
            return this.env.getDatabaseNames();
        }

        public Long getJournalNumber(String dbName) {
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setAllowCreate(false);
            dbConfig.setReadOnly(true);
            Database db = this.env.openDatabase(null, dbName, dbConfig);
            return db.count();
        }

        public List<Long> getJournalIds(String dbName) throws BDBDebugException {
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setAllowCreate(false);
            dbConfig.setReadOnly(true);
            Database db = this.env.openDatabase(null, dbName, dbConfig);
            List journalIds = Lists.newArrayList();
            Cursor cursor = db.openCursor(null, null);
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry value = new DatabaseEntry();
            TupleBinding idBinding = TupleBinding.getPrimitiveBinding(Long.class);
            try {
                OperationStatus status;
                while ((status = cursor.getNext(key, value, null)) != OperationStatus.NOTFOUND) {
                    Long id = (Long)idBinding.entryToObject(key);
                    journalIds.add(id);
                }
            }
            catch (Exception e) {
                LOG.warn("failed to get journal ids of {}", (Object)dbName, (Object)e);
                throw new BDBDebugException("failed to get journal ids of database " + dbName, e);
            }
            return journalIds;
        }

        public JournalEntityWrapper getJournalEntity(String dbName, Long journalId) {
            MetaContext metaContext = new MetaContext();
            metaContext.setMetaVersion(107);
            metaContext.setThreadLocalInfo();
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setAllowCreate(false);
            dbConfig.setReadOnly(true);
            Database db = this.env.openDatabase(null, dbName, dbConfig);
            JournalEntityWrapper entityWrapper = new JournalEntityWrapper(journalId);
            DatabaseEntry key = new DatabaseEntry();
            TupleBinding myBinding = TupleBinding.getPrimitiveBinding(Long.class);
            myBinding.objectToEntry((Object)journalId, key);
            DatabaseEntry value = new DatabaseEntry();
            OperationStatus status = db.get(null, key, value, LockMode.READ_COMMITTED);
            if (status == OperationStatus.SUCCESS) {
                byte[] retData = value.getData();
                DataInputStream in = new DataInputStream(new ByteArrayInputStream(retData));
                JournalEntity entity = new JournalEntity();
                try {
                    entity.readFields(in);
                    entityWrapper.entity = entity;
                }
                catch (Exception e) {
                    LOG.warn("failed to read entity", (Throwable)e);
                    entityWrapper.errMsg = e.getMessage();
                }
            } else if (status == OperationStatus.NOTFOUND) {
                entityWrapper.errMsg = "Key not found";
            }
            MetaContext.remove();
            return entityWrapper;
        }
    }

    private static class SingletonHolder {
        private static final BDBDebugger INSTANCE = new BDBDebugger();

        private SingletonHolder() {
        }
    }
}

