/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.journal;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.alter.AlterJobV2;
import org.apache.doris.alter.BatchAlterJobPersistInfo;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.backup.BackupJob;
import org.apache.doris.backup.Repository;
import org.apache.doris.backup.RestoreJob;
import org.apache.doris.blockrule.SqlBlockRule;
import org.apache.doris.catalog.BrokerMgr;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.EncryptKey;
import org.apache.doris.catalog.EncryptKeySearchDesc;
import org.apache.doris.catalog.Function;
import org.apache.doris.catalog.FunctionSearchDesc;
import org.apache.doris.catalog.Resource;
import org.apache.doris.cluster.BaseParam;
import org.apache.doris.cluster.Cluster;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.SmallFileMgr;
import org.apache.doris.ha.MasterInfo;
import org.apache.doris.journal.bdbje.Timestamp;
import org.apache.doris.load.DeleteInfo;
import org.apache.doris.load.ExportJob;
import org.apache.doris.load.LoadErrorHub;
import org.apache.doris.load.LoadJob;
import org.apache.doris.load.StreamLoadRecordMgr;
import org.apache.doris.load.loadv2.LoadJob;
import org.apache.doris.load.loadv2.LoadJobFinalOperation;
import org.apache.doris.load.routineload.RoutineLoadJob;
import org.apache.doris.load.sync.SyncJob;
import org.apache.doris.mysql.privilege.UserPropertyInfo;
import org.apache.doris.persist.AlterRoutineLoadJobOperationLog;
import org.apache.doris.persist.AlterViewInfo;
import org.apache.doris.persist.BackendIdsUpdateInfo;
import org.apache.doris.persist.BackendReplicasInfo;
import org.apache.doris.persist.BackendTabletsInfo;
import org.apache.doris.persist.BatchDropInfo;
import org.apache.doris.persist.BatchModifyPartitionsInfo;
import org.apache.doris.persist.BatchRemoveTransactionsOperation;
import org.apache.doris.persist.ClusterInfo;
import org.apache.doris.persist.ColocatePersistInfo;
import org.apache.doris.persist.ConsistencyCheckInfo;
import org.apache.doris.persist.CreateTableInfo;
import org.apache.doris.persist.DatabaseInfo;
import org.apache.doris.persist.DropDbInfo;
import org.apache.doris.persist.DropInfo;
import org.apache.doris.persist.DropLinkDbAndUpdateDbInfo;
import org.apache.doris.persist.DropPartitionInfo;
import org.apache.doris.persist.DropResourceOperationLog;
import org.apache.doris.persist.DropSqlBlockRuleOperationLog;
import org.apache.doris.persist.GlobalVarPersistInfo;
import org.apache.doris.persist.HbPackage;
import org.apache.doris.persist.LdapInfo;
import org.apache.doris.persist.ModifyCommentOperationLog;
import org.apache.doris.persist.ModifyPartitionInfo;
import org.apache.doris.persist.ModifyTableDefaultDistributionBucketNumOperationLog;
import org.apache.doris.persist.ModifyTableEngineOperationLog;
import org.apache.doris.persist.ModifyTablePropertyOperationLog;
import org.apache.doris.persist.PartitionPersistInfo;
import org.apache.doris.persist.PrivInfo;
import org.apache.doris.persist.RecoverInfo;
import org.apache.doris.persist.RefreshExternalTableInfo;
import org.apache.doris.persist.RemoveAlterJobV2OperationLog;
import org.apache.doris.persist.ReplacePartitionOperationLog;
import org.apache.doris.persist.ReplaceTableOperationLog;
import org.apache.doris.persist.ReplicaPersistInfo;
import org.apache.doris.persist.RoutineLoadOperation;
import org.apache.doris.persist.SetReplicaStatusOperationLog;
import org.apache.doris.persist.TableInfo;
import org.apache.doris.persist.TablePropertyInfo;
import org.apache.doris.persist.TruncateTableInfo;
import org.apache.doris.plugin.PluginInfo;
import org.apache.doris.system.Backend;
import org.apache.doris.system.Frontend;
import org.apache.doris.transaction.TransactionState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JournalEntity
implements Writable {
    public static final Logger LOG = LogManager.getLogger(JournalEntity.class);
    private short opCode;
    private Writable data;

    public short getOpCode() {
        return this.opCode;
    }

    public void setOpCode(short opCode) {
        this.opCode = opCode;
    }

    public Writable getData() {
        return this.data;
    }

    public void setData(Writable data) {
        this.data = data;
    }

    public String toString() {
        return " opCode=" + this.opCode + " " + this.data;
    }

    public void write(DataOutput out) throws IOException {
        out.writeShort(this.opCode);
        this.data.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.opCode = in.readShort();
        boolean isRead = false;
        LOG.debug("get opcode: {}", (Object)this.opCode);
        switch (this.opCode) {
            case 0: {
                this.data = new Text();
                ((Text)this.data).readFields(in);
                isRead = true;
                break;
            }
            case 104: {
                this.data = new Text();
                ((Text)this.data).readFields(in);
                isRead = true;
                break;
            }
            case 1: {
                this.data = Database.read(in);
                isRead = true;
                break;
            }
            case 2: {
                this.data = DropDbInfo.read(in);
                isRead = true;
                break;
            }
            case 3: 
            case 6: {
                this.data = new DatabaseInfo();
                ((DatabaseInfo)this.data).readFields(in);
                isRead = true;
                break;
            }
            case 10: {
                this.data = new CreateTableInfo();
                ((CreateTableInfo)this.data).readFields(in);
                isRead = true;
                break;
            }
            case 11: {
                this.data = new DropInfo();
                ((DropInfo)this.data).readFields(in);
                isRead = true;
                break;
            }
            case 280: {
                this.data = RefreshExternalTableInfo.read(in);
                isRead = true;
                break;
            }
            case 12: {
                this.data = new PartitionPersistInfo();
                ((PartitionPersistInfo)this.data).readFields(in);
                isRead = true;
                break;
            }
            case 13: {
                this.data = DropPartitionInfo.read(in);
                isRead = true;
                break;
            }
            case 14: {
                this.data = ModifyPartitionInfo.read(in);
                isRead = true;
                break;
            }
            case 211: {
                this.data = BatchModifyPartitionsInfo.read(in);
                isRead = true;
                break;
            }
            case 4: 
            case 15: 
            case 16: {
                this.data = new Text();
                ((Text)this.data).readFields(in);
                isRead = true;
                break;
            }
            case 5: 
            case 17: 
            case 18: {
                this.data = new RecoverInfo();
                ((RecoverInfo)this.data).readFields(in);
                isRead = true;
                break;
            }
            case 24: {
                this.data = new DropInfo();
                ((DropInfo)this.data).readFields(in);
                isRead = true;
                break;
            }
            case 124: {
                this.data = BatchDropInfo.read(in);
                isRead = true;
                break;
            }
            case 19: 
            case 110: 
            case 120: {
                this.data = new TableInfo();
                ((TableInfo)this.data).readFields(in);
                isRead = true;
                break;
            }
            case 119: {
                this.data = AlterViewInfo.read(in);
                isRead = true;
                break;
            }
            case 116: {
                this.data = BackupJob.read(in);
                isRead = true;
                break;
            }
            case 117: {
                this.data = RestoreJob.read(in);
                isRead = true;
                break;
            }
            case 29: {
                this.data = new ConsistencyCheckInfo();
                ((ConsistencyCheckInfo)this.data).readFields(in);
                isRead = true;
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                this.data = new LoadJob();
                ((LoadJob)this.data).readFields(in);
                isRead = true;
                break;
            }
            case 36: {
                this.data = ExportJob.read(in);
                isRead = true;
                break;
            }
            case 37: {
                this.data = new ExportJob.StateTransfer();
                ((ExportJob.StateTransfer)this.data).readFields(in);
                isRead = true;
                break;
            }
            case 41: {
                this.data = DeleteInfo.read(in);
                isRead = true;
                break;
            }
            case 28: 
            case 42: 
            case 43: 
            case 45: {
                this.data = ReplicaPersistInfo.read(in);
                isRead = true;
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 91: {
                this.data = Backend.read(in);
                isRead = true;
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                this.data = new Frontend();
                ((Frontend)this.data).readFields(in);
                isRead = true;
                break;
            }
            case 58: {
                this.data = new LoadErrorHub.Param();
                ((LoadErrorHub.Param)this.data).readFields(in);
                isRead = true;
                break;
            }
            case 63: {
                this.data = UserIdentity.read(in);
                isRead = true;
                break;
            }
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                this.data = PrivInfo.read(in);
                isRead = true;
                break;
            }
            case 290: {
                this.data = LdapInfo.read(in);
                isRead = true;
                break;
            }
            case 69: {
                this.data = UserPropertyInfo.read(in);
                isRead = true;
                break;
            }
            case 71: {
                this.data = new MasterInfo();
                ((MasterInfo)this.data).readFields(in);
                isRead = true;
                break;
            }
            case 70: {
                this.data = new Timestamp();
                ((Timestamp)this.data).readFields(in);
                isRead = true;
                break;
            }
            case 72: {
                this.data = new Text();
                ((Text)this.data).readFields(in);
                isRead = true;
                break;
            }
            case 74: {
                this.data = Cluster.read(in);
                isRead = true;
                break;
            }
            case 75: 
            case 76: {
                this.data = new ClusterInfo();
                ((ClusterInfo)this.data).readFields(in);
                isRead = true;
                break;
            }
            case 77: 
            case 78: {
                this.data = new BaseParam();
                ((BaseParam)this.data).readFields(in);
                isRead = true;
                break;
            }
            case 82: {
                this.data = new DatabaseInfo();
                ((DatabaseInfo)this.data).readFields(in);
                isRead = true;
                break;
            }
            case 83: {
                this.data = new DropLinkDbAndUpdateDbInfo();
                ((DropLinkDbAndUpdateDbInfo)this.data).readFields(in);
                isRead = true;
                break;
            }
            case 85: 
            case 86: {
                this.data = new BrokerMgr.ModifyBrokerInfo();
                ((BrokerMgr.ModifyBrokerInfo)this.data).readFields(in);
                isRead = true;
                break;
            }
            case 87: {
                this.data = new Text();
                ((Text)this.data).readFields(in);
                isRead = true;
                break;
            }
            case 88: {
                this.data = new BackendIdsUpdateInfo();
                ((BackendIdsUpdateInfo)this.data).readFields(in);
                isRead = true;
                break;
            }
            case 100: 
            case 101: {
                this.data = new TransactionState();
                ((TransactionState)this.data).readFields(in);
                isRead = true;
                break;
            }
            case 105: {
                this.data = BatchRemoveTransactionsOperation.read(in);
                isRead = true;
                break;
            }
            case 89: {
                this.data = Repository.read(in);
                isRead = true;
                break;
            }
            case 90: {
                this.data = new Text();
                ((Text)this.data).readFields(in);
                isRead = true;
                break;
            }
            case 118: {
                this.data = TruncateTableInfo.read(in);
                isRead = true;
                break;
            }
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                this.data = ColocatePersistInfo.read(in);
                isRead = true;
                break;
            }
            case 99: {
                this.data = new TablePropertyInfo();
                ((TablePropertyInfo)this.data).readFields(in);
                isRead = true;
                break;
            }
            case 59: {
                this.data = HbPackage.read(in);
                isRead = true;
                break;
            }
            case 130: {
                this.data = Function.read(in);
                isRead = true;
                break;
            }
            case 131: {
                this.data = FunctionSearchDesc.read(in);
                isRead = true;
                break;
            }
            case 253: {
                this.data = EncryptKey.read(in);
                isRead = true;
                break;
            }
            case 254: {
                this.data = EncryptKeySearchDesc.read(in);
                isRead = true;
                break;
            }
            case 46: {
                this.data = BackendTabletsInfo.read(in);
                isRead = true;
                break;
            }
            case 48: {
                this.data = BackendReplicasInfo.read(in);
                isRead = true;
                break;
            }
            case 200: {
                this.data = RoutineLoadJob.read(in);
                isRead = true;
                break;
            }
            case 201: 
            case 202: {
                this.data = RoutineLoadOperation.read(in);
                isRead = true;
                break;
            }
            case 230: {
                this.data = org.apache.doris.load.loadv2.LoadJob.read(in);
                isRead = true;
                break;
            }
            case 231: {
                this.data = LoadJobFinalOperation.read(in);
                isRead = true;
                break;
            }
            case 232: {
                this.data = LoadJob.LoadJobStateUpdateInfo.read(in);
                isRead = true;
                break;
            }
            case 234: {
                this.data = SyncJob.read(in);
                isRead = true;
                break;
            }
            case 235: {
                this.data = SyncJob.SyncJobUpdateStateInfo.read(in);
                isRead = true;
                break;
            }
            case 233: {
                this.data = StreamLoadRecordMgr.FetchStreamLoadRecord.read(in);
                isRead = true;
                break;
            }
            case 276: {
                this.data = Resource.read(in);
                isRead = true;
                break;
            }
            case 277: {
                this.data = DropResourceOperationLog.read(in);
                isRead = true;
                break;
            }
            case 251: 
            case 252: {
                this.data = SmallFileMgr.SmallFile.read(in);
                isRead = true;
                break;
            }
            case 121: {
                this.data = AlterJobV2.read(in);
                isRead = true;
                break;
            }
            case 123: {
                this.data = BatchAlterJobPersistInfo.read(in);
                isRead = true;
                break;
            }
            case 122: {
                this.data = TableInfo.read(in);
                isRead = true;
                break;
            }
            case 47: {
                this.data = SetReplicaStatusOperationLog.read(in);
                isRead = true;
                break;
            }
            case 261: 
            case 266: 
            case 267: {
                this.data = ModifyTablePropertyOperationLog.read(in);
                isRead = true;
                break;
            }
            case 268: {
                this.data = ModifyTableDefaultDistributionBucketNumOperationLog.read(in);
                isRead = true;
                break;
            }
            case 210: {
                this.data = ReplacePartitionOperationLog.read(in);
                isRead = true;
                break;
            }
            case 270: {
                this.data = PluginInfo.read(in);
                isRead = true;
                break;
            }
            case 271: {
                this.data = PluginInfo.read(in);
                isRead = true;
                break;
            }
            case 125: {
                this.data = RemoveAlterJobV2OperationLog.read(in);
                isRead = true;
                break;
            }
            case 126: {
                this.data = ModifyCommentOperationLog.read(in);
                isRead = true;
                break;
            }
            case 111: {
                this.data = AlterRoutineLoadJobOperationLog.read(in);
                isRead = true;
                break;
            }
            case 84: {
                this.data = GlobalVarPersistInfo.read(in);
                isRead = true;
                break;
            }
            case 212: {
                this.data = ReplaceTableOperationLog.read(in);
                isRead = true;
                break;
            }
            case 300: {
                this.data = SqlBlockRule.read(in);
                isRead = true;
                break;
            }
            case 301: {
                this.data = SqlBlockRule.read(in);
                isRead = true;
                break;
            }
            case 302: {
                this.data = DropSqlBlockRuleOperationLog.read(in);
                isRead = true;
                break;
            }
            case 127: {
                this.data = ModifyTableEngineOperationLog.read(in);
                isRead = true;
                break;
            }
            default: {
                IOException e = new IOException();
                LOG.error("UNKNOWN Operation Type {}", (Object)this.opCode, (Object)e);
                throw e;
            }
        }
        Preconditions.checkState((boolean)isRead);
    }
}

