/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.util;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.doris.common.util.Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.multipart.MultipartFile;

public class TmpFileMgr {
    public static final Logger LOG = LogManager.getLogger(TmpFileMgr.class);
    private static final long MAX_TOTAL_FILE_SIZE_BYTES = 0x40000000L;
    private static final long MAX_TOTAL_FILE_NUM = 100L;
    public static final long MAX_SINGLE_FILE_SIZE = 0x6400000L;
    private static final String UPLOAD_DIR = "_doris_upload";
    private AtomicLong fileIdGenerator = new AtomicLong(0L);
    private String rootDir;
    private Map<Long, TmpFile> fileMap = Maps.newConcurrentMap();
    private long totalFileSize = 0L;

    public TmpFileMgr(String dir) {
        this.rootDir = dir + "/" + UPLOAD_DIR;
        this.init();
    }

    private void init() {
        File root = new File(this.rootDir);
        if (!root.exists()) {
            root.mkdirs();
        } else if (!root.isDirectory()) {
            throw new IllegalStateException("Path " + this.rootDir + " is not directory");
        }
        Util.deleteDirectory(root);
        root.mkdirs();
    }

    public synchronized TmpFile upload(UploadFile uploadFile) throws TmpFileException {
        if (uploadFile.file.getSize() > 0x6400000L) {
            throw new TmpFileException("File size " + uploadFile.file.getSize() + " exceed limit " + 0x6400000L);
        }
        if (this.totalFileSize + uploadFile.file.getSize() > 0x40000000L) {
            throw new TmpFileException("Total file size will exceed limit 1073741824");
        }
        if ((long)this.fileMap.size() > 100L) {
            throw new TmpFileException("Number of temp file " + this.fileMap.size() + " exceed limit " + 100L);
        }
        long fileId = this.fileIdGenerator.incrementAndGet();
        String fileUUID = UUID.randomUUID().toString();
        TmpFile tmpFile = new TmpFile(fileId, fileUUID, uploadFile.file.getOriginalFilename(), uploadFile.file.getSize(), uploadFile.columnSeparator);
        try {
            tmpFile.save(uploadFile.file);
        }
        catch (IOException e) {
            throw new TmpFileException("Failed to upload file. Reason: " + e.getMessage());
        }
        this.fileMap.put(tmpFile.id, tmpFile);
        this.totalFileSize += uploadFile.file.getSize();
        return tmpFile;
    }

    public TmpFile getFile(long id, String uuid) throws TmpFileException {
        TmpFile tmpFile = this.fileMap.get(id);
        if (tmpFile == null || !tmpFile.uuid.equals(uuid)) {
            throw new TmpFileException("File with [" + id + "-" + uuid + "] does not exist");
        }
        return tmpFile;
    }

    public List<TmpFileBrief> listFiles() {
        return this.fileMap.values().stream().map(t -> new TmpFileBrief((TmpFile)t)).collect(Collectors.toList());
    }

    public void deleteFile(Long fileId, String fileUUID) {
        Iterator<Map.Entry<Long, TmpFile>> iterator = this.fileMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, TmpFile> entry = iterator.next();
            if (entry.getValue().id != fileId || !entry.getValue().uuid.equals(fileUUID)) continue;
            entry.getValue().delete();
            iterator.remove();
        }
    }

    public static class TmpFileException
    extends Exception {
        public TmpFileException(String msg) {
            super(msg);
        }

        public TmpFileException(String msg, Throwable t) {
            super(msg, t);
        }
    }

    public static class UploadFile {
        public MultipartFile file;
        public String columnSeparator;

        public UploadFile(MultipartFile file, String columnSeparator) {
            this.file = file;
            this.columnSeparator = columnSeparator;
        }
    }

    public static class TmpFileBrief {
        public long id;
        public String uuid;
        public String originFileName;
        public long fileSize;
        public String columnSeparator;

        public TmpFileBrief(TmpFile tmpFile) {
            this.id = tmpFile.id;
            this.uuid = tmpFile.uuid;
            this.originFileName = tmpFile.originFileName;
            this.fileSize = tmpFile.fileSize;
            this.columnSeparator = tmpFile.columnSeparator;
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public String getUuid() {
            return this.uuid;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public String getOriginFileName() {
            return this.originFileName;
        }

        public void setOriginFileName(String originFileName) {
            this.originFileName = originFileName;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public void setFileSize(long fileSize) {
            this.fileSize = fileSize;
        }

        public String getColumnSeparator() {
            return this.columnSeparator;
        }

        public void setColumnSeparator(String columnSeparator) {
            this.columnSeparator = columnSeparator;
        }
    }

    public class TmpFile {
        public final long id;
        public final String uuid;
        public final String originFileName;
        public final long fileSize;
        public String columnSeparator;
        public String absPath;
        public List<List<String>> lines = null;
        public int maxColNum = 0;
        private static final int MAX_PREVIEW_LINES = 10;

        public TmpFile(long id, String uuid, String originFileName, long fileSize, String columnSeparator) {
            this.id = id;
            this.uuid = uuid;
            this.originFileName = originFileName;
            this.fileSize = fileSize;
            this.columnSeparator = columnSeparator;
        }

        public void save(MultipartFile file) throws IOException {
            File dest = new File(Joiner.on((String)"/").join((Object)TmpFileMgr.this.rootDir, (Object)this.uuid, new Object[0]));
            boolean uploadSucceed = false;
            try {
                file.transferTo(dest);
                this.absPath = dest.getAbsolutePath();
                uploadSucceed = true;
                LOG.info("upload file {} succeed at {}", (Object)this, (Object)dest.getAbsolutePath());
            }
            catch (IOException e) {
                LOG.warn("failed to upload file {}, dest: {}", (Object)this, (Object)dest.getAbsolutePath(), (Object)e);
                throw e;
            }
            finally {
                if (!uploadSucceed) {
                    dest.delete();
                }
            }
        }

        public void setPreview() throws IOException {
            this.lines = Lists.newArrayList();
            String escapedColSep = Util.escapeSingleRegex(this.columnSeparator);
            try (FileReader fr = new FileReader(this.absPath);
                 BufferedReader bf = new BufferedReader(fr);){
                String str;
                while ((str = bf.readLine()) != null) {
                    Object[] cols = str.split(escapedColSep, -1);
                    this.lines.add(Lists.newArrayList((Object[])cols));
                    if (cols.length > this.maxColNum) {
                        this.maxColNum = cols.length;
                    }
                    if (this.lines.size() < 10) continue;
                    break;
                }
            }
        }

        public TmpFile copy() {
            TmpFile copiedFile = new TmpFile(this.id, this.uuid, this.originFileName, this.fileSize, this.columnSeparator);
            copiedFile.absPath = this.absPath;
            return copiedFile;
        }

        public void delete() {
            File file = new File(this.absPath);
            file.delete();
            LOG.info("delete tmp file: {}", (Object)this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[id=").append(this.id).append(", uuid=").append(this.uuid).append("\uff0c origin name=").append(this.originFileName).append(", size=").append(this.fileSize).append("]");
            return sb.toString();
        }
    }
}

