/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.ExportStmt;
import org.apache.doris.analysis.InsertStmt;
import org.apache.doris.analysis.QueryStmt;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.analysis.SqlParser;
import org.apache.doris.analysis.SqlScanner;
import org.apache.doris.analysis.StatementBase;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.ThreadPoolManager;
import org.apache.doris.common.util.SqlParserUtils;
import org.apache.doris.httpv2.util.ExecutionResultSet;
import org.apache.doris.qe.ConnectContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StatementSubmitter {
    private static final Logger LOG = LogManager.getLogger(StatementSubmitter.class);
    private static final String TYPE_RESULT_SET = "result_set";
    private static final String TYPE_EXEC_STATUS = "exec_status";
    private static final String JDBC_DRIVER = "org.mariadb.jdbc.Driver";
    private static final String DB_URL_PATTERN = "jdbc:mariadb://127.0.0.1:%d/%s";
    private ThreadPoolExecutor executor = ThreadPoolManager.newDaemonCacheThreadPool(2, "SQL submitter", true);

    public Future<ExecutionResultSet> submit(StmtContext queryCtx) {
        Worker worker = new Worker(ConnectContext.get(), queryCtx);
        return this.executor.submit(worker);
    }

    public static class StmtContext {
        public String stmt;
        public String user;
        public String passwd;
        public long limit;

        public StmtContext(String stmt, String user, String passwd, long limit) {
            this.stmt = stmt;
            this.user = user;
            this.passwd = passwd;
            this.limit = limit;
        }
    }

    private static class Worker
    implements Callable<ExecutionResultSet> {
        private ConnectContext ctx;
        private StmtContext queryCtx;

        public Worker(ConnectContext ctx, StmtContext queryCtx) {
            this.ctx = ctx;
            this.queryCtx = queryCtx;
        }

        @Override
        public ExecutionResultSet call() throws Exception {
            StatementBase stmtBase = this.analyzeStmt(this.queryCtx.stmt);
            Connection conn = null;
            Statement stmt = null;
            String dbUrl = String.format(StatementSubmitter.DB_URL_PATTERN, Config.query_port, this.ctx.getDatabase());
            try {
                Class.forName(StatementSubmitter.JDBC_DRIVER);
                conn = DriverManager.getConnection(dbUrl, this.queryCtx.user, this.queryCtx.passwd);
                long startTime = System.currentTimeMillis();
                if (stmtBase instanceof QueryStmt || stmtBase instanceof ShowStmt) {
                    stmt = conn.prepareStatement(this.queryCtx.stmt, 1003, 1007);
                    ((PreparedStatement)stmt).setFetchSize(1);
                    ResultSet rs = ((PreparedStatement)stmt).executeQuery();
                    ExecutionResultSet resultSet = this.generateResultSet(rs, startTime);
                    rs.close();
                    ExecutionResultSet executionResultSet = resultSet;
                    return executionResultSet;
                }
                if (stmtBase instanceof InsertStmt || stmtBase instanceof DdlStmt || stmtBase instanceof ExportStmt) {
                    ExecutionResultSet resultSet;
                    stmt = conn.createStatement();
                    stmt.execute(this.queryCtx.stmt);
                    ExecutionResultSet executionResultSet = resultSet = this.generateExecStatus(startTime);
                    return executionResultSet;
                }
                throw new Exception("Unsupported statement type");
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException se2) {
                    LOG.warn("failed to close stmt", (Throwable)se2);
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException se) {
                    LOG.warn("failed to close connection", (Throwable)se);
                }
            }
        }

        private ExecutionResultSet generateResultSet(ResultSet rs, long startTime) throws SQLException {
            HashMap result = Maps.newHashMap();
            result.put("type", StatementSubmitter.TYPE_RESULT_SET);
            if (rs == null) {
                return new ExecutionResultSet(result);
            }
            ResultSetMetaData metaData = rs.getMetaData();
            int colNum = metaData.getColumnCount();
            ArrayList metaFields = Lists.newArrayList();
            for (int i = 1; i <= colNum; ++i) {
                HashMap field = Maps.newHashMap();
                field.put("name", metaData.getColumnName(i));
                field.put("type", metaData.getColumnTypeName(i));
                metaFields.add(field);
            }
            ArrayList rows = Lists.newArrayList();
            for (long rowCount = 0L; rs.next() && rowCount < this.queryCtx.limit; ++rowCount) {
                ArrayList row = Lists.newArrayListWithCapacity((int)colNum);
                for (int i = 1; i <= colNum; ++i) {
                    String type = rs.getMetaData().getColumnTypeName(i);
                    if ("DATE".equalsIgnoreCase(type) || "DATETIME".equalsIgnoreCase(type)) {
                        row.add(rs.getString(i));
                        continue;
                    }
                    row.add(rs.getObject(i));
                }
                rows.add(row);
            }
            result.put("meta", metaFields);
            result.put("data", rows);
            result.put("time", System.currentTimeMillis() - startTime);
            return new ExecutionResultSet(result);
        }

        private ExecutionResultSet generateExecStatus(long startTime) throws SQLException {
            HashMap result = Maps.newHashMap();
            result.put("type", StatementSubmitter.TYPE_EXEC_STATUS);
            result.put("status", Maps.newHashMap());
            result.put("time", System.currentTimeMillis() - startTime);
            return new ExecutionResultSet(result);
        }

        private StatementBase analyzeStmt(String stmtStr) throws Exception {
            SqlParser parser = new SqlParser(new SqlScanner(new StringReader(stmtStr)));
            try {
                return SqlParserUtils.getFirstStmt(parser);
            }
            catch (AnalysisException e) {
                String errorMessage = parser.getErrorMsg(stmtStr);
                if (errorMessage == null) {
                    throw e;
                }
                throw new AnalysisException(errorMessage, e);
            }
            catch (Exception e) {
                throw new Exception("error happens when parsing stmt: " + e.getMessage());
            }
        }
    }
}

