/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.restv2;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.httpv2.rest.RestBaseController;
import org.apache.doris.system.Backend;
import org.apache.doris.system.SystemInfoService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/v2"})
public class StatisticAction
extends RestBaseController {
    private static final Logger LOG = LogManager.getLogger(StatisticAction.class);

    @RequestMapping(path={"/api/cluster_overview"}, method={RequestMethod.GET})
    public Object clusterOverview(HttpServletRequest request, HttpServletResponse response) {
        if (!Catalog.getCurrentCatalog().isMaster()) {
            return this.redirectToMaster(request, response);
        }
        HashMap resultMap = Maps.newHashMap();
        Catalog catalog = Catalog.getCurrentCatalog();
        SystemInfoService infoService = Catalog.getCurrentSystemInfo();
        resultMap.put("dbCount", catalog.getDbIds().size());
        resultMap.put("tblCount", this.getTblCount(catalog));
        resultMap.put("diskOccupancy", this.getDiskOccupancy(infoService));
        resultMap.put("beCount", infoService.getClusterBackendIds("default_cluster").size());
        resultMap.put("feCount", catalog.getFrontends(null).size());
        resultMap.put("remainDisk", this.getRemainDisk(infoService));
        return ResponseEntityBuilder.ok(resultMap);
    }

    private int getTblCount(Catalog catalog) {
        return catalog.getDbIds().stream().map(catalog::getDbNullable).filter(Objects::nonNull).map(db -> db.getTables().size()).reduce(Integer::sum).orElse(0);
    }

    private long getDiskOccupancy(SystemInfoService infoService) {
        long diskOccupancy = 0L;
        List<Backend> backends = infoService.getClusterBackends("default_cluster");
        for (Backend be : backends) {
            diskOccupancy += be.getDataUsedCapacityB();
        }
        return diskOccupancy;
    }

    private long getRemainDisk(SystemInfoService infoService) {
        long remainDisk = 0L;
        List<Backend> backends = infoService.getClusterBackends("default_cluster");
        for (Backend be : backends) {
            remainDisk += be.getAvailableCapacityB();
        }
        return remainDisk;
    }
}

