/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.restv2;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Table;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.UserException;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.httpv2.exception.BadRequestException;
import org.apache.doris.httpv2.rest.RestBaseController;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/v2"})
public class MetaInfoActionV2
extends RestBaseController {
    private static final String NAMESPACES = "namespaces";
    private static final String DATABASES = "databases";
    private static final String TABLES = "tables";
    private static final String PARAM_LIMIT = "limit";
    private static final String PARAM_OFFSET = "offset";
    private static final String PARAM_WITH_MV = "with_mv";

    @RequestMapping(path={"/api/meta/namespaces/{ns}/databases"}, method={RequestMethod.GET})
    public Object getAllDatabases(@PathVariable(value="ns") String ns, HttpServletRequest request, HttpServletResponse response) {
        this.checkWithCookie(request, response, false);
        if (!ns.equalsIgnoreCase("default_cluster")) {
            return ResponseEntityBuilder.badRequest("Only support 'default_cluster' now");
        }
        List<String> dbNames = null;
        try {
            dbNames = Catalog.getCurrentCatalog().getClusterDbNames(ns);
        }
        catch (AnalysisException e) {
            return ResponseEntityBuilder.okWithCommonError("namespace does not exist: " + ns);
        }
        ArrayList dbNameSet = Lists.newArrayList();
        for (String fullName : dbNames) {
            String db = ClusterNamespace.getNameFromFullName(fullName);
            if (!Catalog.getCurrentCatalog().getAuth().checkDbPriv(ConnectContext.get(), fullName, PrivPredicate.SHOW)) continue;
            dbNameSet.add(db);
        }
        Collections.sort(dbNames);
        Pair<Integer, Integer> fromToIndex = this.getFromToIndex(request, dbNames.size());
        return ResponseEntityBuilder.ok(dbNames.subList((Integer)fromToIndex.first, (Integer)fromToIndex.second));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(path={"/api/meta/namespaces/{ns}/databases/{db}/tables"}, method={RequestMethod.GET})
    public Object getTables(@PathVariable(value="ns") String ns, @PathVariable(value="db") String dbName, HttpServletRequest request, HttpServletResponse response) {
        Database db;
        this.checkWithCookie(request, response, false);
        if (!ns.equalsIgnoreCase("default_cluster")) {
            return ResponseEntityBuilder.badRequest("Only support 'default_cluster' now");
        }
        String fullDbName = this.getFullDbName(dbName);
        try {
            db = Catalog.getCurrentCatalog().getDbOrMetaException(fullDbName);
        }
        catch (MetaNotFoundException e) {
            return ResponseEntityBuilder.okWithCommonError(e.getMessage());
        }
        ArrayList tblNames = Lists.newArrayList();
        db.readLock();
        try {
            for (Table tbl : db.getTables()) {
                if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), fullDbName, tbl.getName(), PrivPredicate.SHOW)) continue;
                tblNames.add(tbl.getName());
            }
        }
        finally {
            db.readUnlock();
        }
        Collections.sort(tblNames);
        Pair<Integer, Integer> fromToIndex = this.getFromToIndex(request, tblNames.size());
        return ResponseEntityBuilder.ok(tblNames.subList((Integer)fromToIndex.first, (Integer)fromToIndex.second));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(path={"/api/meta/namespaces/{ns}/databases/{db}/tables/{table}/schema"}, method={RequestMethod.GET})
    public Object getTableSchema(@PathVariable(value="ns") String ns, @PathVariable(value="db") String dbName, @PathVariable(value="table") String tblName, HttpServletRequest request, HttpServletResponse response) throws UserException {
        this.checkWithCookie(request, response, false);
        if (!ns.equalsIgnoreCase("default_cluster")) {
            return ResponseEntityBuilder.badRequest("Only support 'default_cluster' now");
        }
        String fullDbName = this.getFullDbName(dbName);
        this.checkTblAuth(ConnectContext.get().getCurrentUserIdentity(), fullDbName, tblName, PrivPredicate.SHOW);
        String withMvPara = request.getParameter(PARAM_WITH_MV);
        boolean withMv = !Strings.isNullOrEmpty((String)withMvPara) && withMvPara.equals("1");
        Database db = Catalog.getCurrentCatalog().getDbOrMetaException(fullDbName);
        db.readLock();
        try {
            Object tbl = db.getTableOrMetaException(tblName, Table.TableType.OLAP);
            TableSchemaInfo tableSchemaInfo = new TableSchemaInfo();
            tableSchemaInfo.setEngineType(((Table)tbl).getType().toString());
            SchemaInfo schemaInfo = this.generateSchemaInfo((Table)tbl, withMv);
            tableSchemaInfo.setSchemaInfo(schemaInfo);
            ResponseEntity responseEntity = ResponseEntityBuilder.ok(tableSchemaInfo);
            db.readUnlock();
            return responseEntity;
        }
        catch (Throwable throwable) {
            try {
                db.readUnlock();
                throw throwable;
            }
            catch (MetaNotFoundException e) {
                return ResponseEntityBuilder.okWithCommonError(e.getMessage());
            }
        }
    }

    private SchemaInfo generateSchemaInfo(Table tbl, boolean withMv) {
        SchemaInfo schemaInfo = new SchemaInfo();
        HashMap schemaMap = Maps.newHashMap();
        if (tbl.getType() == Table.TableType.OLAP) {
            OlapTable olapTable = (OlapTable)tbl;
            long baseIndexId = olapTable.getBaseIndexId();
            TableSchema baseTableSchema = new TableSchema();
            baseTableSchema.setBaseIndex(true);
            baseTableSchema.setKeyType(olapTable.getKeysTypeByIndexId(baseIndexId).name());
            Schema baseSchema = this.generateSchame(olapTable.getSchemaByIndexId(baseIndexId));
            baseTableSchema.setSchema(baseSchema);
            schemaMap.put(olapTable.getIndexNameById(baseIndexId), baseTableSchema);
            if (withMv) {
                for (long indexId : olapTable.getIndexIdListExceptBaseIndex()) {
                    TableSchema tableSchema = new TableSchema();
                    tableSchema.setBaseIndex(false);
                    tableSchema.setKeyType(olapTable.getKeysTypeByIndexId(indexId).name());
                    Schema schema = this.generateSchame(olapTable.getSchemaByIndexId(indexId));
                    tableSchema.setSchema(schema);
                    schemaMap.put(olapTable.getIndexNameById(indexId), tableSchema);
                }
            }
        } else {
            TableSchema tableSchema = new TableSchema();
            tableSchema.setBaseIndex(false);
            Schema schema = this.generateSchame(tbl.getBaseSchema());
            tableSchema.setSchema(schema);
            schemaMap.put(tbl.getName(), tableSchema);
            schemaInfo.setSchemaMap(schemaMap);
        }
        schemaInfo.setSchemaMap(schemaMap);
        return schemaInfo;
    }

    private Schema generateSchame(List<Column> columns) {
        Schema schema = new Schema();
        for (Column column : columns) {
            schema.setField(column.getName());
            schema.setType(column.getType().toString());
            schema.setIsNull(String.valueOf(column.isAllowNull()));
            schema.setDefaultVal(column.getDefaultValue());
            schema.setKey(String.valueOf(column.isKey()));
            schema.setAggrType(column.getAggregationType() == null ? "None" : column.getAggregationType().toString());
            schema.setComment(column.getComment());
        }
        return schema;
    }

    private void generateResult(Table tbl, boolean isBaseIndex, Map<String, Map<String, Object>> result) throws UserException {
        HashMap propMap = result.get(tbl.getName());
        if (propMap == null) {
            propMap = Maps.newHashMap();
            result.put(tbl.getName(), propMap);
        }
        propMap.put("isBase", isBaseIndex);
        propMap.put("tableType", tbl.getEngine());
        if (tbl.getType() == Table.TableType.OLAP) {
            propMap.put("keyType", ((OlapTable)tbl).getKeysType());
        }
        propMap.put("schema", this.generateSchema(tbl.getBaseSchema()));
    }

    List<Map<String, String>> generateSchema(List<Column> columns) throws UserException {
        ArrayList schema = Lists.newArrayList();
        for (Column column : columns) {
            HashMap colSchema = Maps.newHashMap();
            colSchema.put("Field", column.getName());
            colSchema.put("Type", column.getType().toString());
            colSchema.put("Null", String.valueOf(column.isAllowNull()));
            colSchema.put("Default", column.getDefaultValue());
            colSchema.put("Key", String.valueOf(column.isKey()));
            colSchema.put("AggType", column.getAggregationType().toString());
            colSchema.put("Comment", column.getComment());
            schema.add(colSchema);
        }
        return schema;
    }

    private String convertIfNull(String val) {
        return val.equals(FeConstants.null_string) ? null : val;
    }

    private Pair<Integer, Integer> getFromToIndex(HttpServletRequest request, int maxNum) {
        String limitStr = request.getParameter(PARAM_LIMIT);
        String offsetStr = request.getParameter(PARAM_OFFSET);
        int offset = 0;
        int limit = Integer.MAX_VALUE;
        if (Strings.isNullOrEmpty((String)limitStr)) {
            if (!Strings.isNullOrEmpty((String)offsetStr)) {
                throw new BadRequestException("Param offset should be set with param limit");
            }
        } else {
            limit = Integer.valueOf(limitStr);
            if (limit < 0) {
                throw new BadRequestException("Param limit should >= 0");
            }
            offset = 0;
            if (!Strings.isNullOrEmpty((String)offsetStr) && (offset = Integer.valueOf(offsetStr).intValue()) < 0) {
                throw new BadRequestException("Param offset should >= 0");
            }
        }
        if (maxNum <= 0) {
            return Pair.create(0, 0);
        }
        return Pair.create(Math.min(offset, maxNum - 1), Math.min(limit + offset, maxNum));
    }

    public static class Schema {
        private String field;
        private String type;
        private String isNull;
        private String defaultVal;
        private String key;
        private String aggrType;
        private String comment;

        public String getField() {
            return this.field;
        }

        public String getType() {
            return this.type;
        }

        public String getIsNull() {
            return this.isNull;
        }

        public String getDefaultVal() {
            return this.defaultVal;
        }

        public String getKey() {
            return this.key;
        }

        public String getAggrType() {
            return this.aggrType;
        }

        public String getComment() {
            return this.comment;
        }

        public void setField(String field) {
            this.field = field;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setIsNull(String isNull) {
            this.isNull = isNull;
        }

        public void setDefaultVal(String defaultVal) {
            this.defaultVal = defaultVal;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setAggrType(String aggrType) {
            this.aggrType = aggrType;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }
    }

    public static class TableSchema {
        private Schema schema;
        private boolean isBaseIndex;
        private String keyType;

        public Schema getSchema() {
            return this.schema;
        }

        public boolean isBaseIndex() {
            return this.isBaseIndex;
        }

        public String getKeyType() {
            return this.keyType;
        }

        public void setSchema(Schema schema) {
            this.schema = schema;
        }

        public void setBaseIndex(boolean isBaseIndex) {
            this.isBaseIndex = isBaseIndex;
        }

        public void setKeyType(String keyType) {
            this.keyType = keyType;
        }
    }

    public static class SchemaInfo {
        private Map<String, TableSchema> schemaMap;

        public Map<String, TableSchema> getSchemaMap() {
            return this.schemaMap;
        }

        public void setSchemaMap(Map<String, TableSchema> schemaMap) {
            this.schemaMap = schemaMap;
        }
    }

    public static class TableSchemaInfo {
        private String engineType;
        private SchemaInfo schemaInfo;

        public String getEngineType() {
            return this.engineType;
        }

        public SchemaInfo getSchemaInfo() {
            return this.schemaInfo;
        }

        public void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        public void setSchemaInfo(SchemaInfo schemaInfo) {
            this.schemaInfo = schemaInfo;
        }
    }
}

