/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.restv2;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.analysis.BrokerDesc;
import org.apache.doris.common.UserException;
import org.apache.doris.common.parquet.ParquetReader;
import org.apache.doris.common.util.BrokerUtil;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.thrift.TBrokerFileStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/v2"})
public class ImportAction {
    private static final Logger LOG = LogManager.getLogger(ImportAction.class);
    private static final long MAX_READ_LEN_BYTES = 0x100000L;
    private static final String FORMAT_CSV = "CSV";
    private static final String FORMAT_PARQUET = "PARQUET";
    private static final String FORMAT_ORC = "ORC";
    private static final int MAX_SAMPLE_LINE = 50;

    @RequestMapping(path={"/api/import/file_review"}, method={RequestMethod.POST})
    public Object fileReview(@RequestBody FileReviewRequestVo body, HttpServletRequest request, HttpServletResponse response) {
        FileInfo fileInfo = body.getFileInfo();
        ConnectInfo connectInfo = body.getConnectInfo();
        BrokerDesc brokerDesc = new BrokerDesc(connectInfo.getBrokerName(), connectInfo.getBrokerProps());
        ArrayList fileStatuses = Lists.newArrayList();
        try {
            BrokerUtil.parseFile(fileInfo.getFileUrl(), brokerDesc, fileStatuses);
            FileReviewResponseVo reviewResponseVo = this.createFileReviewResponse(brokerDesc, fileInfo, fileStatuses);
            return ResponseEntityBuilder.ok(reviewResponseVo);
        }
        catch (UserException e) {
            return ResponseEntityBuilder.okWithCommonError(e.getMessage());
        }
    }

    private FileReviewResponseVo createFileReviewResponse(BrokerDesc brokerDesc, FileInfo fileInfo, List<TBrokerFileStatus> fileStatuses) throws UserException {
        FileReviewResponseVo responseVo = new FileReviewResponseVo();
        FileReviewStatistic statistic = new FileReviewStatistic();
        statistic.setFileNumber(fileStatuses.size());
        long totalFileSize = 0L;
        for (TBrokerFileStatus fStatus : fileStatuses) {
            if (fStatus.isDir) {
                throw new UserException("Not all matched paths are files: " + fStatus.path);
            }
            totalFileSize += fStatus.size;
        }
        statistic.setFileSize(totalFileSize);
        responseVo.setReviewStatistic(statistic);
        if (fileStatuses.isEmpty()) {
            return responseVo;
        }
        TBrokerFileStatus sampleFile = fileStatuses.get(0);
        FileSample fileSample = new FileSample();
        fileSample.setSampleFileName(sampleFile.path);
        if (fileInfo.format.equalsIgnoreCase(FORMAT_CSV)) {
            byte[] fileContentBytes = BrokerUtil.readFile(sampleFile.path, brokerDesc, 0x100000L);
            this.parseContent(fileInfo.columnSeparator, "\n", fileContentBytes, fileSample);
        } else if (fileInfo.format.equalsIgnoreCase(FORMAT_PARQUET)) {
            try {
                ParquetReader parquetReader = ParquetReader.create(sampleFile.path, brokerDesc);
                this.parseParquet(parquetReader, fileSample);
            }
            catch (IOException e) {
                LOG.warn("failed to get sample data of parquet file: {}", (Object)sampleFile.path, (Object)e);
                throw new UserException("failed to get sample data of parquet file. " + e.getMessage());
            }
        } else {
            throw new UserException("Only support CSV or PARQUET file format");
        }
        responseVo.setFileSample(fileSample);
        return responseVo;
    }

    private void parseContent(String columnSeparator, String lineDelimiter, byte[] fileContentBytes, FileSample fileSample) {
        String[] lines;
        ArrayList sampleLines = Lists.newArrayList();
        int maxColSize = 0;
        String content = new String(fileContentBytes);
        for (String line : lines = content.split(lineDelimiter)) {
            if (sampleLines.size() >= 50) break;
            Object[] cols = line.split(columnSeparator);
            ArrayList row = Lists.newArrayList((Object[])cols);
            sampleLines.add(row);
            maxColSize = Math.max(maxColSize, row.size());
        }
        fileSample.setFileLineNumber(sampleLines.size());
        fileSample.setMaxColumnSize(maxColSize);
        fileSample.setSampleFileLines(sampleLines);
    }

    private void parseParquet(ParquetReader reader, FileSample fileSample) throws IOException {
        fileSample.setColNames(reader.getSchema(false));
        fileSample.setMaxColumnSize(fileSample.colNames.size());
        fileSample.setSampleFileLines(reader.getLines(50));
        fileSample.setFileLineNumber(fileSample.sampleFileLines.size());
    }

    public static class FileSample {
        private String sampleFileName;
        private int fileLineNumber;
        private int maxColumnSize;
        private List<String> colNames;
        private List<List<String>> sampleFileLines;

        public String getSampleFileName() {
            return this.sampleFileName;
        }

        public int getFileLineNumber() {
            return this.fileLineNumber;
        }

        public int getMaxColumnSize() {
            return this.maxColumnSize;
        }

        public List<String> getColNames() {
            return this.colNames;
        }

        public List<List<String>> getSampleFileLines() {
            return this.sampleFileLines;
        }

        public void setSampleFileName(String sampleFileName) {
            this.sampleFileName = sampleFileName;
        }

        public void setFileLineNumber(int fileLineNumber) {
            this.fileLineNumber = fileLineNumber;
        }

        public void setMaxColumnSize(int maxColumnSize) {
            this.maxColumnSize = maxColumnSize;
        }

        public void setColNames(List<String> colNames) {
            this.colNames = colNames;
        }

        public void setSampleFileLines(List<List<String>> sampleFileLines) {
            this.sampleFileLines = sampleFileLines;
        }
    }

    public static class FileReviewStatistic {
        private int fileNumber;
        private long fileSize;

        public int getFileNumber() {
            return this.fileNumber;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public void setFileNumber(int fileNumber) {
            this.fileNumber = fileNumber;
        }

        public void setFileSize(long fileSize) {
            this.fileSize = fileSize;
        }
    }

    public static class FileReviewResponseVo {
        private FileReviewStatistic reviewStatistic;
        private FileSample fileSample;

        public FileReviewStatistic getReviewStatistic() {
            return this.reviewStatistic;
        }

        public FileSample getFileSample() {
            return this.fileSample;
        }

        public void setReviewStatistic(FileReviewStatistic reviewStatistic) {
            this.reviewStatistic = reviewStatistic;
        }

        public void setFileSample(FileSample fileSample) {
            this.fileSample = fileSample;
        }
    }

    public static class ConnectInfo {
        private String brokerName;
        private Map<String, String> brokerProps;

        public String getBrokerName() {
            return this.brokerName;
        }

        public Map<String, String> getBrokerProps() {
            return this.brokerProps;
        }

        public void setBrokerName(String brokerName) {
            this.brokerName = brokerName;
        }

        public void setBrokerProps(Map<String, String> brokerProps) {
            this.brokerProps = brokerProps;
        }
    }

    public static class FileInfo {
        private String columnSeparator;
        private String fileUrl;
        private String format;

        public String getColumnSeparator() {
            return this.columnSeparator;
        }

        public String getFileUrl() {
            return this.fileUrl;
        }

        public String getFormat() {
            return this.format;
        }

        public void setColumnSeparator(String columnSeparator) {
            this.columnSeparator = columnSeparator;
        }

        public void setFileUrl(String fileUrl) {
            this.fileUrl = fileUrl;
        }

        public void setFormat(String format) {
            this.format = format;
        }
    }

    public static class FileReviewRequestVo {
        private FileInfo fileInfo;
        private ConnectInfo connectInfo;

        public FileInfo getFileInfo() {
            return this.fileInfo;
        }

        public ConnectInfo getConnectInfo() {
            return this.connectInfo;
        }

        public void setFileInfo(FileInfo fileInfo) {
            this.fileInfo = fileInfo;
        }

        public void setConnectInfo(ConnectInfo connectInfo) {
            this.connectInfo = connectInfo;
        }
    }
}

