/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.rest.manager;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.Pair;
import org.apache.doris.common.profile.ProfileTreeNode;
import org.apache.doris.common.profile.ProfileTreePrinter;
import org.apache.doris.common.util.ProfileManager;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.httpv2.rest.RestBaseController;
import org.apache.doris.httpv2.rest.manager.HttpUtils;
import org.apache.doris.httpv2.rest.manager.NodeAction;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.doris.qe.ConnectContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/v2/manager/query"})
public class QueryProfileAction
extends RestBaseController {
    private static final Logger LOG = LogManager.getLogger(QueryProfileAction.class);
    public static final String QUERY_ID = "Query ID";
    public static final String NODE = "FE\u8282\u70b9";
    public static final String USER = "\u67e5\u8be2\u7528\u6237";
    public static final String DEFAULT_DB = "\u6267\u884c\u6570\u636e\u5e93";
    public static final String SQL_STATEMENT = "Sql";
    public static final String QUERY_TYPE = "\u67e5\u8be2\u7c7b\u578b";
    public static final String START_TIME = "\u5f00\u59cb\u65f6\u95f4";
    public static final String END_TIME = "\u7ed3\u675f\u65f6\u95f4";
    public static final String TOTAL = "\u6267\u884c\u65f6\u957f";
    public static final String QUERY_STATE = "\u72b6\u6001";
    private static final String QUERY_ID_PARA = "query_id";
    private static final String SEARCH_PARA = "search";
    private static final String IS_ALL_NODE_PARA = "is_all_node";
    private static final String FRAGMENT_ID = "fragment_id";
    private static final String INSTANCE_ID = "instance_id";
    public static final ImmutableList<String> QUERY_TITLE_NAMES = new ImmutableList.Builder().add((Object)"Query ID").add((Object)"FE\u8282\u70b9").add((Object)"\u67e5\u8be2\u7528\u6237").add((Object)"\u6267\u884c\u6570\u636e\u5e93").add((Object)"Sql").add((Object)"\u67e5\u8be2\u7c7b\u578b").add((Object)"\u5f00\u59cb\u65f6\u95f4").add((Object)"\u7ed3\u675f\u65f6\u95f4").add((Object)"\u6267\u884c\u65f6\u957f").add((Object)"\u72b6\u6001").build();

    private List<String> requestAllFe(String httpPath, Map<String, String> arguments, String authorization) {
        List<Pair<String, Integer>> frontends = HttpUtils.getFeList();
        ImmutableMap header = ImmutableMap.builder().put((Object)"Authorization", (Object)authorization).build();
        ArrayList dataList = Lists.newArrayList();
        for (Pair<String, Integer> ipPort : frontends) {
            String url = HttpUtils.concatUrl(ipPort, httpPath, arguments);
            try {
                String data = HttpUtils.parseResponse(HttpUtils.doGet(url, (Map<String, String>)header));
                if (Strings.isNullOrEmpty((String)data) || data.equals("{}")) continue;
                dataList.add(data);
            }
            catch (Exception e) {
                LOG.warn("request url {} error", (Object)url, (Object)e);
            }
        }
        return dataList;
    }

    @RequestMapping(path={"/query_info"}, method={RequestMethod.GET})
    public Object queryInfo(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="query_id", required=false) String queryId, @RequestParam(value="search", required=false) String search, @RequestParam(value="is_all_node", required=false, defaultValue="true") boolean isAllNode) {
        this.executeCheckPassword(request, response);
        this.checkGlobalAuth(ConnectContext.get().getCurrentUserIdentity(), PrivPredicate.ADMIN);
        List<Object> queries = Lists.newArrayList();
        if (isAllNode) {
            String httpPath = "/rest/v2/manager/query/query_info";
            HashMap hashMap = Maps.newHashMap();
            hashMap.put(QUERY_ID_PARA, queryId);
            if (!Strings.isNullOrEmpty((String)search)) {
                try {
                    search = URLEncoder.encode(search, StandardCharsets.UTF_8.toString());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            hashMap.put(SEARCH_PARA, search);
            hashMap.put(IS_ALL_NODE_PARA, "false");
            List<String> list = this.requestAllFe(httpPath, hashMap, request.getHeader("Authorization"));
            for (String data : list) {
                try {
                    NodeAction.NodeInfo nodeInfo = (NodeAction.NodeInfo)GsonUtils.GSON.fromJson(data, new TypeToken<NodeAction.NodeInfo>(){}.getType());
                    queries.addAll(nodeInfo.getRows());
                }
                catch (Exception e) {
                    LOG.warn("parse query info error: {}", (Object)data, (Object)e);
                }
            }
            return ResponseEntityBuilder.ok(new NodeAction.NodeInfo((List<String>)QUERY_TITLE_NAMES, (List<List<String>>)queries));
        }
        queries = ProfileManager.getInstance().getAllQueries().stream().filter(profile -> ((String)profile.get(4)).equals("Query")).collect(Collectors.toList());
        if (!Strings.isNullOrEmpty((String)queryId)) {
            queries = queries.stream().filter(q -> ((String)q.get(0)).equals(queryId)).collect(Collectors.toList());
        }
        for (List list : queries) {
            list.add(1, (String)Catalog.getCurrentCatalog().getSelfNode().first + ":" + Config.http_port);
        }
        if (!Strings.isNullOrEmpty((String)search)) {
            ArrayList tempQueries = Lists.newArrayList();
            block6: for (List list : queries) {
                for (String field : list) {
                    if (!field.contains(search)) continue;
                    tempQueries.add(list);
                    continue block6;
                }
            }
            queries = tempQueries;
        }
        return ResponseEntityBuilder.ok(new NodeAction.NodeInfo((List<String>)QUERY_TITLE_NAMES, (List<List<String>>)queries));
    }

    @RequestMapping(path={"/sql/{query_id}"}, method={RequestMethod.GET})
    public Object queryInfo(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="query_id") String queryId, @RequestParam(value="is_all_node", required=false, defaultValue="true") boolean isAllNode) {
        this.executeCheckPassword(request, response);
        this.checkGlobalAuth(ConnectContext.get().getCurrentUserIdentity(), PrivPredicate.ADMIN);
        HashMap querySql = Maps.newHashMap();
        if (isAllNode) {
            ImmutableMap arguments;
            String httpPath = "/rest/v2/manager/query/sql/" + queryId;
            List<String> dataList = this.requestAllFe(httpPath, (Map<String, String>)(arguments = ImmutableMap.builder().put((Object)IS_ALL_NODE_PARA, (Object)"false").build()), request.getHeader("Authorization"));
            if (!dataList.isEmpty()) {
                try {
                    String sql = JsonParser.parseString((String)dataList.get(0)).getAsJsonObject().get("sql").getAsString();
                    querySql.put("sql", sql);
                    return ResponseEntityBuilder.ok(querySql);
                }
                catch (Exception e) {
                    LOG.warn("parse sql error: {}", (Object)dataList.get(0), (Object)e);
                }
            }
        } else {
            List queries = ProfileManager.getInstance().getAllQueries().stream().filter(query -> ((String)query.get(0)).equals(queryId)).collect(Collectors.toList());
            if (!queries.isEmpty()) {
                querySql.put("sql", (String)((List)queries.get(0)).get(3));
            }
        }
        return ResponseEntityBuilder.ok(querySql);
    }

    @RequestMapping(path={"/profile/text/{query_id}"}, method={RequestMethod.GET})
    public Object queryProfileText(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="query_id") String queryId, @RequestParam(value="is_all_node", required=false, defaultValue="true") boolean isAllNode) {
        this.executeCheckPassword(request, response);
        this.checkGlobalAuth(ConnectContext.get().getCurrentUserIdentity(), PrivPredicate.ADMIN);
        HashMap profileMap = Maps.newHashMap();
        if (isAllNode) {
            ImmutableMap arguments;
            String httpPath = "/rest/v2/manager/query/profile/text/" + queryId;
            List<String> dataList = this.requestAllFe(httpPath, (Map<String, String>)(arguments = ImmutableMap.builder().put((Object)IS_ALL_NODE_PARA, (Object)"false").build()), request.getHeader("Authorization"));
            if (!dataList.isEmpty()) {
                try {
                    String profile = JsonParser.parseString((String)dataList.get(0)).getAsJsonObject().get("profile").getAsString();
                    profileMap.put("profile", profile);
                    return ResponseEntityBuilder.ok(profileMap);
                }
                catch (Exception e) {
                    LOG.warn("parse profile text error: {}", (Object)dataList.get(0), (Object)e);
                }
            }
        } else {
            String profile = ProfileManager.getInstance().getProfile(queryId);
            if (!Strings.isNullOrEmpty((String)profile)) {
                profileMap.put("profile", profile);
            }
        }
        return ResponseEntityBuilder.ok(profileMap);
    }

    @RequestMapping(path={"/profile/fragments/{query_id}"}, method={RequestMethod.GET})
    public Object fragments(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="query_id") String queryId, @RequestParam(value="is_all_node", required=false, defaultValue="true") boolean isAllNode) {
        this.executeCheckPassword(request, response);
        this.checkGlobalAuth(ConnectContext.get().getCurrentUserIdentity(), PrivPredicate.ADMIN);
        if (isAllNode) {
            String httpPath = "/rest/v2/manager/query/profile/fragments/" + queryId;
            ImmutableMap arguments = ImmutableMap.builder().put((Object)IS_ALL_NODE_PARA, (Object)"false").build();
            List<Pair<String, Integer>> frontends = HttpUtils.getFeList();
            ImmutableMap header = ImmutableMap.builder().put((Object)"Authorization", (Object)request.getHeader("Authorization")).build();
            for (Pair<String, Integer> ipPort : frontends) {
                String url = HttpUtils.concatUrl(ipPort, httpPath, (Map<String, String>)arguments);
                try {
                    String responseJson = HttpUtils.doGet(url, (Map<String, String>)header);
                    int code = JsonParser.parseString((String)responseJson).getAsJsonObject().get("code").getAsInt();
                    if (code != 0) continue;
                    return responseJson;
                }
                catch (Exception e) {
                    LOG.warn((Object)e);
                }
            }
        } else {
            try {
                return ResponseEntityBuilder.ok(ProfileManager.getInstance().getFragmentsAndInstances(queryId));
            }
            catch (AnalysisException e) {
                return ResponseEntityBuilder.badRequest(e.getMessage());
            }
        }
        return ResponseEntityBuilder.badRequest("not found query id");
    }

    @RequestMapping(path={"/profile/graph/{query_id}"}, method={RequestMethod.GET})
    public Object queryProfileGraph(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="query_id") String queryId, @RequestParam(value="fragment_id", required=false) String fragmentId, @RequestParam(value="instance_id", required=false) String instanceId, @RequestParam(value="is_all_node", required=false, defaultValue="true") boolean isAllNode) {
        this.executeCheckPassword(request, response);
        this.checkGlobalAuth(ConnectContext.get().getCurrentUserIdentity(), PrivPredicate.ADMIN);
        HashMap graph = Maps.newHashMap();
        if (isAllNode) {
            String httpPath = "/rest/v2/manager/query/profile/graph/" + queryId;
            HashMap arguments = Maps.newHashMap();
            arguments.put(FRAGMENT_ID, fragmentId);
            arguments.put(INSTANCE_ID, instanceId);
            arguments.put(IS_ALL_NODE_PARA, "false");
            List<String> dataList = this.requestAllFe(httpPath, arguments, request.getHeader("Authorization"));
            if (!dataList.isEmpty()) {
                try {
                    String profileGraph = JsonParser.parseString((String)dataList.get(0)).getAsJsonObject().get("graph").getAsString();
                    graph.put("graph", profileGraph);
                    return ResponseEntityBuilder.ok(graph);
                }
                catch (Exception e) {
                    LOG.warn("parse profile graph error: {}", (Object)dataList.get(0), (Object)e);
                }
            }
        } else {
            try {
                ArrayList results;
                if (Strings.isNullOrEmpty((String)fragmentId) || Strings.isNullOrEmpty((String)instanceId)) {
                    ProfileTreeNode treeRoot = ProfileManager.getInstance().getFragmentProfileTree(queryId, queryId);
                    results = Lists.newArrayList((Object[])new String[]{ProfileTreePrinter.printFragmentTree(treeRoot)});
                } else {
                    ProfileTreeNode treeRoot = ProfileManager.getInstance().getInstanceProfileTree(queryId, queryId, fragmentId, instanceId);
                    results = Lists.newArrayList((Object[])new String[]{ProfileTreePrinter.printInstanceTree(treeRoot)});
                }
                graph.put("graph", (String)results.get(0));
            }
            catch (Exception e) {
                LOG.warn("get profile graph error, queryId:{}, fragementId:{}, instanceId:{}", (Object)queryId, (Object)fragmentId, (Object)instanceId, (Object)e);
            }
        }
        return ResponseEntityBuilder.ok(graph);
    }
}

