/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.rest.manager;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.ConfigBase;
import org.apache.doris.common.MarkedCountDownLatch;
import org.apache.doris.common.Pair;
import org.apache.doris.common.ThreadPoolManager;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.proc.ProcService;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.httpv2.rest.RestBaseController;
import org.apache.doris.httpv2.rest.SetConfigAction;
import org.apache.doris.httpv2.rest.manager.HttpUtils;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.system.Backend;
import org.apache.doris.system.Frontend;
import org.apache.doris.system.SystemInfoService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/v2/manager/node"})
public class NodeAction
extends RestBaseController {
    private static final Logger LOG = LogManager.getLogger(NodeAction.class);
    private static final Pattern PATTERN = Pattern.compile(":");
    public static final String AUTHORIZATION = "Authorization";
    private static final int HTTP_WAIT_TIME_SECONDS = 2;
    public static final String CONFIG = "\u914d\u7f6e\u9879";
    public static final String NODE_IP_PORT = "\u8282\u70b9";
    public static final String NODE_TYPE = "\u8282\u70b9\u7c7b\u578b";
    public static final String CONFIG_TYPE = "\u914d\u7f6e\u503c\u7c7b\u578b";
    public static final String MASTER_ONLY = "MasterOnly";
    public static final String CONFIG_VALUE = "\u914d\u7f6e\u503c";
    public static final String IS_MUTABLE = "\u53ef\u4fee\u6539";
    public static final ImmutableList<String> FE_CONFIG_TITLE_NAMES = new ImmutableList.Builder().add((Object)"\u914d\u7f6e\u9879").add((Object)"\u8282\u70b9").add((Object)"\u8282\u70b9\u7c7b\u578b").add((Object)"\u914d\u7f6e\u503c\u7c7b\u578b").add((Object)"MasterOnly").add((Object)"\u914d\u7f6e\u503c").add((Object)"\u53ef\u4fee\u6539").build();
    public static final ImmutableList<String> BE_CONFIG_TITLE_NAMES = new ImmutableList.Builder().add((Object)"\u914d\u7f6e\u9879").add((Object)"\u8282\u70b9").add((Object)"\u8282\u70b9\u7c7b\u578b").add((Object)"\u914d\u7f6e\u503c\u7c7b\u578b").add((Object)"\u914d\u7f6e\u503c").add((Object)"\u53ef\u4fee\u6539").build();
    private Object httpExecutorLock = new Object();
    private static volatile ExecutorService httpExecutor = null;

    @RequestMapping(path={"/frontends"}, method={RequestMethod.GET})
    public Object frontends_info(HttpServletRequest request, HttpServletResponse response) throws AnalysisException {
        this.executeCheckPassword(request, response);
        this.checkGlobalAuth(ConnectContext.get().getCurrentUserIdentity(), PrivPredicate.ADMIN);
        return this.fetchNodeInfo(request, response, "/frontends");
    }

    @RequestMapping(path={"/backends"}, method={RequestMethod.GET})
    public Object backends_info(HttpServletRequest request, HttpServletResponse response) throws AnalysisException {
        this.executeCheckPassword(request, response);
        this.checkGlobalAuth(ConnectContext.get().getCurrentUserIdentity(), PrivPredicate.ADMIN);
        return this.fetchNodeInfo(request, response, "/backends");
    }

    @RequestMapping(path={"/brokers"}, method={RequestMethod.GET})
    public Object brokers_info(HttpServletRequest request, HttpServletResponse response) throws AnalysisException {
        this.executeCheckPassword(request, response);
        this.checkGlobalAuth(ConnectContext.get().getCurrentUserIdentity(), PrivPredicate.ADMIN);
        return this.fetchNodeInfo(request, response, "/brokers");
    }

    private Object fetchNodeInfo(HttpServletRequest request, HttpServletResponse response, String procPath) throws AnalysisException {
        if (!Catalog.getCurrentCatalog().isMaster()) {
            return this.redirectToMaster(request, response);
        }
        try {
            ProcResult procResult = ProcService.getInstance().open(procPath).fetchResult();
            ArrayList columnNames = Lists.newArrayList(procResult.getColumnNames());
            return ResponseEntityBuilder.ok(new NodeInfo(columnNames, procResult.getRows()));
        }
        catch (Exception e) {
            LOG.warn((Object)e);
            throw e;
        }
    }

    @RequestMapping(path={"/configuration_name"}, method={RequestMethod.GET})
    public Object configurationName(HttpServletRequest request, HttpServletResponse response) {
        this.executeCheckPassword(request, response);
        this.checkGlobalAuth(ConnectContext.get().getCurrentUserIdentity(), PrivPredicate.ADMIN);
        HashMap result = Maps.newHashMap();
        try {
            result.put("frontend", Lists.newArrayList(Config.dump().keySet()));
            ArrayList beConfigNames = Lists.newArrayList();
            List<Long> beIds = Catalog.getCurrentSystemInfo().getBackendIds(true);
            if (!beIds.isEmpty()) {
                Backend be = Catalog.getCurrentSystemInfo().getBackend(beIds.get(0));
                String url = "http://" + be.getHost() + ":" + be.getHttpPort() + "/api/show_config";
                String questResult = HttpUtils.doGet(url, null);
                List configs = (List)GsonUtils.GSON.fromJson(questResult, new TypeToken<List<List<String>>>(){}.getType());
                for (List config : configs) {
                    beConfigNames.add((String)config.get(0));
                }
            }
            result.put("backend", beConfigNames);
        }
        catch (Exception e) {
            LOG.warn((Object)e);
            return ResponseEntityBuilder.internalError(e.getMessage());
        }
        return ResponseEntityBuilder.ok(result);
    }

    @RequestMapping(path={"/node_list"}, method={RequestMethod.GET})
    public Object nodeList(HttpServletRequest request, HttpServletResponse response) {
        this.executeCheckPassword(request, response);
        this.checkGlobalAuth(ConnectContext.get().getCurrentUserIdentity(), PrivPredicate.ADMIN);
        HashMap result = Maps.newHashMap();
        result.put("frontend", NodeAction.getFeList());
        result.put("backend", NodeAction.getBeList());
        return ResponseEntityBuilder.ok(result);
    }

    private static List<String> getFeList() {
        return Catalog.getCurrentCatalog().getFrontends(null).stream().map(fe -> fe.getHost() + ":" + Config.http_port).collect(Collectors.toList());
    }

    private static List<String> getBeList() {
        return Catalog.getCurrentSystemInfo().getBackendIds(false).stream().map(beId -> {
            Backend be = Catalog.getCurrentSystemInfo().getBackend((long)beId);
            return be.getHost() + ":" + be.getHttpPort();
        }).collect(Collectors.toList());
    }

    @RequestMapping(path={"/config"}, method={RequestMethod.GET})
    public Object config(HttpServletRequest request, HttpServletResponse response) {
        this.executeCheckPassword(request, response);
        this.checkGlobalAuth(ConnectContext.get().getCurrentUserIdentity(), PrivPredicate.ADMIN);
        List<List<String>> configs = ConfigBase.getConfigInfo(null);
        configs.sort(Comparator.comparing(o -> (String)o.get(0)));
        ArrayList results = Lists.newArrayList();
        for (List<String> config : configs) {
            ArrayList list = Lists.newArrayList();
            list.add(config.get(0));
            list.add(config.get(2));
            list.add(config.get(4));
            list.add(config.get(1));
            list.add(config.get(3));
            results.add(list);
        }
        return results;
    }

    @RequestMapping(path={"/configuration_info"}, method={RequestMethod.POST})
    public Object configurationInfo(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="type") String type, @RequestBody(required=false) ConfigInfoRequestBody requestBody) {
        this.executeCheckPassword(request, response);
        this.checkGlobalAuth(ConnectContext.get().getCurrentUserIdentity(), PrivPredicate.ADMIN);
        this.initHttpExecutor();
        if (requestBody == null) {
            requestBody = new ConfigInfoRequestBody();
        }
        if (type.equalsIgnoreCase("fe")) {
            List<Pair<String, Integer>> hostPorts = requestBody.getNodes() != null && !requestBody.getNodes().isEmpty() ? NodeAction.parseHostPort(requestBody.getNodes()) : NodeAction.parseHostPort(NodeAction.getFeList());
            ArrayList errNodes = Lists.newArrayList();
            List<List<String>> data = this.handleConfigurationInfo(hostPorts, request.getHeader(AUTHORIZATION), "/rest/v2/manager/node/config", "FE", requestBody.getConfNames(), errNodes);
            if (!errNodes.isEmpty()) {
                LOG.warn("Failed to get fe node configuration information from:{}", (Object)((Object)errNodes).toString());
            }
            return ResponseEntityBuilder.ok(new NodeInfo((List<String>)FE_CONFIG_TITLE_NAMES, data));
        }
        if (type.equalsIgnoreCase("be")) {
            List<Pair<String, Integer>> hostPorts = requestBody.getNodes() != null && !requestBody.getNodes().isEmpty() ? NodeAction.parseHostPort(requestBody.getNodes()) : NodeAction.parseHostPort(NodeAction.getBeList());
            ArrayList errNodes = Lists.newArrayList();
            List<List<String>> data = this.handleConfigurationInfo(hostPorts, request.getHeader(AUTHORIZATION), "/api/show_config", "BE", requestBody.getConfNames(), errNodes);
            if (!errNodes.isEmpty()) {
                LOG.warn("Failed to get be node configuration information from:{}", (Object)((Object)errNodes).toString());
            }
            return ResponseEntityBuilder.ok(new NodeInfo((List<String>)BE_CONFIG_TITLE_NAMES, data));
        }
        return ResponseEntityBuilder.badRequest("Unsupported type: " + type + ". Only types of fe or be are supported");
    }

    private List<List<String>> handleConfigurationInfo(List<Pair<String, Integer>> hostPorts, String authorization, String questPath, String nodeType, List<String> confNames, List<Map.Entry<String, Integer>> errNodes) {
        ArrayList configInfoTotal = Lists.newArrayList();
        MarkedCountDownLatch<String, Integer> configRequestDoneSignal = new MarkedCountDownLatch<String, Integer>(hostPorts.size());
        for (int i = 0; i < hostPorts.size(); ++i) {
            configInfoTotal.add(Lists.newArrayList());
            Pair<String, Integer> hostPort = hostPorts.get(i);
            configRequestDoneSignal.addMark((String)hostPort.first + ":" + hostPort.second, -1);
            String url = "http://" + (String)hostPort.first + ":" + hostPort.second + questPath;
            httpExecutor.submit(new HttpConfigInfoTask(url, hostPort, authorization, nodeType, confNames, configRequestDoneSignal, (List)configInfoTotal.get(i)));
        }
        ArrayList resultConfigs = Lists.newArrayList();
        try {
            configRequestDoneSignal.await(2L, TimeUnit.SECONDS);
            for (List lists : configInfoTotal) {
                resultConfigs.addAll(lists);
            }
        }
        catch (InterruptedException e) {
            errNodes.addAll(configRequestDoneSignal.getLeftMarks());
        }
        return resultConfigs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initHttpExecutor() {
        if (httpExecutor == null) {
            Object object = this.httpExecutorLock;
            synchronized (object) {
                if (httpExecutor == null) {
                    httpExecutor = ThreadPoolManager.newDaemonFixedThreadPool(5, 100, "node-config-update-pool", true);
                }
            }
        }
    }

    static List<Pair<String, Integer>> parseHostPort(List<String> nodes) {
        ArrayList hostPorts = Lists.newArrayList();
        for (String node : nodes) {
            try {
                Pair<String, Integer> ipPort = SystemInfoService.validateHostAndPort(node);
                hostPorts.add(ipPort);
            }
            catch (Exception e) {
                LOG.warn((Object)e);
            }
        }
        return hostPorts;
    }

    @RequestMapping(path={"/set_config/fe"}, method={RequestMethod.POST})
    public Object setConfigFe(HttpServletRequest request, HttpServletResponse response, @RequestBody Map<String, SetConfigRequestBody> requestBody) {
        this.executeCheckPassword(request, response);
        this.checkGlobalAuth(ConnectContext.get().getCurrentUserIdentity(), PrivPredicate.ADMIN);
        ArrayList failedTotal = Lists.newArrayList();
        List<NodeConfigs> nodeConfigList = this.parseSetConfigNodes(requestBody, failedTotal);
        List<Pair<String, Integer>> aliveFe = Catalog.getCurrentCatalog().getFrontends(null).stream().filter(Frontend::isAlive).map(fe -> new Pair<String, Integer>(fe.getHost(), Config.http_port)).collect(Collectors.toList());
        this.checkNodeIsAlive(nodeConfigList, aliveFe, failedTotal);
        HashMap header = Maps.newHashMap();
        header.put(AUTHORIZATION, request.getHeader(AUTHORIZATION));
        for (NodeConfigs nodeConfigs : nodeConfigList) {
            String url;
            if (!nodeConfigs.getConfigs(true).isEmpty()) {
                url = this.concatFeSetConfigUrl(nodeConfigs, true);
                try {
                    String responsePersist = HttpUtils.doGet(url, header);
                    this.parseFeSetConfigResponse(responsePersist, nodeConfigs.getHostPort(), failedTotal);
                }
                catch (Exception e) {
                    this.addSetConfigErrNode(nodeConfigs.getConfigs(true), nodeConfigs.getHostPort(), e.getMessage(), failedTotal);
                }
            }
            if (nodeConfigs.getConfigs(false).isEmpty()) continue;
            url = this.concatFeSetConfigUrl(nodeConfigs, false);
            try {
                String responseTemp = HttpUtils.doGet(url, header);
                this.parseFeSetConfigResponse(responseTemp, nodeConfigs.getHostPort(), failedTotal);
            }
            catch (Exception e) {
                this.addSetConfigErrNode(nodeConfigs.getConfigs(false), nodeConfigs.getHostPort(), e.getMessage(), failedTotal);
            }
        }
        HashMap data = Maps.newHashMap();
        data.put("failed", failedTotal);
        return ResponseEntityBuilder.ok(data);
    }

    private void addSetConfigErrNode(Map<String, String> configs, Pair<String, Integer> hostPort, String err, List<Map<String, String>> failedTotal) {
        for (Map.Entry<String, String> entry : configs.entrySet()) {
            HashMap failed = Maps.newHashMap();
            NodeAction.addFailedConfig(entry.getKey(), entry.getValue(), (String)hostPort.first + ":" + hostPort.second, err, failed);
            failedTotal.add(failed);
        }
    }

    private void parseFeSetConfigResponse(String response, Pair<String, Integer> hostPort, List<Map<String, String>> failedTotal) throws Exception {
        JsonObject jsonObject = JsonParser.parseString((String)response).getAsJsonObject();
        if (jsonObject.get("code").getAsInt() != 0) {
            throw new Exception(jsonObject.get("msg").getAsString());
        }
        SetConfigAction.SetConfigEntity setConfigEntity = (SetConfigAction.SetConfigEntity)GsonUtils.GSON.fromJson((JsonElement)jsonObject.get("data").getAsJsonObject(), SetConfigAction.SetConfigEntity.class);
        for (SetConfigAction.ErrConfig errConfig : setConfigEntity.getErrConfigs()) {
            HashMap failed = Maps.newHashMap();
            NodeAction.addFailedConfig(errConfig.getConfigName(), errConfig.getConfigValue(), (String)hostPort.first + ":" + hostPort.second, errConfig.getErrInfo(), failed);
            failedTotal.add(failed);
        }
    }

    private static void addFailedConfig(String configName, String value, String node, String errInfo, Map<String, String> failed) {
        failed.put("config_name", configName);
        failed.put("value", value);
        failed.put("node", node);
        failed.put("err_info", errInfo);
    }

    private String concatFeSetConfigUrl(NodeConfigs nodeConfigs, boolean isPersist) {
        StringBuffer sb = new StringBuffer();
        Pair<String, Integer> hostPort = nodeConfigs.getHostPort();
        sb.append("http://").append((String)hostPort.first).append(":").append(hostPort.second).append("/api/_set_config");
        Map<String, String> configs = nodeConfigs.getConfigs(isPersist);
        boolean addAnd = false;
        for (Map.Entry<String, String> entry : configs.entrySet()) {
            if (addAnd) {
                sb.append("&");
            } else {
                sb.append("?");
                addAnd = true;
            }
            sb.append(entry.getKey()).append("=").append(entry.getValue());
        }
        if (isPersist) {
            sb.append("&persist=true&reset_persist=false");
        }
        return sb.toString();
    }

    @RequestMapping(path={"/set_config/be"}, method={RequestMethod.POST})
    public Object setConfigBe(HttpServletRequest request, HttpServletResponse response, @RequestBody Map<String, SetConfigRequestBody> requestBody) {
        this.executeCheckPassword(request, response);
        this.checkGlobalAuth(ConnectContext.get().getCurrentUserIdentity(), PrivPredicate.ADMIN);
        List<Object> failedTotal = Lists.newArrayList();
        List<NodeConfigs> nodeConfigList = this.parseSetConfigNodes(requestBody, failedTotal);
        List<Pair<String, Integer>> aliveBe = Catalog.getCurrentSystemInfo().getBackendIds(true).stream().map(beId -> {
            Backend be = Catalog.getCurrentSystemInfo().getBackend((long)beId);
            return new Pair<String, Integer>(be.getHost(), be.getHttpPort());
        }).collect(Collectors.toList());
        this.checkNodeIsAlive(nodeConfigList, aliveBe, failedTotal);
        this.handleBeSetConfig(nodeConfigList, request.getHeader(AUTHORIZATION), failedTotal);
        failedTotal = failedTotal.stream().filter(e -> !e.isEmpty()).collect(Collectors.toList());
        HashMap data = Maps.newHashMap();
        data.put("failed", failedTotal);
        return ResponseEntityBuilder.ok(data);
    }

    private List<NodeConfigs> parseSetConfigNodes(Map<String, SetConfigRequestBody> requestBody, List<Map<String, String>> errNodes) {
        ArrayList nodeConfigsList = Lists.newArrayList();
        for (String configName : requestBody.keySet()) {
            SetConfigRequestBody configPara = requestBody.get(configName);
            String value = configPara.getValue();
            boolean persist = configPara.isPersist();
            if (value == null || configPara.getNodes() == null) continue;
            for (String node : configPara.getNodes()) {
                Pair<String, Integer> ipPort;
                try {
                    ipPort = SystemInfoService.validateHostAndPort(node);
                }
                catch (Exception e) {
                    HashMap failed = Maps.newHashMap();
                    NodeAction.addFailedConfig(configName, configPara.getValue(), node, "node invalid", failed);
                    errNodes.add(failed);
                    continue;
                }
                boolean find = false;
                for (NodeConfigs nodeConfigs : nodeConfigsList) {
                    Pair<String, Integer> hostPort = nodeConfigs.getHostPort();
                    if (!((String)ipPort.first).equals(hostPort.first) || !((Integer)ipPort.second).equals(hostPort.second)) continue;
                    find = true;
                    nodeConfigs.addConfig(configName, value, persist);
                }
                if (find) continue;
                NodeConfigs newNodeConfigs = new NodeConfigs((String)ipPort.first, (Integer)ipPort.second);
                nodeConfigsList.add(newNodeConfigs);
                newNodeConfigs.addConfig(configName, value, persist);
            }
        }
        return nodeConfigsList;
    }

    private void checkNodeIsAlive(List<NodeConfigs> nodeConfigsList, List<Pair<String, Integer>> aliveNodes, List<Map<String, String>> failedNodes) {
        Iterator<NodeConfigs> it = nodeConfigsList.iterator();
        while (it.hasNext()) {
            NodeConfigs node = it.next();
            boolean isExist = false;
            for (Pair<String, Integer> aliveHostPort : aliveNodes) {
                if (!((String)aliveHostPort.first).equals(node.getHostPort().first) || !((Integer)aliveHostPort.second).equals(node.getHostPort().second)) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            this.addSetConfigErrNode(node.getConfigs(true), node.getHostPort(), "Node does not exist or is not alive", failedNodes);
            this.addSetConfigErrNode(node.getConfigs(false), node.getHostPort(), "Node does not exist or is not alive", failedNodes);
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, String>> handleBeSetConfig(List<NodeConfigs> nodeConfigList, String authorization, List<Map<String, String>> failedTotal) {
        this.initHttpExecutor();
        int configNum = nodeConfigList.stream().mapToInt(e -> e.getConfigs(true).size() + e.getConfigs(false).size()).sum();
        MarkedCountDownLatch<String, Integer> beSetConfigCountDownSignal = new MarkedCountDownLatch<String, Integer>(configNum);
        for (NodeConfigs nodeConfigs : nodeConfigList) {
            this.submitBeSetConfigTask(nodeConfigs, true, authorization, beSetConfigCountDownSignal, failedTotal);
            this.submitBeSetConfigTask(nodeConfigs, false, authorization, beSetConfigCountDownSignal, failedTotal);
        }
        try {
            beSetConfigCountDownSignal.await(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e2) {
            LOG.warn("set be config exception:", (Throwable)e2);
        }
        finally {
            List leftNode = beSetConfigCountDownSignal.getLeftMarks();
            for (Map.Entry failedNode : leftNode) {
                Map<String, String> failed = this.parseNodeConfig((String)failedNode.getKey());
                if (failed.isEmpty()) continue;
                failed.put("err_info", "Connection timeout");
                failedTotal.add(failed);
            }
        }
        return failedTotal;
    }

    private void submitBeSetConfigTask(NodeConfigs nodeConfigs, boolean isPersist, String authorization, MarkedCountDownLatch<String, Integer> beSetConfigCountDownSignal, List<Map<String, String>> failedTotal) {
        if (!nodeConfigs.getConfigs(isPersist).isEmpty()) {
            for (Map.Entry<String, String> entry : nodeConfigs.getConfigs(isPersist).entrySet()) {
                failedTotal.add(Maps.newHashMap());
                Pair<String, Integer> hostPort = nodeConfigs.getHostPort();
                beSetConfigCountDownSignal.addMark(this.concatNodeConfig((String)hostPort.first, (Integer)hostPort.second, entry.getKey(), entry.getValue()), -1);
                String url = this.concatBeSetConfigUrl((String)hostPort.first, (Integer)hostPort.second, entry.getKey(), entry.getValue(), isPersist);
                httpExecutor.submit(new HttpSetConfigTask(url, hostPort, authorization, entry.getKey(), entry.getValue(), beSetConfigCountDownSignal, failedTotal.get(failedTotal.size() - 1)));
            }
        }
    }

    private String concatBeSetConfigUrl(String host, Integer port, String configName, String configValue, boolean isPersist) {
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append("http://").append(host).append(":").append(port).append("/api/update_config").append("?").append(configName).append("=").append(configValue);
        if (isPersist) {
            stringBuffer.append("&persist=true");
        }
        return stringBuffer.toString();
    }

    private String concatNodeConfig(String host, Integer port, String configName, String configValue) {
        return host + ":" + port + ":" + configName + ":" + configValue;
    }

    private Map<String, String> parseNodeConfig(String nodeConfig) {
        HashMap map = Maps.newHashMap();
        String[] splitStrings = PATTERN.split(nodeConfig);
        if (splitStrings.length == 4) {
            NodeAction.addFailedConfig(splitStrings[2], splitStrings[3], splitStrings[0] + ":" + splitStrings[1], "", map);
        }
        return map;
    }

    public static class SetConfigRequestBody {
        @JsonProperty(value="node")
        private List<String> nodes;
        private String value;
        private boolean persist;

        public List<String> getNodes() {
            return this.nodes;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isPersist() {
            return this.persist;
        }

        @JsonProperty(value="node")
        public void setNodes(List<String> nodes) {
            this.nodes = nodes;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setPersist(boolean persist) {
            this.persist = persist;
        }
    }

    public static class ConfigInfoRequestBody {
        @JsonProperty(value="conf_name")
        public List<String> confNames;
        @JsonProperty(value="node")
        public List<String> nodes;

        public List<String> getConfNames() {
            return this.confNames;
        }

        public List<String> getNodes() {
            return this.nodes;
        }

        @JsonProperty(value="conf_name")
        public void setConfNames(List<String> confNames) {
            this.confNames = confNames;
        }

        @JsonProperty(value="node")
        public void setNodes(List<String> nodes) {
            this.nodes = nodes;
        }
    }

    public static class NodeConfigs {
        private Pair<String, Integer> hostPort;
        private Map<String, String> persistConfigs;
        private Map<String, String> nonPersistConfigs;

        public NodeConfigs(String host, Integer httpPort) {
            this.hostPort = new Pair<String, Integer>(host, httpPort);
            this.persistConfigs = Maps.newHashMap();
            this.nonPersistConfigs = Maps.newHashMap();
        }

        public Pair<String, Integer> getHostPort() {
            return this.hostPort;
        }

        public void addConfig(String name, String value, boolean persist) {
            if (persist) {
                this.persistConfigs.put(name, value);
            } else {
                this.nonPersistConfigs.put(name, value);
            }
        }

        public Map<String, String> getConfigs(boolean isPersist) {
            return isPersist ? this.persistConfigs : this.nonPersistConfigs;
        }
    }

    private class HttpSetConfigTask
    implements Runnable {
        private String url;
        private Pair<String, Integer> hostPort;
        private String authorization;
        private String configName;
        private String configValue;
        private MarkedCountDownLatch<String, Integer> beSetConfigDoneSignal;
        private Map<String, String> failed;

        public HttpSetConfigTask(String url, Pair<String, Integer> hostPort, String authorization, String configName, String configValue, MarkedCountDownLatch<String, Integer> beSetConfigDoneSignal, Map<String, String> failed) {
            this.url = url;
            this.hostPort = hostPort;
            this.authorization = authorization;
            this.configName = configName;
            this.configValue = configValue;
            this.beSetConfigDoneSignal = beSetConfigDoneSignal;
            this.failed = failed;
        }

        @Override
        public void run() {
            try {
                String response = HttpUtils.doPost(this.url, (Map<String, String>)ImmutableMap.builder().put((Object)NodeAction.AUTHORIZATION, (Object)this.authorization).build(), null);
                JsonObject jsonObject = JsonParser.parseString((String)response).getAsJsonObject();
                String status = jsonObject.get("status").getAsString();
                if (!status.equals("OK")) {
                    NodeAction.addFailedConfig(this.configName, this.configValue, (String)this.hostPort.first + ":" + this.hostPort.second, jsonObject.get("msg").getAsString(), this.failed);
                }
                this.beSetConfigDoneSignal.markedCountDown(NodeAction.this.concatNodeConfig((String)this.hostPort.first, (Integer)this.hostPort.second, this.configName, this.configValue), -1);
            }
            catch (Exception e) {
                LOG.warn("set be:{} config:{} failed.", (Object)((String)this.hostPort.first + ":" + this.hostPort.second), (Object)(this.configName + "=" + this.configValue), (Object)e);
                this.beSetConfigDoneSignal.countDown();
            }
        }
    }

    private class HttpConfigInfoTask
    implements Runnable {
        private String url;
        private Pair<String, Integer> hostPort;
        private String authorization;
        private String nodeType;
        private List<String> confNames;
        private MarkedCountDownLatch<String, Integer> configRequestDoneSignal;
        private List<List<String>> config;

        public HttpConfigInfoTask(String url, Pair<String, Integer> hostPort, String authorization, String nodeType, List<String> confNames, MarkedCountDownLatch<String, Integer> configRequestDoneSignal, List<List<String>> config) {
            this.url = url;
            this.hostPort = hostPort;
            this.authorization = authorization;
            this.nodeType = nodeType;
            this.confNames = confNames;
            this.configRequestDoneSignal = configRequestDoneSignal;
            this.config = config;
        }

        @Override
        public void run() {
            try {
                String configInfo = HttpUtils.doGet(this.url, (Map<String, String>)ImmutableMap.builder().put((Object)NodeAction.AUTHORIZATION, (Object)this.authorization).build());
                List configs = (List)GsonUtils.GSON.fromJson(configInfo, new TypeToken<List<List<String>>>(){}.getType());
                for (List conf : configs) {
                    if (this.confNames != null && !this.confNames.isEmpty() && !this.confNames.contains(conf.get(0))) continue;
                    this.addConfig(conf);
                }
                this.configRequestDoneSignal.markedCountDown((String)this.hostPort.first + ":" + this.hostPort.second, -1);
            }
            catch (Exception e) {
                LOG.warn("get config from {}:{} failed.", this.hostPort.first, this.hostPort.second, (Object)e);
                this.configRequestDoneSignal.countDown();
            }
        }

        private void addConfig(List<String> conf) {
            conf.add(1, (String)this.hostPort.first + ":" + this.hostPort.second);
            conf.add(2, this.nodeType);
            this.config.add(conf);
        }
    }

    public static class NodeInfo {
        public List<String> column_names;
        public List<List<String>> rows;

        public NodeInfo(List<String> column_names, List<List<String>> rows) {
            this.column_names = column_names;
            this.rows = rows;
        }

        public List<String> getColumn_names() {
            return this.column_names;
        }

        public List<List<String>> getRows() {
            return this.rows;
        }

        public void setColumn_names(List<String> column_names) {
            this.column_names = column_names;
        }

        public void setRows(List<List<String>> rows) {
            this.rows = rows;
        }
    }
}

