/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.rest.manager;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.Config;
import org.apache.doris.common.Pair;
import org.apache.doris.httpv2.entity.ResponseBody;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.doris.system.Frontend;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.parquet.Strings;

public class HttpUtils {
    static final int REQUEST_SUCCESS_CODE = 0;

    static List<Pair<String, Integer>> getFeList() {
        return Catalog.getCurrentCatalog().getFrontends(null).stream().filter(Frontend::isAlive).map(fe -> new Pair<String, Integer>(fe.getHost(), Config.http_port)).collect(Collectors.toList());
    }

    static String concatUrl(Pair<String, Integer> ipPort, String path, Map<String, String> arguments) {
        StringBuilder url = new StringBuilder("http://").append((String)ipPort.first).append(":").append(ipPort.second).append(path);
        boolean isFirst = true;
        for (Map.Entry<String, String> entry : arguments.entrySet()) {
            if (Strings.isNullOrEmpty((String)entry.getValue())) continue;
            if (isFirst) {
                url.append("?");
            } else {
                url.append("&");
            }
            isFirst = false;
            url.append(entry.getKey()).append("=").append(entry.getValue());
        }
        return url.toString();
    }

    static String doGet(String url, Map<String, String> headers) throws IOException {
        HttpGet httpGet = new HttpGet(url);
        HttpUtils.setRequestConfig((HttpRequestBase)httpGet, headers);
        return HttpUtils.executeRequest((HttpRequestBase)httpGet);
    }

    static String doPost(String url, Map<String, String> headers, Object body) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        if (Objects.nonNull(body)) {
            String jsonString = GsonUtils.GSON.toJson(body);
            StringEntity stringEntity = new StringEntity(jsonString, "UTF-8");
            httpPost.setEntity((HttpEntity)stringEntity);
        }
        HttpUtils.setRequestConfig((HttpRequestBase)httpPost, headers);
        return HttpUtils.executeRequest((HttpRequestBase)httpPost);
    }

    private static void setRequestConfig(HttpRequestBase request, Map<String, String> headers) {
        if (null != headers) {
            for (String key : headers.keySet()) {
                request.setHeader(key, headers.get(key));
            }
        }
        RequestConfig config = RequestConfig.custom().setConnectTimeout(2000).setConnectionRequestTimeout(2000).setSocketTimeout(2000).build();
        request.setConfig(config);
    }

    private static String executeRequest(HttpRequestBase request) throws IOException {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        return (String)client.execute((HttpUriRequest)request, httpResponse -> EntityUtils.toString((HttpEntity)httpResponse.getEntity()));
    }

    static String parseResponse(String response) {
        ResponseBody responseEntity = (ResponseBody)GsonUtils.GSON.fromJson(response, new TypeToken<ResponseBody>(){}.getType());
        if (responseEntity.getCode() != 0) {
            throw new RuntimeException(responseEntity.getMsg());
        }
        return GsonUtils.GSON.toJson(responseEntity.getData());
    }
}

