/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.rest.manager;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.Config;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.httpv2.rest.RestBaseController;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.system.Frontend;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/v2/manager/cluster"})
public class ClusterAction
extends RestBaseController {
    @RequestMapping(path={"/cluster_info/conn_info"}, method={RequestMethod.GET})
    public Object clusterInfo(HttpServletRequest request, HttpServletResponse response) {
        this.executeCheckPassword(request, response);
        this.checkGlobalAuth(ConnectContext.get().getCurrentUserIdentity(), PrivPredicate.ADMIN);
        HashMap result = Maps.newHashMap();
        List frontends = Catalog.getCurrentCatalog().getFrontends(null).stream().filter(Frontend::isAlive).map(Frontend::getHost).collect(Collectors.toList());
        result.put("mysql", frontends.stream().map(ip -> ip + ":" + Config.query_port).collect(Collectors.toList()));
        result.put("http", frontends.stream().map(ip -> ip + ":" + Config.http_port).collect(Collectors.toList()));
        return ResponseEntityBuilder.ok(result);
    }
}

