/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.rest;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.common.Config;
import org.apache.doris.httpv2.controller.BaseController;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.httpv2.rest.RestBaseController;
import org.apache.doris.httpv2.util.LoadSubmitter;
import org.apache.doris.httpv2.util.TmpFileMgr;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class UploadAction
extends RestBaseController {
    private static final Logger LOG = LogManager.getLogger(UploadAction.class);
    private static TmpFileMgr fileMgr = new TmpFileMgr(Config.tmp_dir);
    private static LoadSubmitter loadSubmitter = new LoadSubmitter();
    private static final String PARAM_COLUMN_SEPARATOR = "column_separator";
    private static final String PARAM_PREVIEW = "preview";
    private static final String PARAM_FILE_ID = "file_id";
    private static final String PARAM_FILE_UUID = "file_uuid";

    @RequestMapping(path={"/api/{ns}/{db}/{table}/upload"}, method={RequestMethod.POST})
    public Object upload(@PathVariable(value="ns") String ns, @PathVariable(value="db") String dbName, @PathVariable(value="table") String tblName, @RequestParam(value="file") MultipartFile file, HttpServletRequest request, HttpServletResponse response) {
        String preview;
        this.checkWithCookie(request, response, false);
        if (!ns.equalsIgnoreCase("default_cluster")) {
            return ResponseEntityBuilder.badRequest("Only support 'default_cluster' now");
        }
        String fullDbName = this.getFullDbName(dbName);
        this.checkTblAuth(ConnectContext.get().getCurrentUserIdentity(), fullDbName, tblName, PrivPredicate.LOAD);
        String columnSeparator = request.getParameter(PARAM_COLUMN_SEPARATOR);
        if (Strings.isNullOrEmpty((String)columnSeparator)) {
            columnSeparator = "\t";
        }
        if (Strings.isNullOrEmpty((String)(preview = request.getParameter(PARAM_PREVIEW)))) {
            preview = "false";
        }
        if (file.isEmpty()) {
            return ResponseEntityBuilder.badRequest("Empty file");
        }
        try {
            TmpFileMgr.TmpFile tmpFile = fileMgr.upload(new TmpFileMgr.UploadFile(file, columnSeparator));
            TmpFileMgr.TmpFile copiedFile = tmpFile.copy();
            if (preview.equalsIgnoreCase("true")) {
                copiedFile.setPreview();
            }
            return ResponseEntityBuilder.ok(copiedFile);
        }
        catch (IOException | TmpFileMgr.TmpFileException e) {
            return ResponseEntityBuilder.okWithCommonError(e.getMessage());
        }
    }

    @RequestMapping(path={"/api/{ns}/{db}/{table}/upload"}, method={RequestMethod.PUT})
    public Object submit(@PathVariable(value="ns") String ns, @PathVariable(value="db") String dbName, @PathVariable(value="table") String tblName, HttpServletRequest request, HttpServletResponse response) {
        BaseController.ActionAuthorizationInfo authInfo = this.checkWithCookie(request, response, false);
        if (!ns.equalsIgnoreCase("default_cluster")) {
            return ResponseEntityBuilder.badRequest("Only support 'default_cluster' now");
        }
        String fullDbName = this.getFullDbName(dbName);
        this.checkTblAuth(ConnectContext.get().getCurrentUserIdentity(), fullDbName, tblName, PrivPredicate.LOAD);
        String fileIdStr = request.getParameter(PARAM_FILE_ID);
        if (Strings.isNullOrEmpty((String)fileIdStr)) {
            return ResponseEntityBuilder.badRequest("Missing file id parameter");
        }
        String fileUUIDStr = request.getParameter(PARAM_FILE_UUID);
        if (Strings.isNullOrEmpty((String)fileUUIDStr)) {
            return ResponseEntityBuilder.badRequest("Missing file id parameter");
        }
        TmpFileMgr.TmpFile tmpFile = null;
        try {
            tmpFile = fileMgr.getFile(Long.valueOf(fileIdStr), fileUUIDStr);
        }
        catch (TmpFileMgr.TmpFileException e) {
            return ResponseEntityBuilder.okWithCommonError("file not found");
        }
        Preconditions.checkNotNull((Object)tmpFile, (Object)fileIdStr);
        LoadContext loadContext = new LoadContext(request, dbName, tblName, authInfo.fullUserName, authInfo.password, tmpFile);
        Future<LoadSubmitter.SubmitResult> future = loadSubmitter.submit(loadContext);
        try {
            LoadSubmitter.SubmitResult res = future.get();
            return ResponseEntityBuilder.ok(res);
        }
        catch (InterruptedException | ExecutionException e) {
            return ResponseEntityBuilder.okWithCommonError(e.getMessage());
        }
    }

    @RequestMapping(path={"/api/{ns}/{db}/{table}/upload"}, method={RequestMethod.GET})
    public Object list(@PathVariable(value="ns") String ns, @PathVariable(value="db") String dbName, @PathVariable(value="table") String tblName, HttpServletRequest request, HttpServletResponse response) {
        this.checkWithCookie(request, response, false);
        if (!ns.equalsIgnoreCase("default_cluster")) {
            return ResponseEntityBuilder.badRequest("Only support 'default_cluster' now");
        }
        String fullDbName = this.getFullDbName(dbName);
        this.checkTblAuth(ConnectContext.get().getCurrentUserIdentity(), fullDbName, tblName, PrivPredicate.LOAD);
        String fileIdStr = request.getParameter(PARAM_FILE_ID);
        String fileUUIDStr = request.getParameter(PARAM_FILE_UUID);
        if (Strings.isNullOrEmpty((String)fileIdStr) || Strings.isNullOrEmpty((String)fileUUIDStr)) {
            List<TmpFileMgr.TmpFileBrief> files = fileMgr.listFiles();
            return ResponseEntityBuilder.ok(files);
        }
        String preview = request.getParameter(PARAM_PREVIEW);
        if (Strings.isNullOrEmpty((String)preview)) {
            preview = "true";
        }
        try {
            TmpFileMgr.TmpFile tmpFile = fileMgr.getFile(Long.valueOf(fileIdStr), fileUUIDStr);
            TmpFileMgr.TmpFile copiedFile = tmpFile.copy();
            if (preview.equalsIgnoreCase("true")) {
                copiedFile.setPreview();
            }
            return ResponseEntityBuilder.ok(copiedFile);
        }
        catch (IOException | TmpFileMgr.TmpFileException e) {
            return ResponseEntityBuilder.okWithCommonError(e.getMessage());
        }
    }

    @RequestMapping(path={"/api/{ns}/{db}/{table}/upload"}, method={RequestMethod.DELETE})
    public Object delete(@PathVariable(value="ns") String ns, @PathVariable(value="db") String dbName, @PathVariable(value="table") String tblName, HttpServletRequest request, HttpServletResponse response) {
        this.checkWithCookie(request, response, false);
        if (!ns.equalsIgnoreCase("default_cluster")) {
            return ResponseEntityBuilder.badRequest("Only support 'default_cluster' now");
        }
        String fullDbName = this.getFullDbName(dbName);
        this.checkTblAuth(ConnectContext.get().getCurrentUserIdentity(), fullDbName, tblName, PrivPredicate.LOAD);
        String fileIdStr = request.getParameter(PARAM_FILE_ID);
        if (Strings.isNullOrEmpty((String)fileIdStr)) {
            return ResponseEntityBuilder.badRequest("Missing file id parameter");
        }
        String fileUUIDStr = request.getParameter(PARAM_FILE_UUID);
        if (Strings.isNullOrEmpty((String)fileUUIDStr)) {
            return ResponseEntityBuilder.badRequest("Missing file id parameter");
        }
        fileMgr.deleteFile(Long.valueOf(fileIdStr), fileUUIDStr);
        return ResponseEntityBuilder.ok();
    }

    public static class LoadContext {
        public String user;
        public String passwd;
        public String db;
        public String tbl;
        public TmpFileMgr.TmpFile file;
        public String label;
        public String columnSeparator;
        public String columns;
        public String where;
        public String maxFilterRatio;
        public String partitions;
        public String timeout;
        public String strictMode;
        public String timezone;
        public String execMemLimit;
        public String format;
        public String jsonPaths;
        public String stripOuterArray;
        public String jsonRoot;
        public String numAsString;
        public String fuzzyParse;

        public LoadContext(HttpServletRequest request, String db, String tbl, String user, String passwd, TmpFileMgr.TmpFile file) {
            this.db = db;
            this.tbl = tbl;
            this.user = user;
            this.passwd = passwd;
            this.file = file;
            this.parseHeader(request);
        }

        private void parseHeader(HttpServletRequest request) {
            this.label = request.getHeader("label");
            this.columnSeparator = this.file.columnSeparator;
            if (!Strings.isNullOrEmpty((String)request.getHeader(UploadAction.PARAM_COLUMN_SEPARATOR))) {
                this.columnSeparator = request.getHeader(UploadAction.PARAM_COLUMN_SEPARATOR);
            }
            this.columns = request.getHeader("columns");
            this.where = request.getHeader("where");
            this.maxFilterRatio = request.getHeader("max_filter_ratio");
            this.partitions = request.getHeader("partitions");
            this.timeout = request.getHeader("timeout");
            this.strictMode = request.getHeader("strict_mode");
            this.timezone = request.getHeader("timezone");
            this.execMemLimit = request.getHeader("exec_mem_limit");
            this.format = request.getHeader("format");
            this.jsonPaths = request.getHeader("jsonpaths");
            this.stripOuterArray = request.getHeader("strip_outer_array");
            this.numAsString = request.getHeader("num_as_string");
            this.jsonRoot = request.getHeader("json_root");
            this.fuzzyParse = request.getHeader("fuzzy_parse");
        }
    }
}

