/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.rest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.catalog.AggregateType;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.DorisHttpException;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.httpv2.rest.RestBaseController;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TableSchemaAction
extends RestBaseController {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(path={"/api/{db}/{table}/_schema"}, method={RequestMethod.GET})
    protected Object schema(@PathVariable(value="db") String dbName, @PathVariable(value="table") String tblName, HttpServletRequest request, HttpServletResponse response) {
        this.executeCheckPassword(request, response);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        try {
            OlapTable table;
            String fullDbName = this.getFullDbName(dbName);
            this.checkTblAuth(ConnectContext.get().getCurrentUserIdentity(), fullDbName, tblName, PrivPredicate.SELECT);
            try {
                Database db = Catalog.getCurrentCatalog().getDbOrMetaException(fullDbName);
                table = (OlapTable)db.getTableOrMetaException(tblName, Table.TableType.OLAP);
            }
            catch (MetaNotFoundException e) {
                return ResponseEntityBuilder.okWithCommonError(e.getMessage());
            }
            table.readLock();
            try {
                try {
                    List<Column> columns = table.getBaseSchema();
                    ArrayList propList = new ArrayList(columns.size());
                    for (Column column : columns) {
                        HashMap<String, String> baseInfo = new HashMap<String, String>(2);
                        Type colType = column.getOriginType();
                        PrimitiveType primitiveType = colType.getPrimitiveType();
                        if (primitiveType == PrimitiveType.DECIMALV2) {
                            ScalarType scalarType = (ScalarType)colType;
                            baseInfo.put("precision", scalarType.getPrecision() + "");
                            baseInfo.put("scale", scalarType.getScalarScale() + "");
                        }
                        baseInfo.put("type", primitiveType.toString());
                        baseInfo.put("comment", column.getComment());
                        baseInfo.put("name", column.getDisplayName());
                        Optional<AggregateType> aggregationType = Optional.ofNullable(column.getAggregationType());
                        baseInfo.put("aggregation_type", aggregationType.isPresent() ? column.getAggregationType().toSql() : "");
                        propList.add(baseInfo);
                    }
                    resultMap.put("status", 200);
                    resultMap.put("keysType", table.getKeysType().name());
                    resultMap.put("properties", propList);
                    return ResponseEntityBuilder.ok(resultMap);
                }
                catch (Exception e) {
                    ResponseEntity responseEntity = ResponseEntityBuilder.okWithCommonError(e.getMessage());
                    table.readUnlock();
                    return responseEntity;
                }
            }
            finally {
                table.readUnlock();
            }
        }
        catch (DorisHttpException e) {
            resultMap.put("status", e.getCode().code());
            resultMap.put("exception", e.getMessage());
        }
        return ResponseEntityBuilder.ok(resultMap);
    }
}

