/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.rest;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.DorisHttpException;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.httpv2.rest.RestBaseController;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TableRowCountAction
extends RestBaseController {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(path={"/api/{db}/{table}/_count"}, method={RequestMethod.GET})
    public Object count(@PathVariable(value="db") String dbName, @PathVariable(value="table") String tblName, HttpServletRequest request, HttpServletResponse response) {
        this.executeCheckPassword(request, response);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        try {
            OlapTable olapTable;
            String fullDbName = this.getFullDbName(dbName);
            this.checkTblAuth(ConnectContext.get().getCurrentUserIdentity(), fullDbName, tblName, PrivPredicate.SELECT);
            try {
                Database db = Catalog.getCurrentCatalog().getDbOrMetaException(fullDbName);
                olapTable = (OlapTable)db.getTableOrMetaException(tblName, Table.TableType.OLAP);
            }
            catch (MetaNotFoundException e) {
                return ResponseEntityBuilder.okWithCommonError(e.getMessage());
            }
            olapTable.readLock();
            try {
                resultMap.put("status", 200);
                resultMap.put("size", olapTable.proximateRowCount());
            }
            finally {
                olapTable.readUnlock();
            }
        }
        catch (DorisHttpException e) {
            resultMap.put("status", e.getCode().code());
            resultMap.put("exception", e.getMessage());
        }
        return ResponseEntityBuilder.ok(resultMap);
    }
}

