/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.rest;

import com.google.common.base.Strings;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.analysis.InlineViewRef;
import org.apache.doris.analysis.SelectStmt;
import org.apache.doris.analysis.StatementBase;
import org.apache.doris.analysis.TableName;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.DorisHttpException;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.httpv2.rest.RestBaseController;
import org.apache.doris.httpv2.util.HttpUtil;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.planner.PlanFragment;
import org.apache.doris.planner.Planner;
import org.apache.doris.planner.ScanNode;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.OriginStatement;
import org.apache.doris.qe.StmtExecutor;
import org.apache.doris.thrift.TDataSink;
import org.apache.doris.thrift.TDataSinkType;
import org.apache.doris.thrift.TMemoryScratchSink;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TPaloScanRange;
import org.apache.doris.thrift.TPlanFragment;
import org.apache.doris.thrift.TQueryOptions;
import org.apache.doris.thrift.TQueryPlanInfo;
import org.apache.doris.thrift.TScanRangeLocations;
import org.apache.doris.thrift.TTabletVersionInfo;
import org.apache.doris.thrift.TUniqueId;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TableQueryPlanAction
extends RestBaseController {
    public static final Logger LOG = LogManager.getLogger(TableQueryPlanAction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(path={"/api/{db}/{table}/_query_plan"}, method={RequestMethod.GET, RequestMethod.POST})
    public Object query_plan(@PathVariable(value="db") String dbName, @PathVariable(value="table") String tblName, HttpServletRequest request, HttpServletResponse response) {
        this.executeCheckPassword(request, response);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        String postContent = HttpUtil.getBody(request);
        try {
            Object table;
            if (Strings.isNullOrEmpty((String)postContent)) {
                return ResponseEntityBuilder.badRequest("POST body must contains [sql] root object");
            }
            JSONObject jsonObject = (JSONObject)JSONValue.parse((String)postContent);
            if (jsonObject == null) {
                return ResponseEntityBuilder.badRequest("malformed json: " + postContent);
            }
            String sql = (String)jsonObject.get((Object)"sql");
            if (Strings.isNullOrEmpty((String)sql)) {
                return ResponseEntityBuilder.badRequest("POST body must contains [sql] root object");
            }
            LOG.info("receive SQL statement [{}] from external service [ user [{}]] for database [{}] table [{}]", (Object)sql, (Object)ConnectContext.get().getCurrentUserIdentity(), (Object)dbName, (Object)tblName);
            String fullDbName = this.getFullDbName(dbName);
            this.checkTblAuth(ConnectContext.get().getCurrentUserIdentity(), fullDbName, tblName, PrivPredicate.SELECT);
            try {
                Database db = Catalog.getCurrentCatalog().getDbOrMetaException(fullDbName);
                table = db.getTableOrMetaException(tblName, Table.TableType.OLAP);
            }
            catch (MetaNotFoundException e) {
                return ResponseEntityBuilder.okWithCommonError(e.getMessage());
            }
            ((Table)table).readLock();
            try {
                this.handleQuery(ConnectContext.get(), fullDbName, tblName, sql, resultMap);
            }
            finally {
                ((Table)table).readUnlock();
            }
        }
        catch (DorisHttpException e) {
            resultMap.put("status", e.getCode().code());
            resultMap.put("exception", e.getMessage());
        }
        return ResponseEntityBuilder.ok(resultMap);
    }

    private void handleQuery(ConnectContext context, String requestDb, String requestTable, String sql, Map<String, Object> result) throws DorisHttpException {
        String opaqued_query_plan;
        StmtExecutor stmtExecutor = new StmtExecutor(context, new OriginStatement(sql, 0), false);
        try {
            TQueryOptions tQueryOptions = context.getSessionVariable().toThrift();
            tQueryOptions.num_nodes = 1;
            stmtExecutor.analyze(tQueryOptions);
        }
        catch (Exception e) {
            throw new DorisHttpException(HttpResponseStatus.BAD_REQUEST, e.getMessage());
        }
        StatementBase query = stmtExecutor.getParsedStmt();
        if (!(query instanceof SelectStmt)) {
            throw new DorisHttpException(HttpResponseStatus.BAD_REQUEST, "Select statement needed, but found [" + sql + " ]");
        }
        SelectStmt stmt = (SelectStmt)query;
        if (stmt.hasAggInfo() || stmt.hasAnalyticInfo() || stmt.hasOrderByClause() || stmt.hasOffset() || stmt.hasLimit() || stmt.isExplain()) {
            throw new DorisHttpException(HttpResponseStatus.BAD_REQUEST, "only support single table filter-prune-scan, but found [ " + sql + "]");
        }
        List<TableRef> fromTables = stmt.getTableRefs();
        if (fromTables.size() != 1) {
            throw new DorisHttpException(HttpResponseStatus.BAD_REQUEST, "Select statement must have only one table");
        }
        TableRef fromTable = fromTables.get(0);
        if (fromTable instanceof InlineViewRef) {
            throw new DorisHttpException(HttpResponseStatus.BAD_REQUEST, "Select statement must not embed another statement");
        }
        TableName tableAndDb = fromTables.get(0).getName();
        if (!tableAndDb.getDb().equals(requestDb) || !tableAndDb.getTbl().equals(requestTable)) {
            throw new DorisHttpException(HttpResponseStatus.BAD_REQUEST, "requested database and table must consistent with sql: request [ " + requestDb + "." + requestTable + "]and sql [" + tableAndDb.toString() + "]");
        }
        Planner planner = stmtExecutor.planner();
        List<ScanNode> scanNodes = planner.getScanNodes();
        if (scanNodes.size() != 1) {
            throw new DorisHttpException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "Planner should plan just only one ScanNode but found [ " + scanNodes.size() + "]");
        }
        List<TScanRangeLocations> scanRangeLocations = scanNodes.get(0).getScanRangeLocations(0L);
        List<PlanFragment> fragments = planner.getFragments();
        if (fragments.size() != 1) {
            throw new DorisHttpException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "Planner should plan just only one PlanFragment but found [ " + fragments.size() + "]");
        }
        TQueryPlanInfo tQueryPlanInfo = new TQueryPlanInfo();
        TPlanFragment tPlanFragment = fragments.get(0).toThrift();
        TDataSink tDataSink = new TDataSink();
        tDataSink.type = TDataSinkType.MEMORY_SCRATCH_SINK;
        tDataSink.memory_scratch_sink = new TMemoryScratchSink();
        tPlanFragment.output_sink = tDataSink;
        tQueryPlanInfo.plan_fragment = tPlanFragment;
        tQueryPlanInfo.desc_tbl = query.getAnalyzer().getDescTbl().toThrift();
        UUID uuid = UUID.randomUUID();
        tQueryPlanInfo.query_id = new TUniqueId(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
        HashMap tablet_info = new HashMap();
        Map<String, Node> tabletRoutings = this.assemblePrunedPartitions(scanRangeLocations);
        tabletRoutings.forEach((tabletId, node) -> {
            long tablet = Long.parseLong(tabletId);
            tablet_info.put(tablet, new TTabletVersionInfo(tablet, node.version, 0L, node.schemaHash));
        });
        tQueryPlanInfo.tablet_info = tablet_info;
        TSerializer serializer = new TSerializer();
        try {
            byte[] query_plan_stream = serializer.serialize((TBase)tQueryPlanInfo);
            opaqued_query_plan = Base64.getEncoder().encodeToString(query_plan_stream);
        }
        catch (TException e) {
            throw new DorisHttpException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "TSerializer failed to serialize PlanFragment, reason [ " + e.getMessage() + " ]");
        }
        result.put("partitions", tabletRoutings);
        result.put("opaqued_query_plan", opaqued_query_plan);
        result.put("status", 200);
    }

    private Map<String, Node> assemblePrunedPartitions(List<TScanRangeLocations> scanRangeLocationsList) {
        HashMap<String, Node> result = new HashMap<String, Node>();
        for (TScanRangeLocations scanRangeLocations : scanRangeLocationsList) {
            TPaloScanRange scanRange = scanRangeLocations.scan_range.palo_scan_range;
            Node tabletRouting = new Node(Long.parseLong(scanRange.version), Integer.parseInt(scanRange.schema_hash));
            for (TNetworkAddress address : scanRange.hosts) {
                tabletRouting.addRouting(address.hostname + ":" + address.port);
            }
            result.put(String.valueOf(scanRange.tablet_id), tabletRouting);
        }
        return result;
    }

    final class Node {
        public List<String> routings = new ArrayList<String>();
        public long version;
        public int schemaHash;

        public Node(long version, int schemaHash) {
            this.version = version;
            this.schemaHash = schemaHash;
        }

        private void addRouting(String routing) {
            this.routings.add(routing);
        }
    }
}

