/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.rest;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.MaterializedIndexMeta;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.httpv2.rest.RestBaseController;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.thrift.TStorageType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class StorageTypeCheckAction
extends RestBaseController {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(path={"/api/_check_storagetype"}, method={RequestMethod.GET})
    protected Object check_storagetype(HttpServletRequest request, HttpServletResponse response) {
        Database db;
        this.executeCheckPassword(request, response);
        this.checkGlobalAuth(ConnectContext.get().getCurrentUserIdentity(), PrivPredicate.ADMIN);
        String dbName = request.getParameter("db");
        if (Strings.isNullOrEmpty((String)dbName)) {
            return ResponseEntityBuilder.badRequest("No database selected");
        }
        String fullDbName = this.getFullDbName(dbName);
        try {
            db = Catalog.getCurrentCatalog().getDbOrMetaException(fullDbName);
        }
        catch (MetaNotFoundException e) {
            return ResponseEntityBuilder.okWithCommonError(e.getMessage());
        }
        HashMap result = Maps.newHashMap();
        List<Table> tbls = db.getTables();
        for (Table tbl : tbls) {
            if (tbl.getType() != Table.TableType.OLAP) continue;
            OlapTable olapTbl = (OlapTable)tbl;
            olapTbl.readLock();
            try {
                HashMap indexMap = Maps.newHashMap();
                for (Map.Entry<Long, MaterializedIndexMeta> entry : olapTbl.getIndexIdToMeta().entrySet()) {
                    MaterializedIndexMeta indexMeta = entry.getValue();
                    if (indexMeta.getStorageType() != TStorageType.ROW) continue;
                    indexMap.put(olapTbl.getIndexNameById(entry.getKey()), indexMeta.getStorageType().name());
                }
                result.put(tbl.getName(), indexMap);
            }
            finally {
                olapTbl.readUnlock();
            }
        }
        return ResponseEntityBuilder.ok(result);
    }
}

