/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.rest;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.common.DdlException;
import org.apache.doris.httpv2.controller.BaseController;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.httpv2.rest.RestBaseController;
import org.apache.doris.httpv2.util.ExecutionResultSet;
import org.apache.doris.httpv2.util.StatementSubmitter;
import org.apache.doris.qe.ConnectContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class StmtExecutionAction
extends RestBaseController {
    private static final Logger LOG = LogManager.getLogger(StmtExecutionAction.class);
    private static StatementSubmitter stmtSubmitter = new StatementSubmitter();
    private static final String PARAM_SYNC = "sync";
    private static final String PARAM_LIMIT = "limit";
    private static final long DEFAULT_ROW_LIMIT = 1000L;
    private static final long MAX_ROW_LIMIT = 10000L;

    @RequestMapping(path={"/api/query/{ns}/{db}"}, method={RequestMethod.POST})
    public Object executeSQL(@PathVariable(value="ns") String ns, @PathVariable(value="db") String dbName, HttpServletRequest request, HttpServletResponse response, @RequestBody String stmtBody) throws DdlException {
        BaseController.ActionAuthorizationInfo authInfo = this.checkWithCookie(request, response, false);
        if (!ns.equalsIgnoreCase("default_cluster")) {
            return ResponseEntityBuilder.badRequest("Only support 'default_cluster' now");
        }
        boolean isSync = true;
        String syncParam = request.getParameter(PARAM_SYNC);
        if (!Strings.isNullOrEmpty((String)syncParam)) {
            isSync = syncParam.equals("1");
        }
        String limitParam = request.getParameter(PARAM_LIMIT);
        long limit = 1000L;
        if (!Strings.isNullOrEmpty((String)limitParam)) {
            limit = Math.min(Long.valueOf(limitParam), 10000L);
        }
        Type type = new TypeToken<StmtRequestBody>(){}.getType();
        StmtRequestBody stmtRequestBody = (StmtRequestBody)new Gson().fromJson(stmtBody, type);
        if (Strings.isNullOrEmpty((String)stmtRequestBody.stmt)) {
            return ResponseEntityBuilder.badRequest("Missing statement request body");
        }
        LOG.info("stmt: {}", (Object)stmtRequestBody.stmt);
        ConnectContext.get().setDatabase(this.getFullDbName(dbName));
        StatementSubmitter.StmtContext stmtCtx = new StatementSubmitter.StmtContext(stmtRequestBody.stmt, authInfo.fullUserName, authInfo.password, limit);
        Future<ExecutionResultSet> future = stmtSubmitter.submit(stmtCtx);
        if (isSync) {
            try {
                ExecutionResultSet resultSet = future.get();
                return ResponseEntityBuilder.ok(resultSet.getResult());
            }
            catch (InterruptedException e) {
                LOG.warn("failed to execute stmt", (Throwable)e);
                return ResponseEntityBuilder.okWithCommonError("Failed to execute sql: " + e.getMessage());
            }
            catch (ExecutionException e) {
                LOG.warn("failed to execute stmt", (Throwable)e);
                return ResponseEntityBuilder.okWithCommonError("Failed to execute sql: " + e.getMessage());
            }
        }
        return ResponseEntityBuilder.okWithCommonError("Not support async query execution");
    }

    private static class StmtRequestBody {
        public String stmt;

        private StmtRequestBody() {
        }
    }
}

