/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.rest;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.proc.ProcService;
import org.apache.doris.ha.HAProtocol;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.httpv2.rest.RestBaseController;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.persist.Storage;
import org.apache.doris.qe.ConnectContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.view.RedirectView;

@RestController
public class ShowAction
extends RestBaseController {
    private static final Logger LOG = LogManager.getLogger(ShowAction.class);

    @RequestMapping(path={"/api/show_meta_info"}, method={RequestMethod.GET})
    public Object show_meta_info(HttpServletRequest request, HttpServletResponse response) {
        String action = request.getParameter("action");
        if (Strings.isNullOrEmpty((String)action)) {
            return ResponseEntityBuilder.badRequest("Missing action parameter");
        }
        switch (Action.getAction(action.toUpperCase())) {
            case SHOW_DB_SIZE: {
                return ResponseEntityBuilder.ok(this.getDataSize());
            }
            case SHOW_HA: {
                try {
                    return ResponseEntityBuilder.ok(this.getHaInfo());
                }
                catch (IOException e) {
                    return ResponseEntityBuilder.internalError(e.getMessage());
                }
            }
        }
        return ResponseEntityBuilder.badRequest("Unknown action: " + action);
    }

    @RequestMapping(path={"/api/show_proc"}, method={RequestMethod.GET})
    public Object show_proc(HttpServletRequest request, HttpServletResponse response) {
        this.executeCheckPassword(request, response);
        this.checkGlobalAuth(ConnectContext.get().getCurrentUserIdentity(), PrivPredicate.ADMIN);
        String path = request.getParameter("path");
        String forward = request.getParameter("forward");
        boolean isForward = false;
        if (!Strings.isNullOrEmpty((String)forward) && forward.equals("true")) {
            isForward = true;
        }
        if (!Catalog.getCurrentCatalog().isMaster() && isForward) {
            RedirectView redirectView = this.redirectToMaster(request, response);
            Preconditions.checkNotNull((Object)redirectView);
            return redirectView;
        }
        ProcNodeInterface procNode = null;
        ProcService instance = ProcService.getInstance();
        try {
            procNode = Strings.isNullOrEmpty((String)path) ? instance.open("/") : instance.open(path);
        }
        catch (AnalysisException e) {
            return ResponseEntityBuilder.okWithCommonError(e.getMessage());
        }
        if (procNode != null) {
            try {
                ProcResult result = procNode.fetchResult();
                List<List<String>> rows = result.getRows();
                return ResponseEntityBuilder.ok(rows);
            }
            catch (AnalysisException e) {
                return ResponseEntityBuilder.okWithCommonError(e.getMessage());
            }
        }
        return ResponseEntityBuilder.badRequest("Invalid proc path: " + path);
    }

    @RequestMapping(path={"/api/show_runtime_info"}, method={RequestMethod.GET})
    public Object show_runtime_info(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, String> feInfo = new HashMap<String, String>();
        Runtime r = Runtime.getRuntime();
        feInfo.put("free_mem", String.valueOf(r.freeMemory()));
        feInfo.put("total_mem", String.valueOf(r.totalMemory()));
        feInfo.put("max_mem", String.valueOf(r.maxMemory()));
        ThreadGroup parentThread = Thread.currentThread().getThreadGroup();
        while (parentThread.getParent() != null) {
            parentThread = parentThread.getParent();
        }
        feInfo.put("thread_cnt", String.valueOf(parentThread.activeCount()));
        return ResponseEntityBuilder.ok(feInfo);
    }

    @RequestMapping(path={"/api/show_data"}, method={RequestMethod.GET})
    public Object show_data(HttpServletRequest request, HttpServletResponse response) {
        HashMap oneEntry = Maps.newHashMap();
        String dbName = request.getParameter("db");
        ConcurrentHashMap<String, Database> fullNameToDb = Catalog.getCurrentCatalog().getFullNameToDb();
        long totalSize = 0L;
        if (dbName != null) {
            String fullDbName = this.getFullDbName(dbName);
            Database db = fullNameToDb.get(fullDbName);
            if (db == null) {
                return ResponseEntityBuilder.okWithCommonError("database " + fullDbName + " not found.");
            }
            totalSize = this.getDataSizeOfDatabase(db);
            oneEntry.put(fullDbName, totalSize);
        } else {
            for (Database db : fullNameToDb.values()) {
                if (db.isInfoSchemaDb()) continue;
                totalSize += this.getDataSizeOfDatabase(db);
            }
            oneEntry.put("__total_size", totalSize);
        }
        return ResponseEntityBuilder.ok(oneEntry);
    }

    private Map<String, String> getHaInfo() throws IOException {
        HashMap<String, String> feInfo = new HashMap<String, String>();
        feInfo.put("role", Catalog.getCurrentCatalog().getFeType().toString());
        if (Catalog.getCurrentCatalog().isMaster()) {
            feInfo.put("current_journal_id", String.valueOf(Catalog.getCurrentCatalog().getEditLog().getMaxJournalId()));
        } else {
            feInfo.put("current_journal_id", String.valueOf(Catalog.getCurrentCatalog().getReplayedJournalId()));
        }
        HAProtocol haProtocol = Catalog.getCurrentCatalog().getHaProtocol();
        if (haProtocol != null) {
            InetSocketAddress master = null;
            try {
                master = haProtocol.getLeader();
            }
            catch (Exception e) {
                LOG.warn("failed to get leader: {}", (Object)e.getMessage());
            }
            if (master != null) {
                feInfo.put("master", master.getHostString());
            } else {
                feInfo.put("master", "unknown");
            }
            List<InetSocketAddress> electableNodes = haProtocol.getElectableNodes(false);
            ArrayList<String> electableNodeNames = new ArrayList<String>();
            if (electableNodes != null) {
                for (InetSocketAddress node : electableNodes) {
                    electableNodeNames.add(node.getHostString());
                }
                feInfo.put("electable_nodes", StringUtils.join((Object[])electableNodeNames.toArray(), (String)","));
            }
            List<InetSocketAddress> observerNodes = haProtocol.getObserverNodes();
            ArrayList<String> observerNodeNames = new ArrayList<String>();
            if (observerNodes != null) {
                for (InetSocketAddress node : observerNodes) {
                    observerNodeNames.add(node.getHostString());
                }
                feInfo.put("observer_nodes", StringUtils.join((Object[])observerNodeNames.toArray(), (String)","));
            }
        }
        feInfo.put("can_read", String.valueOf(Catalog.getCurrentCatalog().canRead()));
        feInfo.put("is_ready", String.valueOf(Catalog.getCurrentCatalog().isReady()));
        Storage storage = new Storage(Config.meta_dir + "/image");
        feInfo.put("last_checkpoint_version", String.valueOf(storage.getLatestImageSeq()));
        long lastCheckpointTime = storage.getCurrentImageFile().lastModified();
        feInfo.put("last_checkpoint_time", String.valueOf(lastCheckpointTime));
        return feInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDataSizeOfDatabase(Database db) {
        long totalSize = 0L;
        db.readLock();
        try {
            List<Table> tables = db.getTables();
            for (Table table : tables) {
                if (table.getType() != Table.TableType.OLAP) continue;
                table.readLock();
                try {
                    long tableSize = ((OlapTable)table).getDataSize();
                    totalSize += tableSize;
                }
                finally {
                    table.readUnlock();
                }
            }
        }
        finally {
            db.readUnlock();
        }
        return totalSize;
    }

    private Map<String, Long> getDataSize() {
        HashMap<String, Long> result = new HashMap<String, Long>();
        List<String> dbNames = Catalog.getCurrentCatalog().getDbNames();
        for (String dbName : dbNames) {
            Catalog.getCurrentCatalog().getDb(dbName).ifPresent(db -> {
                long totalSize = this.getDataSizeOfDatabase((Database)db);
                result.put(dbName, totalSize);
            });
        }
        return result;
    }

    private static enum Action {
        SHOW_DB_SIZE,
        SHOW_HA,
        INVALID;


        public static Action getAction(String str) {
            try {
                return Action.valueOf(str);
            }
            catch (Exception ex) {
                return INVALID;
            }
        }
    }
}

