/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.rest;

import com.clearspring.analytics.util.Lists;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.common.ConfigBase;
import org.apache.doris.common.DdlException;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.httpv2.rest.RestBaseController;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SetConfigAction
extends RestBaseController {
    private static final Logger LOG = LogManager.getLogger(SetConfigAction.class);
    private static final String PERSIST_PARAM = "persist";
    private static final String RESET_PERSIST = "reset_persist";

    @RequestMapping(path={"/api/_set_config"}, method={RequestMethod.GET})
    protected Object set_config(HttpServletRequest request, HttpServletResponse response) {
        String[] val;
        this.executeCheckPassword(request, response);
        this.checkGlobalAuth(ConnectContext.get().getCurrentUserIdentity(), PrivPredicate.ADMIN);
        boolean needPersist = false;
        boolean resetPersist = true;
        Map tempConfigs = request.getParameterMap();
        HashMap configs = Maps.newHashMap();
        configs.putAll(tempConfigs);
        if (configs.containsKey(PERSIST_PARAM) && (val = (String[])configs.remove(PERSIST_PARAM)).length == 1 && val[0].equals("true")) {
            needPersist = true;
        }
        if (configs.containsKey(RESET_PERSIST) && (val = (String[])configs.remove(RESET_PERSIST)).length == 1 && val[0].equals("false")) {
            resetPersist = false;
        }
        HashMap setConfigs = Maps.newHashMap();
        List errConfigs = Lists.newArrayList();
        LOG.debug("get config from url: {}, need persist: {}", (Object)configs, (Object)needPersist);
        for (Map.Entry config : configs.entrySet()) {
            String confKey = (String)config.getKey();
            Object[] confValue = (String[])config.getValue();
            try {
                if (confValue != null && confValue.length == 1) {
                    ConfigBase.setMutableConfig(confKey, (String)confValue[0]);
                    setConfigs.put(confKey, confValue[0]);
                    continue;
                }
                throw new DdlException("conf value size != 1");
            }
            catch (DdlException e) {
                LOG.warn("failed to set config {}:{}", (Object)confKey, (Object)Arrays.toString(confValue), (Object)e);
                errConfigs.add(new ErrConfig(confKey, Arrays.toString(confValue), e.getMessage()));
            }
        }
        String persistMsg = "";
        if (needPersist) {
            try {
                ConfigBase.persistConfig(setConfigs, resetPersist);
                persistMsg = "ok";
            }
            catch (IOException e) {
                LOG.warn("failed to persist config", (Throwable)e);
                persistMsg = e.getMessage();
            }
        }
        return ResponseEntityBuilder.ok(new SetConfigEntity(setConfigs, errConfigs, persistMsg));
    }

    public static class SetConfigEntity {
        @SerializedName(value="set")
        @JsonProperty(value="set")
        Map<String, String> setConfigs;
        @SerializedName(value="err")
        @JsonProperty(value="err")
        List<ErrConfig> errConfigs;
        @SerializedName(value="persist")
        @JsonProperty(value="persist")
        String persistMsg;

        public Map<String, String> getSetConfigs() {
            return this.setConfigs;
        }

        public List<ErrConfig> getErrConfigs() {
            return this.errConfigs;
        }

        public String getPersistMsg() {
            return this.persistMsg;
        }

        @JsonProperty(value="set")
        public void setSetConfigs(Map<String, String> setConfigs) {
            this.setConfigs = setConfigs;
        }

        @JsonProperty(value="err")
        public void setErrConfigs(List<ErrConfig> errConfigs) {
            this.errConfigs = errConfigs;
        }

        @JsonProperty(value="persist")
        public void setPersistMsg(String persistMsg) {
            this.persistMsg = persistMsg;
        }

        public SetConfigEntity(Map<String, String> setConfigs, List<ErrConfig> errConfigs, String persistMsg) {
            this.setConfigs = setConfigs;
            this.errConfigs = errConfigs;
            this.persistMsg = persistMsg;
        }
    }

    public static class ErrConfig {
        @SerializedName(value="config_name")
        @JsonProperty(value="config_name")
        private String configName;
        @SerializedName(value="config_value")
        @JsonProperty(value="config_value")
        private String configValue;
        @SerializedName(value="err_info")
        @JsonProperty(value="err_info")
        private String errInfo;

        public String getConfigName() {
            return this.configName;
        }

        public String getConfigValue() {
            return this.configValue;
        }

        public String getErrInfo() {
            return this.errInfo;
        }

        @JsonProperty(value="config_name")
        public void setConfigName(String configName) {
            this.configName = configName;
        }

        @JsonProperty(value="config_value")
        public void setConfigValue(String configValue) {
            this.configValue = configValue;
        }

        @JsonProperty(value="err_info")
        public void setErrInfo(String errInfo) {
            this.errInfo = errInfo;
        }

        public ErrConfig(String configName, String configValue, String errInfo) {
            this.configName = configName;
            this.configValue = configValue;
            this.errInfo = errInfo;
        }
    }
}

