/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.rest;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.httpv2.entity.ResponseEntityBuilder;
import org.apache.doris.httpv2.rest.RestBaseController;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RowCountAction
extends RestBaseController {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(path={"/api/rowcount"}, method={RequestMethod.GET})
    protected Object rowcount(HttpServletRequest request, HttpServletResponse response) {
        OlapTable olapTable;
        this.executeCheckPassword(request, response);
        this.checkGlobalAuth(ConnectContext.get().getCurrentUserIdentity(), PrivPredicate.ADMIN);
        String dbName = request.getParameter("db");
        if (Strings.isNullOrEmpty((String)dbName)) {
            return ResponseEntityBuilder.badRequest("No database selected");
        }
        String tableName = request.getParameter("table");
        if (Strings.isNullOrEmpty((String)tableName)) {
            return ResponseEntityBuilder.badRequest("No table selected");
        }
        String fullDbName = this.getFullDbName(dbName);
        HashMap indexRowCountMap = Maps.newHashMap();
        try {
            Database db = Catalog.getCurrentCatalog().getDbOrMetaException(fullDbName);
            olapTable = (OlapTable)db.getTableOrMetaException(tableName, Table.TableType.OLAP);
        }
        catch (MetaNotFoundException e) {
            return ResponseEntityBuilder.okWithCommonError(e.getMessage());
        }
        olapTable.readLock();
        try {
            for (Partition partition : olapTable.getAllPartitions()) {
                long version = partition.getVisibleVersion();
                for (MaterializedIndex index : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.VISIBLE)) {
                    long indexRowCount = 0L;
                    for (Tablet tablet : index.getTablets()) {
                        long tabletRowCount = 0L;
                        for (Replica replica : tablet.getReplicas()) {
                            if (!replica.checkVersionCatchUp(version, false) || replica.getRowCount() <= tabletRowCount) continue;
                            tabletRowCount = replica.getRowCount();
                        }
                        indexRowCount += tabletRowCount;
                    }
                    index.setRowCount(indexRowCount);
                    indexRowCountMap.put(olapTable.getIndexNameById(index.getId()), indexRowCount);
                }
            }
        }
        finally {
            olapTable.readUnlock();
        }
        return ResponseEntityBuilder.ok(indexRowCountMap);
    }
}

