/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.httpv2.rest;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.httpv2.controller.BaseController;
import org.apache.doris.httpv2.exception.UnauthorizedException;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.view.RedirectView;

public class RestBaseController
extends BaseController {
    protected static final String NS_KEY = "ns";
    protected static final String DB_KEY = "db";
    protected static final String TABLE_KEY = "table";
    protected static final String LABEL_KEY = "label";
    protected static final String TXN_ID_KEY = "txn_id";
    protected static final String TXN_OPERATION_KEY = "txn_operation";
    private static final Logger LOG = LogManager.getLogger(RestBaseController.class);

    public BaseController.ActionAuthorizationInfo executeCheckPassword(HttpServletRequest request, HttpServletResponse response) throws UnauthorizedException {
        BaseController.ActionAuthorizationInfo authInfo = this.getAuthorizationInfo(request);
        UserIdentity currentUser = this.checkPassword(authInfo);
        ConnectContext ctx = new ConnectContext(null);
        ctx.setCatalog(Catalog.getCurrentCatalog());
        ctx.setQualifiedUser(authInfo.fullUserName);
        ctx.setRemoteIP(authInfo.remoteIp);
        ctx.setCurrentUserIdentity(currentUser);
        ctx.setCluster(authInfo.cluster);
        ctx.setThreadLocalInfo();
        return authInfo;
    }

    public RedirectView redirectTo(HttpServletRequest request, TNetworkAddress addr) {
        URI urlObj = null;
        URI resultUriObj = null;
        String urlStr = request.getRequestURI();
        String userInfo = null;
        if (!Strings.isNullOrEmpty((String)request.getHeader("Authorization"))) {
            BaseController.ActionAuthorizationInfo authInfo = this.getAuthorizationInfo(request);
            String clusterName = ConnectContext.get() == null ? "default_cluster" : ConnectContext.get().getClusterName();
            userInfo = ClusterNamespace.getNameFromFullName(authInfo.fullUserName) + "@" + clusterName + ":" + authInfo.password;
        }
        try {
            urlObj = new URI(urlStr);
            resultUriObj = new URI("http", userInfo, addr.getHostname(), addr.getPort(), urlObj.getPath(), "", null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String redirectUrl = resultUriObj.toASCIIString();
        if (!Strings.isNullOrEmpty((String)request.getQueryString())) {
            redirectUrl = redirectUrl + request.getQueryString();
        }
        LOG.info("redirect url: {}", (Object)redirectUrl);
        RedirectView redirectView = new RedirectView(redirectUrl);
        redirectView.setContentType("text/html;charset=utf-8");
        redirectView.setStatusCode(HttpStatus.TEMPORARY_REDIRECT);
        return redirectView;
    }

    public RedirectView redirectToMaster(HttpServletRequest request, HttpServletResponse response) {
        Catalog catalog = Catalog.getCurrentCatalog();
        if (catalog.isMaster()) {
            return null;
        }
        return this.redirectTo(request, new TNetworkAddress(catalog.getMasterIp(), catalog.getMasterHttpPort()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFile(HttpServletRequest request, HttpServletResponse response, Object obj, String fileName) throws IOException {
        response.setHeader("Content-type", "application/octet-stream");
        response.addHeader("Content-Disposition", "attachment;fileName=" + fileName);
        if (obj instanceof File) {
            File file = (File)obj;
            byte[] buffer = new byte[1024];
            FileInputStream fis = null;
            BufferedInputStream bis = null;
            try {
                fis = new FileInputStream(file);
                bis = new BufferedInputStream(fis);
                ServletOutputStream os = response.getOutputStream();
                int i = bis.read(buffer);
                while (i != -1) {
                    os.write(buffer, 0, i);
                    i = bis.read(buffer);
                }
                return;
            }
            finally {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (obj instanceof byte[]) {
            ServletOutputStream os = response.getOutputStream();
            os.write((byte[])obj);
        }
    }

    public void writeFileResponse(HttpServletRequest request, HttpServletResponse response, File imageFile) throws IOException {
        Preconditions.checkArgument((imageFile != null && imageFile.exists() ? 1 : 0) != 0);
        response.setHeader("Content-type", "application/octet-stream");
        response.addHeader("Content-Disposition", "attachment;fileName=" + imageFile.getName());
        response.setHeader("X-Image-Size", imageFile.length() + "");
        this.getFile(request, response, imageFile, imageFile.getName());
    }

    public String getFullDbName(String dbName) {
        String fullDbName = dbName;
        String clusterName = ClusterNamespace.getClusterNameFromFullName(fullDbName);
        if (clusterName == null) {
            fullDbName = ClusterNamespace.getFullName("default_cluster", dbName);
        }
        return fullDbName;
    }
}

